/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.BinarySequence;
import jalview.Format;
import jalview.Matrix;
import jalview.ProgressBar;
import jalview.Sequence;
import jalview.TextAreaPrintStream;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class PCA
implements Runnable {
    Matrix m;
    Matrix symm;
    Matrix m2;
    double[] eigenvalue;
    Matrix eigenvector;
    ProgressBar pb;
    Sequence[] s;
    Vector resscores;

    public PCA(Matrix matrix) {
        this.m = matrix;
    }

    public PCA(Sequence[] sequenceArray, ProgressBar progressBar) {
        this.pb = progressBar;
        this.s = sequenceArray;
        Runtime runtime = Runtime.getRuntime();
        BinarySequence[] binarySequenceArray = new BinarySequence[sequenceArray.length];
        int n = 0;
        while (n < sequenceArray.length && sequenceArray[n] != null) {
            binarySequenceArray[n] = new BinarySequence(sequenceArray[n]);
            binarySequenceArray[n].encode();
            ++n;
        }
        BinarySequence[] binarySequenceArray2 = new BinarySequence[sequenceArray.length];
        n = 0;
        while (n < sequenceArray.length && sequenceArray[n] != null) {
            binarySequenceArray2[n] = new BinarySequence(sequenceArray[n]);
            binarySequenceArray2[n].blosumEncode();
            ++n;
        }
        int n2 = 0;
        while (n2 < binarySequenceArray.length && binarySequenceArray[n2] != null) {
            ++n2;
        }
        double[][] dArray = new double[n2][binarySequenceArray[0].dbinary.length];
        double[][] dArray2 = new double[n2][binarySequenceArray2[0].dbinary.length];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = binarySequenceArray[n3].dbinary;
            dArray2[n3] = binarySequenceArray2[n3].dbinary;
            ++n3;
        }
        this.m = new Matrix(dArray, n2, binarySequenceArray[0].dbinary.length);
        this.m2 = new Matrix(dArray2, n2, binarySequenceArray2[0].dbinary.length);
        PCA.printMemory(runtime);
    }

    public static void printMemory(Runtime runtime) {
        System.out.println("Free memory = " + runtime.freeMemory());
    }

    public double[] getEigenvector(int n) {
        return this.eigenvector.getColumn(n);
    }

    public double getEigenvalue(int n) {
        return this.eigenvector.d[n];
    }

    public float[][] getComponents(int n, int n2, int n3) {
        return this.getComponents(n, n2, n3, 1.0f);
    }

    public float[][] getComponents(int n, int n2, int n3, float f) {
        float[][] fArray = new float[this.m.rows][3];
        int n4 = 0;
        while (n4 < this.m.rows) {
            fArray[n4][0] = (float)this.component(n4, n) * f;
            fArray[n4][1] = (float)this.component(n4, n2) * f;
            fArray[n4][2] = (float)this.component(n4, n3) * f;
            ++n4;
        }
        return fArray;
    }

    public double[] component(int n) {
        double[] dArray = new double[this.m.rows];
        int n2 = 0;
        while (n2 < this.m.rows) {
            dArray[n2] = this.component(n2, n);
            ++n2;
        }
        return dArray;
    }

    public double component(int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < this.symm.cols) {
            d += this.symm.value[n][n3] * this.eigenvector.value[n3][n2];
            ++n3;
        }
        return d / this.eigenvector.d[n2];
    }

    public void checkEigenvector(int n, PrintStream printStream) {
        printStream.println(" --- Eigenvector " + n + " --- ");
        double[] dArray = this.eigenvector.getColumn(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            Format.print(printStream, "%15.4f", dArray[n2]);
            ++n2;
        }
        System.out.println();
        double[] dArray2 = this.symm.vectorPostMultiply(dArray);
        printStream.println(" --- symmat * eigenv / lambda --- ");
        if (this.eigenvector.d[n] > 1.0E-4) {
            int n3 = 0;
            while (n3 < dArray2.length) {
                Format.print(printStream, "%15.4f", dArray2[n3] / this.eigenvector.d[n]);
                ++n3;
            }
        }
        System.out.println();
    }

    public void updateBar(int n) {
        if (this.pb != null) {
            System.out.println("UPdating bar " + n);
            this.pb.updateBar(n);
        }
    }

    public void run() {
        Matrix matrix = this.m.transpose();
        this.updateBar(5);
        this.eigenvector = matrix.preMultiply(this.m2);
        this.updateBar(10);
        this.symm = this.eigenvector.copy();
        this.updateBar(20);
        TextArea textArea = new TextArea(25, 72);
        TextAreaPrintStream textAreaPrintStream = new TextAreaPrintStream((OutputStream)System.out, textArea);
        Frame frame = new Frame("PCA output");
        frame.resize(500, 500);
        frame.setLayout(new BorderLayout());
        frame.add("Center", textArea);
        frame.show();
        long l = System.currentTimeMillis();
        this.eigenvector.tred(this.pb);
        long l2 = System.currentTimeMillis();
        textAreaPrintStream.println("Time take for tred = " + (l2 - l) + "ms");
        textAreaPrintStream.println(" ---Tridiag transform matrix ---");
        textAreaPrintStream.println(" --- D vector ---");
        this.eigenvector.printD(textAreaPrintStream);
        textAreaPrintStream.println();
        textAreaPrintStream.println(" --- E vector ---");
        this.eigenvector.printE(textAreaPrintStream);
        textAreaPrintStream.println();
        l = System.currentTimeMillis();
        this.eigenvector.tqli(this.pb);
        l2 = System.currentTimeMillis();
        if (this.pb != null) {
            this.pb.updateBar(100);
        }
        textAreaPrintStream.println("Time take for tqli = " + (l2 - l) + " ms");
        textAreaPrintStream.println(" --- Eigenvalues ---");
        this.eigenvector.printD(textAreaPrintStream);
        this.resscores = new Vector();
        int n = 0;
        while (n < this.eigenvector.cols) {
            Object object;
            double[] dArray = this.eigenvector.getColumn(n);
            double[][] dArray2 = new double[this.s.length][this.s[0].getSequence().length()];
            double d = -100000.0;
            double d2 = 100000.0;
            Hashtable[] hashtableArray = new Hashtable[this.s[0].getSequence().length()];
            int n2 = 0;
            while (n2 < this.s[0].getSequence().length()) {
                hashtableArray[n2] = new Hashtable();
                double d3 = 0.0;
                int n3 = 0;
                while (n3 < this.s.length) {
                    object = this.s[n3].getSequence().length() > n2 ? this.s[n3].getSequence().substring(n2, n2 + 1) : this.s[n3].getSequence().substring(n2);
                    double d4 = 0.0;
                    if (hashtableArray[n2].containsKey(object)) {
                        d4 = (Double)hashtableArray[n2].get(object);
                    }
                    hashtableArray[n2].put(object, new Double(d4 += dArray[n3]));
                    ++n3;
                }
                object = hashtableArray[n2].keys();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    double d5 = (Double)hashtableArray[n2].get(string);
                    if (d5 < d2) {
                        d2 = d5;
                    }
                    if (d5 > d) {
                        d = d5;
                    }
                    hashtableArray[n2].put(string, new Double(d5));
                }
                ++n2;
            }
            textAreaPrintStream.println("MAXMIN " + d + " " + d2);
            textAreaPrintStream.println("");
            int n4 = 0;
            while (n4 < this.s.length) {
                int n5 = 0;
                while (n5 < this.s[n4].getSequence().length()) {
                    Hashtable hashtable = hashtableArray[n5];
                    object = n5 < this.s[n4].getSequence().length() ? this.s[n4].getSequence().substring(n5, n5 + 1) : this.s[n4].getSequence().substring(n5);
                    float f = ((Double)hashtable.get(object)).floatValue();
                    f = (f - (float)d2) * 10.0f / (float)(d - d2);
                    dArray2[n4][n5] = f;
                    ++n5;
                }
                ++n4;
            }
            this.resscores.addElement(dArray2);
            ++n;
        }
    }
}

