/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import jalview.ProgressBar;
import java.io.PrintStream;

public class Matrix {
    double[][] value;
    int rows;
    int cols;
    double[] d;
    double[] e;

    public Matrix(double[][] dArray, int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.value = dArray;
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.cols][this.rows];
        int n = 0;
        while (n < this.cols) {
            int n2 = 0;
            while (n2 < this.rows) {
                dArray[n][n2] = this.value[n2][n];
                ++n2;
            }
            ++n;
        }
        return new Matrix(dArray, this.cols, this.rows);
    }

    public void print(PrintStream printStream) {
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                Format.print(printStream, "%8.2f", this.value[n][n2]);
                ++n2;
            }
            printStream.println();
            ++n;
        }
    }

    public Matrix preMultiply(Matrix matrix) {
        System.out.println("new matrix size " + matrix.rows + " " + this.cols);
        double[][] dArray = new double[matrix.rows][this.cols];
        int n = 0;
        while (n < matrix.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                dArray[n][n2] = 0.0;
                int n3 = 0;
                while (n3 < matrix.cols) {
                    double[] dArray2 = dArray[n];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + matrix.value[n][n3] * this.value[n3][n2];
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return new Matrix(dArray, matrix.rows, this.cols);
    }

    public double[] vectorPostMultiply(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = 0.0;
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = n;
                dArray2[n3] = dArray2[n3] + this.value[n][n2] * dArray[n2];
                ++n2;
            }
            ++n;
        }
        return dArray2;
    }

    public Matrix postMultiply(Matrix matrix) {
        double[][] dArray = new double[this.rows][matrix.cols];
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < matrix.cols) {
                dArray[n][n2] = 0.0;
                int n3 = 0;
                while (n3 < this.rows) {
                    dArray[n][n2] = dArray[n][n2] + this.value[n][n3] * matrix.value[n3][n2];
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return new Matrix(dArray, this.cols, matrix.rows);
    }

    public Matrix copy() {
        double[][] dArray = new double[this.rows][this.cols];
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                dArray[n][n2] = this.value[n][n2];
                ++n2;
            }
            ++n;
        }
        return new Matrix(dArray, this.rows, this.cols);
    }

    public void tred(ProgressBar progressBar) {
        int n;
        double d;
        int n2;
        int n3;
        int n4 = this.rows;
        this.d = new double[this.rows];
        this.e = new double[this.rows];
        int n5 = 0;
        if (progressBar != null) {
            n5 = progressBar.bc.t;
        }
        int n6 = n4;
        while (n6 >= 2) {
            if (progressBar != null) {
                progressBar.updateBar(n5 + (n4 - n6) * 50 / n4);
            }
            n3 = n6 - 1;
            double d2 = 0.0;
            double d3 = 0.0;
            if (n3 > 1) {
                n2 = 1;
                while (n2 <= n3) {
                    d3 += Math.abs(this.value[n6 - 1][n2 - 1]);
                    ++n2;
                }
                if (d3 == 0.0) {
                    this.e[n6 - 1] = this.value[n6 - 1][n3 - 1];
                } else {
                    n2 = 1;
                    while (n2 <= n3) {
                        double[] dArray = this.value[n6 - 1];
                        int n7 = n2 - 1;
                        dArray[n7] = dArray[n7] / d3;
                        d2 += this.value[n6 - 1][n2 - 1] * this.value[n6 - 1][n2 - 1];
                        ++n2;
                    }
                    double d4 = this.value[n6 - 1][n3 - 1];
                    d = d4 > 0.0 ? -1.0 * Math.sqrt(d2) : Math.sqrt(d2);
                    this.e[n6 - 1] = d3 * d;
                    d2 -= d4 * d;
                    this.value[n6 - 1][n3 - 1] = d4 - d;
                    d4 = 0.0;
                    n = 1;
                    while (n <= n3) {
                        this.value[n - 1][n6 - 1] = this.value[n6 - 1][n - 1] / d2;
                        d = 0.0;
                        n2 = 1;
                        while (n2 <= n) {
                            d += this.value[n - 1][n2 - 1] * this.value[n6 - 1][n2 - 1];
                            ++n2;
                        }
                        n2 = n + 1;
                        while (n2 <= n3) {
                            d += this.value[n2 - 1][n - 1] * this.value[n6 - 1][n2 - 1];
                            ++n2;
                        }
                        this.e[n - 1] = d / d2;
                        d4 += this.e[n - 1] * this.value[n6 - 1][n - 1];
                        ++n;
                    }
                    double d5 = d4 / (d2 + d2);
                    n = 1;
                    while (n <= n3) {
                        d4 = this.value[n6 - 1][n - 1];
                        this.e[n - 1] = d = this.e[n - 1] - d5 * d4;
                        n2 = 1;
                        while (n2 <= n) {
                            double[] dArray = this.value[n - 1];
                            int n8 = n2 - 1;
                            dArray[n8] = dArray[n8] - (d4 * this.e[n2 - 1] + d * this.value[n6 - 1][n2 - 1]);
                            ++n2;
                        }
                        ++n;
                    }
                }
            } else {
                this.e[n6 - 1] = this.value[n6 - 1][n3 - 1];
            }
            this.d[n6 - 1] = d2;
            --n6;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        n6 = 1;
        while (n6 <= n4) {
            n3 = n6 - 1;
            if (this.d[n6 - 1] != 0.0) {
                n = 1;
                while (n <= n3) {
                    d = 0.0;
                    n2 = 1;
                    while (n2 <= n3) {
                        d += this.value[n6 - 1][n2 - 1] * this.value[n2 - 1][n - 1];
                        ++n2;
                    }
                    n2 = 1;
                    while (n2 <= n3) {
                        double[] dArray = this.value[n2 - 1];
                        int n9 = n - 1;
                        dArray[n9] = dArray[n9] - d * this.value[n2 - 1][n6 - 1];
                        ++n2;
                    }
                    ++n;
                }
            }
            this.d[n6 - 1] = this.value[n6 - 1][n6 - 1];
            this.value[n6 - 1][n6 - 1] = 1.0;
            n = 1;
            while (n <= n3) {
                this.value[n - 1][n6 - 1] = 0.0;
                this.value[n6 - 1][n - 1] = 0.0;
                ++n;
            }
            ++n6;
        }
    }

    public void tqli(ProgressBar progressBar) {
        int n = this.rows;
        int n2 = 2;
        while (n2 <= n) {
            this.e[n2 - 2] = this.e[n2 - 1];
            ++n2;
        }
        this.e[n - 1] = 0.0;
        int n3 = 0;
        if (progressBar != null) {
            n3 = progressBar.bc.t;
        }
        int n4 = 1;
        while (n4 <= n) {
            int n5;
            if (progressBar != null) {
                progressBar.updateBar(n3 + n4 * 30 / n);
            }
            int n6 = 0;
            do {
                double d;
                n5 = n4;
                while (n5 <= n - 1) {
                    double d2 = Math.abs(this.d[n5 - 1]) + Math.abs(this.d[n5]);
                    if (Math.abs(this.e[n5 - 1]) + d2 == d2) break;
                    ++n5;
                }
                if (n5 == n4) continue;
                if (++n6 == 30) {
                    System.out.print("Too many iterations in tqli");
                    System.exit(0);
                }
                double d3 = (this.d[n4] - this.d[n4 - 1]) / (2.0 * this.e[n4 - 1]);
                double d4 = Math.sqrt(d3 * d3 + 1.0);
                d3 = this.d[n5 - 1] - this.d[n4 - 1] + this.e[n4 - 1] / (d3 + this.sign(d4, d3));
                double d5 = d = 1.0;
                double d6 = 0.0;
                n2 = n5 - 1;
                while (n2 >= n4) {
                    double d7 = d5 * this.e[n2 - 1];
                    double d8 = d * this.e[n2 - 1];
                    if (Math.abs(d7) >= Math.abs(d3)) {
                        d = d3 / d7;
                        d4 = Math.sqrt(d * d + 1.0);
                        this.e[n2] = d7 * d4;
                        d5 = 1.0 / d4;
                        d *= d5;
                    } else {
                        d5 = d7 / d3;
                        d4 = Math.sqrt(d5 * d5 + 1.0);
                        this.e[n2] = d3 * d4;
                        d = 1.0 / d4;
                        d5 *= d;
                    }
                    d3 = this.d[n2] - d6;
                    d4 = (this.d[n2 - 1] - d3) * d5 + 2.0 * d * d8;
                    d6 = d5 * d4;
                    this.d[n2] = d3 + d6;
                    d3 = d * d4 - d8;
                    int n7 = 1;
                    while (n7 <= n) {
                        d7 = this.value[n7 - 1][n2];
                        this.value[n7 - 1][n2] = d5 * this.value[n7 - 1][n2 - 1] + d * d7;
                        this.value[n7 - 1][n2 - 1] = d * this.value[n7 - 1][n2 - 1] - d5 * d7;
                        ++n7;
                    }
                    --n2;
                }
                this.d[n4 - 1] = this.d[n4 - 1] - d6;
                this.e[n4 - 1] = d3;
                this.e[n5 - 1] = 0.0;
            } while (n5 != n4);
            ++n4;
        }
    }

    public void tred2() {
        int n;
        double d;
        int n2;
        int n3;
        int n4 = this.rows;
        this.d = new double[this.rows];
        this.e = new double[this.rows];
        int n5 = n4 - 1;
        while (n5 >= 1) {
            n3 = n5 - 1;
            double d2 = 0.0;
            double d3 = 0.0;
            if (n3 > 0) {
                n2 = 0;
                while (n2 < n3) {
                    d3 += Math.abs(this.value[n5][n2]);
                    ++n2;
                }
                if (d3 == 0.0) {
                    this.e[n5] = this.value[n5][n3];
                } else {
                    n2 = 0;
                    while (n2 < n3) {
                        double[] dArray = this.value[n5];
                        int n6 = n2;
                        dArray[n6] = dArray[n6] / d3;
                        d2 += this.value[n5][n2] * this.value[n5][n2];
                        ++n2;
                    }
                    double d4 = this.value[n5][n3];
                    d = d4 > 0.0 ? -1.0 * Math.sqrt(d2) : Math.sqrt(d2);
                    this.e[n5] = d3 * d;
                    d2 -= d4 * d;
                    this.value[n5][n3] = d4 - d;
                    d4 = 0.0;
                    n = 0;
                    while (n < n3) {
                        this.value[n][n5] = this.value[n5][n] / d2;
                        d = 0.0;
                        n2 = 0;
                        while (n2 < n) {
                            d += this.value[n][n2] * this.value[n5][n2];
                            ++n2;
                        }
                        n2 = n;
                        while (n2 < n3) {
                            d += this.value[n2][n] * this.value[n5][n2];
                            ++n2;
                        }
                        this.e[n] = d / d2;
                        d4 += this.e[n] * this.value[n5][n];
                        ++n;
                    }
                    double d5 = d4 / (d2 + d2);
                    n = 0;
                    while (n < n3) {
                        d4 = this.value[n5][n];
                        this.e[n] = d = this.e[n] - d5 * d4;
                        n2 = 0;
                        while (n2 < n) {
                            double[] dArray = this.value[n];
                            int n7 = n2;
                            dArray[n7] = dArray[n7] - (d4 * this.e[n2] + d * this.value[n5][n2]);
                            ++n2;
                        }
                        ++n;
                    }
                }
            } else {
                this.e[n5] = this.value[n5][n3];
            }
            this.d[n5] = d2;
            --n5;
        }
        this.d[0] = 0.0;
        this.e[0] = 0.0;
        n5 = 0;
        while (n5 < n4) {
            n3 = n5 - 1;
            if (this.d[n5] != 0.0) {
                n = 0;
                while (n < n3) {
                    d = 0.0;
                    n2 = 0;
                    while (n2 < n3) {
                        d += this.value[n5][n2] * this.value[n2][n];
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < n3) {
                        double[] dArray = this.value[n2];
                        int n8 = n;
                        dArray[n8] = dArray[n8] - d * this.value[n2][n5];
                        ++n2;
                    }
                    ++n;
                }
            }
            this.d[n5] = this.value[n5][n5];
            this.value[n5][n5] = 1.0;
            n = 0;
            while (n < n3) {
                this.value[n][n5] = 0.0;
                this.value[n5][n] = 0.0;
                ++n;
            }
            ++n5;
        }
    }

    public void tqli2() {
        int n = this.rows;
        int n2 = 2;
        while (n2 <= n) {
            this.e[n2 - 2] = this.e[n2 - 1];
            ++n2;
        }
        this.e[n - 1] = 0.0;
        int n3 = 1;
        while (n3 <= n) {
            int n4;
            int n5 = 0;
            do {
                double d;
                n4 = n3;
                while (n4 <= n - 1) {
                    double d2 = Math.abs(this.d[n4 - 1]) + Math.abs(this.d[n4]);
                    if (Math.abs(this.e[n4 - 1]) + d2 == d2) break;
                    ++n4;
                }
                if (n4 == n3) continue;
                if (++n5 == 30) {
                    System.out.print("Too many iterations in tqli");
                    System.exit(0);
                }
                double d3 = (this.d[n3] - this.d[n3 - 1]) / (2.0 * this.e[n3 - 1]);
                double d4 = Math.sqrt(d3 * d3 + 1.0);
                d3 = this.d[n4 - 1] - this.d[n3 - 1] + this.e[n3 - 1] / (d3 + this.sign(d4, d3));
                double d5 = d = 1.0;
                double d6 = 0.0;
                n2 = n4 - 1;
                while (n2 >= n3) {
                    double d7 = d5 * this.e[n2 - 1];
                    double d8 = d * this.e[n2 - 1];
                    if (Math.abs(d7) >= Math.abs(d3)) {
                        d = d3 / d7;
                        d4 = Math.sqrt(d * d + 1.0);
                        this.e[n2] = d7 * d4;
                        d5 = 1.0 / d4;
                        d *= d5;
                    } else {
                        d5 = d7 / d3;
                        d4 = Math.sqrt(d5 * d5 + 1.0);
                        this.e[n2] = d3 * d4;
                        d = 1.0 / d4;
                        d5 *= d;
                    }
                    d3 = this.d[n2] - d6;
                    d4 = (this.d[n2 - 1] - d3) * d5 + 2.0 * d * d8;
                    d6 = d5 * d4;
                    this.d[n2] = d3 + d6;
                    d3 = d * d4 - d8;
                    int n6 = 1;
                    while (n6 <= n) {
                        d7 = this.value[n6 - 1][n2];
                        this.value[n6 - 1][n2] = d5 * this.value[n6 - 1][n2 - 1] + d * d7;
                        this.value[n6 - 1][n2 - 1] = d * this.value[n6 - 1][n2 - 1] - d5 * d7;
                        ++n6;
                    }
                    --n2;
                }
                this.d[n3 - 1] = this.d[n3 - 1] - d6;
                this.e[n3 - 1] = d3;
                this.e[n4 - 1] = 0.0;
            } while (n4 != n3);
            ++n3;
        }
    }

    public double sign(double d, double d2) {
        if (d2 < 0.0) {
            return -Math.abs(d);
        }
        return Math.abs(d);
    }

    public double[] getColumn(int n) {
        double[] dArray = new double[this.rows];
        int n2 = 0;
        while (n2 < this.rows) {
            dArray[n2] = this.value[n2][n];
            ++n2;
        }
        return dArray;
    }

    public void printD(PrintStream printStream) {
        int n = 0;
        while (n < this.rows) {
            Format.print(printStream, "%15.4e", this.d[n]);
            ++n;
        }
    }

    public void printE(PrintStream printStream) {
        int n = 0;
        while (n < this.rows) {
            Format.print(printStream, "%15.4e", this.e[n]);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        double[][] dArray = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                dArray[n2][n3] = Math.random();
                ++n3;
            }
            ++n2;
        }
        Matrix matrix = new Matrix(dArray, n, n);
        Matrix matrix2 = matrix.transpose();
        Matrix matrix3 = matrix2.postMultiply(matrix);
        Matrix matrix4 = matrix3.copy();
        long l = System.currentTimeMillis();
        matrix3.tred(null);
        long l2 = System.currentTimeMillis();
        l = System.currentTimeMillis();
        matrix3.tqli(null);
        l2 = System.currentTimeMillis();
    }
}

