/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.FileParse;
import jalview.Format;
import jalview.Sequence;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClustalFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    Hashtable myHash;
    Vector seqs;
    Vector headers;
    Vector ids;
    Vector words = new Vector();
    long start;
    long end;

    public ClustalFile(String string) {
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.ids = new Vector();
        this.readLines(string);
        System.out.println(this.noLines);
        System.out.println(this.lineArray.size());
        this.parse();
    }

    public ClustalFile(String string, String string2) throws IOException {
        super(string, string2);
        this.myHash = new Hashtable();
        this.seqs = new Vector();
        this.headers = new Vector();
        this.ids = new Vector();
        System.out.print("Reading file....");
        this.start = System.currentTimeMillis();
        this.readLines();
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
        System.out.println("Parsing file....");
        this.start = System.currentTimeMillis();
        this.parse();
    }

    public void parse() {
        CharSequence charSequence;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        n = 0;
        while (n < this.noLines) {
            if (this.lineArray.elementAt(n).toString().indexOf(" ") != 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.lineArray.elementAt(n).toString(), " ");
                String string = "";
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string.equals("CLUSTAL")) {
                        bl = true;
                    } else if (bl) {
                        charSequence = new StringBuffer();
                        if (this.myHash.containsKey(string)) {
                            charSequence = new StringBuffer(this.myHash.get(string).toString());
                        }
                        if (!this.headers.contains(string)) {
                            this.headers.addElement(string);
                        }
                        ((StringBuffer)charSequence).append(stringTokenizer.nextToken());
                        this.myHash.put(string, ((StringBuffer)charSequence).toString());
                    }
                }
            }
            ++n;
        }
        if (bl) {
            this.noSeqs = this.headers.size();
            n = 0;
            while (n < this.headers.size()) {
                int n2 = -1;
                int n3 = -1;
                if (this.myHash.get(this.headers.elementAt(n)) != null) {
                    Object object;
                    if (this.maxLength < this.myHash.get(this.headers.elementAt(n)).toString().length()) {
                        this.maxLength = this.myHash.get(this.headers.elementAt(n)).toString().length();
                    }
                    charSequence = this.headers.elementAt(n).toString();
                    n2 = 1;
                    n3 = this.myHash.get(this.headers.elementAt(n)).toString().length();
                    if (((String)charSequence).indexOf("/") > 0) {
                        object = new StringTokenizer((String)charSequence, "/");
                        if (((StringTokenizer)object).countTokens() == 2) {
                            this.ids.addElement(((StringTokenizer)object).nextToken());
                            String string = ((StringTokenizer)object).nextToken();
                            object = new StringTokenizer(string, "-");
                            if (((StringTokenizer)object).countTokens() == 2) {
                                n2 = Integer.valueOf(((StringTokenizer)object).nextToken());
                                n3 = Integer.valueOf(((StringTokenizer)object).nextToken());
                            }
                        } else {
                            this.ids.addElement(this.headers.elementAt(n));
                        }
                    } else {
                        this.ids.addElement(this.headers.elementAt(n));
                    }
                    object = new Sequence(this.ids.elementAt(n).toString(), this.myHash.get(this.headers.elementAt(n).toString()).toString(), n2, n3);
                    this.seqs.addElement(object);
                } else {
                    System.out.println("Can't find sequence for " + this.headers.elementAt(n));
                }
                ++n;
            }
        }
        this.end = System.currentTimeMillis();
        System.out.println("done");
        System.out.println("Total time taken = " + (this.end - this.start) + "ms");
    }

    public static String print(Sequence[] sequenceArray) {
        StringBuffer stringBuffer = new StringBuffer("CLUSTAL\n\n");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < sequenceArray.length && sequenceArray[n3] != null) {
            String string = sequenceArray[n3].getName() + "/" + sequenceArray[n3].start + "-" + sequenceArray[n3].end;
            if (sequenceArray[n3].getSequence().length() > n) {
                n = sequenceArray[n3].getSequence().length();
            }
            if (string.length() > n2) {
                n2 = string.length();
            }
            ++n3;
        }
        if (n2 < 15) {
            n2 = 15;
        }
        ++n2;
        int n4 = 60;
        int n5 = n / n4 + 1;
        n3 = 0;
        while (n3 < n5) {
            int n6 = 0;
            while (n6 < sequenceArray.length && sequenceArray[n6] != null) {
                stringBuffer.append(new Format("%-" + n2 + "s").form(sequenceArray[n6].getName() + "/" + sequenceArray[n6].start + "-" + sequenceArray[n6].end) + " ");
                int n7 = n3 * n4;
                int n8 = n7 + n4;
                if (n8 < sequenceArray[n6].getSequence().length() && n7 < sequenceArray[n6].getSequence().length()) {
                    stringBuffer.append(sequenceArray[n6].getSequence().substring(n7, n8) + "\n");
                } else if (n7 < sequenceArray[n6].getSequence().length()) {
                    stringBuffer.append(sequenceArray[n6].getSequence().substring(n7) + "\n");
                }
                ++n6;
            }
            stringBuffer.append("\n");
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "CLUSTAL\n\nt1  GTGASAAATGGNNTGATTCTGTACCTTGTGGAGACTGGCGTGATGTGCAG\nt2  AAATGATTCTGTACCTTGTGGATGGACTGGCGTGATGTGCAGCAACTATT\n\nt1  CAACTATTCGANNGTGATCCAGTGGTTTTGTCGTTGAATCTGTCTTCGAT\nt2  CGAGTGATCCAGAGGTTTTGTCCTTGAATCTGTCTTCGATGGTTCTCTCG\n\nt1  GGTTCTCGGGTAAGCTATCACCAAGCATAGGTGGATTGGTTCATCTGAAG\nt2  GGTAAGATCCACCAAGCATATGCTAGCT\n ";
        ClustalFile clustalFile = new ClustalFile(string);
        Sequence[] sequenceArray = new Sequence[clustalFile.seqs.size() + 1];
        int n = 0;
        while (n < clustalFile.seqs.size()) {
            sequenceArray[n] = (Sequence)clustalFile.seqs.elementAt(n);
            ++n;
        }
        String string2 = ClustalFile.print(sequenceArray);
        System.out.println(string2);
    }
}

