/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.Format;
import jalview.MSFfile;
import jalview.ResidueProperties;
import jalview.Sequence;
import jalview.ick;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AlignSeq {
    int[][] score;
    int[][] E;
    int[][] F;
    int[][] traceback;
    int[] seq1;
    int[] seq2;
    Sequence s1;
    Sequence s2;
    String s1str;
    String s2str;
    int maxi;
    int maxj;
    int[] aseq1;
    int[] aseq2;
    String astr1 = "";
    String astr2 = "";
    int seq1start;
    int seq1end;
    int seq2start;
    int seq2end;
    int count;
    int maxscore;
    float pid;
    int prev = 0;
    public static Hashtable dnaHash = new Hashtable();
    static String[] dna;
    static String[] pep;
    int gapOpen = 120;
    int gapExtend = 10;
    int[][] lookup = ResidueProperties.BLOSUM62;
    int defInt = 23;
    String[] intToStr = pep;
    String output = "";
    String type;
    Runtime rt;

    public AlignSeq() {
    }

    public AlignSeq(Sequence sequence, Sequence sequence2, String string) {
        this.rt = Runtime.getRuntime();
        this.SeqInit(sequence, sequence2, string);
    }

    public void SeqInit(Sequence sequence, Sequence sequence2, String string) {
        System.out.println(sequence.getSequence());
        System.out.println(sequence2.getSequence());
        this.s1str = AlignSeq.extractGaps(".", sequence.getSequence());
        this.s2str = AlignSeq.extractGaps(".", sequence2.getSequence());
        this.s1str = AlignSeq.extractGaps("-", this.s1str);
        this.s2str = AlignSeq.extractGaps("-", this.s2str);
        this.s1str = AlignSeq.extractGaps(" ", this.s1str);
        this.s2str = AlignSeq.extractGaps(" ", this.s2str);
        this.s1 = sequence;
        this.s2 = sequence2;
        this.type = string;
        if (string.equals("pep")) {
            this.lookup = ResidueProperties.BLOSUM62;
            this.intToStr = pep;
            this.defInt = 23;
        } else if (string.equals("dna")) {
            this.lookup = ResidueProperties.DNA;
            this.intToStr = dna;
            this.defInt = 4;
        } else {
            this.output = this.output + "Wrong type = dna or pep only";
            System.exit(0);
        }
        this.seq1 = new int[this.s1str.length()];
        this.seq2 = new int[this.s2str.length()];
        this.score = new int[this.s1str.length()][this.s2str.length()];
        this.E = new int[this.s1str.length()][this.s2str.length()];
        this.F = new int[this.s1str.length()][this.s2str.length()];
        this.traceback = new int[this.s1str.length()][this.s2str.length()];
        this.seq1 = this.stringToInt(this.s1str, string);
        this.seq2 = this.stringToInt(this.s2str, string);
    }

    public void traceAlignment() {
        int n = -9999;
        int n2 = this.seq1.length - 1;
        int n3 = this.seq2.length - 2;
        int n4 = n2;
        int n5 = n3;
        this.maxscore = this.score[n4][n5] / 10;
        this.seq1end = n2 + 1;
        this.seq2end = n3 + 1;
        this.aseq1 = new int[this.seq1.length + this.seq2.length];
        this.aseq2 = new int[this.seq1.length + this.seq2.length];
        this.count = this.seq1.length + this.seq2.length - 1;
        while (n4 > 0 && n5 > 0) {
            int n6;
            if (this.aseq1[this.count] != this.defInt && n4 >= 0) {
                this.aseq1[this.count] = this.seq1[n4];
                this.astr1 = this.intToStr[this.seq1[n4]] + this.astr1;
            }
            if (this.aseq2[this.count] != this.defInt && n5 > 0) {
                this.aseq2[this.count] = this.seq2[n5];
                this.astr2 = this.intToStr[this.seq2[n5]] + this.astr2;
            }
            if ((n6 = this.findTrace(n4, n5)) == 0) {
                --n4;
                --n5;
            } else if (n6 == 1) {
                --n5;
                this.aseq1[this.count] = this.defInt;
                this.astr1 = "-" + this.astr1.substring(1);
            } else if (n6 == -1) {
                --n4;
                this.aseq2[this.count] = this.defInt;
                this.astr2 = "-" + this.astr2.substring(1);
            }
            --this.count;
        }
        this.seq1start = n4 + 1;
        this.seq2start = n5 + 1;
        if (this.aseq1[this.count] != this.defInt) {
            this.aseq1[this.count] = this.seq1[n4];
            this.astr1 = this.intToStr[this.seq1[n4]] + this.astr1;
        }
        if (this.aseq2[this.count] != this.defInt) {
            this.aseq2[this.count] = this.seq2[n5];
            this.astr2 = this.intToStr[this.seq2[n5]] + this.astr2;
        }
    }

    public void printAlignment() {
        int n = this.s1.getName().length();
        if (this.s2.getName().length() > n) {
            n = this.s2.getName().length();
        }
        int n2 = 72 - n - 1;
        int n3 = (this.aseq1.length - this.count) / n2 + 1;
        this.pid = 0.0f;
        boolean bl = false;
        this.output = this.output + "Score = " + this.score[this.maxi][this.maxj] + "\n";
        this.output = this.output + "Length of alignment = " + (this.aseq1.length - this.count) + "\n";
        this.output = this.output + "Sequence ";
        this.output = this.output + new Format("%" + n + "s").form(this.s1.getName());
        this.output = this.output + " :  " + this.seq1start + " - " + this.seq1end + " (Sequence length = " + this.s1str.length() + ")\n";
        this.output = this.output + "Sequence ";
        this.output = this.output + new Format("%" + n + "s").form(this.s2.getName());
        this.output = this.output + " :  " + this.seq2start + " - " + this.seq2end + " (Sequence length = " + this.s2str.length() + ")\n\n";
        int n4 = 0;
        while (n4 < n3) {
            this.output = this.output + new Format("%" + n + "s").form(this.s1.getName()) + " ";
            int n5 = 0;
            while (n5 < n2) {
                if (this.count + n5 + n4 * n2 < this.aseq1.length) {
                    this.output = this.output + new Format("%s").form(this.intToStr[this.aseq1[this.count + n5 + n4 * n2]]);
                }
                ++n5;
            }
            this.output = this.output + "\n";
            this.output = this.output + new Format("%" + n + "s").form(" ") + " ";
            int n6 = 0;
            while (n6 < n2) {
                if (this.count + n6 + n4 * n2 < this.aseq1.length) {
                    if (this.intToStr[this.aseq1[this.count + n6 + n4 * n2]].equals(this.intToStr[this.aseq2[this.count + n6 + n4 * n2]]) && !this.intToStr[this.aseq1[this.count + n6 + n4 * n2]].equals("-")) {
                        this.pid += 1.0f;
                        this.output = this.output + "|";
                    } else {
                        this.output = this.type.equals("pep") ? (ResidueProperties.getPAM250(this.intToStr[this.aseq1[this.count + n6 + n4 * n2]], this.intToStr[this.aseq2[this.count + n6 + n4 * n2]]) > 0 ? this.output + "." : this.output + " ") : this.output + " ";
                    }
                }
                ++n6;
            }
            this.output = this.output + "\n";
            this.output = this.output + new Format("%" + n + "s").form(this.s2.getName()) + " ";
            int n7 = 0;
            while (n7 < n2) {
                if (this.count + n7 + n4 * n2 < this.aseq1.length) {
                    this.output = this.output + new Format("%s").form(this.intToStr[this.aseq2[this.count + n7 + n4 * n2]]);
                }
                ++n7;
            }
            this.output = this.output + "\n\n";
            ++n4;
        }
        this.pid = this.pid / (float)(this.aseq1.length - this.count) * 100.0f;
        this.output = this.output + new Format("Percentage ID = %2.2f\n\n").form(this.pid);
    }

    public void printScoreMatrix(int[][] nArray) {
        int n = this.seq1.length;
        int n2 = this.seq2.length;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if (n3 == 0) {
                Format.print(System.out, "%8s", this.s2str.substring(0, 1));
                n4 = 1;
                while (n4 < n2) {
                    Format.print(System.out, "%5s", this.s2str.substring(n4, n4 + 1));
                    ++n4;
                }
                System.out.println();
            }
            n4 = 0;
            while (n4 < n2) {
                if (n4 == 0) {
                    Format.print(System.out, "%3s", this.s1str.substring(n3, n3 + 1));
                }
                Format.print(System.out, "%3d ", nArray[n3][n4] / 10);
                ++n4;
            }
            System.out.println();
            ++n3;
        }
    }

    public void printScoreMatrix(int[][] nArray, int[][] nArray2) {
        int n = this.seq1.length;
        int n2 = this.seq2.length;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if (n3 == 0) {
                Format.print(System.out, "%20s", this.s2str.substring(0, 1));
                n4 = 1;
                while (n4 < n2) {
                    Format.print(System.out, "%12s", this.s2str.substring(n4, n4 + 1));
                    ++n4;
                }
                System.out.println();
            }
            n4 = 0;
            while (n4 < n2) {
                if (n4 == 0) {
                    Format.print(System.out, "%12s", this.s1str.substring(n3, n3 + 1));
                }
                Format.print(System.out, "%4d ", nArray[n3][n4] / 10);
                Format.print(System.out, "(%4d) ", nArray2[n3][n4] / 10);
                ++n4;
            }
            System.out.println();
            ++n3;
        }
    }

    public int findTrace(int n, int n2) {
        int n3 = 0;
        int n4 = this.score[n - 1][n2 - 1] + this.lookup[this.seq1[n]][this.seq2[n2]] * 10;
        if (this.F[n][n2] > n4) {
            n4 = this.F[n][n2];
            n3 = -1;
        } else if (this.F[n][n2] == n4) {
            if (this.prev == -1) {
                n4 = this.F[n][n2];
                n3 = -1;
            }
        } else if (this.E[n][n2] > n4) {
            n4 = this.E[n][n2];
            n3 = 1;
        } else if (this.E[n][n2] == n4 && this.prev == 1) {
            n4 = this.E[n][n2];
            n3 = 1;
        }
        this.prev = n3;
        return n3;
    }

    public void calcScoreMatrix() {
        int n = this.seq1.length;
        int n2 = this.seq2.length;
        this.score[0][0] = this.lookup[this.seq1[0]][this.seq2[0]] * 10;
        this.E[0][0] = -this.gapOpen;
        this.F[0][0] = -this.gapOpen;
        int n3 = 1;
        while (n3 < n2) {
            this.E[0][n3] = this.max(this.score[0][n3 - 1] - this.gapOpen, this.E[0][n3 - 1] - this.gapExtend);
            this.F[0][n3] = -this.gapOpen;
            this.score[0][n3] = this.max(this.lookup[this.seq1[0]][this.seq2[n3]] * 10, -this.gapOpen, -this.gapExtend);
            this.traceback[0][n3] = 1;
            ++n3;
        }
        int n4 = 1;
        while (n4 < n) {
            this.E[n4][0] = -this.gapOpen;
            this.F[n4][0] = this.max(this.score[n4 - 1][0] - this.gapOpen, this.F[n4 - 1][0] - this.gapExtend);
            this.score[n4][0] = this.max(this.lookup[this.seq1[n4]][this.seq2[0]] * 10, this.E[n4][0], this.F[n4][0]);
            this.traceback[n4][0] = -1;
            ++n4;
        }
        int n5 = 1;
        while (n5 < n) {
            int n6 = 1;
            while (n6 < n2) {
                this.E[n5][n6] = this.max(this.score[n5][n6 - 1] - this.gapOpen, this.E[n5][n6 - 1] - this.gapExtend);
                this.F[n5][n6] = this.max(this.score[n5 - 1][n6] - this.gapOpen, this.F[n5 - 1][n6] - this.gapExtend);
                this.score[n5][n6] = this.max(this.score[n5 - 1][n6 - 1] + this.lookup[this.seq1[n5]][this.seq2[n6]] * 10, this.E[n5][n6], this.F[n5][n6]);
                this.traceback[n5][n6] = this.findTrace(n5, n6);
                ++n6;
            }
            ++n5;
        }
    }

    public static String extractChars(String string, String string2) {
        String string3 = string2;
        int n = 0;
        while (n < string.length()) {
            String string4 = string.substring(n, n + 1);
            string3 = AlignSeq.extractGaps(string4, string3);
            ++n;
        }
        return string3;
    }

    public static String extractGaps(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = string3 + stringTokenizer.nextToken();
        }
        return string3;
    }

    public int max(int n, int n2, int n3) {
        int n4 = n;
        if (n2 > n) {
            n4 = n2;
        }
        if (n3 > n4) {
            n4 = n3;
        }
        return n4;
    }

    public int max(int n, int n2) {
        int n3 = n;
        if (n2 > n) {
            n3 = n2;
        }
        return n3;
    }

    public int[] stringToInt(String string, String string2) {
        int[] nArray = new int[string.length()];
        int n = 0;
        while (n < string.length()) {
            String string3 = string.substring(n, n + 1).toUpperCase();
            try {
                if (string2.equals("pep")) {
                    nArray[n] = (Integer)ResidueProperties.aaHash.get(string3);
                } else if (string2.equals("dna")) {
                    nArray[n] = (Integer)dnaHash.get(string3);
                }
                if (nArray[n] > 23) {
                    nArray[n] = 23;
                }
            }
            catch (Exception exception) {
                nArray[n] = string2.equals("dna") ? 4 : 23;
            }
            ++n;
        }
        return nArray;
    }

    public void displayTrace(Graphics graphics, int n, int n2, int n3) {
        int n4 = n - 1;
        int n5 = n2 - 1;
        while (n4 > 0 && n5 > 0) {
            int n6 = this.findTrace(n4, n5);
            if (n6 == 0) {
                --n4;
                --n5;
            } else if (n6 == 1) {
                --n5;
                this.aseq1[this.count] = this.defInt;
                this.astr1 = "-" + this.astr1.substring(1);
            } else if (n6 == -1) {
                --n4;
                this.aseq2[this.count] = this.defInt;
                this.astr2 = "-" + this.astr2.substring(1);
            }
            int n7 = n3 * n4;
            int n8 = n3 * n5;
            graphics.setColor(Color.white);
            graphics.fillRect(n7, n8, n3, n3);
        }
    }

    public static void displayMatrix(Graphics graphics, int[][] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = -1000;
        int n6 = 1000;
        int n7 = 0;
        while (n7 < n) {
            n4 = 0;
            while (n4 < n2) {
                if (nArray[n7][n4] >= n5) {
                    n5 = nArray[n7][n4];
                }
                if (nArray[n7][n4] <= n6) {
                    n6 = nArray[n7][n4];
                }
                ++n4;
            }
            ++n7;
        }
        n4 = 0;
        while (n4 < n) {
            int n8 = 0;
            while (n8 < n2) {
                int n9 = n3 * n4;
                int n10 = n3 * n8;
                float f = (float)(nArray[n4][n8] - n6) / (float)(n5 - n6);
                graphics.setColor(new Color(f, 0.0f, 0.0f));
                graphics.fillRect(n9, n10, n3, n3);
                ++n8;
            }
            ++n4;
        }
    }

    public static void main(String[] stringArray) {
        MSFfile mSFfile = null;
        try {
            if (stringArray.length != 3) {
                System.out.println("args: <msffile> <File|URL> <pep|dna>");
                System.exit(0);
            }
            mSFfile = new MSFfile(stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println("exception in msf parsing " + exception);
        }
        if (mSFfile != null) {
            int n;
            Sequence[] sequenceArray = new Sequence[mSFfile.seqs.size()];
            int[][] nArray = new int[mSFfile.seqs.size()][mSFfile.seqs.size()];
            int n2 = 0;
            int n3 = 0;
            while (n3 < mSFfile.seqs.size()) {
                sequenceArray[n3] = (Sequence)mSFfile.seqs.elementAt(n3);
                ++n3;
            }
            int n4 = 1;
            while (n4 < 2) {
                n = 0;
                while (n < n4) {
                    AlignSeq alignSeq = new AlignSeq(sequenceArray[n4], sequenceArray[n], stringArray[2]);
                    alignSeq.calcScoreMatrix();
                    alignSeq.traceAlignment();
                    alignSeq.printAlignment();
                    nArray[n4][n] = alignSeq.maxscore;
                    n2 += alignSeq.maxscore;
                    System.out.println(alignSeq.output);
                    Frame frame = new Frame("Score matrix");
                    Panel panel = new Panel();
                    panel.setLayout(new BorderLayout());
                    ick ick2 = new ick(alignSeq);
                    int n5 = 500 / sequenceArray[n4].sequence.length();
                    panel.add("Center", ick2);
                    frame.setLayout(new BorderLayout());
                    frame.add("Center", panel);
                    System.out.println(alignSeq.s1str.length() + " " + alignSeq.s2str.length());
                    frame.resize(alignSeq.s1str.length() * n5, alignSeq.s2str.length() * n5);
                    frame.show();
                    ++n;
                }
                ++n4;
            }
            System.out.println();
            System.out.print("      ");
            n = 1;
            while (n < mSFfile.seqs.size()) {
                Format.print(System.out, "%6d ", n);
                ++n;
            }
            System.out.println();
            int n6 = 1;
            while (n6 < mSFfile.seqs.size()) {
                Format.print(System.out, "%6d", n6 + 1);
                int n7 = 0;
                while (n7 < n6) {
                    Format.print(System.out, "%7.3f", (float)nArray[n6][n7] / (float)n2);
                    ++n7;
                }
                System.out.println();
                ++n6;
            }
        }
    }

    static {
        dnaHash.put("C", new Integer(0));
        dnaHash.put("T", new Integer(1));
        dnaHash.put("A", new Integer(2));
        dnaHash.put("G", new Integer(3));
        dnaHash.put("-", new Integer(4));
        dna = new String[]{"C", "T", "A", "G", "-"};
        pep = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "B", "Z", "X", "-"};
    }
}

