/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import MCview.PDBChain;
import MCview.PDBfile;
import MCview.rotFrame;
import jalview.AlignSeq;
import jalview.AlignmentPanel;
import jalview.AppletFilePopup;
import jalview.AppletPostscriptPopup;
import jalview.BigPanel;
import jalview.Blosum62ColourScheme;
import jalview.BuriedColourScheme;
import jalview.ClustalwCGI;
import jalview.ClustalwThread;
import jalview.ClustalxColourScheme;
import jalview.ColourChooserFrame;
import jalview.Conservation;
import jalview.ConservationColourScheme;
import jalview.DrawableSequence;
import jalview.FeatureFrame;
import jalview.FilePopup;
import jalview.FileProperties;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.GroupPopup;
import jalview.HelixColourScheme;
import jalview.HydrophobicColourScheme;
import jalview.IncrementPopup;
import jalview.InputPopup;
import jalview.JnetCGI;
import jalview.MailProperties;
import jalview.MailTextPopup;
import jalview.OutputFilePopup;
import jalview.OutputGenerator;
import jalview.OutputPopup;
import jalview.PCAThread;
import jalview.PDBPopup;
import jalview.PIDColourScheme;
import jalview.PairAlignThread;
import jalview.PercentIdentityPopup;
import jalview.PostalCGI;
import jalview.Postscript;
import jalview.PostscriptFilePopup;
import jalview.PostscriptPopup;
import jalview.PostscriptProperties;
import jalview.ProgressBar;
import jalview.ProgressFrame;
import jalview.RedundancyPopup;
import jalview.ResidueProperties;
import jalview.ScorePanel;
import jalview.ScoreSequence;
import jalview.Sequence;
import jalview.SequenceFeatureThread;
import jalview.SequenceGroup;
import jalview.SequenceNode;
import jalview.SimpleBrowser;
import jalview.StrandColourScheme;
import jalview.TaylorColourScheme;
import jalview.TextAreaPrintStream;
import jalview.TreeFile;
import jalview.TreeThread;
import jalview.TurnColourScheme;
import jalview.URLPopup;
import jalview.ZappoColourScheme;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class AlignFrame
extends Frame
implements OutputGenerator {
    MenuBar mb;
    Menu file;
    Menu edit;
    Menu font;
    Menu view;
    Menu colour;
    Menu calc;
    Menu help;
    Menu align;
    MenuItem gapCharacter;
    CheckboxMenuItem groupEdit;
    CheckboxMenuItem fastDraw;
    CheckboxMenuItem helvetica;
    CheckboxMenuItem courier;
    CheckboxMenuItem times;
    CheckboxMenuItem zappo;
    CheckboxMenuItem clustalx;
    CheckboxMenuItem taylor;
    CheckboxMenuItem Hydrophobicity;
    CheckboxMenuItem helix;
    CheckboxMenuItem strand;
    CheckboxMenuItem turn;
    CheckboxMenuItem buried;
    CheckboxMenuItem conservation;
    CheckboxMenuItem autoconsensus;
    CheckboxMenuItem PID;
    CheckboxMenuItem BLOSUM62;
    MenuItem features;
    MenuItem structures;
    MenuItem PIDthreshold;
    MenuItem incitem;
    MenuItem userColours;
    CheckboxMenuItem colourText;
    CheckboxMenuItem blackText;
    CheckboxMenuItem boxes;
    CheckboxMenuItem text;
    CheckboxMenuItem scores;
    CheckboxMenuItem wrap;
    public BigPanel bp;
    public AlignmentPanel ap;
    Object parent;
    Label status;
    Label redraw;
    Panel labelPanel;
    public Hashtable[] cons;
    public PCAThread pca;
    public TreeThread tt;
    public SimpleBrowser browser;
    public FeatureFrame ff;
    SequenceFeatureThread sft;
    String srsServer = "srs.ebi.ac.uk/srs7bin/cgi-bin/";
    String database = "swall";
    String tempdir = "temp";
    public MailProperties mp;
    public FileProperties fp;
    public PostscriptProperties pp;
    int threshold = 0;
    int increment = 30;
    public boolean hasAlignment = false;

    public AlignFrame(Object object, DrawableSequence[] drawableSequenceArray) {
        this.bp = new BigPanel(this, drawableSequenceArray);
        this.ap = this.bp;
        this.hasAlignment = true;
        this.parent = object;
        this.frameInit();
        this.propertiesInit();
    }

    public AlignFrame(DrawableSequence[] drawableSequenceArray) {
        this.bp = new BigPanel(this, drawableSequenceArray);
        this.hasAlignment = true;
        this.ap = this.bp;
        this.frameInit();
        this.propertiesInit();
    }

    public AlignFrame(Object object, String string, String string2, String string3) {
        this.parent = object;
        DrawableSequence[] drawableSequenceArray = null;
        drawableSequenceArray = FormatAdapter.toDrawableSequence(FormatAdapter.read(string, string2, string3));
        this.bp = new BigPanel(this, drawableSequenceArray);
        System.out.println("Made BigPanel");
        this.ap = this.bp;
        this.frameInit();
        System.out.println("finished framInit");
        this.propertiesInit();
        System.out.println("finished propertiesInit");
        this.hasAlignment = true;
    }

    private void setQuality() {
        this.ap.seqPanel.align.percentIdentity2();
        this.ap.seqPanel.align.findQuality();
        DrawableSequence[] drawableSequenceArray = new ScoreSequence[]{this.ap.seqPanel.align.qualityScore};
        this.bp.setScorePanel(new ScorePanel(this, drawableSequenceArray));
    }

    public void propertiesInit() {
        this.mp = new MailProperties();
        this.mp.server = "circinus.ebi.ac.uk";
        this.pp = new PostscriptProperties();
        this.fp = new FileProperties();
    }

    public void frameInit() {
        System.out.println("Java version = " + System.getProperty("java.version"));
        this.fileMenu();
        this.editMenu();
        this.fontMenu();
        this.viewMenu();
        this.colourMenu();
        this.calcMenu();
        this.helpMenu();
        this.alignMenu();
        this.mb = new MenuBar();
        this.mb.add(this.file);
        this.mb.add(this.edit);
        this.mb.add(this.font);
        this.mb.add(this.view);
        this.mb.add(this.colour);
        this.mb.add(this.calc);
        this.mb.add(this.align);
        this.mb.add(this.help);
        this.setMenuBar(this.mb);
        this.setLayout(new BorderLayout());
        this.setQuality();
        this.status = new Label("Status : ", 0);
        this.redraw = new Label(" ", 2);
        this.labelPanel = new Panel();
        this.labelPanel.setLayout(new GridLayout(1, 3));
        this.add("South", this.labelPanel);
        this.labelPanel.add(this.status);
        this.add("Center", this.ap);
        this.resize(700, 500);
        this.show();
        this.updateFont();
        System.out.println("three");
        this.updateFont();
        System.out.println("four");
    }

    public void setStates(CheckboxMenuItem checkboxMenuItem, String string, boolean bl, boolean bl2) {
        checkboxMenuItem.setState(true);
        if (checkboxMenuItem.getState()) {
            if (checkboxMenuItem != this.zappo) {
                this.zappo.setState(false);
            }
            if (checkboxMenuItem != this.taylor) {
                this.taylor.setState(false);
            }
            if (checkboxMenuItem != this.PID) {
                this.PID.setState(false);
            }
            if (checkboxMenuItem != this.BLOSUM62) {
                this.BLOSUM62.setState(false);
            }
            if (checkboxMenuItem != this.Hydrophobicity) {
                this.Hydrophobicity.setState(false);
            }
            if (checkboxMenuItem != this.helix) {
                this.helix.setState(false);
            }
            if (checkboxMenuItem != this.strand) {
                this.strand.setState(false);
            }
            if (checkboxMenuItem != this.turn) {
                this.turn.setState(false);
            }
            if (checkboxMenuItem != this.buried) {
                this.buried.setState(false);
            }
            if (checkboxMenuItem != this.clustalx) {
                this.clustalx.setState(false);
            }
            this.updateFont();
            if (bl) {
                this.PIDthreshold.enable();
            } else {
                this.PIDthreshold.disable();
            }
            if (checkboxMenuItem == this.zappo && bl2) {
                this.userColours.enable();
            } else {
                this.userColours.disable();
            }
        }
        this.status.setText(string);
        this.status.validate();
    }

    public boolean action(Event event, Object object) {
        System.out.println("Event is " + event);
        if (event.target instanceof CheckboxMenuItem) {
            String string = ((CheckboxMenuItem)event.target).getLabel();
            if (string.equals("Boxes")) {
                this.ap.seqPanel.seqCanvas.boxFlag = !this.ap.seqPanel.seqCanvas.boxFlag;
                this.setBoxes(this.boxes.getState());
                this.updateFont();
                if (this.boxes.getState()) {
                    this.status.setText("Residue boxes on");
                } else {
                    this.status.setText("Residue boxes off");
                }
                this.status.validate();
            } else if (string.equals("Scores")) {
                this.ap.seqPanel.seqCanvas.showScores = this.scores.getState();
                this.ap.idPanel.idCanvas.showScores = this.scores.getState();
                this.updateFont();
                if (this.scores.getState()) {
                    this.status.setText("Showing scores");
                } else {
                    this.status.setText("Hiding scores");
                }
            } else if (string.equals("Wrap alignment")) {
                this.ap.seqPanel.seqCanvas.wrap = this.wrap.getState();
                this.ap.idPanel.idCanvas.wrap = this.wrap.getState();
                this.ap.seqPanel.seqCanvas.paintFlag = true;
                this.ap.seqPanel.setScrollValues(0, 0);
                this.ap.seqPanel.offx = 0;
                this.ap.seqPanel.offy = 0;
                this.ap.scaleheight = this.wrap.getState() ? 0 : 20;
                this.updateFont();
                if (this.wrap.getState()) {
                    this.status.setText("Wrapping alignment");
                } else {
                    this.status.setText("Unwrapping alignment");
                }
            } else if (string.equals("Group editing mode")) {
                this.ap.groupEdit = this.groupEdit.getState();
                if (this.ap.groupEdit) {
                    this.status.setText("Group editing mode on");
                } else {
                    this.status.setText("Group editing mode off");
                }
                this.status.validate();
            } else if (string.equals("Text")) {
                this.ap.seqPanel.seqCanvas.textFlag = !this.ap.seqPanel.seqCanvas.textFlag;
                this.setText(this.text.getState());
                this.updateFont();
                if (this.text.getState()) {
                    this.status.setText("Residue text on");
                } else {
                    this.status.setText("Residue text off");
                }
                this.status.validate();
            } else if (string.equals("Zappo Colourscheme")) {
                this.status.setText("Setting Zappo colours...");
                this.status.validate();
                this.ap.setSequenceColor(new ZappoColourScheme());
                this.ap.color = ResidueProperties.color;
                this.setStates(this.zappo, string, true, true);
            } else if (string.equals("Clustalx colours")) {
                this.status.setText("Setting clustalx colours...");
                this.status.validate();
                this.incitem.disable();
                this.conservation.disable();
                long l = System.currentTimeMillis();
                this.ap.seqPanel.align.percentIdentity2();
                long l2 = System.currentTimeMillis();
                System.out.println("Time for consensus " + (l2 - l));
                l = System.currentTimeMillis();
                this.ap.setSequenceColor(new ClustalxColourScheme(this.ap.seqPanel.align.cons2, this.ap.seqPanel.align.size()));
                l2 = System.currentTimeMillis();
                System.out.println("Time for colours " + (l2 - l));
                this.ap.color = ResidueProperties.color;
                this.setStates(this.clustalx, string, false, false);
            } else if (string.equals("Strand propensity")) {
                this.status.setText("Setting strand colours...");
                this.status.validate();
                this.ap.setSequenceColor(new StrandColourScheme());
                this.setStates(this.strand, "Strand propensity", true, true);
            } else if (string.equals("Helix propensity")) {
                this.status.setText("Setting helix colours...");
                this.status.validate();
                this.ap.setSequenceColor(new HelixColourScheme());
                this.setStates(this.helix, "Helix propensity", true, true);
            } else if (string.equals("Turn propensity")) {
                this.status.setText("Setting turn colours...");
                this.status.validate();
                this.ap.setSequenceColor(new TurnColourScheme());
                this.setStates(this.turn, "Turn propensity", true, true);
            } else if (string.equals("Buried index")) {
                this.status.setText("Setting buried colours...");
                this.status.validate();
                this.ap.setSequenceColor(new BuriedColourScheme());
                this.setStates(this.helix, "Buried index", true, true);
            } else if (string.equals("Taylor Colourscheme")) {
                this.status.setText("Setting Taylor colours...");
                this.status.validate();
                this.ap.setSequenceColor(new TaylorColourScheme());
                this.setStates(this.taylor, "Willie Taylor Colours", true, true);
            } else if (string.equals("By PID")) {
                this.status.setText("Setting PID colours...");
                this.status.validate();
                this.ap.setSequenceColor(new PIDColourScheme(this.ap.seqPanel.align.cons));
                this.setStates(this.PID, "Percentage identity colours", false, false);
            } else if (string.equals("By BLOSUM62 score")) {
                this.status.setText("Setting BLOSUM62 colours...");
                this.status.validate();
                this.ap.setSequenceColor(new Blosum62ColourScheme());
                this.setStates(this.BLOSUM62, "BLOSUM62 score colours", false, false);
            } else if (string.equals("By Hydrophobicity")) {
                this.status.setText("Setting hydrophobicity colours...");
                this.status.validate();
                this.ap.setSequenceColor(new HydrophobicColourScheme());
                this.setStates(this.Hydrophobicity, "colour by hydrophobicity", true, false);
            } else if (string.equals("By conservation")) {
                if (this.conservation.getState()) {
                    this.status.setText("Colouring by conservation");
                    this.status.validate();
                    this.incitem.enable();
                    this.ap.conservation = true;
                    int n = 0;
                    while (n < this.ap.seqPanel.align.groups.size()) {
                        SequenceGroup sequenceGroup = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(n);
                        if (sequenceGroup.conserve != null) {
                            sequenceGroup.colourScheme = new ConservationColourScheme(sequenceGroup);
                            sequenceGroup.colourScheme.setColours(sequenceGroup);
                            this.updateFont();
                        }
                        ++n;
                    }
                } else {
                    this.status.setText("No conservation colouring");
                    this.status.validate();
                    this.incitem.disable();
                    this.ap.conservation = false;
                    if (!this.PID.getState() || !this.BLOSUM62.getState()) {
                        this.PIDthreshold.enable();
                    }
                    int n = 0;
                    while (n < this.ap.seqPanel.align.groups.size()) {
                        SequenceGroup sequenceGroup = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(n);
                        if (sequenceGroup.colourScheme instanceof ConservationColourScheme) {
                            sequenceGroup.colourScheme = ((ConservationColourScheme)sequenceGroup.colourScheme).cs;
                            sequenceGroup.colourScheme.setColours(sequenceGroup);
                            this.updateFont();
                        }
                        ++n;
                    }
                }
            } else if (string.equals("Colour text")) {
                this.ap.seqPanel.seqCanvas.colourText = this.colourText.getState();
                this.blackText.setState(!this.colourText.getState());
                this.setColourText(this.colourText.getState());
                if (this.colourText.getState()) {
                    this.status.setText("Colouring text");
                    this.status.validate();
                } else {
                    this.status.setText("Text colour black");
                    this.status.validate();
                }
                this.updateFont();
            } else if (string.equals("Black text")) {
                this.ap.seqPanel.seqCanvas.colourText = !this.blackText.getState();
                this.colourText.setState(!this.blackText.getState());
                this.setColourText(this.colourText.getState());
                this.updateFont();
                if (this.colourText.getState()) {
                    this.status.setText("Colouring text");
                    this.status.validate();
                } else {
                    this.status.setText("Text colour black");
                    this.status.validate();
                }
            } else if (string.equals("Fast Draw")) {
                this.ap.seqPanel.setFastDraw(this.fastDraw.getState());
                if (this.bp.scorePanel != null) {
                    this.bp.scorePanel.seqPanel.setFastDraw(this.fastDraw.getState());
                }
                if (this.fastDraw.getState()) {
                    this.status.setText("Fast draw mode on");
                    this.status.validate();
                    this.courier.setState(false);
                    this.times.setState(false);
                    this.helvetica.setState(false);
                    this.times.disable();
                    this.helvetica.disable();
                    this.courier.disable();
                    this.setFont("Courier");
                    this.updateFont();
                } else {
                    this.status.setText("Fast draw mode off");
                    this.status.validate();
                    this.courier.setState(true);
                    this.times.setState(false);
                    this.helvetica.setState(false);
                    this.times.enable();
                    this.helvetica.enable();
                    this.courier.enable();
                    this.setFont("Courier");
                    this.updateFont();
                }
            } else if (string.equals("Helvetica")) {
                this.status.setText("Changing font...");
                this.status.validate();
                this.helvetica.setState(true);
                this.times.setState(false);
                this.courier.setState(false);
                if (!this.ap.seqPanel.seqCanvas.fontName.equals("Helvetica")) {
                    this.setFont("Helvetica");
                }
            } else if (string.equals("Courier")) {
                this.status.setText("Changing font...");
                this.status.validate();
                this.helvetica.setState(false);
                this.times.setState(false);
                this.courier.setState(true);
                if (!this.ap.seqPanel.seqCanvas.fontName.equals("Courier")) {
                    this.setFont("Courier");
                }
            } else if (string.equals("Times-Roman")) {
                this.status.setText("Changing font...");
                this.status.validate();
                this.helvetica.setState(false);
                this.times.setState(true);
                this.courier.setState(false);
                if (!this.ap.seqPanel.seqCanvas.fontName.equals("TimesRoman")) {
                    this.setFont("TimesRoman");
                }
            } else if (string.equals("Autocalculate consensus")) {
                if (this.ap.seqPanel.align.autoConsensus) {
                    this.status.setText("Automatic consensus calculation OFF");
                } else {
                    this.status.setText("Automatic consensus calculation ON");
                }
                this.ap.seqPanel.align.autoConsensus = !this.ap.seqPanel.align.autoConsensus;
                this.autoconsensus.setState(this.ap.seqPanel.align.autoConsensus);
            }
        } else {
            if (event.target instanceof MenuItem) {
                String string = (String)object;
                if (string.equals("Quit")) {
                    this.status.setText("Closing frame...");
                    this.status.validate();
                    this.hide();
                    this.dispose();
                    System.out.println(this.parent);
                    if (!(this.parent instanceof Applet)) {
                        this.status.setText("Exiting...");
                        this.status.validate();
                        System.exit(0);
                    }
                } else if (string.equals("Close")) {
                    this.status.setText("Closing frame...");
                    this.status.validate();
                    this.hide();
                    this.dispose();
                } else if (string.equals("Set gap character to .")) {
                    this.status.setText("Changing gap character...");
                    this.status.validate();
                    this.ap.seqPanel.align.gapCharacter = ".";
                    this.edit.remove(this.gapCharacter);
                    this.gapCharacter = new MenuItem("Set gap character to -");
                    this.edit.add(this.gapCharacter);
                } else if (string.equals("Set gap character to -")) {
                    this.status.setText("Changing gap character...");
                    this.status.validate();
                    this.ap.seqPanel.align.gapCharacter = "-";
                    this.edit.remove(this.gapCharacter);
                    this.gapCharacter = new MenuItem("Set gap character to .");
                    this.edit.add(this.gapCharacter);
                } else if (string.equals("Mail alignment...")) {
                    this.status.setText("Creating mail window...");
                    this.status.validate();
                    MailTextPopup mailTextPopup = new MailTextPopup((Frame)this, "Mail text alignment", this);
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Mail postscript...")) {
                    this.status.setText("Creating mail window...");
                    this.status.validate();
                    PostscriptPopup postscriptPopup = new PostscriptPopup((Frame)this, "Mail postscript", this);
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Groups...")) {
                    this.status.setText("Creating group edit window...");
                    this.status.validate();
                    GroupPopup groupPopup = new GroupPopup((Frame)this, "Group properties", this.ap.seqPanel.align);
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Remove gapped columns")) {
                    this.status.setText("Removing gaps...");
                    this.status.validate();
                    this.ap.seqPanel.align.removeGappedColumns();
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Delete selected sequences")) {
                    this.status.setText("Deleting selected sequences...");
                    this.status.validate();
                    int n = 0;
                    while (n < this.ap.sel.size()) {
                        this.ap.seqPanel.align.deleteSequence((DrawableSequence)this.ap.sel.elementAt(n));
                        ++n;
                    }
                    this.ap.sel.removeAllElements();
                    if (this.ap instanceof BigPanel) {
                        BigPanel bigPanel = (BigPanel)this.ap;
                        int n2 = 0;
                        while (n2 < bigPanel.scorePanel.sel.size()) {
                            bigPanel.scorePanel.seqPanel.align.deleteSequence((DrawableSequence)bigPanel.scorePanel.sel.elementAt(n2));
                            ++n2;
                        }
                        bigPanel.scorePanel.sel.removeAllElements();
                    }
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Remote alignment at EBI")) {
                    Thread thread;
                    Object object2;
                    this.status.setText("Aligning sequences remotely...");
                    this.status.validate();
                    Sequence[] sequenceArray = new Sequence[this.ap.seqPanel.align.size()];
                    int n = 0;
                    while (n < sequenceArray.length) {
                        object2 = AlignSeq.extractGaps(" ", this.ap.seqPanel.align.ds[n].getSequence());
                        object2 = AlignSeq.extractGaps("-", (String)object2);
                        object2 = AlignSeq.extractGaps(".", (String)object2);
                        sequenceArray[n] = new Sequence(this.ap.seqPanel.align.ds[n].name, (String)object2, this.ap.seqPanel.align.ds[n].start, this.ap.seqPanel.align.ds[n].end);
                        ++n;
                    }
                    this.status.setText("Creating progress frame");
                    this.status.validate();
                    object2 = new ProgressFrame("Clustalw progress...", this, null);
                    TextAreaPrintStream textAreaPrintStream = new TextAreaPrintStream((OutputStream)System.out, ((ProgressFrame)object2).ta);
                    ClustalwCGI clustalwCGI = new ClustalwCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runclustal", sequenceArray, (PrintStream)textAreaPrintStream);
                    ((ProgressFrame)object2).pp.ct = thread = new Thread(clustalwCGI);
                    ((Window)object2).show();
                    Thread thread2 = new Thread(((ProgressFrame)object2).pp);
                    thread2.start();
                    thread.start();
                    this.status.setText("Starting clustalw thread...");
                    this.status.validate();
                } else if (string.equals("Remote postal analysis at EBI")) {
                    Thread thread;
                    this.status.setText("Remote postal analysis...");
                    this.status.validate();
                    Sequence[] sequenceArray = new Sequence[this.ap.seqPanel.align.size()];
                    this.status.setText("Creating progress frame");
                    this.status.validate();
                    ProgressFrame progressFrame = new ProgressFrame("Postal progress...", this, null);
                    TextAreaPrintStream textAreaPrintStream = new TextAreaPrintStream((OutputStream)System.out, progressFrame.ta);
                    PostalCGI postalCGI = new PostalCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runpostal", this.ap.seqPanel.align.ds, (PrintStream)textAreaPrintStream);
                    progressFrame.pp.ct = thread = new Thread(postalCGI);
                    progressFrame.show();
                    Thread thread3 = new Thread(progressFrame.pp);
                    thread3.start();
                    thread.start();
                    this.status.setText("Starting postal thread...");
                    this.status.validate();
                } else if (string.equals("Remote Jnet analysis at EBI")) {
                    Object object3;
                    JnetCGI jnetCGI;
                    this.status.setText("Running Jnet remotely...");
                    this.status.validate();
                    int n = 0;
                    if (this.ap.sel.size() == 0) {
                        while (n < this.ap.seqPanel.align.ds.length && this.ap.seqPanel.align.ds[n] != null) {
                            this.ap.seqPanel.align.ds[n].sequence = this.ap.seqPanel.align.ds[n].sequence.toUpperCase();
                            ++n;
                        }
                        jnetCGI = new JnetCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runjnet", this.ap.seqPanel.align.ds, System.out, this);
                    } else {
                        object3 = new DrawableSequence[this.ap.sel.size()];
                        int n3 = 0;
                        while (n3 < this.ap.sel.size()) {
                            object3[n3] = (DrawableSequence)this.ap.sel.elementAt(n3);
                            ++n3;
                        }
                        jnetCGI = new JnetCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runjnet", (Sequence[])object3, System.out, this);
                    }
                    object3 = new Thread(jnetCGI);
                    ((Thread)object3).start();
                    this.status.setText("Starting jnet thread...");
                    this.status.validate();
                } else if (string.equals("Local alignment")) {
                    if (!(this.parent instanceof Applet)) {
                        Object object4;
                        this.status.setText("Starting local alignment...");
                        this.status.validate();
                        Sequence[] sequenceArray = new Sequence[this.ap.seqPanel.align.size()];
                        int n = 0;
                        while (n < sequenceArray.length) {
                            object4 = AlignSeq.extractGaps(" ", this.ap.seqPanel.align.ds[n].getSequence());
                            object4 = AlignSeq.extractGaps("-", (String)object4);
                            object4 = AlignSeq.extractGaps(".", (String)object4);
                            object4 = AlignSeq.extractGaps("~", (String)object4);
                            System.out.println((String)object4);
                            sequenceArray[n] = new Sequence(this.ap.seqPanel.align.ds[n].name, (String)object4, this.ap.seqPanel.align.ds[n].start, this.ap.seqPanel.align.ds[n].end);
                            ++n;
                        }
                        object4 = new ClustalwThread(sequenceArray);
                        ((Thread)object4).start();
                    } else {
                        this.error("ERROR: Can't run local process from Applet", true);
                    }
                } else if (string.equals("Above PID threshold only...")) {
                    if (this.ap.seqPanel.align.cons != null) {
                        this.status.setText("Creating PID threshold chooser...");
                        this.status.validate();
                        this.PIDthreshold.disable();
                        PercentIdentityPopup percentIdentityPopup = new PercentIdentityPopup(this, "PID threshold selection", "Percent identity", 0, 100, this.threshold);
                        this.status.setText("Colouring above PID threshold...");
                        this.status.validate();
                        this.updateFont();
                        this.status.setText("done");
                        this.status.validate();
                        this.PIDthreshold.enable();
                    } else {
                        this.error("ERROR: No consensus to compare with", true);
                    }
                } else if (string.equals("Conservation colour increment...")) {
                    this.status.setText("Creating increment chooser...");
                    this.status.validate();
                    IncrementPopup incrementPopup = new IncrementPopup(this, "Conservation colour increment selection", "Colour increment", 0, 50);
                    this.status.setText("Changing colour increment...");
                    this.status.validate();
                    int n = 0;
                    while (n < this.ap.seqPanel.align.groups.size()) {
                        SequenceGroup sequenceGroup = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(n);
                        if (sequenceGroup.colourScheme instanceof ConservationColourScheme) {
                            ((ConservationColourScheme)sequenceGroup.colourScheme).inc = this.increment;
                            sequenceGroup.colourScheme.setColours(sequenceGroup);
                            this.status.setText("Changing group colour increment");
                            this.status.validate();
                        }
                        ++n;
                    }
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Move selected sequences to new alignment")) {
                    if (this.ap.sel.size() > 0) {
                        this.status.setText("Moving selected sequences...");
                        this.status.validate();
                        DrawableSequence[] drawableSequenceArray = new DrawableSequence[this.ap.sel.size()];
                        int n = 0;
                        while (n < this.ap.sel.size()) {
                            drawableSequenceArray[n] = new DrawableSequence((Sequence)this.ap.sel.elementAt(n));
                            this.ap.seqPanel.align.deleteSequence((Sequence)this.ap.sel.elementAt(n));
                            ++n;
                        }
                        this.ap.sel = new Vector();
                        this.status.setText("Creating new alignment window...");
                        this.status.validate();
                        AlignFrame alignFrame = new AlignFrame((Object)this, drawableSequenceArray);
                        Font font = this.getFont();
                        alignFrame.setAlignFont(font.getName(), font.getStyle(), font.getSize());
                        alignFrame.resize(700, 500);
                        alignFrame.show();
                        this.status.setText("done");
                        this.status.validate();
                        this.updateFont();
                    } else {
                        this.error("ERROR: No sequences selected...", true);
                    }
                } else if (string.equals("Copy selected sequences to new alignment")) {
                    if (this.ap.sel.size() > 0) {
                        this.status.setText("Copying selected sequences...");
                        this.status.validate();
                        DrawableSequence[] drawableSequenceArray = new DrawableSequence[this.ap.sel.size()];
                        int n = 0;
                        while (n < this.ap.sel.size()) {
                            drawableSequenceArray[n] = new DrawableSequence((Sequence)this.ap.sel.elementAt(n));
                            ++n;
                        }
                        this.ap.sel = new Vector();
                        this.status.setText("Creating new alignment window...");
                        this.status.validate();
                        AlignFrame alignFrame = new AlignFrame((Object)this, drawableSequenceArray);
                        Font font = this.getFont();
                        alignFrame.setAlignFont(font.getName(), font.getStyle(), font.getSize());
                        alignFrame.resize(700, 500);
                        alignFrame.show();
                        this.updateFont();
                        this.status.setText("done");
                        this.status.validate();
                    }
                } else if (string.equals("Sort by group")) {
                    this.status.setText("Sorting sequences by group...");
                    this.status.validate();
                    this.ap.seqPanel.align.sortGroups();
                    this.ap.seqPanel.align.sortByGroup();
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Sort by ID")) {
                    this.status.setText("Sorting sequences by ID...");
                    this.status.validate();
                    this.ap.seqPanel.align.sortByID();
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Sort by tree order")) {
                    if (this.tt != null) {
                        this.status.setText("Sorting by tree order...");
                        this.status.validate();
                        this.ap.seqPanel.align.sortByTree(this.tt.tf.p.njt.tf);
                        this.status.setText("Updating display");
                        this.status.validate();
                        this.updateFont();
                        this.status.setText("done");
                        this.status.validate();
                    } else {
                        this.error("ERROR: No tree defined", true);
                    }
                } else if (string.equals("Sort by pairwise identity")) {
                    if (this.ap.seqPanel.align.cons == null) {
                        this.status.setText("Calculating consensus...");
                        this.status.validate();
                        this.ap.seqPanel.align.percentIdentity(this.ap.sel);
                        this.status.setText("done");
                        this.status.validate();
                    }
                    String string2 = "";
                    int n = 0;
                    while (n < this.ap.seqPanel.align.maxLength()) {
                        string2 = string2 + this.ap.seqPanel.align.cons[n].get("max");
                        ++n;
                    }
                    this.status.setText("Sorting by pairwise identity...");
                    this.status.validate();
                    this.ap.seqPanel.align.sortByPID(new DrawableSequence("Consensus", string2, 1, string2.length()));
                    this.updateFont();
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Remove redundancy")) {
                    this.status.setText("Creating redundancy chooser...");
                    this.status.validate();
                    RedundancyPopup redundancyPopup = new RedundancyPopup(this, "Redundancy threshold selection", "Percent identity", 0, 100, 100);
                    this.updateFont();
                    this.status.setText("Redundant sequences removed");
                    this.status.validate();
                } else if (string.equals("Remove sequence <- left of selected columns")) {
                    if (this.ap.selectedColumns.size() > 0) {
                        this.status.setText("Trimming sequences left...");
                        this.status.validate();
                        Enumeration enumeration = this.ap.selectedColumns.elements();
                        int n = this.ap.seqPanel.align.maxLength;
                        while (enumeration.hasMoreElements()) {
                            Integer n4 = (Integer)enumeration.nextElement();
                            if (n4 >= n) continue;
                            n = n4;
                        }
                        if (n < this.ap.seqPanel.align.maxLength) {
                            this.ap.seqPanel.align.trimLeft(n);
                            if (this.bp.scorePanel != null) {
                                this.bp.scorePanel.seqPanel.align.trimLeft(n);
                            }
                            int n5 = 0;
                            while (n5 < this.ap.selectedColumns.size()) {
                                int n6 = (Integer)this.ap.selectedColumns.elementAt(n5);
                                this.ap.selectedColumns.setElementAt(new Integer(n6 - n), n5);
                                ++n5;
                            }
                            this.status.setText("Trimmed left of " + n);
                            this.status.validate();
                        } else {
                            this.error("ERROR: No columns selected", true);
                        }
                    }
                    this.updateFont();
                } else if (string.equals("Remove sequence -> right of selected columns")) {
                    if (this.ap.selectedColumns.size() > 0) {
                        this.status.setText("Trimming sequences right...");
                        this.status.validate();
                        Enumeration enumeration = this.ap.selectedColumns.elements();
                        int n = 0;
                        while (enumeration.hasMoreElements()) {
                            Integer n7 = (Integer)enumeration.nextElement();
                            if (n7 <= n) continue;
                            n = n7;
                        }
                        if (n > 0) {
                            this.ap.seqPanel.align.trimRight(n);
                            if (this.bp.scorePanel != null) {
                                this.bp.scorePanel.seqPanel.align.trimRight(n);
                            }
                            int n8 = 0;
                            while (n8 < this.ap.selectedColumns.size()) {
                                int n9 = (Integer)this.ap.selectedColumns.elementAt(n8);
                                if (n9 > n) {
                                    this.ap.selectedColumns.removeElementAt(n8);
                                }
                                ++n8;
                            }
                            this.status.setText("Trimmed right of " + n);
                            this.status.validate();
                        }
                        this.updateFont();
                    } else {
                        this.error("ERROR: No columns selected", true);
                    }
                } else if (string.equals("Fetch sequence features")) {
                    this.status.setText("Fetching sequence features...");
                    this.status.validate();
                    this.sft = new SequenceFeatureThread(this);
                    this.sft.start();
                } else if (string.equals("Fetch PDB structure")) {
                    this.status.setText("Creating PDB popup...");
                    this.status.validate();
                    PDBPopup pDBPopup = new PDBPopup((Frame)this, "PDB selector", this.ap.seqPanel.align);
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Select all sequences")) {
                    this.status.setText("Selecting all sequences");
                    this.status.validate();
                    int n = 0;
                    while (n < this.ap.seqPanel.align.sequences.length && this.ap.seqPanel.align.sequences[n] != null) {
                        this.ap.sel.addElement(this.ap.seqPanel.align.sequences[n]);
                        ++n;
                    }
                    this.updateFont();
                    this.status.setText("Selected all sequences");
                    this.status.validate();
                } else if (string.equals("Deselect all sequences")) {
                    this.status.setText("Deselecting all sequences...");
                    this.status.validate();
                    this.ap.sel.removeAllElements();
                    this.updateFont();
                    this.status.setText("Deselected all sequences");
                    this.status.validate();
                } else if (string.equals("Invert sequence selection")) {
                    this.status.setText("Inverting sequence selection");
                    this.status.validate();
                    int n = 0;
                    while (n < this.ap.seqPanel.align.sequences.length && this.ap.seqPanel.align.sequences[n] != null) {
                        if (this.ap.sel.contains(this.ap.seqPanel.align.sequences[n])) {
                            this.ap.sel.removeElement(this.ap.seqPanel.align.sequences[n]);
                        } else {
                            this.ap.sel.addElement(this.ap.seqPanel.align.sequences[n]);
                        }
                        ++n;
                    }
                    this.updateFont();
                    this.status.setText("Inverted sequence selection");
                    this.status.validate();
                } else if (string.equals("Deselect all columns")) {
                    this.status.setText("Deselecting all columns...");
                    this.status.validate();
                    this.ap.selectedColumns.removeAllElements();
                    this.ap.scalePanel.scaleCanvas.paintFlag = true;
                    this.ap.scalePanel.scaleCanvas.repaint();
                    this.status.setText("Deselected all columns");
                    this.status.validate();
                } else if (string.equals("Bold")) {
                    this.status.setText("Setting bold font");
                    this.status.validate();
                    if (this.ap.seqPanel.seqCanvas.fontStyle != 1) {
                        this.setFont(1, this.ap.seqPanel.seqCanvas.fontSize);
                    }
                    this.status.setText("Changed to bold font");
                    this.status.validate();
                } else if (string.equals("Plain")) {
                    this.status.setText("Setting plain font");
                    this.status.validate();
                    if (this.ap.seqPanel.seqCanvas.fontStyle != 0) {
                        this.setFont(0, this.ap.seqPanel.seqCanvas.fontSize);
                    }
                    this.status.setText("Changed to plain font");
                    this.status.validate();
                } else if (string.indexOf("Size =") == 0) {
                    this.status.setText("Setting font size");
                    this.status.validate();
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    int n = Integer.valueOf(string3);
                    this.setFont(this.ap.seqPanel.seqCanvas.fontStyle, n);
                } else if (string.equals("Average distance tree using PID")) {
                    if (this.ap.sel != null && this.ap.sel.size() > 3) {
                        this.status.setText("Calculating average distance tree...");
                        this.status.validate();
                        this.tt = new TreeThread("Average distance tree using PID", (Object)this, this.ap.sel, "AV", "PID");
                    } else {
                        this.status.setText("Calculating average distance tree...");
                        this.status.validate();
                        this.tt = new TreeThread("Average distance tree using PID", (Object)this, this.ap.seqPanel.align.ds, "AV", "PID");
                    }
                    this.tt.start();
                } else if (string.equals("Neighbour joining tree using PID")) {
                    if (this.ap.sel != null && this.ap.sel.size() > 3) {
                        this.tt = new TreeThread("Neighbour joining tree using PID", (Object)this, this.ap.sel, "NJ", "PID");
                        this.status.setText("Calculating NJ tree");
                        this.status.validate();
                    } else {
                        this.tt = new TreeThread("Neighbour joining tree using PID", (Object)this, this.ap.seqPanel.align.ds, "NJ", "PID");
                        this.status.setText("Calculating NJ tree");
                        this.status.validate();
                    }
                    this.tt.start();
                } else if (string.equals("Principal component analysis")) {
                    this.status.setText("Starting PCA calculation...");
                    this.status.validate();
                    this.pca = new PCAThread(this, this.ap.seqPanel.align.ds);
                    this.pca.start();
                } else if (string.equals("Consensus")) {
                    this.status.setText("Calculating consensus");
                    this.status.validate();
                    int n = this.ap.countSelected();
                    if (n == 0) {
                        if (this.bp.scorePanel != null) {
                            this.bp.scorePanel.seqPanel.align.ds[0] = this.ap.seqPanel.align.qualityScore;
                            this.updateFont();
                        }
                        this.ap.seqPanel.align.percentIdentity();
                        this.status.setText("Using all sequences for consensus");
                        this.status.validate();
                    } else {
                        this.ap.seqPanel.align.percentIdentity(this.ap.sel);
                    }
                    this.cons = this.ap.seqPanel.align.cons;
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.indexOf("User") == 0) {
                    this.status.setText("Creating user colour chooser...");
                    this.status.validate();
                    ColourChooserFrame colourChooserFrame = new ColourChooserFrame(this, this.ap.color);
                    colourChooserFrame.show();
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Information")) {
                    if (this.parent != null) {
                        if (this.parent instanceof Applet) {
                            this.status.setText("Fetching URL help file");
                            this.status.validate();
                            try {
                                String string4 = "http://circinus.ebi.ac.uk:6543/~michele/jalview/help.html";
                                URL uRL = new URL(string4);
                                ((Applet)this.parent).getAppletContext().showDocument(uRL, "right");
                            }
                            catch (MalformedURLException malformedURLException) {
                                this.status.setText("Couldn't fetch help URL");
                                this.status.validate();
                            }
                            this.status.setText("Help file displayed in browser");
                            this.status.validate();
                        }
                    } else {
                        this.status.setText("Fetching URL information file");
                        this.status.validate();
                    }
                } else if (string.equals("Conservation")) {
                    this.conservation.enable();
                    this.incitem.enable();
                    this.status.setText("Calculating conservation...");
                    this.status.validate();
                    int n = 0;
                    while (n < this.ap.seqPanel.align.groups.size()) {
                        SequenceGroup sequenceGroup = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(n);
                        Vector vector = sequenceGroup.sequences;
                        sequenceGroup.conserve = new Conservation("All", this.ap.seqPanel.align.cons, ResidueProperties.propHash, 3, vector, 0, this.ap.seqPanel.align.sequences[0].getSequence().length() - 1);
                        sequenceGroup.conserve.calculate();
                        sequenceGroup.conserve.verdict(false, 100.0f);
                        System.out.println("Conservation = " + sequenceGroup.conserve.consSequence.sequence);
                        sequenceGroup.colourScheme = new ConservationColourScheme(sequenceGroup);
                        sequenceGroup.colourScheme.setColours(sequenceGroup);
                        this.updateFont();
                        ++n;
                    }
                    this.status.setText("Calculated conservation");
                    this.status.validate();
                    this.conservation.setState(true);
                    this.ap.conservation = true;
                    this.PIDthreshold.disable();
                } else if (string.equals("Contents")) {
                    if (this.parent != null) {
                        if (this.parent instanceof Applet) {
                            this.status.setText("Fetching URL help file");
                            this.status.validate();
                            try {
                                String string5 = "http://circinus.ebi.ac.uk:6543/~michele/jalview/contents.html";
                                URL uRL = new URL(string5);
                                ((Applet)this.parent).getAppletContext().showDocument(uRL, "right");
                            }
                            catch (MalformedURLException malformedURLException) {
                                this.status.setText("Couldn't fetch help URL");
                                this.status.validate();
                            }
                            this.status.setText("Help file displayed in browser");
                            this.status.validate();
                        }
                    } else {
                        this.status.setText("Fetching URL help file");
                        this.status.validate();
                    }
                } else if (string.equals("Input alignment as URL")) {
                    this.status.setText("Creating URL chooser...");
                    this.status.validate();
                    URLPopup uRLPopup = new URLPopup((Frame)this, "Input alignment as URL");
                } else if (string.equals("Input alignment from local file")) {
                    this.status.setText("Creating file chooser...");
                    this.status.validate();
                    FilePopup filePopup = new FilePopup((Frame)this, "Input alignment from local file");
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Save alignment to local file")) {
                    this.status.setText("Creating file chooser...");
                    this.status.validate();
                    if (this.parent instanceof Applet) {
                        AppletFilePopup appletFilePopup = new AppletFilePopup((Frame)this, "Save alignment to local file");
                    } else {
                        OutputFilePopup outputFilePopup = new OutputFilePopup((Frame)this, "Save alignment to local file");
                    }
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Save postscript to local file")) {
                    this.status.setText("Creating file chooser...");
                    this.status.validate();
                    if (this.parent instanceof Applet) {
                        AppletPostscriptPopup appletPostscriptPopup = new AppletPostscriptPopup((Frame)this, "Save postscript to local file", this);
                    } else {
                        PostscriptFilePopup postscriptFilePopup = new PostscriptFilePopup((Frame)this, "Save postscript to local file", this);
                    }
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Input alignment via text box")) {
                    this.status.setText("Creating input textbox...");
                    this.status.validate();
                    InputPopup inputPopup = new InputPopup((Frame)this, "Input alignment via text box");
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Output alignment via text box")) {
                    this.status.setText("Creating output textbox...");
                    this.status.validate();
                    OutputPopup outputPopup = new OutputPopup((Frame)this, "Alignment " + this.getTitle());
                    this.status.setText("done");
                    this.status.validate();
                } else if (string.equals("Pairwise alignments")) {
                    this.status.setText("Aligning selected sequences...");
                    this.status.validate();
                    PairAlignThread pairAlignThread = new PairAlignThread(this);
                    pairAlignThread.start();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            if (this.parent instanceof Applet) {
                this.status.setText("Closing window...");
                this.status.validate();
                this.hide();
                this.dispose();
            } else if (this.parent == null) {
                this.status.setText("Quitting application");
                this.status.validate();
                System.exit(0);
            } else {
                this.status.setText("Closing window...");
                this.status.validate();
                this.hide();
                this.dispose();
            }
        } else {
            super.handleEvent(event);
        }
        return false;
    }

    public int getScheme() {
        if (this.zappo.getState()) {
            return 0;
        }
        if (this.taylor.getState()) {
            return 1;
        }
        if (this.PID.getState()) {
            return 2;
        }
        if (this.BLOSUM62.getState()) {
            return 3;
        }
        if (this.Hydrophobicity.getState()) {
            return 4;
        }
        if (this.helix.getState()) {
            return 8;
        }
        if (this.strand.getState()) {
            return 9;
        }
        if (this.turn.getState()) {
            return 10;
        }
        if (this.buried.getState()) {
            return 11;
        }
        return -1;
    }

    public void setBoxes(boolean bl) {
        int n = 0;
        while (n < this.ap.seqPanel.align.groups.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(n);
            sequenceGroup.displayBoxes = bl;
            this.ap.seqPanel.align.displayBoxes(sequenceGroup);
            ++n;
        }
    }

    public void setText(boolean bl) {
        int n = 0;
        while (n < this.ap.seqPanel.align.groups.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(n);
            sequenceGroup.displayText = bl;
            this.ap.seqPanel.align.displayText(sequenceGroup);
            ++n;
        }
    }

    public void setColourText(boolean bl) {
        int n = 0;
        while (n < this.ap.seqPanel.align.groups.size()) {
            SequenceGroup sequenceGroup = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(n);
            sequenceGroup.colourText = bl;
            this.ap.seqPanel.align.colourText(sequenceGroup);
            ++n;
        }
    }

    public void fileMenu() {
        this.file = new Menu("File", true);
        if (!(this.parent instanceof Applet)) {
            this.file.add("Input alignment from local file");
            this.file.add("Input alignment as URL");
            this.file.addSeparator();
            this.file.add("Save alignment to local file");
            this.file.add("Save postscript to local file");
            this.file.addSeparator();
        }
        this.file.add("Input alignment via text box");
        this.file.add("Output alignment via text box");
        this.file.addSeparator();
        this.file.add("Close");
        this.file.add("Quit");
    }

    public void editMenu() {
        this.edit = new Menu("Edit", true);
        this.edit.add("Groups...");
        this.groupEdit = new CheckboxMenuItem("Group editing mode");
        this.edit.add(this.groupEdit);
        this.groupEdit.setState(false);
        this.edit.addSeparator();
        this.edit.add("Select all sequences");
        this.edit.add("Deselect all sequences");
        this.edit.add("Invert sequence selection");
        this.edit.addSeparator();
        this.edit.add("Delete selected sequences");
        this.edit.add("Move selected sequences to new alignment");
        this.edit.add("Copy selected sequences to new alignment");
        this.edit.addSeparator();
        this.edit.add("Deselect all columns");
        this.edit.add("Remove sequence <- left of selected columns");
        this.edit.add("Remove sequence -> right of selected columns");
        this.edit.addSeparator();
        this.edit.add("Remove gapped columns");
        if (this.ap.seqPanel.align.gapCharacter.equals("-")) {
            this.gapCharacter = new MenuItem("Set gap character to .");
            this.edit.add(this.gapCharacter);
        } else if (this.ap.seqPanel.align.gapCharacter.equals(".")) {
            this.gapCharacter = new MenuItem("Set gap character to -");
            this.edit.add(this.gapCharacter);
        }
    }

    public void fontMenu() {
        this.font = new Menu("Font", true);
        this.fastDraw = new CheckboxMenuItem("Fast Draw");
        this.helvetica = new CheckboxMenuItem("Helvetica");
        this.courier = new CheckboxMenuItem("Courier");
        this.times = new CheckboxMenuItem("Times-Roman");
        this.fastDraw.setState(true);
        this.helvetica.setState(false);
        this.times.setState(false);
        this.courier.setState(false);
        this.helvetica.disable();
        this.times.disable();
        this.courier.disable();
        this.font.add(this.fastDraw);
        this.font.addSeparator();
        this.font.add(this.helvetica);
        this.font.add(this.courier);
        this.font.add(this.times);
        this.font.addSeparator();
        this.font.add("Size = 1");
        this.font.add("Size = 2");
        this.font.add("Size = 4");
        this.font.add("Size = 6");
        this.font.add("Size = 8");
        this.font.add("Size = 10");
        this.font.add("Size = 12");
        this.font.add("Size = 14");
        this.font.add("Size = 16");
        this.font.add("Size = 20");
        this.font.add("Size = 24");
        this.font.addSeparator();
        this.font.add("Plain");
        this.font.add("Bold");
    }

    public void viewMenu() {
        this.view = new Menu("View", true);
        this.boxes = new CheckboxMenuItem("Boxes");
        this.boxes.setState(true);
        this.text = new CheckboxMenuItem("Text");
        this.text.setState(true);
        this.scores = new CheckboxMenuItem("Scores");
        this.scores.setState(false);
        this.wrap = new CheckboxMenuItem("Wrap alignment");
        this.wrap.setState(false);
        this.ap.seqPanel.seqCanvas.showScores = false;
        this.ap.seqPanel.seqCanvas.wrap = false;
        this.ap.idPanel.idCanvas.showScores = false;
        this.ap.idPanel.idCanvas.wrap = false;
        this.view.add(this.boxes);
        this.view.add(this.text);
        this.view.add(this.scores);
        this.view.addSeparator();
        this.colourText = new CheckboxMenuItem("Colour text");
        this.colourText.setState(false);
        this.view.add(this.colourText);
        this.blackText = new CheckboxMenuItem("Black text");
        this.blackText.setState(true);
        this.view.add(this.blackText);
    }

    public void colourMenu() {
        this.colour = new Menu("Colour", true);
        this.clustalx = new CheckboxMenuItem("Clustalx colours");
        this.clustalx.setState(true);
        this.colour.add(this.clustalx);
        this.zappo = new CheckboxMenuItem("Zappo Colourscheme");
        this.zappo.setState(false);
        this.colour.add(this.zappo);
        this.taylor = new CheckboxMenuItem("Taylor Colourscheme");
        this.taylor.setState(false);
        this.colour.add(this.taylor);
        this.Hydrophobicity = new CheckboxMenuItem("By Hydrophobicity");
        this.Hydrophobicity.setState(false);
        this.colour.add(this.Hydrophobicity);
        this.helix = new CheckboxMenuItem("Helix propensity");
        this.helix.setState(false);
        this.colour.add(this.helix);
        this.strand = new CheckboxMenuItem("Strand propensity");
        this.strand.setState(false);
        this.colour.add(this.strand);
        this.turn = new CheckboxMenuItem("Turn propensity");
        this.turn.setState(false);
        this.colour.add(this.turn);
        this.buried = new CheckboxMenuItem("Buried index");
        this.buried.setState(false);
        this.colour.add(this.buried);
        this.colour.addSeparator();
        this.conservation = new CheckboxMenuItem("By conservation");
        this.conservation.disable();
        this.conservation.setState(false);
        this.ap.conservation = false;
        this.conservation.disable();
        this.colour.add(this.conservation);
        this.colour.addSeparator();
        this.PIDthreshold = new MenuItem("Above PID threshold only...");
        this.PIDthreshold.disable();
        this.incitem = new MenuItem("Conservation colour increment...");
        this.incitem.disable();
        this.colour.add(this.PIDthreshold);
        this.colour.add(this.incitem);
        this.userColours = new MenuItem("User defined colours...");
        this.userColours.disable();
        this.colour.add(this.userColours);
        this.colour.addSeparator();
        this.PID = new CheckboxMenuItem("By PID");
        this.PID.setState(false);
        SequenceGroup sequenceGroup = (SequenceGroup)this.ap.seqPanel.align.groups.elementAt(0);
        sequenceGroup.colourScheme = new PIDColourScheme();
        this.colour.add(this.PID);
        this.BLOSUM62 = new CheckboxMenuItem("By BLOSUM62 score");
        this.BLOSUM62.setState(false);
        this.colour.add(this.BLOSUM62);
        this.colour.addSeparator();
        this.features = new MenuItem("Fetch sequence features");
        this.colour.add(this.features);
        this.structures = new MenuItem("Fetch PDB structure");
        this.colour.add(this.structures);
    }

    public void calcMenu() {
        this.calc = new Menu("Calculate", true);
        this.calc.add("Consensus");
        this.autoconsensus = new CheckboxMenuItem("Autocalculate consensus");
        this.autoconsensus.setState(false);
        this.ap.seqPanel.align.autoConsensus = false;
        this.calc.add(this.autoconsensus);
        this.calc.addSeparator();
        this.calc.add("Sort by pairwise identity");
        this.calc.add("Sort by ID");
        this.calc.add("Sort by group");
        this.calc.add("Sort by tree order");
        this.calc.add("Remove redundancy");
        this.calc.addSeparator();
        this.calc.add("Pairwise alignments");
        this.calc.add("Principal component analysis");
        this.calc.addSeparator();
        this.calc.add("Average distance tree using PID");
        this.calc.add("Neighbour joining tree using PID");
        this.calc.addSeparator();
        this.calc.add("Conservation");
    }

    public void helpMenu() {
        this.help = new Menu("Help", true);
        this.help.add("Information");
        this.help.add("Contents");
    }

    public void alignMenu() {
        this.align = new Menu("Align", true);
        if (this.parent instanceof Applet) {
            Applet applet = (Applet)this.parent;
            if (applet.getCodeBase().getHost().equals("circinus.ebi.ac.uk")) {
                this.align.add("Remote alignment at EBI");
                this.align.add("Remote postal analysis at EBI");
                this.align.add("Remote Jnet analysis at EBI");
            } else {
                this.align.disable();
            }
        } else {
            this.align.add("Local alignment");
            this.align.add("Remote alignment at EBI");
            this.align.add("Remote postal analysis at EBI");
            this.align.add("Remote Jnet analysis at EBI");
        }
    }

    public void setAlignFont(String string, int n, int n2) {
        this.ap.seqPanel.seqCanvas.fontName = string;
        this.ap.seqPanel.seqCanvas.fontStyle = n;
        this.ap.seqPanel.seqCanvas.fontSize = n2;
        this.ap.seqPanel.seqCanvas.setFont(new Font(string, n, n2));
        if (this.bp.scorePanel != null) {
            this.bp.scorePanel.seqPanel.seqCanvas.fontName = string;
            this.bp.scorePanel.seqPanel.seqCanvas.fontStyle = n;
            this.bp.scorePanel.seqPanel.seqCanvas.fontSize = n2;
            this.bp.scorePanel.seqPanel.seqCanvas.setFont(new Font(string, n, n2));
        }
    }

    public Font getAlignFont() {
        return this.ap.seqPanel.seqCanvas.f;
    }

    public void setFont(String string) {
        this.ap.seqPanel.seqCanvas.fontName = string;
        this.ap.seqPanel.seqCanvas.setFont(new Font(string, this.ap.seqPanel.seqCanvas.fontStyle, this.ap.seqPanel.seqCanvas.fontSize));
        if (this.bp.scorePanel != null) {
            this.bp.scorePanel.seqPanel.seqCanvas.fontName = string;
            this.bp.scorePanel.seqPanel.seqCanvas.setFont(new Font(string, this.ap.seqPanel.seqCanvas.fontStyle, this.ap.seqPanel.seqCanvas.fontSize));
        }
        this.updateFont();
        this.status.setText("Font changed to " + string);
    }

    public void setFont(int n, int n2) {
        this.ap.seqPanel.seqCanvas.setFont(n, n2);
        if (this.bp.scorePanel != null) {
            this.bp.scorePanel.seqPanel.seqCanvas.setFont(n, n2);
        }
        this.updateFont();
        this.status.setText("Font changed to " + n + " " + n2);
    }

    public void updateFont() {
        super.repaint();
        if (this.ap instanceof BigPanel) {
            BigPanel bigPanel = (BigPanel)this.ap;
            bigPanel.setScrollValues(this.ap.seqPanel.offx, 0);
            if (bigPanel.scorePanel != null) {
                bigPanel.scorePanel.seqPanel.invalidate();
                bigPanel.scorePanel.idPanel.idCanvas.invalidate();
                bigPanel.scorePanel.idPanel.invalidate();
                bigPanel.scorePanel.scalePanel.invalidate();
                bigPanel.scorePanel.invalidate();
                bigPanel.scorePanel.validate();
                bigPanel.invalidate();
                bigPanel.validate();
                bigPanel.scorePanel.idPanel.idCanvas.paintFlag = true;
                bigPanel.scorePanel.seqPanel.seqCanvas.paintFlag = true;
                bigPanel.scorePanel.scalePanel.scaleCanvas.paintFlag = true;
                bigPanel.scorePanel.scalePanel.scaleCanvas.repaint();
                bigPanel.scorePanel.idPanel.idCanvas.paint(bigPanel.scorePanel.idPanel.idCanvas.getGraphics());
                bigPanel.scorePanel.seqPanel.seqCanvas.paint(bigPanel.scorePanel.seqPanel.seqCanvas.getGraphics());
                bigPanel.scorePanel.invalidate();
                bigPanel.scorePanel.validate();
            }
        }
        this.ap.idPanel.idCanvas.paintFlag = true;
        this.ap.seqPanel.seqCanvas.paintFlag = true;
        this.ap.scalePanel.scaleCanvas.paintFlag = true;
        this.ap.scalePanel.scaleCanvas.repaint();
        this.ap.idPanel.idCanvas.paint(this.ap.idPanel.idCanvas.getGraphics());
        this.ap.seqPanel.seqCanvas.paint(this.ap.seqPanel.seqCanvas.getGraphics());
        this.ap.invalidate();
        this.ap.validate();
        this.validate();
        if (this.tt != null) {
            this.tt.tf.p.mc.repaint();
        }
        if (this.pca != null) {
            this.pca.p.rc.redrawneeded = true;
            this.pca.p.rc.repaint();
        }
    }

    public MailProperties getMailProperties() {
        return this.mp;
    }

    public PostscriptProperties getPostscriptProperties() {
        return this.pp;
    }

    public FileProperties getFileProperties() {
        return this.fp;
    }

    public void setMailProperties(MailProperties mailProperties) {
        this.mp = mailProperties;
    }

    public void setPostscriptProperties(PostscriptProperties postscriptProperties) {
        this.pp = postscriptProperties;
    }

    public void setFileProperties(FileProperties fileProperties) {
        this.fp = fileProperties;
    }

    public String getText(String string) {
        if (FormatProperties.contains(string)) {
            return FormatAdapter.get(string, this.ap.seqPanel.align.sequences);
        }
        return null;
    }

    public void getPostscript(BufferedWriter bufferedWriter) {
        ProgressBar progressBar = new ProgressBar(0, this.ap.seqPanel.align.size() - 1, true);
        this.labelPanel.remove(this.status);
        this.labelPanel.add(progressBar);
        this.labelPanel.validate();
        Postscript postscript = new Postscript(this, bufferedWriter, progressBar);
        postscript.generate();
        this.labelPanel.remove(progressBar);
        this.labelPanel.add(this.status);
    }

    public StringBuffer getPostscript() {
        ProgressBar progressBar = new ProgressBar(0, this.ap.seqPanel.align.size() - 1, true);
        this.labelPanel.remove(this.status);
        this.labelPanel.add(progressBar);
        Postscript postscript = new Postscript(this, true, progressBar);
        postscript.generate();
        this.labelPanel.remove(progressBar);
        this.labelPanel.add(this.status);
        return postscript.out;
    }

    public void getPostscript(PrintStream printStream) {
        ProgressBar progressBar = new ProgressBar(0, this.ap.seqPanel.align.size() - 1, true);
        this.labelPanel.add(progressBar);
        this.labelPanel.validate();
        Postscript postscript = new Postscript(this, printStream, progressBar);
        postscript.generate();
        printStream.flush();
        printStream.close();
        this.labelPanel.remove(progressBar);
    }

    public static void fetchPDBStructure(DrawableSequence drawableSequence, String string) throws UnknownHostException, IOException {
        if (drawableSequence.pdbcode.size() > 0) {
            System.out.println("code = " + drawableSequence.pdbcode.elementAt(0));
            PDBfile pDBfile = new PDBfile("http://" + string + "wgetz?-e+[pdb-id:" + drawableSequence.pdbcode.elementAt(0) + "]", "URL");
            drawableSequence.setPDBfile(pDBfile);
            ((PDBChain)pDBfile.chains.elementAt((int)drawableSequence.maxchain)).isVisible = true;
            ((PDBChain)pDBfile.chains.elementAt((int)drawableSequence.maxchain)).ds = drawableSequence;
            ((PDBChain)pDBfile.chains.elementAt(drawableSequence.maxchain)).colourBySequence();
            rotFrame rotFrame2 = new rotFrame(pDBfile);
            rotFrame2.resize(500, 500);
            rotFrame2.show();
        } else {
            System.out.println("No pdb code found");
        }
    }

    public static AlignFrame parseArgs(String[] stringArray) {
        AlignFrame alignFrame;
        block12: {
            alignFrame = null;
            int[] nArray = new int[stringArray.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = 0;
                ++n;
            }
            try {
                String string = null;
                String string2 = "File";
                String string3 = "MSF";
                if (stringArray.length == 2) {
                    string = stringArray[0];
                    string2 = stringArray[1];
                } else if (stringArray.length >= 3) {
                    string = stringArray[0];
                    string2 = stringArray[1];
                    string3 = stringArray[2];
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].equals("-mail")) {
                            alignFrame.mp.server = stringArray[n2 + 1];
                            System.out.println("Mail server = " + alignFrame.mp.server);
                        }
                        if (stringArray[n2].equals("-srsserver")) {
                            alignFrame.srsServer = stringArray[n2 + 1];
                            if (!alignFrame.srsServer.substring(alignFrame.srsServer.length() - 1).equals("/")) {
                                alignFrame.srsServer = alignFrame.srsServer + "/";
                            }
                            System.out.println("Srs server = " + alignFrame.srsServer);
                        }
                        if (stringArray[n2].equals("-database")) {
                            alignFrame.database = stringArray[n2 + 1];
                            System.out.println("SRS database = " + alignFrame.database);
                        }
                        ++n2;
                    }
                }
                if (string != null) {
                    alignFrame = new AlignFrame(null, string, string2, string3);
                    alignFrame.setTitle(string);
                    break block12;
                }
                System.out.println("Making empty alignframe");
                Sequence sequence = new Sequence("", "", 0, 0);
                DrawableSequence[] drawableSequenceArray = new DrawableSequence[]{new DrawableSequence(sequence)};
                alignFrame = new AlignFrame(null, drawableSequenceArray);
                alignFrame.hasAlignment = false;
            }
            catch (Exception exception) {
                System.out.println(exception);
                System.out.println("\nUsage: java jalview.AlignFrame <alignmentfile> <type> <format> \n");
                System.out.println("              [-srsserver <srsServer>] [-database <srs database>]\n");
                System.out.println("  type  = File or URL  (case is important I'm afraid)");
                System.out.println("format  = MSF, CLUSTAL, FASTA, BLC, MSP  or PIR\n");
                System.out.println("srsServer is the cgi-bin directory containing wgetz on your srs server.");
                System.out.println("For example: srs.ebi.ac.uk/srs7bin/cgi-bin");
                System.out.println("database is the srs database to be queried");
                System.exit(0);
            }
        }
        return alignFrame;
    }

    public void regroup(float f) {
        if (this.tt != null) {
            this.status.setText("Regrouping sequences by tree...");
            this.status.validate();
            TreeFile treeFile = this.tt.tf.p.njt.tf;
            treeFile.groups.removeAllElements();
            treeFile.groupNodes(treeFile.top, f);
            treeFile.setColor(treeFile.top, Color.black);
            int n = 0;
            while (n < treeFile.groups.size()) {
                Object object;
                this.ap.sel.removeAllElements();
                int n2 = n % 7;
                Color[] colorArray = ResidueProperties.groupColors[n2];
                treeFile.setColor((SequenceNode)treeFile.groups.elementAt(n), colorArray[0].darker());
                Vector vector = treeFile.findLeaves((SequenceNode)treeFile.groups.elementAt(n), new Vector());
                int n3 = 0;
                while (n3 < vector.size()) {
                    object = (SequenceNode)vector.elementAt(n3);
                    this.ap.sel.addElement((Sequence)((SequenceNode)object).element);
                    ++n3;
                }
                object = this.ap.seqPanel.align.addGroup();
                SequenceGroup sequenceGroup = this.ap.seqPanel.align.findGroup((Sequence)this.ap.sel.elementAt(0));
                ((SequenceGroup)object).colourScheme = sequenceGroup.colourScheme;
                ((SequenceGroup)object).conserve = null;
                ((SequenceGroup)object).color = this.ap.color;
                int n4 = 0;
                while (n4 < this.ap.sel.size()) {
                    this.ap.seqPanel.align.removeFromGroup(this.ap.seqPanel.align.findGroup((Sequence)this.ap.sel.elementAt(n4)), (Sequence)this.ap.sel.elementAt(n4));
                    this.ap.seqPanel.align.addToGroup((SequenceGroup)object, (Sequence)this.ap.sel.elementAt(n4));
                    ++n4;
                }
                if (this.conservation.getState() && ((SequenceGroup)object).conserve != null) {
                    this.status.setText("Setting conservation colour scheme...");
                    this.status.validate();
                    ((SequenceGroup)object).colourScheme = new ConservationColourScheme((SequenceGroup)object);
                }
                this.status.setText("Setting residue colours...");
                this.status.validate();
                ((SequenceGroup)object).colourScheme.setColours((SequenceGroup)object);
                this.ap.seqPanel.align.setColourScheme((SequenceGroup)object);
                this.status.setText("Finished group");
                this.status.validate();
                ++n;
            }
            this.ap.sel.removeAllElements();
            this.updateFont();
            this.status.setText("Finished grouping nodes");
            this.status.validate();
        } else {
            this.error("ERROR: No tree defined yet", true);
        }
    }

    public static void showConsole() {
        Frame frame = new Frame("Jalview console");
        frame.setLayout(new BorderLayout());
        TextArea textArea = new TextArea(20, 80);
        frame.add("Center", textArea);
        frame.resize(700, 200);
        frame.show();
        TextAreaPrintStream textAreaPrintStream = new TextAreaPrintStream((OutputStream)System.out, textArea);
        System.setOut(textAreaPrintStream);
    }

    public void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {}
    }

    public static void main(String[] stringArray) {
        AlignFrame alignFrame = AlignFrame.parseArgs(stringArray);
        alignFrame.printVersion();
        if (alignFrame != null) {
            DrawableSequence[] drawableSequenceArray = new ScoreSequence[1];
            alignFrame.bp.seqPanel.align.addSequence(drawableSequenceArray);
            alignFrame.ap.seqPanel.align.percentIdentity();
            alignFrame.cons = alignFrame.ap.seqPanel.align.cons;
            PIDColourScheme pIDColourScheme = new PIDColourScheme(alignFrame.ap.seqPanel.align.cons);
            alignFrame.ap.seqPanel.align.percentIdentity();
            ClustalxColourScheme clustalxColourScheme = new ClustalxColourScheme(alignFrame.ap.seqPanel.align.cons2, alignFrame.ap.seqPanel.align.size());
            alignFrame.ap.seqPanel.align.setColourScheme(clustalxColourScheme);
            alignFrame.resize(700, 500);
            alignFrame.show();
            alignFrame.status.setText("Updating font and colours");
            alignFrame.status.validate();
            alignFrame.updateFont();
            alignFrame.wait(500);
            alignFrame.updateFont();
            alignFrame.status.setText("done");
            alignFrame.status.validate();
        } else {
            System.out.println("ERROR in argument list");
            System.exit(0);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void printVersion() {
        System.out.println("Jalview version : 1.8");
        System.out.println("Author: Michele Clamp (c) 2003");
        System.out.println("$Header: /nfs/ensembl/cvsroot/jalview118/jalview/AlignFrame.java,v 1.6 2003/04/29 14:22:47 michele Exp $");
    }

    public void error(String string, boolean bl) {
        this.status.setText(string);
        this.status.validate();
        if (bl) {
            System.out.print("\u0007");
            System.out.flush();
        }
    }
}

