/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

public class QuickSort {
    public static void sort(double[] arr, Object[] s) {
        QuickSort.doubleSort(arr, 0, arr.length - 1, s);
    }

    public static void sort(double[] arr, Object[] s, int len) {
        QuickSort.doubleSort(arr, 0, len - 1, s);
    }

    public static void sort(float[] arr, Object[] s) {
        QuickSort.sort(arr, 0, arr.length - 1, s);
    }

    public static void sort(long[] arr, Object[] s) {
        QuickSort.longSort(arr, 0, arr.length - 1, s);
    }

    public static void sort(String[] arr, Object[] s) {
        QuickSort.stringSort(arr, 0, arr.length - 1, s);
    }

    public static void sort(int[] arr, Object[] s) {
        QuickSort.intSort(arr, 0, arr.length - 1, s);
    }

    public static void stringSort(String[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.stringPartition(arr, p, r, s);
            QuickSort.stringSort(arr, p, q, s);
            QuickSort.stringSort(arr, q + 1, r, s);
        }
    }

    public static void intSort(int[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.intPartition(arr, p, r, s);
            QuickSort.intSort(arr, p, q, s);
            QuickSort.intSort(arr, q + 1, r, s);
        }
    }

    public static void longSort(long[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.longPartition(arr, p, r, s);
            QuickSort.longSort(arr, p, q, s);
            QuickSort.longSort(arr, q + 1, r, s);
        }
    }

    public static void sort(float[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.partition(arr, p, r, s);
            QuickSort.sort(arr, p, q, s);
            QuickSort.sort(arr, q + 1, r, s);
        }
    }

    public static void doubleSort(double[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.doublePartition(arr, p, r, s);
            QuickSort.doubleSort(arr, p, q, s);
            QuickSort.doubleSort(arr, q + 1, r, s);
        }
    }

    private static int doublePartition(double[] arr, int p, int r, Object[] s) {
        double x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j] > x) {
                continue;
            }
            while (arr[++i] < x) {
            }
            if (i >= j) break;
            double tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    private static int partition(float[] arr, int p, int r, Object[] s) {
        float x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j] > x) {
                continue;
            }
            while (arr[++i] < x) {
            }
            if (i >= j) break;
            float tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    private static int longPartition(long[] arr, int p, int r, Object[] s) {
        float x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if ((float)arr[--j] > x) {
                continue;
            }
            while ((float)arr[++i] < x) {
            }
            if (i >= j) break;
            long tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    private static int intPartition(int[] arr, int p, int r, Object[] s) {
        int x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j] > x) {
                continue;
            }
            while (arr[++i] < x) {
            }
            if (i >= j) break;
            int tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    private static int stringPartition(String[] arr, int p, int r, Object[] s) {
        String x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j].compareTo(x) < 0) {
                continue;
            }
            while (arr[++i].compareTo(x) > 0) {
            }
            if (i >= j) break;
            String tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }
}

