/*
 * Decompiled with CFR 0.152.
 */
package apollo.util;

import apollo.util.NumericKeyFilter;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class GuiUtil {
    public static Dimension fitToScreen(int width, int height) {
        return GuiUtil.fitToScreen(new Dimension(width, height));
    }

    public static Dimension fitToScreen(Dimension dim) {
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = new Dimension();
        d.height = dim.height > ss.height ? ss.height : dim.height;
        d.width = dim.width > ss.width ? ss.width : dim.width;
        return d;
    }

    public static JLabel makeJLabelWithFont(String label) {
        return GuiUtil.makeJLabelWithFont(label, null);
    }

    public static JLabel makeJLabelWithFont(String label, String example) {
        String l = label;
        l = "<html><FONT color=black><B>" + label + "</B>";
        if (example != null) {
            l = l + "<BR>(e.g. " + example + ")</FONT></HTML>";
        }
        JLabel jLabel = new JLabel(l);
        jLabel.setHorizontalAlignment(4);
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }

    public static GridBagConstraints makeConstraintAt(int x, int y, int width) {
        return GuiUtil.makeConstraintAt(x, y, width, 0, false);
    }

    public static GridBagConstraints makeConstraintAt(int x, int y, int padamt, boolean fill) {
        return GuiUtil.makeConstraintAt(x, y, 1, padamt, fill);
    }

    public static GridBagConstraints makeConstraintAt(int x, int y, int width, int padamt, boolean fill) {
        GridBagConstraints g = GuiUtil.makeWeightConst(x, y, width, padamt, fill);
        g.weightx = 0.0;
        return g;
    }

    public static GridBagConstraints makeWeightConst(int x, int y, int padamt, boolean fill) {
        return GuiUtil.makeWeightConst(x, y, 1, padamt, fill);
    }

    public static GridBagConstraints makeWeightConst(int x, int y, int width, int padamt, boolean fill) {
        int height = 1;
        return GuiUtil.makeConstraint(x, y, width, height, padamt, fill);
    }

    public static GridBagConstraints makeConstraint(int x, int y, int width, int height, int padamt, boolean horFill) {
        int fill = horFill ? 2 : 0;
        double weighty = 0.0;
        return GuiUtil.makeConstraint(x, y, width, height, weighty, padamt, fill);
    }

    public static GridBagConstraints makeConstraint(int x, int y, int width, int height, double weighty, int padamt, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = weighty;
        gbc.anchor = 17;
        gbc.fill = fill;
        gbc.insets = new Insets(0, padamt, 0, padamt);
        return gbc;
    }

    public static JTextField makeNumericTextField() {
        JTextField jtf = new JTextField();
        jtf.addKeyListener(NumericKeyFilter.getFilter());
        jtf.setPreferredSize(new Dimension(75, 25));
        return jtf;
    }
}

