/*
 * Decompiled with CFR 0.152.
 */
package apollo.test;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.chadoxml.ChadoXmlAdapter;
import apollo.dataadapter.gamexml.GAMEAdapter;
import apollo.dataadapter.genbank.GenbankAdapter;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.gui.ApolloLoaderI;
import apollo.main.DataLoader;
import java.util.Vector;
import org.bdgp.io.DataAdapterRegistry;

public class WashingLine
implements ApolloLoaderI {
    CurationSet curation;
    ApolloDataAdapterI load_adapter;
    private Vector history = new Vector();

    public void setCurationSet(CurationSet curation) {
        this.curation = curation;
    }

    public CurationSet getCurationSet() {
        return this.curation;
    }

    public void setAdapter(ApolloDataAdapterI data_adapter) {
        this.load_adapter = data_adapter;
    }

    public Vector getHistory() {
        return this.history;
    }

    public static void main(String[] args) {
        WashingLine wash = new WashingLine();
        DataLoader loader = new DataLoader();
        String usage = "Bad arguments: " + args + ".\nEnter input file type and name followed by " + "the output file type and name.\n" + "FOR EXAMPLE:\n\t" + "java apollo.test.WashingLine -x myfile.xml -gb mygbdir [-valid myvalidation.conf]\n" + "\tor java apollo.test.WashingLine -x myfile.xml -x output.xml";
        AbstractApolloAdapter dataout = null;
        if (args.length < 4) {
            System.out.println(usage);
        } else {
            DataAdapterRegistry adapterRegistry = Config.getAdapterRegistry();
            boolean acc = false;
            String gb_dir = null;
            String validation_config = Config.getRootDir() + "/conf/validation.conf";
            String game_output = null;
            String chado_xml_output = null;
            for (int i = 2; i < args.length - 1; i += 2) {
                if (args[i].equalsIgnoreCase("-gb")) {
                    gb_dir = args[i + 1];
                    System.out.println("Will save genbank files in " + gb_dir);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-acc")) {
                    char c = args[i + 1].charAt(0);
                    acc = c == 't' || c == 'T' || c == 'y' || c == 'Y';
                    continue;
                }
                if (args[i].equalsIgnoreCase("-valid")) {
                    validation_config = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-x")) {
                    game_output = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-cx")) {
                    chado_xml_output = args[i + 1];
                    continue;
                }
                System.err.println("WashingLine: don't understand argument " + args[i]);
            }
            if (gb_dir != null) {
                dataout = (GenbankAdapter)adapterRegistry.getAdapter("apollo.dataadapter.genbank.GenbankAdapter");
                if (dataout == null) {
                    System.out.println("Not configured with GenbankAdapter");
                    System.exit(-1);
                }
                System.out.println("reading from = " + args[1]);
                System.out.println("writing to genbank dir " + gb_dir + " using " + dataout.getClass().getName());
                ((GenbankAdapter)dataout).setInputType(DataInputType.DIR);
                ((GenbankAdapter)dataout).setInput(gb_dir);
                ((GenbankAdapter)dataout).commitAccessions(acc);
                if (validation_config != null) {
                    ((GenbankAdapter)dataout).setValidationFile(validation_config);
                }
            } else if (args[0].equalsIgnoreCase("-x")) {
                dataout = new GAMEAdapter(DataInputType.FILE, args[1], true);
                if (dataout == null) {
                    System.err.println("Not configured with GAMEAdapter");
                    System.exit(-1);
                }
                System.out.println("Reading from GAME XML file " + args[1]);
            } else if (args[0].equalsIgnoreCase("-cx")) {
                dataout = new ChadoXmlAdapter();
                if (dataout == null) {
                    System.err.println("Not configured with ChadoXmlAdapter");
                    System.exit(-1);
                }
                dataout.setInput(args[1]);
                System.out.println("Reading from Chado XML file " + args[1]);
            } else {
                return;
            }
            CurationSet main_curation = null;
            Config.setRefreshPeptides(true);
            try {
                CompositeDataHolder c = loader.getCompositeDataHolder(args, null);
                main_curation = c.getCurationSet(0);
                wash.setCurationSet(main_curation);
            }
            catch (Exception e) {
                System.out.println("Caught exception reading " + args[1] + ": " + e);
                System.exit(-1);
            }
            if (main_curation != null) {
                if (game_output != null) {
                    System.out.println("Writing to GAME XML file " + game_output);
                    ((GAMEAdapter)dataout).setInput(game_output);
                    loader.putCurationSet(dataout, main_curation.getCurationSet());
                } else if (chado_xml_output != null) {
                    System.out.println("Writing to Chado XML file " + chado_xml_output);
                    ((ChadoXmlAdapter)dataout).setInput(chado_xml_output);
                    loader.putCurationSet(dataout, main_curation.getCurationSet());
                } else {
                    ((GenbankAdapter)dataout).commitChanges(main_curation.getCurationSet(), true);
                }
            }
        }
        System.exit(0);
    }
}

