/*
 * Decompiled with CFR 0.152.
 */
package apollo.test;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.chado.ChadoTransactionTransformer;
import apollo.dataadapter.chado.jdbc.JDBCTransactionWriter;
import apollo.dataadapter.gamexml.GAMEAdapter;
import apollo.datamodel.CurationSet;
import apollo.gui.Controller;
import java.util.HashMap;

public class JDBCTransactionLoader {
    private CurationSet curationSet;
    private String dbHost;
    private String dbName;
    private String dbUser;
    private String dbPwd;
    private int port;
    private String fileName;

    public JDBCTransactionLoader(String dbHost, String dbName, String dbUser, String dbPwd, int port) {
        this.dbHost = dbHost;
        this.dbName = dbName;
        this.dbUser = dbUser;
        this.dbPwd = dbPwd;
        this.port = port;
    }

    public void setGAMEFile(String fileName) {
        this.fileName = fileName;
    }

    protected void setUp() throws ApolloAdapterException {
        Config.initializeConfiguration();
        this.curationSet = new CurationSet();
        this.curationSet = new CurationSet();
        GAMEAdapter gameAdapter = new GAMEAdapter();
        gameAdapter.setInput(this.fileName);
        gameAdapter.setInputType(DataInputType.FILE);
        this.curationSet = gameAdapter.getCurationSet();
        Controller controller = new Controller();
        controller.addListener(Controller.getMasterController());
        this.curationSet.getTransactionManager().setAnnotationChangeListener(controller);
    }

    public void loadTransactions() throws Exception {
        JDBCTransactionWriter processor = new JDBCTransactionWriter(this.dbHost, this.dbName, this.dbUser, this.dbPwd, this.port);
        ChadoTransactionTransformer transformer = new ChadoTransactionTransformer();
        processor.setTransformer(new ChadoTransactionTransformer());
        if (!this.curationSet.isChromosomeArmUsed()) {
            processor.setMapID(this.curationSet.getChromosome());
            processor.setMapType("chromosome");
        } else {
            processor.setMapID(this.curationSet.getChromosome());
            processor.setMapType("chromosome_arm");
        }
        processor.commitTransactions(this.curationSet.getTransactionManager());
    }

    public static void main(String[] args) {
        String dbUser;
        String dbName;
        String dbHost;
        int length;
        if (args.length < 8) {
            JDBCTransactionLoader.argsFail();
        }
        if ((length = args.length) % 2 != 0) {
            JDBCTransactionLoader.argsFail();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String key = null;
        String value = null;
        for (int i = 0; i < length / 2; ++i) {
            key = args[i * 2];
            value = args[i * 2 + 1];
            if (!key.startsWith("-")) {
                JDBCTransactionLoader.argsFail();
            }
            map.put(key, value);
        }
        String fileName = (String)map.get("-f");
        if (fileName == null) {
            System.err.println("Game file name is not specified!");
            JDBCTransactionLoader.argsFail();
        }
        if ((dbHost = (String)map.get("-h")) == null) {
            System.err.println("Database host is not specified!");
            JDBCTransactionLoader.argsFail();
        }
        if ((dbName = (String)map.get("-d")) == null) {
            System.err.println("Database name is not specified!");
            JDBCTransactionLoader.argsFail();
        }
        if ((dbUser = (String)map.get("-u")) == null) {
            System.err.println("Database user is not specified");
            JDBCTransactionLoader.argsFail();
        }
        String dbPwd = (String)map.get("-p");
        String portStr = (String)map.get("-port");
        int port = 5432;
        if (portStr != null) {
            port = Integer.parseInt(portStr);
        }
        JDBCTransactionLoader loader = new JDBCTransactionLoader(dbHost, dbName, dbUser, dbPwd, port);
        loader.setGAMEFile(fileName);
        try {
            loader.setUp();
            loader.loadTransactions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void argsFail() {
        String usage = "Usage: java TestJDBCTransactions -h dbHost -d dbName -u dbUser [-p dbPwd] [-port dbPort] -f gameFileName";
        System.err.println(usage);
        System.exit(1);
    }
}

