/*
 * Decompiled with CFR 0.152.
 */
package apollo.seq.io;

import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.io.FileParse;
import apollo.util.FastaHeader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FastaFile
extends FileParse {
    int noSeqs;
    int maxLength = 0;
    Hashtable myHash;
    protected static Vector seqs;
    Vector headers;
    Vector words = new Vector();
    private static boolean debug;

    public FastaFile(DataInputStream in, boolean inHtml) {
        boolean hadPre = !inHtml;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.myHash = new Hashtable();
        seqs = new Vector();
        this.lineArray = new Vector();
        try {
            String data;
            while ((data = reader.readLine()) != null && data.indexOf("</pre>") < 0) {
                if (hadPre) {
                    this.lineArray.addElement(data);
                }
                if (hadPre) continue;
                hadPre = data.indexOf("<pre>") >= 0;
            }
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
        this.parse();
    }

    public FastaFile(String inStr) {
        this.myHash = new Hashtable();
        seqs = new Vector();
        this.headers = new Vector();
        this.readLines(inStr);
        this.parse();
    }

    public FastaFile(String inFile, String type, CurationSet curation) throws IOException {
        this(inFile, type);
        StringTokenizer str;
        SequenceI seq = (SequenceI)seqs.elementAt(0);
        String seq_id = seq.getName();
        curation.setStrand(1);
        String start_str = null;
        String end_str = null;
        int index1 = seq_id.indexOf("/");
        int index2 = seq_id.indexOf("-");
        if (index1 > 0 && index2 > index1 + 1) {
            seq.setName(seq_id.substring(0, index1));
            start_str = seq_id.substring(index1 + 1, index2);
            end_str = seq_id.substring(index2 + 1);
        } else if (seq.getDescription() != null && (str = new StringTokenizer(seq.getDescription())).countTokens() >= 2) {
            if (str.countTokens() == 3) {
                String chr = str.nextToken();
                System.out.println("Setting chromosome to " + chr);
                curation.setChromosome(chr);
            }
            start_str = str.nextToken();
            end_str = str.nextToken();
        }
        if (start_str != null && end_str != null) {
            try {
                int chrstart = Integer.parseInt(start_str);
                int chrend = Integer.parseInt(end_str);
                curation.setStart(chrstart);
                curation.setEnd(chrend);
                System.out.println("Region is " + chrstart + "-" + chrend);
            }
            catch (Exception e) {
                System.out.println("Couldn't parse start and end from " + start_str + "-" + end_str);
                curation.setStart(1);
                curation.setEnd(seq.getLength());
            }
        } else {
            curation.setStart(1);
            curation.setEnd(seq.getLength());
        }
        curation.setName(seq.getName());
        curation.setRefSequence(seq);
    }

    public FastaFile(String inFile, String type) throws IOException {
        super(inFile, type);
        this.myHash = new Hashtable();
        seqs = new Vector();
        this.headers = new Vector();
        System.out.println("Reading FASTA file " + inFile + "....");
        this.readLines();
        this.parse();
    }

    public Vector getSeqs() {
        return seqs;
    }

    public void parse() {
        StringBuffer residues = new StringBuffer();
        SequenceI sequence = null;
        if (debug) {
            System.out.println("File is " + this.lineArray.size() + " lines");
        }
        for (int i = 0; i < this.lineArray.size(); ++i) {
            if (((String)this.lineArray.elementAt(i)).length() <= 0) continue;
            if (((String)this.lineArray.elementAt(i)).substring(0, 1).equals(">")) {
                FastaHeader header = new FastaHeader((String)this.lineArray.elementAt(i));
                if (debug) {
                    System.out.println("\nParsing header " + this.lineArray.elementAt(i));
                }
                if (sequence != null) {
                    sequence.setResidues(residues.toString());
                }
                residues = new StringBuffer();
                sequence = header.generateSequence();
                seqs.addElement(sequence);
                if (!debug) continue;
                this.printSequence(sequence);
                continue;
            }
            residues.append((String)this.lineArray.elementAt(i));
        }
        if (sequence != null) {
            sequence.setResidues(residues.toString());
        }
    }

    public static String print(SequenceI s) {
        SequenceI[] sa = new Sequence[]{s};
        return FastaFile.print(sa, 60);
    }

    public static String print(SequenceI[] s) {
        return FastaFile.print(s, 60);
    }

    public static String print(SequenceI[] s, int len) {
        return FastaFile.print(s, len, true);
    }

    public static String print(SequenceI[] s, int linesize, boolean gaps) {
        StringBuffer out = new StringBuffer();
        for (int si = 0; si < s.length; ++si) {
            SequenceI seq = s[si];
            out.append(FastaFile.format(">" + seq.getName() + "\n", seq.getResidues(), linesize));
        }
        return out.toString();
    }

    public static String printGenomic(SeqFeatureI feature) {
        String header = ">" + feature.getName() + " (genomic sequence with introns)\n";
        return FastaFile.format(header, feature.getResidues(), 50);
    }

    public static String print_cDNA(SeqFeatureI feature) {
        String header = ">" + feature.getName() + " (transcript)\n";
        return FastaFile.format(header, feature.get_cDNA(), 50);
    }

    public static String printTranslation(SeqFeatureI feature) {
        String header = ">" + feature.getName() + " (translation)\n";
        return FastaFile.format(header, feature.translate(), 50);
    }

    public static String format(String header, String residues, int linesize) {
        StringBuffer out = new StringBuffer(header);
        for (int i = 0; i < residues.length(); i += linesize) {
            String nextln = i + linesize < residues.length() ? residues.substring(i, i + linesize) : residues.substring(i);
            out.append(nextln);
            out.append("\n");
        }
        return out.toString();
    }

    private void printSequence(SequenceI seq) {
        String org = seq.getOrganism();
        String org_str = org != null && !org.equals("") ? "\n\torganism:\"" + org + "\"" : "";
        System.out.println(seqs.size() + ". " + seq.getName() + org_str + "\n\tdesc: " + seq.getDescription());
        Vector xrefs = seq.getDbXrefs();
        int xref_count = xrefs == null ? 0 : xrefs.size();
        for (int j = 0; j < xref_count; ++j) {
            DbXref xref = (DbXref)xrefs.elementAt(j);
            System.out.println("\t" + xref.getDbName() + ":" + xref.getIdValue());
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Please provide the name of a fasta file");
            System.exit(0);
        }
        debug = true;
        System.out.println("Parsing " + args[0]);
        try {
            FastaFile fa = new FastaFile(args[0], "File");
            System.out.println("Parsed " + seqs.size() + " sequences");
        }
        catch (Exception e) {
            System.out.println("IO error parsing " + args[0] + " " + e);
        }
    }

    static {
        debug = false;
    }
}

