/*
 * Decompiled with CFR 0.152.
 */
package apollo.main;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.datamodel.CompositeDataHolder;
import apollo.gui.ApolloFrame;
import apollo.gui.synteny.CompositeApolloFrame;
import apollo.main.CommandLine;
import apollo.main.DataLoader;
import apollo.main.Version;
import apollo.util.IOUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import org.bdgp.swing.BackgroundImagePanel;

public class Apollo {
    static String[] args;
    Runnable mainRun = new Runnable(){

        public void run() {
            CompositeDataHolder compositeDataHolder = null;
            try {
                CommandLine commandLine = CommandLine.getCommandLine();
                commandLine.setArgs(args);
                DataLoader loader = new DataLoader();
                if (commandLine.isBatchMode()) {
                    Apollo.this.readAndWriteViaBatchFile(loader, commandLine);
                    System.exit(0);
                }
                if ((compositeDataHolder = loader.getCompositeDataHolder(commandLine)) == null) {
                    System.out.println("Nothing loaded so quitting");
                    System.exit(0);
                }
                if (commandLine.writeIsSpecified()) {
                    Apollo.this.write(loader, commandLine, compositeDataHolder);
                    System.out.println("Exiting.\n");
                    System.exit(0);
                }
                CompositeApolloFrame frame = ApolloFrame.getApolloFrame();
                frame.loadData(loader.getDataAdapter(), compositeDataHolder);
                frame.completeGUIInitialization();
            }
            catch (ApolloAdapterException e) {
                if (ApolloAdapterException.getRealException(e) != null) {
                    ApolloAdapterException.getRealException(e).printStackTrace();
                } else {
                    e.printStackTrace();
                }
                System.exit(2);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e, "Warning", 2);
                System.err.println(e + "\nPrinting stack trace: ");
                e.printStackTrace();
                System.exit(2);
            }
        }
    };

    public static void main(String[] argsStrings) {
        CommandLine commandLine = CommandLine.getCommandLine();
        try {
            commandLine.setArgs(argsStrings);
        }
        catch (ApolloAdapterException e) {
            if (ApolloAdapterException.getRealException(e) != null) {
                ApolloAdapterException.getRealException(e).printStackTrace();
            } else {
                e.printStackTrace();
            }
            System.exit(2);
        }
        if (argsStrings.length > 0 && (argsStrings[0].startsWith("--help") || argsStrings[0].startsWith("-h"))) {
            commandLine.printHelp();
            System.exit(0);
        }
        Apollo theRunner = new Apollo();
        theRunner.setArguments(argsStrings);
        boolean commandLineMode = commandLine.isInCommandLineMode();
        JWindow splashScreen = null;
        if (!commandLineMode) {
            splashScreen = Apollo.displaySplashScreen();
            splashScreen.setVisible(true);
        }
        if (IOUtil.isMac()) {
            Apollo.setMacJVM(!commandLineMode && !Config.supressMacJvmPopupMessage());
        }
        Config.initializeConfiguration();
        System.out.println("\nThis is " + Version.getVersion());
        try {
            Thread.currentThread();
            Thread.sleep(750L);
        }
        catch (Exception e) {
            System.out.println("Exception sleeping : " + e);
        }
        if (!commandLineMode) {
            theRunner.removeSplashScreen(splashScreen);
        }
        SwingUtilities.invokeLater(theRunner.mainRun);
    }

    private void removeSplashScreen(JWindow splashScreen) {
        splashScreen.setVisible(false);
        splashScreen.dispose();
    }

    private String[] getArguments() {
        return args;
    }

    private void setArguments(String[] newValue) {
        args = newValue;
    }

    private void write(DataLoader loader, CommandLine cmdLine, CompositeDataHolder cdh) throws ApolloAdapterException {
        System.out.println("\nRead done.\nWriting...\n");
        ApolloDataAdapterI writer = cmdLine.getWriteAdapter();
        loader.saveCompositeDataHolder(writer, cdh);
        System.out.println("\nWriting done.\n");
    }

    private void readAndWriteViaBatchFile(DataLoader loader, CommandLine commandLine) throws Exception {
        System.out.println("Loading from batchfile...");
        while (commandLine.hasMoreBatchEntries()) {
            commandLine.setToNextBatchEntry();
            CompositeDataHolder compData = loader.getCompositeDataHolder(commandLine);
            System.out.println("Load done. Writing...");
            this.write(loader, commandLine, compData);
            System.out.println("Writing done, loading next entry in file...");
        }
        System.out.println("Batch file done. Exiting.");
        System.exit(0);
    }

    public static URL getSplashURL(String apollosplash) {
        try {
            URL splash = Apollo.toURL(new File(System.getProperty("APOLLO_ROOT") + "/data/" + apollosplash));
            if (new File(splash.getFile()).exists()) {
                return splash;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            System.err.println("Couldn't find splash image " + apollosplash + "--retrieving from jar");
            String splashfile = IOUtil.findFile(apollosplash, true);
            File splash = new File(splashfile);
            System.out.println("Created splashfile " + splashfile + " from jar");
            return Apollo.toURL(splash);
        }
        catch (Exception e) {
            System.err.println("Couldn't get splash screen from jar" + e.getMessage());
            return null;
        }
    }

    private static URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public static JWindow displaySplashScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String splashscreen = "apollosplash.gerry.jpg";
        URL url = null;
        int windowHeight = 240;
        int windowWidth = 529;
        JWindow window = new JWindow();
        Rectangle windowBounds = new Rectangle((screenSize.width - windowWidth) / 2, (screenSize.height - windowHeight) / 2, windowWidth, windowHeight);
        window.setBounds(windowBounds);
        try {
            url = Apollo.getSplashURL(splashscreen);
            BackgroundImagePanel backgroundImagePanel = new BackgroundImagePanel(url, false);
            CompoundBorder border = new CompoundBorder(new LineBorder(Color.black, 1), new BevelBorder(0));
            backgroundImagePanel.setBorder((Border)border);
            window.setContentPane((Container)backgroundImagePanel);
            backgroundImagePanel.repaint();
        }
        catch (Exception e) {
            System.out.println("Error loading splashscreen " + splashscreen);
            e.printStackTrace();
        }
        return window;
    }

    private static void setMacJVM(boolean doPopups) {
        String command = System.getProperty("APOLLO_ROOT") + "/bin/mac-set-jvm";
        try {
            String line;
            System.out.println("Running: " + command);
            Process proc = Runtime.getRuntime().exec(command);
            proc.waitFor();
            if (proc.exitValue() == 0) {
                String message = "Set Apollo to use JDK1.4.  When you click \"Ok\", Apollo will exit\nand you will need to restart it.\n\nYou shouldn't see this message again.";
                JOptionPane pane = new JOptionPane(message);
                JDialog dialog = pane.createDialog(null, "Please Confirm");
                dialog.show();
                System.exit(0);
            } else if (proc.exitValue() == 1) {
                System.out.println("JVM setting ok--Info.plist not changed.");
                return;
            }
            InputStream errors = proc.getErrorStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(errors));
            while ((line = reader.readLine()) != null) {
                System.out.println("Message from mac-set-jvm: " + line);
            }
            if (proc.exitValue() == 2) {
                String message = "Since you are not running an installed version of Apollo, I can't change\nwhich JVM it uses.  Hopefully you have JDK1.4 set up as your default JVM.\n";
                System.out.println(message);
            } else if (proc.exitValue() == 3) {
                String message = "You are running an old version of Mac OS X that does not support JDK1.4.\nYou probably will not be able to run Apollo.\nWe recommend upgrading your Mac operating system.\n";
                if (doPopups) {
                    JOptionPane.showMessageDialog(null, message, "Warning", 2);
                }
                System.out.println(message);
            } else {
                String message = "You may be running incompatible versions of Mac OS X and the JDK.\nRunning Apollo with this configuration could crash your Mac.\nWe recommend updating to JDK1.4 before trying to run Apollo.\nSee http://www.apple.com/macosx/upgrade/softwareupdates.html for instructions.\n";
                if (doPopups) {
                    JOptionPane.showMessageDialog(null, message, "Warning", 2);
                }
                System.out.println(message);
            }
        }
        catch (Exception e) {
            System.out.println("Exception calling " + command + ": " + e);
        }
    }
}

