/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.tweeker;

import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.SliderWindow;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.gui.tweeker.RestrictionEnzymeSelector;
import apollo.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class Tweeker
extends JFrame
implements ActionListener {
    public static int frameWidth = 520;
    public static int frameHeight = 275;
    public static final int GC = 0;
    public static final int RESTRICTION = 1;
    private static final Dimension frameSize = new Dimension(frameWidth, frameHeight);
    private JCheckBox gcplot = new JCheckBox("Show GC content graph");
    private JButton changeColour = new JButton("Change graph color");
    private JPanel gcSliderPanel;
    private RestrictionEnzymeSelector resEnzSel;
    private JTabbedPane tabbedPane;
    private TweekerWindowControl winControl;
    private static Tweeker tweekerSingleton;

    public static void openTweeker(int type) {
        if (tweekerSingleton == null) {
            tweekerSingleton = new Tweeker();
        } else {
            tweekerSingleton.clear();
        }
        tweekerSingleton.initGui(type);
    }

    public Tweeker() {
        super("Sequence Analysis Controls");
    }

    private GuiCurationState getCurState() {
        return CurationManager.getCurationManager().getActiveCurState();
    }

    private StrandedZoomableApolloPanel getSZAP() {
        return this.getCurState().getSZAP();
    }

    private void initGui(int type) {
        this.tabbedPane = new JTabbedPane();
        SliderWindow slider = new SliderWindow(this.getActiveBoundedRangeModel());
        this.gcSliderPanel = new JPanel();
        this.gcSliderPanel.setLayout(new GridBagLayout());
        this.gcSliderPanel.add((Component)slider, GuiUtil.makeConstraintAt(0, 0, 0));
        this.gcSliderPanel.add((Component)this.gcplot, GuiUtil.makeConstraintAt(0, 1, 0));
        this.gcplot.setSelected(this.getSZAP().getGraphVisibility());
        this.gcSliderPanel.add((Component)this.changeColour, GuiUtil.makeConstraintAt(0, 2, 0));
        this.gcplot.addActionListener(this);
        this.changeColour.addActionListener(this);
        this.resEnzSel = new RestrictionEnzymeSelector(this);
        String tip = "Set size of window in calculating GC graph";
        if (type == 1) {
            this.resEnzSel.addToTabbedPane(this.tabbedPane);
            this.tabbedPane.addTab("GC Window Size", null, this.gcSliderPanel, tip);
        } else {
            this.tabbedPane.addTab("GC Window Size", null, this.gcSliderPanel, tip);
            this.resEnzSel.addToTabbedPane(this.tabbedPane);
        }
        this.getContentPane().add(this.tabbedPane);
        this.setSize(frameSize);
        this.winControl = new TweekerWindowControl(this.getCurState().getController());
        this.setVisible(true);
        this.toFront();
        this.selectTab(type);
        if (this.getState() == 1) {
            this.setState(0);
        }
    }

    private BoundedRangeModel getActiveBoundedRangeModel() {
        return this.getSZAP().getGraphView().getScoreCalculator().getModel();
    }

    private void selectTab(int type) {
        if (type == 0) {
            this.tabbedPane.setSelectedComponent(this.gcSliderPanel);
            this.gcplot.setSelected(true);
            this.getSZAP().setGraphVisibility(this.gcplot.isSelected());
        } else {
            int which_is_gc = this.tabbedPane.indexOfComponent(this.gcSliderPanel);
            this.tabbedPane.setSelectedIndex(1 - which_is_gc);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Color colour;
        if (e.getSource() == this.gcplot) {
            this.getSZAP().setGraphVisibility(this.gcplot.isSelected());
        } else if (e.getSource() == this.changeColour && (colour = JColorChooser.showDialog(this, "Change plot colour", this.getSZAP().getGraphView().getPlotColour())) != null) {
            boolean visibleNow = this.getSZAP().getGraphVisibility();
            if (visibleNow) {
                this.getSZAP().setGraphVisibility(false);
            }
            this.getSZAP().getGraphView().setPlotColour(colour);
            if (visibleNow) {
                this.getSZAP().setGraphVisibility(true);
            }
        }
    }

    private void clear() {
        this.winControl.clear();
    }

    private class TweekerWindowControl
    extends WindowAdapter
    implements ControlledObjectI,
    EventListener,
    DataLoadListener {
        private Controller controller;

        private TweekerWindowControl(Controller c) {
            this.setController(c);
            Tweeker.this.addWindowListener(this);
        }

        public void setController(Controller controller) {
            this.controller = controller;
            controller.addListener(this);
        }

        public Controller getController() {
            return this.controller;
        }

        public Object getControllerWindow() {
            return Tweeker.this;
        }

        public boolean needsAutoRemoval() {
            return true;
        }

        public boolean handleDataLoadEvent(DataLoadEvent e) {
            Tweeker.this.getSZAP().setGraphVisibility(false);
            this.clear();
            return true;
        }

        private void clear() {
            if (Tweeker.this.tabbedPane != null) {
                Tweeker.this.getContentPane().remove(Tweeker.this.tabbedPane);
            }
            Tweeker.this.tabbedPane = null;
            if (Tweeker.this.resEnzSel != null) {
                Tweeker.this.resEnzSel.clear();
            }
            Tweeker.this.resEnzSel = null;
            Tweeker.this.hide();
            Tweeker.this.dispose();
            this.controller.removeListener(this);
        }

        public void windowClosing(WindowEvent e) {
            this.clear();
        }
    }
}

