/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.synteny;

import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.SerialDiskAdapter;
import apollo.datamodel.CompositeDataHolder;
import apollo.external.ApolloControlServer;
import apollo.gui.AutoSaveThread;
import apollo.gui.CheckMemoryThread;
import apollo.gui.Controller;
import apollo.gui.StatusBar;
import apollo.gui.event.SetActiveCurStateEvent;
import apollo.gui.evidencepanel.EvidencePanel;
import apollo.gui.evidencepanel.EvidencePanelContainer;
import apollo.gui.synteny.GuiCurationState;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JOptionPane;

public class CurationManager {
    private static CurationManager curationManagerSingleton;
    private List curStateList = new ArrayList(4);
    private GuiCurationState activeCurState;
    private CompositeDataHolder compositeDataHolder;
    private StatusBar statusBar;
    private ApolloDataAdapterI dataAdapter;

    public static CurationManager getCurationManager() {
        if (curationManagerSingleton == null) {
            curationManagerSingleton = new CurationManager();
        }
        return curationManagerSingleton;
    }

    private CurationManager() {
        this.initAutoSave();
        this.statusBar = new StatusBar();
        this.initHttpServer();
    }

    void setCompositeDataHolder(CompositeDataHolder cdh) {
        int i;
        if (this.compositeDataHolder == cdh) {
            return;
        }
        this.compositeDataHolder = cdh;
        this.getEvidencePanelContainer().clear();
        for (i = 0; i < this.compositeDataHolder.numberOfSpecies(); ++i) {
            GuiCurationState curationState = this.getCurationState(i);
            curationState.setCurationName(this.compositeDataHolder.getSpecies(i));
            curationState.setCurationSet(this.compositeDataHolder.getCurationSet(i));
            EvidencePanel currentEvidencePanel = new EvidencePanel(this.getCurationState(i));
            this.getEvidencePanelContainer().addEvidencePanel(currentEvidencePanel);
        }
        if (this.activeCurState == null) {
            this.setActiveCurState(this.getCurationState(0));
        }
        for (i = this.numberOfCurations() - 1; i >= this.compositeDataHolder.numberOfSpecies(); --i) {
            this.removeCurationState(i);
        }
    }

    public CompositeDataHolder getCompositeDataHolder() {
        return this.compositeDataHolder;
    }

    private EvidencePanelContainer getEvidencePanelContainer() {
        return EvidencePanelContainer.getSingleton();
    }

    void setDataAdapter(ApolloDataAdapterI dataAdapter) {
        this.dataAdapter = dataAdapter;
        if (dataAdapter.isComposite()) {
            for (int i = 0; i < dataAdapter.getNumberOfChildAdapters(); ++i) {
                this.getCurationState(i).setDataAdapter(dataAdapter.getChildAdapter(i));
            }
        } else {
            this.getCurationState(0).setDataAdapter(dataAdapter);
            if (this.numberOfCurations() > 1) {
                String m = "Programmer error. CurationManager.setDataAdapter received non-composite data adapter but has more than one curationState";
                System.err.println(m);
            }
        }
    }

    public ApolloDataAdapterI getDataAdapter() {
        return this.dataAdapter;
    }

    public int numberOfCurations() {
        return this.curStateList.size();
    }

    public boolean isMultiCuration() {
        return this.numberOfCurations() > 1;
    }

    public boolean isSingleCuration() {
        return this.numberOfCurations() == 1;
    }

    public GuiCurationState getCurationState(int i) {
        GuiCurationState curState = null;
        if (i < this.curStateList.size()) {
            curState = (GuiCurationState)this.curStateList.get(i);
        } else if (i >= this.curStateList.size()) {
            curState = new GuiCurationState(i);
            curState.setZoomLayoutPosition(this.getZoomLayoutPosition(i));
            this.curStateList.add(i, curState);
        }
        return curState;
    }

    private String getZoomLayoutPosition(int i) {
        if (i == 0 && this.dataAdapter.getNumberOfChildAdapters() > 1) {
            return "North";
        }
        return "South";
    }

    public String getCurationName(int i) {
        return this.getCurationState(i).getCurationName();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void removeCurationState(int i) {
        this.getCurationState(i).clear();
        this.curStateList.remove(i);
    }

    public Controller getCurationController(int i) {
        return this.getCurationState(i).getController();
    }

    void addListenerToAllCurations(EventListener l) {
        for (int i = 0; i < this.numberOfCurations(); ++i) {
            this.getCurationController(i).addListener(l);
        }
    }

    public void setActiveCurState(GuiCurationState curationState) {
        GuiCurationState oldActiveCurState = this.activeCurState;
        SetActiveCurStateEvent evt = new SetActiveCurStateEvent(this, curationState, oldActiveCurState);
        if (this.activeCurState != null) {
            this.activeCurState.getController().handleSetActiveCurStateEvent(evt);
        }
        this.activeCurState = curationState;
        if (curationState != null) {
            curationState.getController().handleSetActiveCurStateEvent(evt);
        }
    }

    public void setActiveCurState(String curSetName) {
        GuiCurationState cs = this.getCurStateForCurName(curSetName);
        if (cs != null) {
            this.setActiveCurState(cs);
        }
    }

    public static Style getActiveStyle() {
        return CurationManager.getActiveCurationState().getStyle();
    }

    public static GuiCurationState getActiveCurationState() {
        return CurationManager.getCurationManager().getActiveCurState();
    }

    public GuiCurationState getActiveCurState() {
        return this.activeCurState;
    }

    public boolean isActiveCurName(String curName) {
        if (curName == null) {
            return false;
        }
        return curName.equals(this.getActiveCurState().getCurationName());
    }

    public GuiCurationState getCurStateForCurName(String curationName) {
        for (int i = 0; i < this.numberOfCurations(); ++i) {
            if (!this.getCurationState(i).getCurationName().equals(curationName)) continue;
            return this.getCurationState(i);
        }
        System.err.println("Programmer error: no cur set with name " + curationName);
        return null;
    }

    public void selectInputFeatures() {
        for (int i = 0; i < CurationManager.getCurationManager().numberOfCurations(); ++i) {
            String in;
            ApolloDataAdapterI dataAdapter = this.getCurationState(i).getDataAdapter();
            if (dataAdapter == null) {
                return;
            }
            if (dataAdapter.getInputType() != DataInputType.GENE && (dataAdapter.getInputType() != DataInputType.URL || dataAdapter.getInput() == null || dataAdapter.getInput().indexOf("gene") <= 0) || (in = dataAdapter.getInput()) == null) continue;
            this.getCurationState(i).getSZAP().selectFeaturesByName(in, Config.getGeneWindow());
        }
    }

    private void initAutoSave() {
        if (!Config.isEditingEnabled()) {
            return;
        }
        try {
            int saveInterval = Config.getAutosaveInterval();
            if (saveInterval > 0) {
                AutoSaveThread ast = new AutoSaveThread(Config.getAutosaveFile(), saveInterval);
                ast.setDataAdapter(new SerialDiskAdapter(Config.getAutosaveFile()));
                ast.start();
            } else {
                System.err.println("WARNING: Autosave disabled. If Apollo crashes and you have not saved, YOUR WORK WILL BE LOST.");
            }
            CheckMemoryThread cmt = new CheckMemoryThread(Config.getMemoryAllocation());
            cmt.start();
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(null, e, "Warning", 2);
            e.printStackTrace();
        }
    }

    private void initHttpServer() {
        if (Config.httpServerIsEnabled()) {
            new ApolloControlServer();
        }
    }
}

