/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.config.DisplayPrefsI;
import apollo.config.FeatureProperty;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.editor.AnnotationEditor;
import apollo.gui.ApolloFrame;
import apollo.gui.Selection;
import apollo.gui.detailviewers.PropertyDisplay;
import apollo.gui.detailviewers.blixem.BlixemRunner;
import apollo.gui.detailviewers.seqexport.SeqExport;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.gui.genomemap.AnnotationView;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.FeatureTierManager;
import apollo.gui.genomemap.FeatureView;
import apollo.gui.genomemap.ResultView;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.menus.AlignMenuItems;
import apollo.gui.menus.ShowMenu;
import apollo.gui.menus.TypesMenu;
import apollo.util.ClipboardUtil;
import apollo.util.HTMLUtil;
import apollo.util.IOUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;

public class TierPopupMenu
extends JPopupMenu
implements ActionListener {
    ResultView resultView;
    ApolloPanelI ap;
    JMenuItem collapseTier;
    JMenuItem expandTier;
    JMenuItem hideTier;
    JMenuItem changeColor;
    AnnotationEditor editor = null;
    Selection selection;
    JMenuItem dnaBlixem;
    JMenuItem protBlixem;
    JMenuItem getData;
    JMenuItem set5Prime;
    JMenuItem set3Prime;
    JMenuItem setEnds;
    JMenuItem createGeneTrans;
    TypesMenu typesMenu;
    JMenuItem addTranscript;
    JMenuItem flipResult;
    JMenuItem sequence;
    JMenuItem props;
    private JMenuItem loadSyntenyLink;
    JMenuItem cancel;
    Hashtable resultTags = new Hashtable();
    private AlignMenuItems jalviewMenus;
    Point pos;
    private static String no_tag = "None";
    ButtonGroup tag_group;

    public TierPopupMenu(ApolloPanelI ap, ResultView resultView, Selection selection, Point pos) {
        super("Tier operations");
        this.ap = ap;
        this.resultView = resultView;
        this.pos = pos;
        this.selection = selection;
        AnnotationView av = resultView.getAnnotationView();
        if (av != null) {
            this.editor = av.getAnnotationEditor();
            FeatureSetI avTopModel = av.getGeneHolder();
            Selection cursorSel = selection.getSelectionDescendedFromModel(avTopModel, true);
            this.editor.setSelections(av, selection, cursorSel.getSelectedVector(), av.getTransform().toUser((Point)pos).x, av.getStrand());
        } else {
            System.err.println("getAnnotationView returned null in TierPopupMenu");
        }
        this.menuInit();
    }

    public TierPopupMenu(ApolloPanelI ap, ResultView resultView, Point pos) {
        this(ap, resultView, null, pos);
    }

    private boolean sequenceAllowed() {
        return true;
    }

    private ApolloFrame getApolloFrame() {
        return ApolloFrame.getApolloFrame();
    }

    public void menuInit() {
        this.dnaBlixem = new JMenuItem("Blixem on DNA hits");
        this.protBlixem = new JMenuItem("Blixem on protein hits");
        this.changeColor = new JMenuItem("Change color of this feature type");
        this.collapseTier = new JMenuItem("Collapse tier");
        this.expandTier = new JMenuItem("Expand tier");
        this.hideTier = new JMenuItem("Hide tier");
        this.getData = new JMenuItem("Get info about this feature via Web");
        this.loadSyntenyLink = new JMenuItem("Bring up link as other species in synteny");
        this.set5Prime = new JMenuItem("Set as 5' end");
        this.set3Prime = new JMenuItem("Set as 3' end");
        this.setEnds = new JMenuItem("Set both ends");
        this.typesMenu = new TypesMenu(this.editor);
        this.createGeneTrans = new JMenuItem("Add as gene transcript");
        this.addTranscript = new JMenuItem("Add as new transcript to selected gene");
        this.flipResult = new JMenuItem("Move to other strand");
        this.sequence = new JMenuItem("Sequence...");
        this.props = new JMenuItem("Print this feature's properties");
        this.cancel = new JMenuItem("Close menu");
        this.add(this.sequence);
        this.add(this.getData);
        this.add(this.props);
        this.props.setEnabled(true);
        this.addSeparator();
        if (Config.getStyle().addSyntenyResultMenuItem()) {
            this.add(this.loadSyntenyLink);
            this.loadSyntenyLink.setEnabled(this.enableSyntenyLink());
        }
        if (Config.getBlixemLocation() != null && IOUtil.isUnix()) {
            this.add(this.dnaBlixem);
            this.add(this.protBlixem);
        }
        FeatureSetI annotTop = this.resultView.getAnnotationView().getTopModel();
        FeatureSetI resultTop = this.resultView.getTopModel();
        this.jalviewMenus = new AlignMenuItems(annotTop, resultTop, this.selection, this.ap.getController());
        this.add(this.jalviewMenus.getAlignSelectionMenuItem());
        this.add(this.jalviewMenus.getAlignRegionMenuItem());
        this.addSeparator();
        if (Config.isEditingEnabled()) {
            this.add(this.set5Prime);
            this.add(this.set3Prime);
            this.add(this.setEnds);
            this.addSeparator();
            this.add(this.typesMenu);
            this.add(this.createGeneTrans);
            this.add(this.addTranscript);
            this.add(this.flipResult);
            if (this.selection.size() == 1) {
                this.addTagItems(this.selection.getSelectedData(0));
            }
            this.addSeparator();
        }
        this.add(this.changeColor);
        this.add(this.collapseTier);
        this.add(this.expandTier);
        this.add(this.hideTier);
        if (this.editor == null) {
            this.set5Prime.setEnabled(false);
            this.set3Prime.setEnabled(false);
            this.setEnds.setEnabled(false);
            this.typesMenu.setEnabled(false);
            this.createGeneTrans.setEnabled(false);
            this.addTranscript.setEnabled(false);
            this.flipResult.setEnabled(false);
            this.changeColor.setEnabled(false);
            this.collapseTier.setEnabled(false);
            this.expandTier.setEnabled(false);
            this.hideTier.setEnabled(false);
        } else {
            this.set5Prime.setEnabled(this.editor.setExonTerminusAllowed());
            this.set3Prime.setEnabled(this.editor.setExonTerminusAllowed());
            this.setEnds.setEnabled(this.editor.setExonTerminusAllowed());
            this.typesMenu.setEnabled(this.editor.addGeneOrTranscriptAllowed());
            this.createGeneTrans.setEnabled(this.editor.addGeneOrTranscriptAllowed());
            this.addTranscript.setEnabled(this.editor.addTranscriptAllowed());
            this.flipResult.setEnabled(this.editor.resultIsSelected());
            this.changeColor.setEnabled(this.editor.resultIsSelected());
            this.collapseTier.setEnabled(this.editor.resultIsSelected());
            this.expandTier.setEnabled(this.editor.resultIsSelected());
            this.hideTier.setEnabled(this.editor.resultIsSelected());
        }
        this.getData.setEnabled(this.selection.size() >= 1);
        boolean have_seq = false;
        if (this.selection.size() > 0) {
            SeqFeatureI firstFeat = this.selection.getFeature(0);
            SequenceI seq = firstFeat.getRefSequence();
            have_seq = seq != null && (seq.isLazy() || seq.getResidues() != null);
        }
        this.sequence.setEnabled(have_seq);
        this.add(new ShowMenu(this.resultView, this.pos));
        this.addSeparator();
        this.add(this.cancel);
        this.dnaBlixem.addActionListener(this);
        this.protBlixem.addActionListener(this);
        this.set5Prime.addActionListener(this);
        this.set3Prime.addActionListener(this);
        this.setEnds.addActionListener(this);
        this.createGeneTrans.addActionListener(this);
        this.addTranscript.addActionListener(this);
        this.flipResult.addActionListener(this);
        this.getData.addActionListener(this);
        this.props.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PropertyDisplay(TierPopupMenu.this.selection);
            }
        });
        this.sequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SeqExport(TierPopupMenu.this.selection, TierPopupMenu.this.ap.getController());
            }
        });
        this.loadSyntenyLink.addActionListener(this);
        this.cancel.addActionListener(this);
        this.collapseTier.addActionListener(this);
        this.expandTier.addActionListener(this);
        this.hideTier.addActionListener(this);
        this.changeColor.addActionListener(this);
        this.collapseTier.setMnemonic('O');
        this.expandTier.setMnemonic('P');
        this.hideTier.setMnemonic('H');
    }

    private Vector getFeatureSets(Vector exons) {
        Hashtable<String, SeqFeatureI> out = new Hashtable<String, SeqFeatureI>();
        Vector v = new Vector();
        if (exons != null) {
            for (int i = 0; i < exons.size(); ++i) {
                SeqFeatureI feature = (SeqFeatureI)exons.elementAt(i);
                if ((feature = this.getFeatureSet(feature)) == null || feature.getId() == null) continue;
                out.put(feature.getId(), feature);
            }
            Enumeration e = out.elements();
            while (e.hasMoreElements()) {
                v.addElement(e.nextElement());
            }
        }
        return v;
    }

    private FeatureSetI getFeatureSet(SeqFeatureI feature) {
        if (feature == null) {
            return null;
        }
        if (feature instanceof DrawableSeqFeature) {
            return this.getFeatureSet(((DrawableSeqFeature)((Object)feature)).getFeature());
        }
        if (feature.canHaveChildren()) {
            return (FeatureSetI)feature;
        }
        return this.getFeatureSet(feature.getRefFeature());
    }

    public void actionPerformed(ActionEvent e) {
        FeatureTierManager tm = (FeatureTierManager)this.resultView.getTierManager();
        if (e.getSource() == this.dnaBlixem || e.getSource() == this.protBlixem) {
            StrandedZoomableApolloPanel szap = this.ap.getStrandedZoomableApolloPanel();
            Vector types = this.getUniqueListOfAllTypesUsedInSelection();
            int centre = this.getCentreOfSelection();
            int resType = e.getSource() == this.dnaBlixem ? 1 : 2;
            System.out.println("Running blixem");
            BlixemRunner br = new BlixemRunner(szap.getCurationSet(), types, centre, resType);
            br.run();
        } else if (e.getSource() == this.set5Prime) {
            this.editor.setAs5Prime();
        } else if (e.getSource() == this.getData) {
            String url = this.makeURLForFeature();
            if (url != null) {
                System.out.println("Loading web page " + url);
                HTMLUtil.loadIntoBrowser(url);
            }
        } else if (e.getSource() == this.set3Prime) {
            this.editor.setAs3Prime();
        } else if (e.getSource() == this.setEnds) {
            this.editor.setAsBothEnds();
        } else if (e.getSource() == this.createGeneTrans) {
            this.editor.addGeneOrTranscript();
        } else if (e.getSource() == this.addTranscript) {
            this.editor.addTranscript();
        } else if (e.getSource() == this.flipResult) {
            this.editor.flipResult();
        } else if (this.resultTags.get(e.getSource()) != null) {
            this.setTag((JRadioButtonMenuItem)e.getSource());
        } else if (e.getSource() == this.loadSyntenyLink) {
            this.getApolloFrame().loadSyntenyLink(this.selection.getSelectedData(0));
        } else if (e.getSource() == this.collapseTier) {
            tm.collapseTier(this.resultView, this.ap);
        } else if (e.getSource() == this.expandTier) {
            tm.expandTier(this.resultView, this.ap);
        } else if (e.getSource() == this.hideTier) {
            tm.hideTier(this.resultView, this.ap);
            this.ap.clearSelection();
        } else if (e.getSource() == this.changeColor) {
            tm.changeTypeColor(this.resultView, this.selection);
        }
        this.resultView.setInvalidity(true);
        this.resultView.getComponent().repaint(this.resultView.getBounds().x, this.resultView.getBounds().y, this.resultView.getBounds().width, this.resultView.getBounds().height);
        AnnotationView av = this.resultView.getAnnotationView();
        if (av != null) {
            av.setInvalidity(true);
            av.getComponent().repaint(av.getBounds().x, av.getBounds().y, av.getBounds().width, av.getBounds().height);
        }
    }

    private Vector getUniqueListOfAllTypesUsedInSelection() {
        Vector v = new Vector();
        v.addAll(this.ap.getSelection().getSelectedVisualTypes());
        return v;
    }

    public int getCentreOfSelection() {
        int min = -1;
        int max = -1;
        if (this.resultView instanceof FeatureView) {
            ResultView fv = this.resultView;
            Selection s = fv.getViewSelection(this.ap.getSelection());
            for (int i = 0; i < s.size(); ++i) {
                SeqFeatureI sf = s.getFeature(i);
                if (sf.getLow() < min || min == -1) {
                    min = sf.getLow();
                }
                if (sf.getHigh() <= max && max != -1) continue;
                max = sf.getHigh();
            }
        }
        return max - min + min;
    }

    private void addTagItems(SeqFeatureI sf) {
        if (sf instanceof FeaturePair) {
            sf = sf.getRefFeature();
        }
        this.resultTags.clear();
        Hashtable tags = Config.getStyle().getResultTags();
        Enumeration e = tags.keys();
        while (e.hasMoreElements()) {
            String current_tag;
            String result_type = (String)e.nextElement();
            FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(sf.getFeatureType());
            if (!fp.getDisplayType().equals(result_type)) continue;
            Vector result_tags = (Vector)tags.get(result_type);
            if (!result_tags.contains(no_tag)) {
                result_tags.addElement(no_tag);
            }
            if ((current_tag = sf.getProperty("tag")) == null || current_tag.equals("")) {
                current_tag = no_tag;
            }
            JMenu tag_menu = new JMenu("Change tag from \"" + current_tag + "\"");
            this.tag_group = new ButtonGroup();
            for (int i = 0; i < result_tags.size(); ++i) {
                String text = (String)result_tags.elementAt(i);
                JRadioButtonMenuItem tag = new JRadioButtonMenuItem(text);
                tag.setEnabled(true);
                tag.addActionListener(this);
                tag_menu.add(tag);
                this.tag_group.add(tag);
                tag.setSelected(text.equals(current_tag));
                this.resultTags.put(tag, sf);
            }
            this.add(tag_menu);
        }
    }

    private void setTag(JRadioButtonMenuItem item) {
        String text;
        SeqFeatureI sf = this.selection.getSelectedData(0);
        SeqFeatureI orig_sf = sf;
        if (orig_sf instanceof FeaturePair) {
            sf = orig_sf.getRefFeature();
        }
        if (!(text = item.getText()).equals(no_tag)) {
            sf.replaceProperty("tag", text);
            Vector spans = sf.getFeatures();
            for (int i = 0; i < spans.size(); ++i) {
                SeqFeatureI span = (SeqFeatureI)spans.elementAt(i);
                if (span.getProperty("tag") != null && !span.getProperty("tag").equals("")) {
                    span.replaceProperty("tag", text);
                }
                SeqFeatureI query = ((FeaturePair)span).getQueryFeature();
                SeqFeatureI subject = ((FeaturePair)span).getHitFeature();
                if (query.getProperty("tag") != null && !query.getProperty("tag").equals("")) {
                    query.replaceProperty("tag", text);
                }
                subject.replaceProperty("tag", text);
            }
            if (this.resultView instanceof ResultView) {
                ResultView rv = this.resultView;
                rv.setInvalidity(true);
                rv.getComponent().repaint(rv.getBounds().x, rv.getBounds().y, rv.getBounds().width, rv.getBounds().height * 2);
            }
        } else {
            sf.removeProperty("tag");
        }
    }

    private String makeURLForFeature() {
        DisplayPrefsI displayPrefs = Config.getDisplayPrefs();
        return displayPrefs.generateURL(this.selection.last());
    }

    private boolean isSyntenyLinked(SeqFeatureI sf) {
        return Config.getPropertyScheme().getFeatureProperty(sf.getTopLevelType()).isSyntenyLinked();
    }

    private boolean enableSyntenyLink() {
        SeqFeatureI sf = this.selection.getFeature(0);
        if (this.selection.size() == 1) {
            return this.isSyntenyLinked(sf);
        }
        if (this.selection.size() >= 1) {
            FeatureSetI parent = null;
            for (int i = 0; i < this.selection.size(); ++i) {
                sf = this.selection.getSelectedData(i);
                if (!this.isSyntenyLinked(sf)) {
                    return false;
                }
                if (parent == null) {
                    parent = sf.getParent();
                }
                if (parent == sf.getParent()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.editor = null;
        if (this.jalviewMenus != null) {
            this.jalviewMenus.clear();
        }
    }

    private class CopyAction
    implements ActionListener {
        JTextArea area;

        public CopyAction(JTextArea area) {
            this.area = area;
        }

        public void actionPerformed(ActionEvent e) {
            ClipboardUtil.copyTextToClipboard(this.area.getSelectedText());
        }
    }
}

