/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.gui.synteny.CompositeApolloFrame;
import apollo.gui.synteny.CurationManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class SyntenyChoiceMenu
extends JMenu {
    Set activationItems = new HashSet();
    static HashMap logicalNamesAndSpecies;
    CompositeApolloFrame frame;
    boolean useOpaqueLinks = Config.getStyle().useOpaqueLinks();
    boolean shadeByPercId = false;
    private boolean lockScrolling = Config.getStyle().initialLockedScrolling();
    private boolean shiftLockZoom = Config.getStyle().initialShiftForLockedZooming();
    JCheckBoxMenuItem useOpaqueLinksItem;
    JCheckBoxMenuItem shadeLinksByPercIdItem;
    JCheckBoxMenuItem lockScrollingItem;
    private JCheckBoxMenuItem shiftLockZoomMenuItem;

    public SyntenyChoiceMenu(CompositeApolloFrame frame) {
        super("Synteny");
        this.frame = frame;
        this.addMenuListener(new SyntenyMenuListener());
        this.menuInit();
    }

    public void menuInit() {
        this.removeAll();
        SyntenyMenuActionListener actionListener = new SyntenyMenuActionListener();
        if (this.getCurationManager().isSingleCuration()) {
            return;
        }
        String name = null;
        JCheckBoxMenuItem item = null;
        for (int i = 0; i < this.getCurationManager().numberOfCurations(); ++i) {
            name = this.getCurationManager().getCurationName(i);
            item = new JCheckBoxMenuItem(name + " panel active");
            this.getActivationItems().add(item);
            item.addActionListener(actionListener);
            this.add(item);
            item.setSelected(this.getCurationManager().isActiveCurName(name));
        }
        this.addSeparator();
        this.useOpaqueLinksItem = new JCheckBoxMenuItem("Use opaque links");
        this.useOpaqueLinksItem.setSelected(this.getUseOpaqueLinks());
        this.useOpaqueLinksItem.addActionListener(actionListener);
        this.add(this.useOpaqueLinksItem);
        this.shadeLinksByPercIdItem = new JCheckBoxMenuItem("Shade links by % identity");
        this.shadeLinksByPercIdItem.addActionListener(actionListener);
        this.shadeLinksByPercIdItem.setSelected(this.getShadeByPercId());
        this.add(this.shadeLinksByPercIdItem);
        this.lockScrollingItem = new JCheckBoxMenuItem("Lock scrolling");
        this.lockScrollingItem.addActionListener(actionListener);
        this.lockScrollingItem.setSelected(this.getLockScrolling());
        this.add(this.lockScrollingItem);
        this.shiftLockZoomMenuItem = new JCheckBoxMenuItem("Shift for locked zooming");
        this.shiftLockZoomMenuItem.addActionListener(actionListener);
        this.shiftLockZoomMenuItem.setSelected(this.getShiftZoomLock());
        this.add(this.shiftLockZoomMenuItem);
    }

    private JCheckBoxMenuItem getLockScrollingItem() {
        return this.lockScrollingItem;
    }

    private JCheckBoxMenuItem getShiftLockZoomMenuItem() {
        return this.shiftLockZoomMenuItem;
    }

    private JCheckBoxMenuItem getUseOpaqueLinksItem() {
        return this.useOpaqueLinksItem;
    }

    private JCheckBoxMenuItem getShadeByPercIdItem() {
        return this.shadeLinksByPercIdItem;
    }

    private Set getActivationItems() {
        return this.activationItems;
    }

    private static HashMap getLogicalNamesAndSpecies() {
        return logicalNamesAndSpecies;
    }

    public void setUseOpaqueLinks(boolean value) {
        this.useOpaqueLinks = value;
    }

    public void setShadeByPercId(boolean value) {
        this.shadeByPercId = value;
    }

    public boolean getUseOpaqueLinks() {
        return this.useOpaqueLinks;
    }

    public boolean getShadeByPercId() {
        return this.shadeByPercId;
    }

    public boolean getLockScrolling() {
        return this.lockScrolling;
    }

    public void setLockScrolling(boolean value) {
        this.lockScrolling = value;
    }

    private boolean getShiftZoomLock() {
        return this.shiftLockZoom;
    }

    private void setShiftZoomLock(boolean b) {
        this.shiftLockZoom = b;
    }

    private CurationManager getCurationManager() {
        return CurationManager.getCurationManager();
    }

    private class SyntenyMenuActionListener
    implements ActionListener {
        private SyntenyMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SyntenyChoiceMenu.this.getActivationItems().contains(e.getSource())) {
                String name = ((JCheckBoxMenuItem)e.getSource()).getText();
                int panelIndex = name.indexOf(" panel");
                name = name.substring(0, panelIndex);
                CurationManager.getCurationManager().setActiveCurState(name);
            } else if (e.getSource().equals(SyntenyChoiceMenu.this.getUseOpaqueLinksItem())) {
                SyntenyChoiceMenu.this.frame.setUseOpaqueLinks(SyntenyChoiceMenu.this.getUseOpaqueLinksItem().isSelected());
                SyntenyChoiceMenu.this.setUseOpaqueLinks(SyntenyChoiceMenu.this.getUseOpaqueLinksItem().isSelected());
            } else if (e.getSource().equals(SyntenyChoiceMenu.this.getShadeByPercIdItem())) {
                SyntenyChoiceMenu.this.frame.setShadeByPercId(SyntenyChoiceMenu.this.getShadeByPercIdItem().isSelected());
                SyntenyChoiceMenu.this.setShadeByPercId(SyntenyChoiceMenu.this.getShadeByPercIdItem().isSelected());
            } else if (e.getSource().equals(SyntenyChoiceMenu.this.getLockScrollingItem())) {
                SyntenyChoiceMenu.this.frame.setLockScrolling(SyntenyChoiceMenu.this.getLockScrollingItem().isSelected());
                SyntenyChoiceMenu.this.setLockScrolling(SyntenyChoiceMenu.this.getLockScrollingItem().isSelected());
            } else if (e.getSource().equals(SyntenyChoiceMenu.this.getShiftLockZoomMenuItem())) {
                SyntenyChoiceMenu.this.frame.setShiftZoomLock(SyntenyChoiceMenu.this.getShiftLockZoomMenuItem().isSelected());
                SyntenyChoiceMenu.this.setShiftZoomLock(SyntenyChoiceMenu.this.getShiftLockZoomMenuItem().isSelected());
            } else if (e.getSource() instanceof String) {
                // empty if block
            }
        }
    }

    private class SyntenyMenuListener
    implements MenuListener {
        private SyntenyMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            SyntenyChoiceMenu.this.menuInit();
        }
    }
}

