/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.gui.synteny.CurationManager;
import apollo.util.HTMLUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class LinksMenu
extends JMenu
implements ActionListener {
    private Hashtable namesToURLs = new Hashtable();
    private Hashtable menuItemsToNames = new Hashtable();
    private JCheckBoxMenuItem igbLink;
    private static LinksMenu singletonInstance;

    public static LinksMenu getLinksMenu() {
        if (singletonInstance == null) {
            singletonInstance = new LinksMenu();
        }
        return singletonInstance;
    }

    private LinksMenu() {
        super("Links");
        this.menuInit();
        this.addMenuListener(new IgbMenuListener());
    }

    private void menuInit() {
        this.makeLink("Primer3 (pick primers)", "http://www-genome.wi.mit.edu/cgi-bin/primer/primer3_www.cgi");
        this.makeLink("NCBI BLAST", "http://www.ncbi.nlm.nih.gov/blast/Blast.cgi?CMD=Web&LAYOUT=TwoWindows&AUTO_FORMAT=Semiauto&ALIGNMENTS=50&ALIGNMENT_VIEW=Pairwise&CLIENT=web&DATABASE=chromosome&DESCRIPTIONS=100&ENTREZ_QUERY=%28none%29&EXPECT=10&FILTER=L&FORMAT_OBJECT=Alignment&FORMAT_TYPE=Text&NCBI_GI=on&PAGE=Nucleotides&PROGRAM=blastn&SERVICE=plain&SET_DEFAULTS.x=34&SET_DEFAULTS.y=8&SHOW_OVERVIEW=on&END_OF_HTTPGET=Yes&SHOW_LINKOUT=yes&GET_SEQUENCE=yes");
        this.makeLink("Fly BLAST", "http://flybase.net/blast/");
        this.makeLink("Genscan (gene predictor)", "http://genes.mit.edu/GENSCAN.html");
        this.makeLink("FgenesH (gene predictor)", "http://www.softberry.com/berry.phtml?topic=fgenesh&group=programs&subgroup=gfind");
        this.makeLink("tRNAscan-SE (tRNA gene finder)", "http://www.genetics.wustl.edu/eddy/tRNAscan-SE/");
        this.makeLink("CMS Molecular Biology Resource", "http://restools.sdsc.edu/biotools/biotools1.html");
        this.makeLink("BCM Search Launcher", "http://searchlauncher.bcm.tmc.edu/");
        if (Config.DEBUG) {
            String u = "http://localhost:7085/UnibrowControl?seqid=chr4&start=136015&end=152756&version=D_melanogaster_Apr_2004 ";
            this.makeLink("IGB test", u);
        }
    }

    private void makeLink(String name, String url) {
        this.namesToURLs.put(name, url);
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(this);
        this.add(item);
        this.menuItemsToNames.put(item, name);
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem item = (JMenuItem)e.getSource();
        String name = (String)this.menuItemsToNames.get(item);
        if (name == null) {
            return;
        }
        String url = (String)this.namesToURLs.get(name);
        if (url == null) {
            return;
        }
        HTMLUtil.loadIntoBrowser(url);
    }

    public static boolean igbLinksEnabled() {
        return LinksMenu.getLinksMenu().getIgbLinkState();
    }

    private boolean getIgbLinkState() {
        if (!this.igbConfigged()) {
            return false;
        }
        if (this.igbLink == null) {
            return false;
        }
        return this.igbLink.getState();
    }

    private boolean igbConfigged() {
        return CurationManager.getActiveStyle().igbHttpConnectionEnabled();
    }

    private class IgbMenuListener
    implements MenuListener {
        private IgbMenuListener() {
        }

        public void menuSelected(MenuEvent e) {
            if (LinksMenu.this.igbLink != null) {
                LinksMenu.this.remove(LinksMenu.this.igbLink);
            }
            if (!LinksMenu.this.igbConfigged()) {
                return;
            }
            if (LinksMenu.this.igbLink == null) {
                LinksMenu.this.igbLink = new JCheckBoxMenuItem("Enable Igb Selection");
            }
            LinksMenu.this.add(LinksMenu.this.igbLink);
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

