/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.config.Config;
import apollo.gui.ApolloFrame;
import apollo.main.Version;
import apollo.util.HTMLUtil;
import apollo.util.IOUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class HelpMenu
extends JMenu
implements ActionListener {
    JMenuItem about;
    JMenuItem help;
    JMenuItem bug;
    JMenuItem update;
    ApolloFrame frame;
    JDialog aboutBox;
    static String HELP_URL = "http://www.fruitfly.org/annot/apollo/";
    static String BUG_URL = "http://sourceforge.net/tracker/?func=add&group_id=27707&atid=462763";
    static String UPDATE_URL = "http://www.fruitfly.org/annot/apollo/install.html";

    public HelpMenu(ApolloFrame frame) {
        super("Help");
        this.frame = frame;
        this.menuInit();
    }

    public void menuInit() {
        this.about = new JMenuItem("About...");
        this.help = new JMenuItem("Apollo userguide...");
        this.bug = new JMenuItem("Report bug...");
        this.update = new JMenuItem("Check for software updates...");
        this.add(this.help);
        this.addSeparator();
        this.add(this.about);
        this.add(this.bug);
        this.add(this.update);
        this.about.addActionListener(this);
        this.help.addActionListener(this);
        this.help.setMnemonic('H');
        this.bug.addActionListener(this);
        this.help.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.update.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.about) {
            this.showAboutBox();
        } else if (e.getSource() == this.help) {
            HelpMenu.showHelpInBrowser();
        } else if (e.getSource() == this.bug) {
            System.err.println("Loading bug tracker " + BUG_URL + " into web browser");
            HTMLUtil.loadIntoBrowser(BUG_URL);
        } else if (e.getSource() == this.update) {
            System.err.println("Loading sofware update page " + UPDATE_URL + " into web browser");
            HTMLUtil.loadIntoBrowser(UPDATE_URL);
        }
    }

    public static void showHelpInBrowser() {
        String rootdir = System.getProperty("APOLLO_ROOT");
        String help = rootdir + "/doc/html/userguide.html";
        HelpMenu.showHelpInBrowser(help);
    }

    public static void showHelpInBrowser(String help) {
        String url;
        File handle;
        String file = help;
        if (help.indexOf("#") > 0) {
            file = file.substring(0, file.indexOf("#"));
        }
        if ((handle = new File(file)).exists()) {
            url = "file://" + help;
        } else {
            System.out.println("Can't find local help file " + file + "--trying " + HELP_URL);
            url = HELP_URL;
        }
        System.err.println("Loading help document " + help + " into web browser " + Config.getBrowserProgram());
        if (IOUtil.isUnix()) {
            System.err.println("\nIf you're on Solaris and don't already have a web browser running,\nyou may need to start one up yourself.\nSee the userguide for more info.\n");
        }
        HTMLUtil.loadIntoBrowser(url);
    }

    public void showAboutBox() {
        if (this.aboutBox == null) {
            String[] orgs = new String[3];
            String[] authors = new String[4];
            String[] debuggers = new String[6];
            JPanel groupPanel = new JPanel(new BorderLayout());
            JPanel buttonPanel = new JPanel(true);
            JTextPane messBox = new JTextPane();
            JScrollPane messPane = new JScrollPane(messBox);
            String message = "Apollo is a collaborative open source project between ";
            orgs[0] = new String("Berkeley Drosophila Genome Project");
            orgs[1] = new String("Sanger Institute");
            orgs[2] = new String("EBI");
            authors[0] = new String("Steve Searle");
            authors[1] = new String("John Richter");
            authors[2] = new String("Suzanna Lewis");
            authors[3] = new String("Michele Clamp");
            debuggers[0] = new String("Suzanna Lewis");
            debuggers[1] = new String("Nomi Harris");
            debuggers[2] = new String("Mark Gibson");
            debuggers[3] = new String("Vivek Iyer");
            debuggers[4] = new String("Guanming Wu");
            debuggers[5] = new String("Sima Misra");
            messBox.setEditable(false);
            messBox.setBackground(Color.white);
            messPane.setPreferredSize(new Dimension(620, 300));
            messPane.setMinimumSize(new Dimension(620, 300));
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setAlignment(attrs, 1);
            StyleConstants.setForeground(attrs, Color.blue);
            StyledDocument doc = messBox.getStyledDocument();
            try {
                int i;
                doc.setParagraphAttributes(0, 1000, attrs, false);
                StyleConstants.setForeground(attrs, new Color(0, 200, 20));
                StyleConstants.setBold(attrs, true);
                doc.insertString(0, Version.getVersion() + "\n\n", attrs);
                if (Config.internalMode()) {
                    StyleConstants.setForeground(attrs, new Color(153, 0, 153));
                    doc.insertString(0, "Project Internal Version\n\n", attrs);
                }
                StyleConstants.setBold(attrs, false);
                StyleConstants.setForeground(attrs, Color.blue);
                doc.insertString(doc.getLength(), message, attrs);
                for (i = 0; i < orgs.length; ++i) {
                    doc.insertString(doc.getLength(), "the ", attrs);
                    StyleConstants.setForeground(attrs, Color.red);
                    StyleConstants.setBold(attrs, true);
                    doc.insertString(doc.getLength(), orgs[i], attrs);
                    StyleConstants.setBold(attrs, false);
                    StyleConstants.setForeground(attrs, Color.blue);
                    if (i == orgs.length - 2 || i == orgs.length - 1 && orgs.length == 2) {
                        doc.insertString(doc.getLength(), " and ", attrs);
                        continue;
                    }
                    if (i < orgs.length - 1) {
                        doc.insertString(doc.getLength(), ", ", attrs);
                        continue;
                    }
                    doc.insertString(doc.getLength(), ".", attrs);
                }
                doc.insertString(doc.getLength(), "\n\nThe first version of Apollo was written by ", attrs);
                for (i = 0; i < authors.length; ++i) {
                    StyleConstants.setForeground(attrs, Color.red);
                    StyleConstants.setBold(attrs, true);
                    doc.insertString(doc.getLength(), authors[i], attrs);
                    StyleConstants.setBold(attrs, false);
                    StyleConstants.setForeground(attrs, Color.blue);
                    if (i == authors.length - 2) {
                        doc.insertString(doc.getLength(), " and ", attrs);
                        continue;
                    }
                    if (i < authors.length - 1 && authors.length >= 2) {
                        doc.insertString(doc.getLength(), ", ", attrs);
                        continue;
                    }
                    doc.insertString(doc.getLength(), ".", attrs);
                }
                doc.insertString(doc.getLength(), "\n\nThis version was revised and debugged by ", attrs);
                for (i = 0; i < debuggers.length; ++i) {
                    StyleConstants.setForeground(attrs, Color.red);
                    StyleConstants.setBold(attrs, true);
                    doc.insertString(doc.getLength(), debuggers[i], attrs);
                    StyleConstants.setBold(attrs, false);
                    StyleConstants.setForeground(attrs, Color.blue);
                    if (i == debuggers.length - 2) {
                        doc.insertString(doc.getLength(), " and ", attrs);
                        continue;
                    }
                    if (i < debuggers.length - 1) {
                        doc.insertString(doc.getLength(), ", ", attrs);
                        continue;
                    }
                    doc.insertString(doc.getLength(), ".", attrs);
                }
                doc.insertString(doc.getLength(), "\n\nAcknowledgements:\nErnest J. Friedman-Hill and Sandia National Laboratories for PSGr\nDavid Goodstein for adding regular expression parsing to Find\nJonathan Crabtree for work on the Chado JDBC adapter\nand others who have sent patches and suggestions.", attrs);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            messBox.setCaretPosition(0);
            JButton button = new JButton("OK");
            this.aboutBox = new JDialog(this.frame, "About Apollo", false);
            this.aboutBox.getContentPane().add((Component)groupPanel, "Center");
            groupPanel.add((Component)messPane, "Center");
            groupPanel.add((Component)buttonPanel, "South");
            buttonPanel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HelpMenu.this.aboutBox.setVisible(false);
                }
            });
        }
        this.aboutBox.pack();
        this.aboutBox.show();
    }
}

