/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.gui.ApolloFrame;
import apollo.gui.FindPanel;
import apollo.gui.PreferencesDialog;
import apollo.gui.synteny.CurationManager;
import apollo.util.IOUtil;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class EditMenu
extends JMenu
implements ActionListener {
    ApolloFrame frame;
    JMenuItem undo;
    JMenuItem redo;
    JMenuItem find;
    JMenuItem prefs;
    JDialog findDialog;
    PreferencesDialog prefsDialog;

    public EditMenu(ApolloFrame frame) {
        super("Edit");
        this.frame = frame;
        this.menuInit();
    }

    public void menuInit() {
        this.undo = new JMenuItem("Undo");
        this.redo = new JMenuItem("Redo");
        this.find = new JMenuItem("Find...");
        this.prefs = new JMenuItem("Preferences (style)...");
        this.undo.setEnabled(false);
        this.redo.setEnabled(false);
        this.add(this.find);
        this.addSeparator();
        this.add(this.prefs);
        this.addSeparator();
        JMenuItem lafTitle = new JMenuItem("Look & Feel:");
        lafTitle.setForeground(Color.blue);
        this.add(lafTitle);
        this.addLAFMenu();
        this.find.addActionListener(this);
        this.prefs.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.undo) {
            System.err.println("Undo selected; not implemented");
        } else if (e.getSource() == this.redo) {
            System.err.println("Redo selected; not implemented");
        } else if (e.getSource() == this.find) {
            if (this.findDialog != null) {
                this.findDialog.dispose();
                this.findDialog = null;
            }
            this.findDialog = new JDialog((Frame)ApolloFrame.getFrame(), "Find");
            this.findDialog.setLocationRelativeTo(ApolloFrame.getFrame());
            CurationManager cm = CurationManager.getCurationManager();
            FindPanel fp = new FindPanel(cm.getActiveCurState());
            this.findDialog.addWindowListener(new FindWindowListener());
            this.findDialog.getContentPane().add(fp);
            this.findDialog.pack();
            this.findDialog.show();
        } else if (e.getSource() == this.prefs) {
            if (this.prefsDialog != null) {
                this.prefsDialog.dispose();
                this.prefsDialog = null;
            }
            this.prefsDialog = new PreferencesDialog();
            this.prefsDialog.addWindowListener(new PrefsWindowListener());
            this.prefsDialog.show();
        }
    }

    private void addLAFMenu() {
        ButtonGroup group = new ButtonGroup();
        UIManager.LookAndFeelInfo[] LFs = UIManager.getInstalledLookAndFeels();
        JRadioButtonMenuItem[] lfsMenuItem = new JRadioButtonMenuItem[LFs.length];
        for (int i = 0; i < LFs.length; ++i) {
            if (LFs[i].getName().equals("Windows") && !IOUtil.isWindows()) continue;
            lfsMenuItem[i] = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem(LFs[i].getName()));
            group.add(lfsMenuItem[i]);
            lfsMenuItem[i].setSelected(UIManager.getLookAndFeel().getName().equals(LFs[i].getName()));
            lfsMenuItem[i].addItemListener(new LAFListener());
        }
    }

    private class PrefsWindowListener
    extends WindowAdapter {
        private PrefsWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            EditMenu.this.prefsDialog.dispose();
            EditMenu.this.prefsDialog = null;
        }
    }

    private class FindWindowListener
    extends WindowAdapter {
        private FindWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            EditMenu.this.findDialog.dispose();
            EditMenu.this.findDialog = null;
        }
    }

    private class LAFListener
    implements ItemListener {
        private LAFListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
            try {
                if (rb.isSelected()) {
                    UIManager.LookAndFeelInfo[] tmpLFs = UIManager.getInstalledLookAndFeels();
                    for (int j = 0; j < tmpLFs.length; ++j) {
                        if (!rb.getText().equals(tmpLFs[j].getName())) continue;
                        UIManager.setLookAndFeel(tmpLFs[j].getClassName());
                        SwingUtilities.updateComponentTreeUI(EditMenu.this.frame);
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("could not change UIFactory: " + ex.getMessage());
            }
        }
    }
}

