/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.menus;

import apollo.analysis.AnalysisDataAdapterI;
import apollo.config.Config;
import apollo.gui.drawable.DrawableAnnotationConstants;
import apollo.gui.synteny.CurationManager;
import apollo.gui.tweeker.Tweeker;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.bdgp.swing.widget.DataAdapterChooser;

public class AnalysisMenu
extends JMenu
implements ActionListener,
DrawableAnnotationConstants {
    JMenuItem gcplot;
    JMenuItem restriction;
    JMenuItem analyze;
    private Tweeker tweekerFrame;

    public AnalysisMenu() {
        super("Analysis");
        this.menuInit();
    }

    public void menuInit() {
        this.gcplot = new JMenuItem("Show GC plot...");
        this.restriction = new JMenuItem("Find restriction sites...");
        this.analyze = new JMenuItem("Analyze sequence...");
        this.add(this.gcplot);
        this.add(this.restriction);
        this.analyze.addActionListener(this);
        AnalysisActionListener al = new AnalysisActionListener();
        this.gcplot.addActionListener(al);
        this.restriction.addActionListener(al);
        this.addMenuListener(new SequenceCheckMenuListener());
    }

    private boolean haveSequence() {
        return CurationManager.getCurationManager().getActiveCurState().haveSequence();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.analyze) {
            DataAdapterChooser chooser = new DataAdapterChooser(Config.getAdapterRegistry(), AnalysisDataAdapterI.OP_ANALYZE_DATA, "Analyze data", null, false);
            chooser.show();
        }
    }

    class ItemWindowListener
    extends WindowAdapter {
        JCheckBoxMenuItem item;

        public ItemWindowListener(JCheckBoxMenuItem item) {
            this.item = item;
        }

        public void windowClosing(WindowEvent e) {
            this.item.setState(false);
            ((Window)e.getSource()).removeWindowListener(this);
        }
    }

    private class SequenceCheckMenuListener
    implements MenuListener {
        private SequenceCheckMenuListener() {
        }

        public void menuSelected(MenuEvent e) {
            AnalysisMenu.this.gcplot.setEnabled(AnalysisMenu.this.haveSequence());
            AnalysisMenu.this.restriction.setEnabled(AnalysisMenu.this.haveSequence());
            AnalysisMenu.this.analyze.setEnabled(false);
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    private class AnalysisActionListener
    implements ActionListener {
        private AnalysisActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int type = -1;
            if (e.getSource() == AnalysisMenu.this.gcplot) {
                type = 0;
            } else if (e.getSource() == AnalysisMenu.this.restriction) {
                type = 1;
            }
            Tweeker.openTweeker(type);
        }
    }
}

