/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.Selection;
import apollo.gui.SelectionItem;
import apollo.gui.Transformer;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.ScrollAdjustedView;
import apollo.util.FeatureList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import org.bdgp.util.DNAUtils;

public class TranslationView
extends ScrollAdjustedView {
    private CurationSet cset;
    private boolean showSequence = true;
    private static int[] rowLocations = new int[]{-3, 3, 10};

    public TranslationView(JComponent ap, String name) {
        super(ap, name, false, 31);
        this.transformer.setYRange(new int[]{-10, 10});
        this.transformer.setXRange(new int[]{-10, 10});
    }

    public void setCurationSet(CurationSet cset) {
        this.cset = cset;
    }

    public void setShowSequence(boolean flag) {
        this.showSequence = flag;
    }

    public void paintView() {
        this.graphics.setColor(this.getBackgroundColour());
        this.graphics.fillRect(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        this.graphics.setColor(this.getForegroundColour());
        if (this.showSequence && this.cset.getRefSequence() != null) {
            this.drawSequence(this.graphics, this.transformer);
        }
    }

    public void drawSequence(Graphics graphics, Transformer transformer) {
        int[] visRange = this.getVisibleRange();
        int startCoord = visRange[0];
        int endCoord = visRange[1];
        String[] aa = new String[3];
        if (startCoord < this.cset.getLow()) {
            startCoord = this.cset.getLow();
        }
        if (endCoord > this.cset.getHigh()) {
            endCoord = this.cset.getHigh();
        }
        PropertyScheme ps = Config.getPropertyScheme();
        if (endCoord > this.cset.getLow() - 1) {
            graphics.setColor(Config.getCoordForeground());
            if (transformer.getXPixelsPerCoord() >= 1.0) {
                int relLow = !this.reverseComplement ? startCoord : endCoord;
                int relHigh = !this.reverseComplement ? endCoord : startCoord;
                String visSeq = this.cset.getRefSequence().getResidues(relLow, relHigh).toUpperCase();
                aa[0] = DNAUtils.translate((String)visSeq, (int)2, (int)100);
                aa[1] = DNAUtils.translate((String)visSeq, (int)3, (int)100);
                aa[2] = DNAUtils.translate((String)visSeq, (int)4, (int)100);
                if (this.reverseComplement) {
                    for (int i = 0; i < 3; ++i) {
                        aa[i] = this.tidyEnd(aa[i]);
                        aa[i] = new StringBuffer(aa[i]).reverse().toString();
                    }
                }
                if ((startCoord - 1) % 3 == 1 && !this.reverseComplement) {
                    String tmp = aa[0];
                    aa[0] = aa[2];
                    aa[2] = aa[1];
                    aa[1] = tmp;
                } else if ((startCoord - 1) % 3 == 2 && !this.reverseComplement) {
                    String tmp = aa[0];
                    aa[0] = aa[1];
                    aa[1] = aa[2];
                    aa[2] = tmp;
                } else if (endCoord % 3 == 0 && this.reverseComplement) {
                    String tmp = aa[0];
                    aa[0] = aa[2];
                    aa[2] = tmp;
                } else if (endCoord % 3 == 2 && this.reverseComplement) {
                    String tmp = aa[0];
                    aa[0] = aa[1];
                    aa[1] = tmp;
                } else if (endCoord % 3 == 1 && this.reverseComplement) {
                    String tmp = aa[1];
                    aa[1] = aa[2];
                    aa[2] = tmp;
                }
                System.out.println("aa[0] = " + aa[0]);
                System.out.println("aa[1] = " + aa[1]);
                System.out.println("aa[2] = " + aa[2]);
                if (transformer.getXPixelsPerCoord() >= 5.0) {
                    int[] dnaPos = new int[3];
                    dnaPos[2] = 0;
                    dnaPos[1] = 0;
                    dnaPos[0] = 0;
                    for (int i = 0; i < endCoord - startCoord + 1; ++i) {
                        int xpos;
                        int width;
                        Point top_corner;
                        Integer grpFlag;
                        graphics.setColor(Config.getCoordForeground());
                        int arrInd = (i + startCoord - 1) % 3;
                        Point aastart = transformer.toPixel(new Point(i + startCoord, rowLocations[arrInd]));
                        SeqFeatureI sf = this.getFeatureAtBase(i + startCoord);
                        if (sf != null && sf.getPhase() != -1 && (grpFlag = ps.getFeatureProperty(sf.getFeatureType()).getGroupFlag()) == FeatureProperty.GRP_GENE) {
                            int width2;
                            graphics.setColor(Color.blue);
                            System.out.println("Got phase " + sf.getPhase());
                            int phase = (3 - sf.getPhase()) % 3;
                            int phaseInd = !this.reverseComplement ? (sf.getStart() + (3 - phase) % 3 - 1) % 3 : (sf.getStart() - (3 - phase) % 3 - 1) % 3;
                            top_corner = transformer.toPixel(new Point(i + startCoord + 1, rowLocations[phaseInd] - 5));
                            if (!this.reverseComplement) {
                                width2 = top_corner.x - aastart.x;
                                graphics.fillRect(aastart.x, top_corner.y, width2, 8);
                            } else {
                                width2 = aastart.x - top_corner.x;
                                graphics.fillRect(top_corner.x - 1, top_corner.y, width2, 8);
                            }
                            graphics.setColor(Config.getCoordForeground());
                        }
                        if (dnaPos[arrInd] >= aa[arrInd].length()) continue;
                        int n = arrInd;
                        dnaPos[n] = dnaPos[n] + 1;
                        String seq = aa[arrInd].substring(dnaPos[arrInd], dnaPos[n]);
                        if (seq.equals("*")) {
                            graphics.setColor(Color.red);
                        }
                        top_corner = transformer.toPixel(new Point(i + startCoord + transformer.getXOrientation(), rowLocations[arrInd]));
                        if (!this.reverseComplement) {
                            width = top_corner.x - aastart.x;
                            xpos = aastart.x;
                        } else {
                            width = aastart.x - top_corner.x;
                            xpos = top_corner.x;
                        }
                        graphics.drawString(seq, xpos + width / 2, aastart.y);
                    }
                }
            }
        }
    }

    private String tidyEnd(String orig) {
        if (orig.endsWith("  ")) {
            return orig.substring(0, orig.length() - 1);
        }
        return orig;
    }

    private SeqFeatureI getFeatureAtBase(int base_position) {
        Selection selection = ((ApolloPanelI)((Object)this.getComponent())).getSelection();
        SeqFeatureI selected = null;
        for (int i = 0; i < selection.size() && selected == null; ++i) {
            SeqFeatureI sf = selection.getSelectedData(i);
            selected = this.featureContains(sf, base_position);
        }
        return selected;
    }

    public Selection findSelected(FeatureSelectionEvent evt) {
        FeatureList features = evt.getFeatures();
        Selection selection = new Selection();
        for (int i = 0; i < features.size(); ++i) {
            SeqFeatureI sf = features.getFeature(i);
            if (!sf.getFeatureType().equals("String")) continue;
            selection.add(new SelectionItem(this, sf));
        }
        return selection;
    }
}

