/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.EvidenceFinder;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.gui.ApolloFrame;
import apollo.gui.BaseScrollable;
import apollo.gui.ControlledObjectI;
import apollo.gui.ControlledPanel;
import apollo.gui.Controller;
import apollo.gui.GCScoreCalculator;
import apollo.gui.SelectionManager;
import apollo.gui.StatusBar;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.DrawableAnnotationConstants;
import apollo.gui.drawable.DrawableFeatureSet;
import apollo.gui.drawable.DrawableSetI;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.event.BaseFocusListener;
import apollo.gui.event.ChainedRepaintEvent;
import apollo.gui.event.NamedFeatureSelectionEvent;
import apollo.gui.event.NamedFeatureSelectionListener;
import apollo.gui.event.OrientationEvent;
import apollo.gui.event.OrientationListener;
import apollo.gui.event.ReverseComplementEvent;
import apollo.gui.event.ReverseComplementListener;
import apollo.gui.event.RubberbandEvent;
import apollo.gui.event.RubberbandListener;
import apollo.gui.event.ScrollEvent;
import apollo.gui.event.ScrollListener;
import apollo.gui.event.SetActiveCurStateEvent;
import apollo.gui.event.SetActiveCurStateListener;
import apollo.gui.event.ZoomEvent;
import apollo.gui.event.ZoomListener;
import apollo.gui.genomemap.AnnotationView;
import apollo.gui.genomemap.ApolloPanel;
import apollo.gui.genomemap.ApolloPanelHolderI;
import apollo.gui.genomemap.ColumnApolloLayout;
import apollo.gui.genomemap.GraphView;
import apollo.gui.genomemap.GuideLine;
import apollo.gui.genomemap.LaidoutViewContainer;
import apollo.gui.genomemap.ResultView;
import apollo.gui.genomemap.RevCompListener;
import apollo.gui.genomemap.ScaleView;
import apollo.gui.genomemap.SiteView;
import apollo.gui.genomemap.SplitterView;
import apollo.gui.genomemap.ViewI;
import apollo.gui.synteny.GuiCurationState;
import apollo.gui.synteny.SyntenyLinkPanel;
import apollo.util.FeatureList;
import apollo.util.Format;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class StrandedZoomableApolloPanel
extends ControlledPanel
implements ActionListener,
AdjustmentListener,
ApolloPanelHolderI,
BaseFocusListener,
ControlledObjectI,
DrawableAnnotationConstants,
NamedFeatureSelectionListener,
SetActiveCurStateListener,
OrientationListener,
DataLoadListener,
RubberbandListener,
ScrollListener,
ReverseComplementListener,
ZoomListener {
    JPanel panel2 = new JPanel();
    ApolloPanel apolloPanel;
    JScrollBar hScroll = new JScrollBar();
    JButton zoomin = new ShiftAwareButton("x2");
    JButton zoomout = new ShiftAwareButton("x.5");
    JButton zoomin2 = new ShiftAwareButton("x10");
    JButton zoomout2 = new ShiftAwareButton("x.1");
    JButton reset = new ShiftAwareButton("Reset");
    StatusBar statusBar = null;
    boolean HSCROLLABLE = true;
    boolean ZOOMABLE = true;
    String ZOOMPOSITION = "South";
    String name = "";
    private boolean forwardVisible = true;
    boolean reverseVisible = true;
    private boolean forwardSitesVisibleAtZoomLevel = false;
    private boolean reverseSitesVisibleAtZoomLevel = false;
    private boolean sitesVisibleOnZoom = true;
    boolean reverseComplement = false;
    ResultView forwardResultView;
    ResultView reverseResultView;
    public AnnotationView forwardAnnotView;
    public AnnotationView reverseAnnotView;
    SplitterView forwardSplitterView;
    SplitterView reverseSplitterView;
    LaidoutViewContainer forwardContainerView;
    LaidoutViewContainer reverseContainerView;
    SplitterView strandSplitter;
    ScaleView scaleView;
    SiteView forwardSiteView;
    SiteView reverseSiteView;
    Controller controller;
    private SelectionManager selectionManager;
    double xscale = 1.0;
    boolean settingScroller = false;
    JLabel zoomLabel = new JLabel("  Zoom factor = " + this.xscale + "   ");
    Vector highlightRegions = new Vector();
    GuideLine guide;
    GraphView graphView;
    CurationSet curationSet;
    private boolean haveSequence = true;
    private RevCompListener revCompListener;
    private JLabel organismLabel;
    boolean useScrollHack = false;
    public static String ZOOMIN = "ZOOMIN";
    public static String ZOOMIN2 = "ZOOMIN2";
    public static String ZOOMOUT = "ZOOMOUT";
    public static String ZOOMOUT2 = "ZOOMOUT2";
    public static String RESET = "RESET";
    public static String CUSTOM = "CUSTOM";
    private boolean annotationViewsVisible;
    private boolean resultViewsVisible;
    private boolean scaleViewVisible = true;
    private boolean scrollingPropagated = false;
    private boolean shiftForLockedZooming = true;
    private Style previousStyle = null;
    private boolean styleChanged = true;
    private GuiCurationState curationState;
    private Color activeColor = new Color(0, 153, 0);
    static /* synthetic */ Class class$apollo$gui$genomemap$ScaleView;

    public StrandedZoomableApolloPanel(GuiCurationState curationState, String zoomPosition) {
        this.ZOOMPOSITION = zoomPosition;
        this.curationState = curationState;
        this.apolloPanel = new ApolloPanel("apolloPanel", curationState);
        this.setController(curationState.getController());
        this.setSelectionManager(curationState.getSelectionManager());
        this.jbInit();
        HighlightDragListener hdl = new HighlightDragListener(this);
        this.apolloPanel.addMouseListener(hdl);
        this.apolloPanel.addMouseMotionListener(hdl);
    }

    public void setGraphVisibility(boolean state) {
        this.graphView.setVisible(state);
        this.apolloPanel.setInvalidity(true);
        this.apolloPanel.doLayout();
        this.apolloPanel.setInvalidity(false);
    }

    public void setGuideLine(boolean state) {
        if (state) {
            this.guide = new GuideLine(this.scaleView);
            this.addHighlightRegion(this.guide, Config.getFeatureBackground() == Color.black ? Color.white : Color.black, false);
        } else if (this.guide != null) {
            this.removeHighlightRegion(this.guide);
        }
        this.repaint();
    }

    public CurationSet getCurationSet() {
        return this.curationSet;
    }

    public void setCurationSet(CurationSet set) {
        this.curationSet = set;
        this.doStyleChangeCheck();
        boolean previousHaveSequence = this.haveSequence;
        SequenceI seq = set.getRefSequence();
        boolean bl = this.haveSequence = seq != null && (seq.isLazy() || seq.getResidues() != null);
        if (this.haveSequence != previousHaveSequence) {
            this.removeAllViews();
            this.addAllViews();
        }
        this.apolloPanel.setSyncLimits(false);
        this.setViewColours();
        this.setFeatureSet(set);
        this.setAnnotations(set);
        if (set.getStart() > 0 && set.getEnd() > 0) {
            this.apolloPanel.setSyncLimits(true, set.getStart(), set.getEnd());
        } else if (set.length() > 0) {
            this.apolloPanel.setSyncLimits(true, 1, set.length());
        } else {
            this.apolloPanel.setSyncLimits(true);
        }
        this.setScrollValues();
        if (this.haveSequence) {
            this.forwardSitesVisibleAtZoomLevel = this.canShowSites(this.forwardVisible);
            this.forwardSiteView.setVisible(this.forwardSitesVisibleAtZoomLevel);
            this.reverseSitesVisibleAtZoomLevel = this.canShowSites(this.reverseVisible);
            this.reverseSiteView.setVisible(this.reverseSitesVisibleAtZoomLevel);
        }
        this.setZoomFactor(1.0, true);
        this.setVisible(true);
        this.putVerticalScrollbarsAtStart();
        this.reverseAnnotView.setEditingEnabled(Config.isEditingEnabled());
        this.forwardAnnotView.setEditingEnabled(Config.isEditingEnabled());
        if (set != null && set.getOrganism() != null) {
            String organism = set.getOrganism();
            String chromosome = set.getChromosome();
            String start = set.getStartAsString();
            String end = set.getEndAsString();
            String label = "";
            if (organism != null) {
                label = label + organism;
            }
            if (chromosome != null) {
                label = label + ":" + chromosome;
            }
            if (start != null) {
                label = label + ":" + start;
            }
            if (end != null) {
                label = label + "-" + end;
            }
            this.getOrganismLabel().setText(label);
        }
    }

    public boolean handleSetActiveCurStateEvent(SetActiveCurStateEvent evt) {
        if (evt.getNewActiveCurState() != null && evt.getNewActiveCurState().getSZAP() == this) {
            this.getOrganismLabel().setForeground(this.activeColor);
        } else if (evt.getOldActiveCurState() != null && evt.getOldActiveCurState().getSZAP() == this) {
            this.getOrganismLabel().setForeground(Color.black);
        }
        return true;
    }

    private void printViewLimits(String where) {
        System.out.println(where);
        System.out.println("View   Min     Max     VisMin   VisMax");
        System.out.print("forwardResultView   " + this.forwardResultView.getMinimum() + "  " + this.forwardResultView.getMaximum());
        System.out.println("  " + this.forwardResultView.getVisibleRange()[0] + "  " + this.forwardResultView.getVisibleRange()[1]);
        System.out.print("forwardAnnotView   " + this.forwardAnnotView.getMinimum() + "  " + this.forwardAnnotView.getMaximum());
        System.out.println("  " + this.forwardAnnotView.getVisibleRange()[0] + "  " + this.forwardAnnotView.getVisibleRange()[1]);
        System.out.print("forwardSiteView   " + this.forwardSiteView.getMinimum() + "  " + this.forwardSiteView.getMaximum());
        System.out.println("  " + this.forwardSiteView.getVisibleRange()[0] + "  " + this.forwardSiteView.getVisibleRange()[1]);
        System.out.print("reverseResultView   " + this.reverseResultView.getMinimum() + "  " + this.reverseResultView.getMaximum());
        System.out.println("  " + this.reverseResultView.getVisibleRange()[0] + "  " + this.reverseResultView.getVisibleRange()[1]);
        System.out.print("reverseAnnotView   " + this.reverseAnnotView.getMinimum() + "  " + this.reverseAnnotView.getMaximum());
        System.out.println("  " + this.reverseAnnotView.getVisibleRange()[0] + "  " + this.reverseAnnotView.getVisibleRange()[1]);
        System.out.print("reverseSiteView   " + this.reverseSiteView.getMinimum() + "  " + this.reverseSiteView.getMaximum());
        System.out.println("  " + this.reverseSiteView.getVisibleRange()[0] + "  " + this.reverseSiteView.getVisibleRange()[1]);
    }

    public FeatureSetI getForwardResults() {
        return this.curationSet.getResults().getForwardSet();
    }

    public FeatureSetI getReverseResults() {
        return this.curationSet.getResults().getReverseSet();
    }

    public void setFeatureSet(CurationSet cset) {
        StrandedFeatureSetI fset = cset.getResults();
        if (fset == null) {
            System.out.println("SZAP.setFeatureSet: do not have any results for " + cset.getName());
            return;
        }
        FeatureSetI forward_results = fset.getForwardSet();
        FeatureSetI reverse_results = fset.getReverseSet();
        System.out.println("Making feature set for " + forward_results.size() + " forward strand analyses");
        this.forwardResultView.setDrawableSet(this.makeDrawableSet(forward_results));
        System.out.println("Making feature set for " + reverse_results.size() + " reverse strand analyses");
        this.reverseResultView.setDrawableSet(this.makeDrawableSet(reverse_results));
        this.scaleView.setCurationSet(cset);
        if (this.haveSequence) {
            System.out.println("Finding start/stop codons...");
            this.forwardSiteView.setStrand(1);
            this.forwardSiteView.setCurationSet(cset);
            this.reverseSiteView.setStrand(-1);
            this.reverseSiteView.setCurationSet(cset);
        }
        this.graphView.setScoreCalculator(new GCScoreCalculator(cset, 100));
    }

    public void setVisible(boolean state) {
        super.setVisible(state);
        if (this.apolloPanel != null) {
            TierManagerI rtm;
            this.apolloPanel.setVisible(state);
            Graphics g = this.apolloPanel.getGraphics();
            if (g == null) {
                return;
            }
            TierManagerI ftm = this.forwardResultView.getTierManager();
            if (ftm != null) {
                g.setFont(Config.getDefaultFont());
                ftm.setCharHeight(g.getFontMetrics().getAscent() + g.getFontMetrics().getDescent());
            }
            if ((rtm = this.reverseResultView.getTierManager()) != null) {
                rtm.setCharHeight(g.getFontMetrics().getAscent() + g.getFontMetrics().getDescent());
            }
            g = this.apolloPanel.getBackBuffer().getGraphics();
            g.setFont(Config.getDefaultFont());
        }
        this.setTextAvoidance(true);
        if (this.styleHasChanged()) {
            this.setViewVisibilityToStyleSpecifications();
        }
        if (state) {
            this.updateSiteVisibility(true);
        }
        this.apolloPanel.setInvalidity(true);
        this.apolloPanel.doLayout();
        this.apolloPanel.setInvalidity(false);
        this.repaint();
        System.gc();
    }

    private void doStyleChangeCheck() {
        Style newStyle = Config.getStyle();
        this.styleChanged = newStyle != this.previousStyle;
        this.previousStyle = newStyle;
    }

    private boolean styleHasChanged() {
        return this.styleChanged;
    }

    public void putVerticalScrollbarsAtStart() {
        this.forwardAnnotView.putScrollAtStart();
        this.reverseAnnotView.putScrollAtStart();
        this.forwardResultView.putScrollAtStart();
        this.reverseResultView.putScrollAtStart();
    }

    public ApolloPanel getApolloPanel() {
        return this.apolloPanel;
    }

    private DrawableSetI makeDrawableSet(FeatureSetI fset) {
        DrawableFeatureSet dfset = new DrawableFeatureSet(fset, false);
        dfset.setVisible(true);
        return dfset;
    }

    private DrawableSetI makeDrawableAnnotatedSet(FeatureSetI fset) {
        DrawableFeatureSet dfset = new DrawableFeatureSet(fset, false);
        dfset.setVisible(true);
        return dfset;
    }

    public FeatureSetI getForwardAnnotations() {
        return this.curationSet.getAnnots().getForwardSet();
    }

    public FeatureSetI getReverseAnnotations() {
        return this.curationSet.getAnnots().getReverseSet();
    }

    public void setAnnotations(CurationSet curation) {
        StrandedFeatureSetI annots = curation.getAnnots();
        if (annots == null) {
            System.out.println("setAnnotations: no annotations.\n");
            return;
        }
        FeatureSetI forward_annots = annots.getForwardSet();
        FeatureSetI reverse_annots = annots.getReverseSet();
        DrawableSetI drawForward = this.makeDrawableAnnotatedSet(forward_annots);
        DrawableSetI drawReverse = this.makeDrawableAnnotatedSet(reverse_annots);
        this.forwardAnnotView.setStrand(1);
        this.forwardAnnotView.setDrawableSet(drawForward);
        this.reverseAnnotView.setStrand(-1);
        this.reverseAnnotView.setDrawableSet(drawReverse);
        this.forwardAnnotView.setCurationSet(curation);
        this.reverseAnnotView.setCurationSet(curation);
        this.setEvidenceFinder(drawForward.getFeatureSet(), this.forwardAnnotView.getEvidenceFinder());
        this.setEvidenceFinder(drawReverse.getFeatureSet(), this.reverseAnnotView.getEvidenceFinder());
    }

    private void setEvidenceFinder(FeatureSetI fs, EvidenceFinder finder) {
        if (finder != null) {
            int feat_count = fs.size();
            for (int i = 0; i < feat_count; ++i) {
                AnnotatedFeatureI annot = (AnnotatedFeatureI)fs.getFeatureAt(i);
                annot.setEvidenceFinder(finder);
            }
        } else {
            System.out.println("setEvidenceFinder: no evidence for FeatureSet " + fs.getName());
        }
    }

    public FeatureSetI getAnnotations() {
        return this.curationSet.getAnnots();
    }

    public FeatureSetI getResults() {
        return this.curationSet.getResults();
    }

    public void zoomToSelection() {
        this.zoomToSelectionWithWindow(0);
    }

    public void zoomToSelectionWithWindow(int window) {
        this.zoomToSelectionWithWindow(window, -1);
    }

    public void zoomToSelectionWithWindow(int window, int centerBase) {
        if (this.apolloPanel.getSelection().size() == 0) {
            return;
        }
        this.setSelectedViewVisible();
        int[] limits = this.apolloPanel.getSelectionLimits();
        double newWidth = (double)Math.max(limits[1] - limits[0], 5) + (double)window;
        double fudgeForScrollbar = 0.95;
        double curWidth = this.apolloPanel.getVisibleBasepairWidth();
        double oldFactor = this.getZoomFactor();
        double newFactor = this.xscale * fudgeForScrollbar * curWidth / newWidth;
        this.setZoomFactor(newFactor);
        int padForScrollbar = (int)(newWidth / 100.0);
        if (centerBase < 0) {
            centerBase = (limits[0] + limits[1]) / 2 + padForScrollbar;
        }
        this.setCentreBase(centerBase);
        this.apolloPanel.verticalScrollToSelection();
        this.controller.handleZoomEvent(new ZoomEvent(this, !this.shiftForLockedZooming(), CUSTOM, newFactor / oldFactor));
    }

    private void setSelectedViewVisible() {
        if (this.forwardVisible && this.reverseVisible) {
            return;
        }
        FeatureList features = this.apolloPanel.getSelection().getSelectedData();
        for (int i = 0; !(i >= features.size() || this.forwardVisible && this.reverseVisible); ++i) {
            SeqFeatureI sf = features.getFeature(i);
            if (sf.getStrand() == 1 && !this.forwardVisible) {
                this.setForwardVisible(true);
            } else if (sf.getStrand() == -1 && !this.reverseVisible) {
                this.setReverseVisible(true);
            }
            if (sf.hasAnnotatedFeature()) {
                if (this.areAnnotationViewsVisible()) continue;
                this.setAnnotationViewsVisible(true);
                continue;
            }
            if (this.areResultViewsVisible()) continue;
            this.setResultViewsVisible(true);
        }
    }

    public void setRevCompListener(RevCompListener l) {
        this.revCompListener = l;
    }

    public RevCompListener getRevCompListener() {
        return this.revCompListener;
    }

    private void notifyRevCompListener() {
        if (this.revCompListener != null) {
            this.revCompListener.updateRevComp(this.isReverseComplement());
        }
    }

    public void scrollToSelection() {
        this.apolloPanel.verticalScrollToSelection();
    }

    private void zoomToWidth(int[] limits) {
        this.zoomToWidth(limits[1] - limits[0], limits);
    }

    public void zoomToWidth(double dispWidth, int[] limits) {
        double curWidth = this.apolloPanel.getVisibleBasepairWidth();
        double zoomFactor = curWidth / dispWidth * this.xscale;
        this.setZoomFactor(zoomFactor);
        this.setCentreBase(limits[0] + (int)dispWidth / 2);
        this.controller.handleZoomEvent(new ZoomEvent(this, false, CUSTOM, zoomFactor));
    }

    public boolean selectFeaturesByName(String name, int window) {
        return this.selectFeaturesByName(name, window, false);
    }

    public boolean selectFeaturesByName(String name, int window, boolean useRegExp) {
        int genePos;
        if (name == null || name.equals("")) {
            return false;
        }
        if (name.startsWith("http") && (genePos = name.indexOf("gene=")) > 0 && (name = name.substring(genePos + 5)).indexOf("&") > 0) {
            name = name.substring(0, name.indexOf("&"));
        }
        ArrayList feats = null;
        if (!useRegExp) {
            feats = this.getAnnotations().findFeaturesByName(name);
        }
        if (feats == null || feats.isEmpty()) {
            feats = this.getAnnotations().findFeaturesByAllNames(name, useRegExp);
        }
        ((FeatureList)feats).addAllFeatures(this.getResults().findFeaturesByAllNames(name, useRegExp));
        if (feats.isEmpty()) {
            feats = this.getResults().findFeaturesByAllNames(name, useRegExp);
        }
        if (feats.isEmpty()) {
            return false;
        }
        this.selectionManager.select((FeatureList)feats, true, false, this);
        this.zoomToSelectionWithWindow(window);
        return true;
    }

    private void jbInit() {
        GridBagConstraints gbc;
        JPanel pp1 = new JPanel();
        JPanel pp2 = new JPanel();
        JPanel pp3 = new JPanel();
        JLabel hlabel = new JLabel("Position");
        JLabel zlabel = new JLabel("Zoom  ");
        this.setLayout(new BorderLayout());
        this.panel2.setLayout(new GridLayout(2, 1));
        this.apolloPanel.setLayout(new ColumnApolloLayout());
        this.reverseSiteView = new SiteView(this.apolloPanel, "reverse sites", this.getController(), this.selectionManager);
        this.reverseResultView = new ResultView((JComponent)this.apolloPanel, "reverse results", this.selectionManager);
        this.reverseAnnotView = new AnnotationView(this.apolloPanel, "reverse annotations", this.selectionManager, this.curationState);
        this.reverseSplitterView = new SplitterView(this.apolloPanel, "reverse splitter", true, this.reverseAnnotView, this.reverseResultView);
        this.scaleView = new ScaleView(this.apolloPanel, "sv");
        this.forwardResultView = new ResultView((JComponent)this.apolloPanel, "forward results", this.selectionManager);
        this.forwardAnnotView = new AnnotationView(this.apolloPanel, "forward annotations", this.selectionManager, this.curationState);
        this.forwardSplitterView = new SplitterView(this.apolloPanel, "forward splitter", true, this.forwardResultView, this.forwardAnnotView);
        this.forwardSiteView = new SiteView(this.apolloPanel, "forward sites", this.getController(), this.selectionManager);
        this.graphView = new GraphView(this.apolloPanel, "graphView");
        this.forwardContainerView = new LaidoutViewContainer((JComponent)this.getApolloPanel(), new ColumnApolloLayout(), "forward container view");
        this.forwardContainerView.add(this.forwardSplitterView, "Both");
        this.forwardContainerView.add(this.scaleView, "Horizontal");
        this.forwardContainerView.add(this.graphView, "Horizontal");
        this.reverseContainerView = new LaidoutViewContainer((JComponent)this.getApolloPanel(), new ColumnApolloLayout(), "reverse container view");
        this.reverseContainerView.add(this.reverseSplitterView, "Both");
        this.strandSplitter = new SplitterView(this.apolloPanel, "strand split", true, this.forwardContainerView, this.reverseContainerView);
        this.forwardResultView.setStrand(1);
        this.reverseResultView.setStrand(-1);
        this.forwardAnnotView.setYOrientation(-1);
        this.forwardResultView.setYOrientation(-1);
        this.addAllViews();
        this.forwardAnnotView.registerDragSource(this.forwardResultView);
        this.forwardAnnotView.registerDragSource(this.forwardAnnotView);
        this.forwardAnnotView.registerDragSource(this.forwardSiteView);
        this.forwardAnnotView.setResultView(this.forwardResultView);
        this.forwardAnnotView.setSiteView(this.forwardSiteView);
        this.reverseAnnotView.registerDragSource(this.reverseResultView);
        this.reverseAnnotView.registerDragSource(this.reverseSiteView);
        this.reverseAnnotView.registerDragSource(this.reverseAnnotView);
        this.reverseAnnotView.setResultView(this.reverseResultView);
        this.reverseAnnotView.setSiteView(this.reverseSiteView);
        this.forwardResultView.setAnnotationView(this.forwardAnnotView);
        this.reverseResultView.setAnnotationView(this.reverseAnnotView);
        this.forwardSiteView.setResultView(this.forwardResultView);
        this.reverseSiteView.setResultView(this.reverseResultView);
        if (this.HSCROLLABLE) {
            this.hScroll.setOrientation(0);
            this.hScroll.addAdjustmentListener(this);
            pp1.setLayout(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            pp1.add((Component)hlabel, gbc);
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            pp1.add((Component)this.hScroll, gbc);
        }
        if (this.ZOOMABLE) {
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            pp2.setLayout(new GridBagLayout());
            pp2.add((Component)zlabel, gbc);
            pp2.add((Component)this.zoomin2, gbc);
            pp2.add((Component)this.zoomin, gbc);
            pp2.add((Component)this.zoomout, gbc);
            pp2.add((Component)this.zoomout2, gbc);
            pp2.add((Component)this.reset, gbc);
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            pp2.add((Component)this.zoomLabel, gbc);
            this.zoomin.addActionListener(this);
            this.zoomin2.addActionListener(this);
            this.zoomout.addActionListener(this);
            this.zoomout2.addActionListener(this);
            this.reset.addActionListener(this);
        }
        pp3.setLayout(new GridBagLayout());
        this.organismLabel = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        pp3.add((Component)pp2, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        pp3.add((Component)this.organismLabel, gbc);
        if (this.getCurationSet() != null && this.getCurationSet().getOrganism() != null) {
            String organism = this.getCurationSet().getOrganism();
            String chromosome = this.getCurationSet().getChromosome();
            String start = this.getCurationSet().getStartAsString();
            String end = this.getCurationSet().getEndAsString();
            this.organismLabel.setText("  " + organism + ":" + chromosome + ":" + start + "-" + end);
        }
        this.panel2.add(pp1);
        this.panel2.add(pp3);
        this.add((Component)this.apolloPanel, "Center");
        if (this.HSCROLLABLE || this.ZOOMABLE) {
            this.add((Component)this.panel2, this.ZOOMPOSITION);
        }
        this.setViewVisibilityToStyleSpecifications();
        if (this.ZOOMPOSITION.equals("South")) {
            this.add((Component)this.curationState.getNavigationBar(), "North");
        } else {
            this.add((Component)this.curationState.getNavigationBar(), "South");
        }
    }

    public void setControlPanelVisibility(boolean state) {
        this.panel2.setVisible(state);
    }

    public boolean isControlPanelVisible() {
        return this.panel2.isVisible();
    }

    private void setViewVisibilityToStyleSpecifications() {
        this.setAnnotationViewsVisible(Config.getShowAnnotations());
        this.setResultViewsVisible(Config.getShowResults());
        this.setScaleViewVisible(true);
        this.sitesVisibleOnZoom = Config.getStyle().getInitialSitesVisibility() && this.haveSequence;
        this.setScrollingPropagated(Config.getStyle().initialLockedScrolling());
        this.setShiftForLockedZooming(Config.getStyle().initialShiftForLockedZooming());
    }

    public void setViewColours() {
        this.reverseResultView.setBackgroundColour(Config.getFeatureBackground());
        this.forwardResultView.setBackgroundColour(Config.getFeatureBackground());
        this.forwardSiteView.setBackgroundColour(Config.getFeatureBackground());
        this.reverseSiteView.setBackgroundColour(Config.getFeatureBackground());
        this.forwardAnnotView.setBackgroundColour(Config.getAnnotationBackground());
        this.reverseAnnotView.setBackgroundColour(Config.getAnnotationBackground());
        this.scaleView.setBackgroundColour(Config.getCoordBackground());
        this.scaleView.setForegroundColour(Config.getCoordForeground());
        this.graphView.setForegroundColour(Config.getCoordForeground());
        this.graphView.setPlotColour(Config.getCoordForeground());
        this.graphView.setBackgroundColour(Config.getCoordBackground());
    }

    private boolean canShowSites(boolean viewIsVisible) {
        boolean showSites;
        if (!this.sitesVisibleOnZoom) {
            return false;
        }
        int siteShowLim = Config.getSiteShowLimit();
        boolean bl = showSites = this.forwardResultView.getTransform().getXCoordsPerPixel() <= (double)siteShowLim && viewIsVisible;
        if (!showSites) {
            return false;
        }
        int[] visRange = this.forwardSiteView.getVisibleRange();
        return this.curationSet != null && this.curationSet.getRefSequence() != null && this.curationSet.getRefSequence().getResidues(visRange[0], visRange[1]) != null;
    }

    private void updateSiteVisibility(boolean force) {
        if (!this.haveSequence) {
            return;
        }
        boolean update = false;
        boolean show_sites = this.canShowSites(this.forwardVisible);
        if (this.forwardSitesVisibleAtZoomLevel != show_sites || force) {
            this.forwardSitesVisibleAtZoomLevel = show_sites;
            this.forwardSiteView.setVisible(this.forwardSitesVisibleAtZoomLevel);
            update = true;
        }
        if (this.reverseSitesVisibleAtZoomLevel != (show_sites = this.canShowSites(this.reverseVisible)) || force) {
            this.reverseSitesVisibleAtZoomLevel = show_sites;
            this.reverseSiteView.setVisible(this.reverseSitesVisibleAtZoomLevel);
            update = true;
        }
        if (update) {
            this.apolloPanel.setInvalidity(true);
            this.apolloPanel.doLayout();
            this.apolloPanel.setInvalidity(false);
        }
    }

    public void setForwardVisible(boolean state) {
        this.setStrandVisible(this.forwardAnnotView, this.forwardResultView, 1, state);
    }

    public void setReverseVisible(boolean state) {
        this.setStrandVisible(this.reverseAnnotView, this.reverseResultView, -1, state);
    }

    public AnnotationView getAnnotView(int strand) {
        return strand == 1 ? this.forwardAnnotView : this.reverseAnnotView;
    }

    private void removeAllViews() {
        this.apolloPanel.remove(this.forwardSiteView);
        this.apolloPanel.remove(this.strandSplitter);
        this.apolloPanel.remove(this.reverseSiteView);
    }

    private void addAllViews() {
        String resultConstraint = "Both";
        this.apolloPanel.setInvalidity(true);
        if (this.reverseComplement) {
            this.apolloPanel.add(this.reverseSiteView, (Object)"Horizontal");
        } else {
            this.apolloPanel.add(this.forwardSiteView, (Object)"Horizontal");
        }
        this.apolloPanel.add(this.strandSplitter, (Object)resultConstraint);
        if (this.reverseComplement) {
            this.apolloPanel.add(this.forwardSiteView, (Object)"Horizontal");
        } else {
            this.apolloPanel.add(this.reverseSiteView, (Object)"Horizontal");
        }
        this.apolloPanel.setScaleView(this.scaleView);
        this.apolloPanel.invalidate();
        this.apolloPanel.validate();
        this.apolloPanel.setInvalidity(false);
    }

    public boolean isForwardStrandVisible() {
        return this.forwardVisible;
    }

    public boolean isReverseStrandVisible() {
        return this.reverseVisible;
    }

    private void setStrandVisible(AnnotationView av, ResultView rv, int strand, boolean state) {
        this.apolloPanel.setInvalidity(true);
        av.setVisible(state && this.annotationViewsVisible);
        rv.setVisible(state && this.resultViewsVisible);
        if (strand == 1) {
            this.forwardVisible = state;
            this.forwardSplitterView.setVisible(state);
            this.forwardContainerView.setVisible(state);
            if (!state && this.forwardContainerView.getViewsOfClass(class$apollo$gui$genomemap$ScaleView == null ? (class$apollo$gui$genomemap$ScaleView = StrandedZoomableApolloPanel.class$("apollo.gui.genomemap.ScaleView")) : class$apollo$gui$genomemap$ScaleView).size() > 0) {
                this.forwardContainerView.remove(this.scaleView);
                this.forwardContainerView.remove(this.graphView);
                if (this.reverseComplement) {
                    this.reverseContainerView.add(this.scaleView, "Horizontal");
                    this.reverseContainerView.add(this.graphView, "Horizontal");
                } else {
                    this.reverseContainerView.addFirst(this.scaleView, "Horizontal");
                    this.reverseContainerView.addFirst(this.graphView, "Horizontal");
                }
            }
        } else {
            this.reverseVisible = state;
            this.reverseSplitterView.setVisible(state);
            this.reverseContainerView.setVisible(state);
            if (!state && this.reverseContainerView.getViewsOfClass(class$apollo$gui$genomemap$ScaleView == null ? (class$apollo$gui$genomemap$ScaleView = StrandedZoomableApolloPanel.class$("apollo.gui.genomemap.ScaleView")) : class$apollo$gui$genomemap$ScaleView).size() > 0) {
                this.reverseContainerView.remove(this.scaleView);
                this.reverseContainerView.remove(this.graphView);
                if (this.reverseComplement) {
                    this.forwardContainerView.addFirst(this.scaleView, "Horizontal");
                    this.forwardContainerView.addFirst(this.graphView, "Horizontal");
                } else {
                    this.forwardContainerView.add(this.scaleView, "Horizontal");
                    this.forwardContainerView.add(this.graphView, "Horizontal");
                }
            }
        }
        this.updateSiteVisibility(true);
    }

    public void setController(Controller controller) {
        this.controller = controller;
        controller.addListener(this);
        this.apolloPanel.setController(controller);
    }

    public boolean handleOrientationEvent(OrientationEvent evt) {
        this.changeYOrientation();
        return false;
    }

    public boolean handleNamedFeatureSelectionEvent(NamedFeatureSelectionEvent theEvent) {
        String[] selectionNames = theEvent.getNames();
        FeatureList foundFeatures = new FeatureList();
        for (int nameCounter = 0; nameCounter < selectionNames.length; ++nameCounter) {
            if ("no_name".equals(selectionNames[nameCounter])) continue;
            String nm = selectionNames[nameCounter];
            if (theEvent.getSource() instanceof SyntenyLinkPanel) {
                foundFeatures.addAllFeatures(this.getResults().findFeaturesByName(nm));
                foundFeatures.addAllFeatures(this.getAnnotations().findFeaturesByName(nm));
                continue;
            }
            foundFeatures.addAllFeatures(this.getResults().findFeaturesByAllNames(nm));
            foundFeatures.addAllFeatures(this.getAnnotations().findFeaturesByAllNames(nm));
        }
        this.getSelectionManager().select(foundFeatures, true, false, theEvent.getSource());
        return true;
    }

    public void changeYOrientation() {
        this.reverseAnnotView.setYOrientation(this.reverseAnnotView.getTransform().getYOrientation() == -1 ? 1 : -1);
        this.reverseResultView.setYOrientation(this.reverseResultView.getTransform().getYOrientation() == -1 ? 1 : -1);
        this.forwardAnnotView.setYOrientation(this.forwardAnnotView.getTransform().getYOrientation() == -1 ? 1 : -1);
        this.forwardResultView.setYOrientation(this.forwardResultView.getTransform().getYOrientation() == -1 ? 1 : -1);
        this.setScrollValues();
        this.repaint();
    }

    public void setSelectionManager(SelectionManager sm) {
        this.selectionManager = sm;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public ScaleView getScaleView() {
        return this.scaleView;
    }

    public GraphView getGraphView() {
        return this.graphView;
    }

    public boolean getGraphVisibility() {
        return this.graphView.isVisible();
    }

    public Rectangle calculateHighlightRect(HighlightWrapper hw) {
        Transformer transformer = this.scaleView.getTransform();
        int startCoord = hw.scroller.getVisibleBase();
        int width = hw.scroller.getVisibleBaseCount();
        int baselineX = transformer.toPixel((int)0, (int)0).x;
        int startXPixel = transformer.minXPixelAtUserCoord(startCoord);
        int widthPixel = transformer.toPixel((int)width, (int)0).x - baselineX;
        if (widthPixel < 0) {
            if (!hw.reverse) {
                startXPixel += widthPixel;
            }
            widthPixel = -widthPixel;
        } else if (hw.reverse) {
            startXPixel -= widthPixel;
        }
        if (widthPixel < 1) {
            widthPixel = 1;
        }
        Rectangle rect = new Rectangle(startXPixel, this.apolloPanel.getBounds().y, widthPixel, this.apolloPanel.getSize().height);
        return rect;
    }

    public void repaintHighlights() {
        RepaintManager currentManager = RepaintManager.currentManager(this);
        for (int i = 0; i < this.highlightRegions.size(); ++i) {
            HighlightWrapper hw = (HighlightWrapper)this.highlightRegions.elementAt(i);
            Rectangle rect = this.calculateHighlightRect(hw);
            Rectangle rect2 = hw.getHighlightRect();
            if (rect != null && rect2 != null && rect2.equals(rect)) continue;
            if (rect != null) {
                currentManager.addDirtyRegion(this, rect.x, rect.y, rect.width + 1, rect.height);
            }
            if (rect2 == null) continue;
            currentManager.addDirtyRegion(this, rect2.x, rect2.y, rect2.width + 1, rect2.height);
        }
        currentManager.paintDirtyRegions();
    }

    public void paint(Graphics g) {
        super.paint(g);
        for (int i = 0; i < this.highlightRegions.size(); ++i) {
            HighlightWrapper hw = (HighlightWrapper)this.highlightRegions.elementAt(i);
            Rectangle rect = this.calculateHighlightRect(hw);
            hw.setHighlightRect(rect);
            g.setColor(hw.color);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void addHighlightRegion(BaseScrollable scroller, Color color, boolean reverse) {
        this.highlightRegions.addElement(new HighlightWrapper(scroller, color, reverse));
    }

    public void removeHighlightRegion(BaseScrollable scroller) {
        this.highlightRegions.removeElement(new HighlightWrapper(scroller, null, false));
    }

    public boolean isReverseComplement() {
        return this.reverseComplement;
    }

    public void setReverseComplement(boolean state) {
        ApolloFrame frame;
        this.reverseComplement = state;
        int frv_val = 0;
        int rrv_val = 0;
        this.forwardContainerView.invertViews();
        this.reverseContainerView.invertViews();
        this.strandSplitter.invertViews();
        if (this.useScrollHack) {
            frv_val = this.forwardResultView.getInvertedScrollbarValue();
            rrv_val = this.reverseResultView.getInvertedScrollbarValue();
        }
        this.removeAllViews();
        this.addAllViews();
        int dir = this.reverseComplement ? -1 : 1;
        this.reverseSiteView.setXOrientation(dir);
        this.reverseResultView.setXOrientation(dir);
        this.reverseAnnotView.setXOrientation(dir);
        this.forwardSiteView.setXOrientation(dir);
        this.forwardResultView.setXOrientation(dir);
        this.forwardAnnotView.setXOrientation(dir);
        this.scaleView.setXOrientation(dir);
        this.graphView.setXOrientation(dir);
        if (this.reverseComplement) {
            this.reverseAnnotView.setYOrientation(-1);
            this.reverseResultView.setYOrientation(-1);
            this.forwardAnnotView.setYOrientation(1);
            this.forwardResultView.setYOrientation(1);
            this.forwardSiteView.setYOrientation(1);
        } else {
            this.reverseAnnotView.setYOrientation(1);
            this.reverseResultView.setYOrientation(1);
            this.reverseSiteView.setYOrientation(1);
            this.forwardAnnotView.setYOrientation(-1);
            this.forwardResultView.setYOrientation(-1);
        }
        this.setScrollValues();
        if (this.useScrollHack) {
            this.forwardResultView.setScrollbarValue(frv_val);
            this.reverseResultView.setScrollbarValue(rrv_val);
        }
        Color tmp = Config.getCoordForeground();
        Config.getStyle().setCoordForeground(Config.getCoordRevcompColor());
        Config.getStyle().setCoordRevcompColor(tmp);
        Window win = SwingUtilities.windowForComponent(this.apolloPanel);
        if (win instanceof ApolloFrame && (frame = (ApolloFrame)win) != null) {
            String revcompPhrase = " (REVERSE COMPLEMENTED)";
            if (this.reverseComplement) {
                frame.setTitle(frame.getTitle() + revcompPhrase);
            } else {
                String title = frame.getTitle();
                if (title != null && title.lastIndexOf(revcompPhrase) > 0) {
                    title = title.substring(0, title.lastIndexOf(revcompPhrase));
                    frame.setTitle(title);
                }
            }
        }
        this.setViewColours();
        this.repaint();
        this.notifyRevCompListener();
    }

    public boolean handleScrollEvent(ScrollEvent event) {
        double pixelAmount = event.getValue();
        int baseAmount = (int)(this.getTransformer().getXCoordsPerPixel() * pixelAmount);
        int finalScrollbarPosition = this.hScroll.getValue() + baseAmount;
        if (this.isReverseComplement()) {
            pixelAmount = -1.0 * pixelAmount;
        }
        this.doScrolling(finalScrollbarPosition);
        return true;
    }

    private void doScrolling(int val) {
        this.setCentreBase(this._scrollToPosition(val));
        this.fireBaseFocusEvent(this.getCentreBase());
        this.setScrollValues();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int val = this.hScroll.getValue();
        if (this.HSCROLLABLE && e.getSource() == this.hScroll && !this.settingScroller) {
            int basesScrolled = this._scrollToPosition(val) - this.getCentreBase();
            double pixelChange = !this.isReverseComplement() ? this.getTransformer().getXPixelsPerCoord() * (double)basesScrolled : -1.0 * this.getTransformer().getXPixelsPerCoord() * (double)basesScrolled;
            this.doScrolling(val);
            if (this.isScrollingPropagated()) {
                this.getController().handleScrollEvent(new ScrollEvent(this, pixelChange));
            }
        }
    }

    private int _scrollToPosition(int scrollVal) {
        int retVal = scrollVal;
        if (this.reverseComplement) {
            retVal = this.apolloPanel.getLinearMaximum() - scrollVal + this.apolloPanel.getLinearMinimum();
        }
        return retVal;
    }

    private int _positionToScroll(int posVal) {
        int retVal = posVal;
        if (this.reverseComplement) {
            retVal = this.apolloPanel.getLinearMaximum() + this.apolloPanel.getLinearMinimum() - posVal;
        }
        return retVal;
    }

    public boolean handleBaseFocusEvent(BaseFocusEvent evt) {
        if (evt.isPosition()) {
            this.setCentreBase(evt.getFocus());
        } else {
            this.zoomToWidth(evt.getRangeLimits());
        }
        return true;
    }

    public boolean handleReverseComplementEvent(ReverseComplementEvent evt) {
        this.setReverseComplement(!this.reverseComplement);
        return false;
    }

    private void fireBaseFocusEvent(int position) {
        BaseFocusEvent evt = new BaseFocusEvent(this, position, null);
        this.controller.handleBaseFocusEvent(evt);
    }

    public int getCentreBase() {
        return this.apolloPanel.getLinearCentre();
    }

    public void setCentreBase(int location) {
        this.apolloPanel.setLinearCentre(location);
        this.settingScroller = true;
        this.hScroll.setValue(this._positionToScroll(location));
        this.settingScroller = false;
    }

    public void setScrollValues() {
        if (this.HSCROLLABLE && this.hScroll != null) {
            this.settingScroller = true;
            int visWidth = this.apolloPanel.getVisibleBasepairWidth();
            this.hScroll.setMinimum(this.apolloPanel.getLinearMinimum());
            this.hScroll.setMaximum(this.apolloPanel.getLinearMaximum() + visWidth);
            this.hScroll.setVisibleAmount(visWidth);
            this.hScroll.setUnitIncrement(Math.max(visWidth / 20, 1));
            this.hScroll.setBlockIncrement(Math.max(visWidth / 4, 1));
            this.hScroll.setValue(this._positionToScroll(this.getCentreBase()));
            this.settingScroller = false;
        }
    }

    private void printScrollValues() {
        if (this.hScroll != null) {
            System.out.println("hscroll values:- ");
            System.out.println(" minimum       = " + this.hScroll.getMinimum());
            System.out.println(" maximum       = " + this.hScroll.getMaximum());
            System.out.println(" visibleAmount = " + this.hScroll.getVisibleAmount());
            System.out.println(" value         = " + this.hScroll.getValue());
            System.out.println(" unitInc       = " + this.hScroll.getUnitIncrement());
            System.out.println(" blockInc      = " + this.hScroll.getBlockIncrement());
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public boolean handleRubberbandEvent(RubberbandEvent evt) {
        return false;
    }

    public boolean handleDataLoadEvent(DataLoadEvent evt) {
        if (!evt.dataRetrievalBeginning()) {
            return false;
        }
        if (this.isReverseComplement()) {
            this.setReverseComplement(false);
        }
        this.clearData();
        this.setScrollValues();
        this.setZoomFactor(1.0);
        return true;
    }

    public void actionPerformed(ActionEvent evt) {
        double newFactor = this.getZoomFactor();
        String zoomFactor = null;
        ShiftAwareButton button = null;
        if (evt.getSource() instanceof ShiftAwareButton) {
            button = (ShiftAwareButton)evt.getSource();
        }
        if (this.ZOOMABLE && button == this.zoomin) {
            newFactor *= 2.0;
            zoomFactor = ZOOMIN;
        } else if (this.ZOOMABLE && button == this.zoomin2) {
            newFactor *= 10.0;
            zoomFactor = ZOOMIN2;
        } else if (this.ZOOMABLE && button == this.zoomout) {
            newFactor /= 2.0;
            zoomFactor = ZOOMOUT;
        } else if (this.ZOOMABLE && button == this.zoomout2) {
            newFactor /= 10.0;
            zoomFactor = ZOOMOUT2;
        } else if (this.ZOOMABLE && button == this.reset) {
            newFactor = 1.0;
            zoomFactor = RESET;
        } else {
            System.out.println("ERROR: Unknown source for ActionEvent");
            return;
        }
        this.doZoom(newFactor, zoomFactor);
        this.controller.handleZoomEvent(new ZoomEvent(this, this.propagateZoom(button), zoomFactor));
    }

    private boolean propagateZoom(ShiftAwareButton button) {
        boolean shift = button != null && button.isMousePressShifted();
        return shift && this.shiftForLockedZooming() || !shift && !this.shiftForLockedZooming();
    }

    private boolean shiftForLockedZooming() {
        return this.shiftForLockedZooming;
    }

    public void setShiftForLockedZooming(boolean state) {
        this.shiftForLockedZooming = state;
    }

    private void doZoom(double newFactor, String zoomCommand) {
        this.setZoomFactor(newFactor);
        if (newFactor == 1.0 && RESET.equals(zoomCommand)) {
            this.putVerticalScrollbarsAtStart();
            this.apolloPanel.verticalScrollToSelection();
        }
    }

    public void resetViews() {
        this.setViewVisibilityToStyleSpecifications();
        this.setZoomFactor(1.0);
        if (this.isReverseComplement()) {
            this.setReverseComplement(false);
        }
        this.forwardSplitterView.resetSplitFract();
        this.reverseSplitterView.resetSplitFract();
        this.strandSplitter.resetSplitFract();
        this.setForwardVisible(true);
        this.setReverseVisible(true);
        this.apolloPanel.setInvalidity(true);
        this.apolloPanel.doLayout();
        this.apolloPanel.setInvalidity(false);
        this.putVerticalScrollbarsAtStart();
        double curWidth = this.apolloPanel.getVisibleBasepairWidth();
        this.setCentreBase(this.curationSet.getLow() + (int)curWidth / 2);
    }

    private void setZoomFactor(double factor, boolean force) {
        double newDesiredWidth = (double)this.apolloPanel.getVisibleBasepairWidth() * this.xscale / factor;
        if (force || newDesiredWidth > 2.0 && newDesiredWidth < 1.0E9) {
            this.xscale = factor;
            this.apolloPanel.setZoomFactor(this.xscale, -1.0);
            this.setScrollValues();
        }
        this.updateSiteVisibility(false);
        int newWidth = this.apolloPanel.getVisibleBasepairWidth();
        this.zoomin.setEnabled(newWidth > 4);
        this.zoomin2.setEnabled(newWidth > 10);
        this.zoomout.setEnabled((long)newWidth < 500000000L);
        this.zoomout2.setEnabled((long)newWidth < 100000000L);
        this.zoomLabel.setText("  Zoom factor = " + new Format("%6.4f").form(this.xscale) + "   ");
    }

    public void setZoomFactor(double factor) {
        this.setZoomFactor(factor, false);
    }

    private double getZoomFactor() {
        return this.xscale;
    }

    public void setTextAvoidance(boolean state) {
        this.forwardAnnotView.setTextAvoidance(state);
        this.reverseAnnotView.setTextAvoidance(state);
        this.forwardResultView.setTextAvoidance(state);
        this.reverseResultView.setTextAvoidance(state);
    }

    public void setStatusBar(StatusBar sb) {
        this.statusBar = sb;
        if (this.apolloPanel != null) {
            this.apolloPanel.setStatusBar(sb);
        }
    }

    public void setEdgeMatching(boolean state) {
        this.apolloPanel.setEdgeMatching(state);
    }

    public Transformer getTransformer() {
        return this.forwardResultView.getTransform();
    }

    public boolean haveSequence() {
        return this.haveSequence;
    }

    public void clearData() {
        this.apolloPanel.clearFeatures();
        this.curationSet = null;
        this.forwardSiteView.setCurationSet(null);
        this.reverseSiteView.setCurationSet(null);
        this.scaleView.setCurationSet(null);
        this.graphView.setScoreCalculator(null);
    }

    public JLabel getOrganismLabel() {
        return this.organismLabel;
    }

    public void repaint() {
        if (this.getController() != null) {
            this.getController().handleChainedRepaintEvent(new ChainedRepaintEvent(this));
        }
        super.repaint();
    }

    public boolean handleZoomEvent(ZoomEvent event) {
        double newFactor = this.getZoomFactor();
        if (this.ZOOMABLE && ZOOMIN.equals(event.getZoomFactor())) {
            newFactor *= 2.0;
        } else if (this.ZOOMABLE && ZOOMIN2.equals(event.getZoomFactor())) {
            newFactor *= 10.0;
        } else if (this.ZOOMABLE && ZOOMOUT.equals(event.getZoomFactor())) {
            newFactor /= 2.0;
        } else if (this.ZOOMABLE && ZOOMOUT2.equals(event.getZoomFactor())) {
            newFactor /= 10.0;
        } else if (this.ZOOMABLE && RESET.equals(event.getZoomFactor())) {
            newFactor = 1.0;
        } else if (this.ZOOMABLE && CUSTOM.equals(event.getZoomFactor())) {
            newFactor *= event.getFactorMultiplier();
        }
        this.doZoom(newFactor, event.getZoomFactor());
        return true;
    }

    public Component getComponent() {
        return this;
    }

    public void setAnnotationViewsVisible(boolean state) {
        this.annotationViewsVisible = state;
        this.apolloPanel.setInvalidity(true);
        this.forwardAnnotView.setVisible(state);
        this.reverseAnnotView.setVisible(state);
    }

    public boolean areAnnotationViewsVisible() {
        return this.annotationViewsVisible;
    }

    public ResultView getViewForFeature(SeqFeatureI sf) {
        return sf.getStrand() >= 0 ? this.forwardResultView : this.reverseResultView;
    }

    public void setResultViewsVisible(boolean state) {
        this.resultViewsVisible = state;
        this.apolloPanel.setInvalidity(true);
        this.forwardResultView.setVisible(state);
        this.reverseResultView.setVisible(state);
    }

    public boolean areResultViewsVisible() {
        return this.resultViewsVisible;
    }

    public void setScaleViewVisible(boolean state) {
        this.scaleViewVisible = state;
        this.scaleView.setVisible(state);
    }

    public boolean isScaleViewVisible() {
        return this.scaleViewVisible;
    }

    public void setSiteViewVisibleOnZoom(boolean state) {
        this.sitesVisibleOnZoom = state;
        this.updateSiteVisibility(true);
    }

    public boolean getSiteViewVisibleOnZoom() {
        return this.sitesVisibleOnZoom;
    }

    public void setScrollingPropagated(boolean value) {
        this.scrollingPropagated = value;
    }

    public boolean isScrollingPropagated() {
        return this.scrollingPropagated;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HighlightDragListener
    extends MouseInputAdapter {
        HighlightWrapper dragged;
        boolean dragging = false;
        RepaintManager repainter;
        JComponent parent;
        Transformer t;

        public HighlightDragListener(JComponent parent) {
            this.t = StrandedZoomableApolloPanel.this.scaleView.getTransform();
            this.repainter = RepaintManager.currentManager(parent);
        }

        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            ViewI view = StrandedZoomableApolloPanel.this.apolloPanel.getViewAt(new Point(e.getX(), e.getY()));
            if (view instanceof ScaleView) {
                for (int i = 0; i < StrandedZoomableApolloPanel.this.highlightRegions.size(); ++i) {
                    HighlightWrapper hw = (HighlightWrapper)StrandedZoomableApolloPanel.this.highlightRegions.elementAt(i);
                    int x = e.getX();
                    Rectangle rect = StrandedZoomableApolloPanel.this.calculateHighlightRect(hw);
                    if (x < rect.x - 1 || x > rect.x + rect.width + 1) continue;
                    this.dragged = hw;
                    this.dragging = true;
                }
            }
        }

        private void updateLoc(int newLoc) {
            int clickCoord = this.t.toUser((int)newLoc, (int)0).x;
            Rectangle rect = StrandedZoomableApolloPanel.this.calculateHighlightRect(this.dragged);
            this.repainter.addDirtyRegion(this.parent, rect.x, 0, rect.width, StrandedZoomableApolloPanel.this.apolloPanel.getSize().height);
            this.repainter.addDirtyRegion(this.parent, newLoc, 0, rect.width, StrandedZoomableApolloPanel.this.apolloPanel.getSize().height);
            this.dragged.scroller.scrollToBase(clickCoord);
            StrandedZoomableApolloPanel.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragging) {
                this.updateLoc(e.getX());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragging) {
                this.updateLoc(e.getX());
                this.dragging = false;
            }
        }
    }

    private class HighlightWrapper {
        Color color;
        BaseScrollable scroller;
        boolean reverse;
        Rectangle highlightRect = null;

        public HighlightWrapper(BaseScrollable scroller, Color color, boolean reverse) {
            this.reverse = reverse;
            this.color = color;
            this.scroller = scroller;
        }

        public boolean equals(Object o) {
            if (o instanceof HighlightWrapper) {
                HighlightWrapper hw = (HighlightWrapper)o;
                return hw.scroller.equals(this.scroller);
            }
            return false;
        }

        public void setHighlightRect(Rectangle highlightRect) {
            this.highlightRect = highlightRect;
        }

        public Rectangle getHighlightRect() {
            return this.highlightRect;
        }
    }

    public class ShiftAwareButton
    extends JButton {
        public boolean mousePressShifted;

        public ShiftAwareButton(String label) {
            super(label);
            this.setMargin(new Insets(2, 6, 2, 6));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMouseEvent(MouseEvent event) {
            try {
                if ((event.getModifiers() & 1) != 0) {
                    this.mousePressShifted = true;
                }
                super.processMouseEvent(event);
            }
            finally {
                this.mousePressShifted = false;
            }
        }

        public boolean isMousePressShifted() {
            return this.mousePressShifted;
        }
    }
}

