/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.genomemap.LinearView;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public abstract class ScrollAdjustedView
extends LinearView {
    protected int scroller = 0;
    protected int prefHeight = 46;
    protected boolean reverseComplement = false;

    public ScrollAdjustedView(JComponent ap, String name, boolean visible, int prefHeight) {
        super(ap, name, visible);
        this.prefHeight = prefHeight;
        Rectangle rect = new Rectangle(1, 1, 1, prefHeight);
        this.setBounds(rect);
    }

    public void setScrollFlag(int scroller) {
        this.scroller = scroller;
        this.setDrawBounds(this.getBounds());
    }

    public Rectangle setScrollSpace(int where) {
        JScrollBar jb = new JScrollBar(1);
        int scrollWidth = jb.getMinimumSize().width;
        Rectangle rect = new Rectangle(this.getBounds());
        rect.width -= scrollWidth;
        if (this.scroller == -1) {
            rect.x += scrollWidth;
        }
        return rect;
    }

    public void setDrawBounds(Rectangle rect) {
        Rectangle newBounds = new Rectangle(rect);
        if (this.scroller != 0) {
            newBounds = this.setScrollSpace(this.scroller);
        }
        this.transformer.setPixelBounds(newBounds);
    }

    public Rectangle getPreferredSize() {
        return new Rectangle(0, 0, 0, this.prefHeight);
    }

    public void setXOrientation(int direction) {
        switch (direction) {
            case 1: {
                this.reverseComplement = false;
                this.getTransform().setXOrientation(direction);
                break;
            }
            case -1: {
                this.getTransform().setXOrientation(direction);
                this.reverseComplement = true;
                break;
            }
            default: {
                System.out.println("Unknown direction in setXOrientation");
            }
        }
    }

    protected SeqFeatureI featureContains(SeqFeatureI sf, int base_position) {
        SeqFeatureI selected = null;
        if (sf.canHaveChildren()) {
            FeatureSetI fs = (FeatureSetI)sf;
            for (int i = 0; i < fs.size() && selected != null; ++i) {
                selected = this.featureContains(fs.getFeatureAt(i), base_position);
            }
        } else if (sf.contains(base_position)) {
            selected = sf;
        }
        return selected;
    }
}

