/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.config.PropertyScheme;
import apollo.datamodel.CurationSet;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.gui.Selection;
import apollo.gui.SelectionItem;
import apollo.gui.Transformer;
import apollo.gui.detailviewers.seqexport.SeqExport;
import apollo.gui.drawable.DrawableUtil;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.PickViewI;
import apollo.gui.genomemap.PlotUtil;
import apollo.gui.genomemap.PopupViewI;
import apollo.gui.genomemap.ScrollAdjustedView;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.genomemap.ViewI;
import apollo.gui.menus.ScaleMenu;
import apollo.seq.io.FastaFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.bdgp.util.DNAUtils;

public class ScaleView
extends ScrollAdjustedView
implements PopupViewI,
PickViewI {
    private static final int scaleLineY = 3;
    private static final int viewYbottom = 10;
    private static final int viewYtop = -4;
    private CurationSet curation;
    private boolean minorTicks = true;
    public static final int SPLICE = 1;
    public static final int FEATURES = 2;
    private Rectangle selectedRect;
    private int startBase;
    private int endBase;
    private int selectedStrand;
    private int maxSeqSelection = 100000;
    private int startOfRange = -1;
    private int endOfRange = -1;
    private ScaleColouringManager colouringManager = new ScaleColouringManager();
    private Hashtable sites = new Hashtable(1);

    public ScaleView(JComponent ap, String name) {
        super(ap, name, true, 46);
        this.transformer.setYRange(new int[]{-10, 10});
    }

    public void setCurationSet(CurationSet set) {
        this.curation = set;
        this.setRangeThatHasSequence();
    }

    public void setMinorTicks(boolean state) {
        this.minorTicks = state;
    }

    public void setSelectedRange(int startBase, int endBase, int strand) {
        this.startBase = startBase;
        this.endBase = endBase;
        this.selectedStrand = strand;
    }

    public void clear() {
        this.endBase = 0;
        this.startBase = 0;
    }

    public Rectangle getSelectedRectangle() {
        if (this.startBase == this.endBase) {
            return null;
        }
        int box_width = !this.reverseComplement ? (int)(this.transformer.getXPixelsPerCoord() * (double)(this.endBase - this.startBase + 1)) : (int)(this.transformer.getXPixelsPerCoord() * (double)(this.startBase - this.endBase + 1));
        int box_y = this.selectedStrand == 1 ? -4 : 10;
        box_y -= 6;
        int box_height = this.graphics.getFontMetrics().getAscent();
        if (this.selectedStrand == -1) {
            box_height -= 2;
        }
        Point box = !this.reverseComplement ? this.transformer.toPixel(new Point(this.startBase - 1, box_y)) : this.transformer.toPixel(new Point(this.startBase, box_y));
        this.selectedRect = new Rectangle(box.x, box.y, box_width, box_height + 4);
        return this.selectedRect;
    }

    public void paintView() {
        Vector labels = new Vector();
        if (this.curation == null) {
            return;
        }
        this.graphics.setColor(this.getBackgroundColour());
        this.graphics.fillRect(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        int[] visRange = this.getVisibleRange();
        int startCoord = visRange[0];
        int endCoord = visRange[1];
        this.graphics.setColor(this.getForegroundColour());
        Point start = this.transformer.toPixel(new Point(visRange[0], 3));
        Point end = this.transformer.toPixel(new Point(visRange[1], 3));
        this.graphics.drawLine(start.x, start.y, end.x, end.y);
        int tick = PlotUtil.calcTickInterval(visRange, this.graphics, this.transformer, labels);
        int startpos = startCoord / tick * tick;
        int half_coord = (int)(this.transformer.getXPixelsPerCoord() * 0.5);
        int firsttick = (int)((double)startpos - (double)tick * 0.5);
        int tickYtop = 1;
        if (firsttick >= startCoord && this.minorTicks) {
            start = this.transformer.toPixel(new Point(firsttick, 3));
            end = this.transformer.toPixel(new Point(firsttick, tickYtop));
            this.graphics.drawLine(start.x - half_coord, start.y, end.x - half_coord, end.y);
        }
        int tickNum = 0;
        int half_tick = (int)((double)tick * 0.5);
        this.graphics.setFont(Config.getDefaultFont());
        FontMetrics fm = this.graphics.getFontMetrics();
        for (int i = startpos; i <= endCoord; i += tick) {
            start = this.transformer.toPixel(new Point(i, 3));
            end = this.transformer.toPixel(new Point(i, tickYtop));
            start.x -= half_coord;
            end.x -= half_coord;
            this.graphics.drawLine(start.x, start.y, end.x, end.y);
            String label = (String)labels.elementAt(tickNum++);
            start.x -= (int)((double)fm.stringWidth(label) * 0.5);
            this.graphics.drawString(label, start.x, start.y - 3);
            if (!this.minorTicks) continue;
            start = this.transformer.toPixel(new Point(i + half_tick, 3));
            end = this.transformer.toPixel(new Point(i + half_tick, tickYtop));
            start.x -= half_coord;
            end.x -= half_coord;
            this.graphics.drawLine(start.x, start.y, end.x, end.y);
        }
        Rectangle rect = this.getSelectedRectangle();
        if (rect != null) {
            this.graphics.setColor(Config.getStyle().getSelectionColor());
            this.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
        int topStrand = this.reverseComplement ? -1 : 1;
        int bottomStrand = -1 * topStrand;
        this.drawSequencingEdits(this.graphics, this.transformer, startCoord, endCoord);
        this.drawOutOfRangeLines(this.graphics, this.transformer, startCoord, endCoord);
        this.drawSequence(this.graphics, this.transformer, -4, topStrand);
        this.drawSequence(this.graphics, this.transformer, 10, bottomStrand);
    }

    public void clearCutSites() {
        this.sites.clear();
        this.getComponent().repaint();
    }

    public void addCutSites(Vector forward_sites, Vector reverse_sites, Color site_color) {
        Vector[] match_positions = new Vector[]{forward_sites, reverse_sites};
        if (this.sites.get(site_color) != null) {
            System.out.println("Yikes, already using color " + site_color);
        }
        this.sites.put(site_color, match_positions);
        this.getComponent().repaint();
    }

    private void drawSequence(Graphics graphics, Transformer transformer, int viewY, int strand) {
        String seq;
        double pixelspercoord = transformer.getXPixelsPerCoord();
        boolean zoomed_out = pixelspercoord < 0.075;
        int[] visRange = this.getVisibleRange();
        if (this.curation == null) {
            return;
        }
        int startCoord = visRange[0] < this.curation.getLow() ? this.curation.getLow() : visRange[0];
        int endCoord = visRange[1] > this.curation.getHigh() ? this.curation.getHigh() : visRange[1];
        String string = seq = !zoomed_out ? this.getSequence(startCoord, endCoord, strand) : null;
        if (seq == null) {
            zoomed_out = true;
        }
        FontMetrics fm = graphics.getFontMetrics();
        int offset = (int)(pixelspercoord * 0.5 - (double)(fm.stringWidth("G") / 2));
        if (this.colouringManager.getColouringMode() == 2 && !zoomed_out) {
            graphics.setColor(Config.getSequenceColor());
            if (pixelspercoord >= 5.0) {
                this.drawFeatureBases(graphics, transformer, startCoord, endCoord, seq, offset, viewY, strand, this.buildBaseColorArray(startCoord, endCoord, strand));
            } else if (pixelspercoord >= 1.0) {
                this.drawFeatureBoxes(graphics, transformer, startCoord, endCoord, viewY, this.buildBaseColorArray(startCoord, endCoord, strand));
            }
        }
        if (this.colouringManager.getColouringMode() == 2) {
            if (pixelspercoord < 5.0) {
                this.drawSites(graphics, transformer, startCoord, endCoord, viewY, strand);
            } else {
                this.drawSites(graphics, transformer, startCoord, endCoord, seq, offset, viewY, strand);
            }
        }
        if (!zoomed_out) {
            if (strand == 1) {
                this.drawGaps(graphics, transformer, startCoord, endCoord, seq, offset);
            }
            graphics.setColor(Config.getSequenceColor());
            if (this.colouringManager.getColouringMode() == 1) {
                if (pixelspercoord >= 5.0) {
                    this.drawSpliceBases(graphics, transformer, startCoord, endCoord, seq, offset, viewY, strand);
                } else if (pixelspercoord >= 1.0) {
                    int topStrand = this.reverseComplement ? -1 : 1;
                    int bottomStrand = -1 * topStrand;
                    this.drawSpliceLines(graphics, transformer, startCoord, endCoord, seq, topStrand);
                    this.drawSpliceLines(graphics, transformer, startCoord, endCoord, seq, bottomStrand);
                }
            }
        }
    }

    protected void drawSpliceBases(Graphics graphics, Transformer transformer, int startCoord, int endCoord, String seq, int offset, int viewY, int strand) {
        Color default_color;
        Color prior_color = default_color = Config.getSequenceColor();
        for (int i = startCoord; i <= endCoord; ++i) {
            Color base_color = this.getSpliceColor(graphics, i, startCoord, endCoord, seq, strand, prior_color);
            graphics.setColor(base_color);
            prior_color = base_color == prior_color ? default_color : base_color;
            Point start = !this.reverseComplement ? transformer.toPixel(new Point(i - 1, viewY)) : transformer.toPixel(new Point(i, viewY));
            int index = this.getSeqIndex(i, startCoord, endCoord);
            String base = index + 1 < seq.length() ? seq.substring(index, index + 1) : seq.substring(index);
            graphics.drawString(base, start.x + offset, start.y);
        }
    }

    protected void drawSpliceLines(Graphics graphics, Transformer transformer, int startCoord, int endCoord, String seq, int strand) {
        Color default_color;
        Color prior_color = default_color = this.getBackgroundColour();
        int height = 10;
        int y = -4;
        if (strand == -1) {
            y = 10;
        }
        for (int i = startCoord; i <= endCoord; ++i) {
            Color base_color = this.getSpliceColor(graphics, i, startCoord, endCoord, seq, strand, prior_color);
            graphics.setColor(base_color);
            Color color = prior_color = base_color == prior_color ? default_color : base_color;
            if (base_color == default_color) continue;
            Point start = this.reverseComplement ? transformer.toPixel(new Point(i, y)) : transformer.toPixel(new Point(i - 1, y));
            graphics.drawLine(start.x, start.y, start.x, start.y - height);
        }
    }

    private int getSeqIndex(int i, int startCoord, int endCoord) {
        return !this.reverseComplement ? i - startCoord : endCoord - i;
    }

    protected Color getSpliceColor(Graphics graphics, int i, int startCoord, int endCoord, String seq, int strand, Color prior_color) {
        int index = this.getSeqIndex(i, startCoord, endCoord);
        int splice_length = 2;
        if (this.reverseComplement && --index < 0) {
            index = 0;
            splice_length = 1;
        }
        String seq2 = index + splice_length < seq.length() ? seq.substring(index, index + splice_length) : seq.substring(index);
        if (strand == 1 && !this.reverseComplement || strand == -1 && this.reverseComplement) {
            if (seq2.equals("GT")) {
                return Color.orange;
            }
            if (seq2.equals("AG")) {
                return Color.cyan;
            }
            return prior_color;
        }
        if (seq2.equals("TG")) {
            return Color.orange;
        }
        if (seq2.equals("GA")) {
            return Color.cyan;
        }
        return prior_color;
    }

    private void drawFeatureBases(Graphics graphics, Transformer transformer, int startCoord, int endCoord, String seq, int xOffset, int viewY, int strand, Color[] base_colors) {
        if (seq == null || seq.length() < 2) {
            return;
        }
        char[] bases = seq.toCharArray();
        int box_width = (int)transformer.getXPixelsPerCoord() + 1;
        int box_y = viewY - 6;
        int height = graphics.getFontMetrics().getAscent() + 4;
        for (int i = startCoord; i <= endCoord; ++i) {
            int index = !this.reverseComplement ? i - startCoord : endCoord - i;
            Color color = base_colors[index];
            if (!color.equals(Color.black)) {
                graphics.setColor(color);
                Point box = !this.reverseComplement ? transformer.toPixel(new Point(i - 1, box_y)) : transformer.toPixel(new Point(i, box_y));
                graphics.fillRect(box.x, box.y, box_width, height);
                graphics.setColor(Config.getSequenceColor());
            }
            Point start = !this.reverseComplement ? transformer.toPixel(new Point(i - 1, viewY)) : transformer.toPixel(new Point(i, viewY));
            graphics.drawChars(bases, index, 1, start.x + xOffset, start.y);
        }
    }

    private void drawFeatureBoxes(Graphics graphics, Transformer transformer, int startCoord, int endCoord, int viewY, Color[] base_colors) {
        int start_x = 0;
        int end_x = 0;
        Color feature_color = null;
        boolean in_feature = false;
        int y_pixel = transformer.toPixelY(viewY) - 10;
        for (int i = startCoord; i <= endCoord; ++i) {
            int index = !this.reverseComplement ? i - startCoord : endCoord - i;
            Color color = base_colors[index];
            if (!color.equals(Color.black)) {
                feature_color = color;
                if (!in_feature) {
                    start_x = this.reverseComplement ? i : i - 1;
                }
                end_x = this.reverseComplement ? i : i - 1;
                in_feature = true;
                continue;
            }
            if (in_feature) {
                int start_pixel = transformer.toPixelX(this.reverseComplement ? end_x : start_x);
                int end_pixel = transformer.toPixelX(this.reverseComplement ? start_x : end_x);
                int width = Math.max(Math.abs(start_pixel - end_pixel), 1);
                graphics.setColor(feature_color);
                graphics.fillRect(start_pixel, y_pixel, width, 10);
            }
            in_feature = false;
        }
        if (in_feature) {
            graphics.setColor(feature_color);
            int start_pixel = transformer.toPixelX(this.reverseComplement ? end_x : start_x);
            int end_pixel = transformer.toPixelX(this.reverseComplement ? start_x : end_x);
            int width = Math.max(Math.abs(start_pixel - end_pixel), 1);
            graphics.fillRect(start_pixel, y_pixel, width, 10);
        }
    }

    private void drawSite(Graphics graphics, Transformer transformer, int startCoord, int endCoord, int y, int height, Color color) {
        int y_pixel = transformer.toPixelY(y) - height;
        int x_pixel = transformer.toPixelX(this.reverseComplement ? startCoord : startCoord - 1);
        int width = this.calcWidth(x_pixel, endCoord);
        graphics.setColor(color);
        graphics.fillRect(x_pixel, y_pixel, width, height);
    }

    private void drawGaps(Graphics graphics, Transformer transformer, int startCoord, int endCoord, String seq, int xOffset) {
        if (seq.indexOf("N") >= 0) {
            char[] bases = seq.toCharArray();
            int top = 1;
            int bottom = 5;
            for (int i = startCoord; i <= endCoord; ++i) {
                Point right;
                Point left;
                int index;
                int n = index = !this.reverseComplement ? i - startCoord : endCoord - i;
                if (bases[index] != 'N') continue;
                if (i % 2 == 0) {
                    left = !this.reverseComplement ? transformer.toPixel(new Point(i - 1, bottom)) : transformer.toPixel(new Point(i, bottom));
                    right = !this.reverseComplement ? transformer.toPixel(new Point(i, top)) : transformer.toPixel(new Point(i + 1, top));
                } else {
                    left = !this.reverseComplement ? transformer.toPixel(new Point(i - 1, top)) : transformer.toPixel(new Point(i, top));
                    right = !this.reverseComplement ? transformer.toPixel(new Point(i, bottom)) : transformer.toPixel(new Point(i + 1, bottom));
                }
                graphics.setColor(Color.red);
                graphics.drawLine(left.x, left.y, right.x, right.y);
            }
        }
    }

    private String getSequence(int startCoord, int endCoord, int strand) {
        boolean got_sequence;
        String seq = null;
        if (this.curation == null) {
            return null;
        }
        boolean bl = got_sequence = this.curation != null && this.curation.getRefSequence() != null && this.curation.getRefSequence().getResidues(startCoord, endCoord) != null;
        if (got_sequence) {
            String string = seq = !this.reverseComplement ? this.curation.getRefSequence().getResidues(startCoord, endCoord) : this.curation.getRefSequence().getResidues(endCoord, startCoord);
        }
        if (seq != null && seq.length() > 1) {
            seq = seq.toUpperCase();
            if (strand == -1 && !this.reverseComplement || strand == 1 && this.reverseComplement) {
                seq = DNAUtils.complement((String)seq);
            }
        } else {
            seq = null;
        }
        return seq;
    }

    private Color[] buildBaseColorArray(int startCoord, int endCoord, int strand) {
        Color[] base_colors = new Color[endCoord - startCoord + 2];
        Selection selection = ((ApolloPanelI)((Object)this.getComponent())).getSelection();
        PropertyScheme ps = Config.getPropertyScheme();
        boolean doneWarn = false;
        for (int base_position = startCoord; base_position <= endCoord; ++base_position) {
            SeqFeatureI selected = null;
            Color color = this.getBaseColor(base_position);
            for (int i = 0; i < selection.size() && selected == null; ++i) {
                String type;
                SeqFeatureI sf = selection.getSelectedData(i);
                selected = this.featureContains(sf, base_position);
                if (selected == null || sf.getStrand() != strand && sf.getStrand() != 0 || (color = DrawableUtil.getFeatureColor(sf, ps.getFeatureProperty(type = sf.getTopLevelType()))) != Color.black || doneWarn) continue;
                System.err.println("WARNING: Color of feature is black - this won't show in ScaleView");
                doneWarn = true;
            }
            int index = !this.reverseComplement ? base_position - startCoord : endCoord - base_position;
            base_colors[index] = color;
        }
        return base_colors;
    }

    private Color getBaseColor(int base_position) {
        return this.curation.getRefSequence().isSequencingErrorPosition(base_position) ? new Color(255, 215, 0) : Color.black;
    }

    private Color[] buildSiteColorArray(int startCoord, int endCoord, int siteLow, int siteHigh, Color site_color) {
        Color[] base_colors = new Color[endCoord - startCoord + 2];
        for (int base_position = startCoord; base_position <= endCoord; ++base_position) {
            int index = !this.reverseComplement ? base_position - startCoord : endCoord - base_position;
            base_colors[index] = base_position >= siteLow && base_position <= siteHigh ? site_color : Color.black;
        }
        return base_colors;
    }

    public void select(Selection selection) {
    }

    public void showPopupMenu(MouseEvent evt) {
        ScaleMenu popup = new ScaleMenu(this, new Point(evt.getX(), evt.getY()));
        popup.show((Component)evt.getSource(), evt.getX(), evt.getY());
    }

    public Action getColouringAction() {
        return this.colouringManager.getAction();
    }

    public Selection findFeaturesForSelection(Rectangle rect) {
        Selection selection = new Selection();
        if (!this.isVisible()) {
            return selection;
        }
        int strand = this.positionRelativeToAxis(rect.y, rect.y + rect.height);
        if (strand == 0) {
            return selection;
        }
        ViewI focus = ((ApolloPanelI)((Object)this.getComponent())).getFocus();
        int clickPos = rect.getLocation().x;
        int endBase = focus.getTransform().toUser((int)((int)((double)(clickPos - 2) + rect.getWidth())), (int)0).x + 1;
        int startBase = focus.getTransform().toUser((int)(clickPos + 2), (int)0).x + 1;
        if (Math.abs(endBase - startBase) < 2) {
            return selection;
        }
        StrandedZoomableApolloPanel szap = ((ApolloPanelI)((Object)this.getComponent())).getStrandedZoomableApolloPanel();
        SequenceI refSeq = szap.getCurationSet().getRefSequence();
        String residues = "";
        if (strand == 1) {
            residues = refSeq.getResidues(startBase, endBase);
        } else if (strand == -1) {
            residues = refSeq.getResidues(endBase, startBase);
        }
        this.setSelectedRange(startBase, endBase, strand);
        String revStrand = this.reverseComplement && strand == 1 || !this.reverseComplement && strand == -1 ? " (reverse strand)" : "";
        String seqName = refSeq.getName() + revStrand + " from " + startBase + " to " + endBase;
        if (residues.length() > this.maxSeqSelection) {
            this.saveSeqAsFile(residues, seqName);
            return selection;
        }
        Sequence seq = new Sequence("Sequence selection", residues);
        SeqFeature seqsel = new SeqFeature(startBase, endBase, "Sequence selection", strand);
        seqsel.setStart(0);
        seqsel.setEnd(residues.length());
        seqsel.setRefSequence(seq);
        seqsel.setName(seqName);
        SelectionItem si = new SelectionItem(this, seqsel);
        selection.add(si);
        new SeqExport(selection, ((ApolloPanelI)((Object)this.getComponent())).getController());
        return selection;
    }

    private int positionRelativeToAxis(int top_y, int bottom_y) {
        int tolerance = 10;
        int topOfScale = this.getBounds().y;
        int bottomOfScale = this.getBounds().y + this.getBounds().height;
        if (top_y < topOfScale - tolerance) {
            return 0;
        }
        if (top_y > bottomOfScale + tolerance || bottom_y > bottomOfScale + tolerance) {
            return 0;
        }
        Point axis_pos = this.transformer.toPixel(new Point(0, 3));
        int strand = 1;
        if (top_y >= axis_pos.y) {
            strand = -1;
        }
        return strand;
    }

    private void drawSites(Graphics graphics, Transformer transformer, int startCoord, int endCoord, int viewY, int strand) {
        Enumeration colors = this.sites.keys();
        while (colors.hasMoreElements()) {
            Color color = (Color)colors.nextElement();
            Vector[] cuts_array = (Vector[])this.sites.get(color);
            Vector cut_sites = strand == 1 ? cuts_array[0] : cuts_array[1];
            int cut_count = cut_sites.size();
            for (int i = 0; i < cut_count; ++i) {
                int[] zone = (int[])cut_sites.elementAt(i);
                if (zone[0] > endCoord || zone[1] <= startCoord) continue;
                this.drawSite(graphics, transformer, zone[0], zone[1], viewY, 10, color);
            }
        }
    }

    private void drawSites(Graphics graphics, Transformer transformer, int startCoord, int endCoord, String seq, int offset, int viewY, int strand) {
        if (seq != null) {
            Enumeration colors = this.sites.keys();
            while (colors.hasMoreElements()) {
                Color color = (Color)colors.nextElement();
                Vector[] cuts_array = (Vector[])this.sites.get(color);
                Vector cut_sites = strand == 1 ? cuts_array[0] : cuts_array[1];
                int cut_count = cut_sites.size();
                for (int i = 0; i < cut_count; ++i) {
                    int[] zone = (int[])cut_sites.elementAt(i);
                    if (zone[0] > endCoord || zone[1] <= startCoord) continue;
                    Color[] site_colors = this.buildSiteColorArray(startCoord, endCoord, zone[0], zone[1], color);
                    this.drawFeatureBases(graphics, transformer, startCoord, endCoord, seq, offset, viewY, strand, site_colors);
                }
            }
        }
    }

    private void drawSequencingEdits(Graphics graphics, Transformer transformer, int startCoord, int endCoord) {
        HashMap edits;
        if (this.curation != null && this.curation.getRefSequence() != null && (edits = this.curation.getRefSequence().getGenomicErrors()) != null) {
            Iterator positions = edits.keySet().iterator();
            while (positions.hasNext()) {
                String position = (String)positions.next();
                int pos = Integer.parseInt(position);
                if (pos > endCoord || pos <= startCoord) continue;
                int y_pixel = transformer.toPixelY(-10);
                int height = transformer.toPixelY(15);
                int x_pixel = transformer.toPixelX(this.reverseComplement ? pos : pos - 1);
                int width = this.calcWidth(x_pixel, this.reverseComplement ? pos + 1 : pos);
                graphics.setColor(Config.getStyle().getSeqErrorColor());
                graphics.fillRect(x_pixel, y_pixel, width, height);
            }
        }
    }

    private void setRangeThatHasSequence() {
        if (this.curation != null && this.curation.getRefSequence() != null) {
            RangeI refSeqRange = this.curation.getRefSequence().getRange();
            this.startOfRange = refSeqRange.getLow();
            this.endOfRange = refSeqRange.getHigh();
        }
    }

    private void drawOutOfRangeLines(Graphics graphics, Transformer transformer, int startCoord, int endCoord) {
        int width;
        int x_pixel;
        int height;
        int y_pixel;
        if (this.startOfRange > startCoord) {
            y_pixel = transformer.toPixelY(-10);
            height = transformer.toPixelY(10) - y_pixel + 1;
            x_pixel = transformer.toPixelX(this.startOfRange - 1);
            width = this.calcWidth(x_pixel, this.reverseComplement ? this.startOfRange - 1 : this.startOfRange);
            graphics.setColor(Color.green);
            graphics.fillRect(x_pixel, y_pixel, width, height);
        }
        if (this.endOfRange < endCoord) {
            y_pixel = transformer.toPixelY(-10);
            height = transformer.toPixelY(10) - y_pixel + 1;
            x_pixel = transformer.toPixelX(this.endOfRange);
            width = this.calcWidth(x_pixel, this.reverseComplement ? this.endOfRange : this.endOfRange + 1);
            graphics.setColor(Color.red);
            graphics.fillRect(x_pixel, y_pixel, width, height);
        }
    }

    public Selection findFeaturesForSelection(Point p, boolean selectParents) {
        return this.findFeaturesForSelection(this.getSelectionRectangle(p));
    }

    private int calcWidth(int x_pixel, int endCoord) {
        int end_x = this.reverseComplement ? endCoord : endCoord - 1;
        return Math.max(Math.abs(x_pixel - this.transformer.toPixelX(end_x)), 1);
    }

    private void saveSeqAsFile(String residues, String description) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Save selected sequence as a FASTA file");
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(FastaFile.format(">" + description + "\n", residues, 50));
                writer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Couldn't write sequence to " + file);
            }
        }
    }

    class ScaleColouringManager {
        private int colouring = 2;
        private ColouringAction action = new ColouringAction(this.getColouringMenuString());

        public ScaleColouringManager() {
            this.action.setEnabled(true);
        }

        public Action getAction() {
            return this.action;
        }

        public int getColouringMode() {
            return this.colouring;
        }

        private String getColouringMenuString() {
            if (this.colouring == 2) {
                return "Color bases by splice site potential";
            }
            return "Color by selected feature";
        }

        class ColouringAction
        extends AbstractAction {
            public ColouringAction(String name) {
                super(name);
            }

            public void actionPerformed(ActionEvent evt) {
                if (ScaleColouringManager.this.colouring == 2) {
                    ScaleColouringManager.this.colouring = 1;
                } else {
                    ScaleColouringManager.this.colouring = 2;
                }
                this.putValue("Name", ScaleColouringManager.this.getColouringMenuString());
                ScaleView.this.getComponent().repaint();
            }
        }
    }
}

