/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.TierManagerI;
import apollo.gui.drawable.Drawable;
import apollo.gui.genomemap.DrawableTierManagerI;
import apollo.gui.genomemap.LinearView;
import apollo.gui.genomemap.ManagedViewI;
import apollo.gui.genomemap.PixelMask;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class ManagedView
extends LinearView
implements ManagedViewI {
    protected TierManagerI manager = null;
    protected Vector visibleDrawables = null;
    protected int leadSpaceSize = 2;
    protected int dropSpaceSize = 0;

    public ManagedView(JComponent ap, String name, boolean visible) {
        super(ap, name, visible);
    }

    public void setTierManager(TierManagerI ftm) {
        this.manager = ftm;
        this.manager.setView(this);
        this.updateManagerHeight();
        this.setInvalidity(true);
        if (this.isVisible()) {
            this.getComponent().repaint();
        }
    }

    public TierManagerI getTierManager() {
        return this.manager;
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.updateManagerHeight();
    }

    protected void updateManagerHeight() {
        if (this.manager != null) {
            this.manager.setViewHeight(this.transformer.getPixelBounds().height - this.getDropSpaceSize());
            this.transformer.setYRange(this.getYRange());
        }
    }

    protected int[] getYRange() {
        int[] managerrange = this.manager.getYRange();
        managerrange[0] = (int)((long)managerrange[0] - (long)this.getLeadSpaceSize() * 10L);
        managerrange[1] = (int)((long)managerrange[1] + (long)this.getDropSpaceSize() * 10L);
        return managerrange;
    }

    public int getLeadSpaceSize() {
        return this.leadSpaceSize;
    }

    public void setLeadSpaceSize(int size) {
        this.leadSpaceSize = size;
    }

    public int getDropSpaceSize() {
        return this.dropSpaceSize;
    }

    public void setDropSpaceSize(int size) {
        this.dropSpaceSize = size;
    }

    public void setXOrientation(int direction) {
        switch (direction) {
            case -1: 
            case 1: {
                this.getTransform().setXOrientation(direction);
                break;
            }
            default: {
                System.out.println("Unknown direction in setXOrientation");
            }
        }
        this.setInvalidity(true);
    }

    public void setYOrientation(int direction) {
        switch (direction) {
            case -1: 
            case 1: {
                this.getTransform().setYOrientation(direction);
                break;
            }
            default: {
                System.out.println("Unknown direction in setYOrientation");
            }
        }
    }

    public void clear() {
        this.visibleDrawables = null;
        this.manager = null;
    }

    public Vector getVisibleDrawables() {
        Vector them = null;
        if (this.manager != null) {
            try {
                int[] visible_range = this.transformer.getXVisibleRange();
                them = ((DrawableTierManagerI)this.manager).getVisibleDrawables(visible_range);
            }
            catch (Exception e) {
                System.out.println("Manager for view " + this.getName() + " " + this.getClass().getName() + " is not a DrawableTierManagerI, but is a " + this.manager.getClass().getName());
                new Throwable().printStackTrace();
            }
        } else {
            System.err.println("The manager is null!");
        }
        return them;
    }

    public void paintView() {
        if (this.graphics == null) {
            return;
        }
        this.graphics.setColor(this.getBackgroundColour());
        if (!this.transparent) {
            this.graphics.fillRect(this.transformer.getPixelBounds().x, this.transformer.getPixelBounds().y, this.transformer.getPixelBounds().width, this.transformer.getPixelBounds().height);
        }
        this.paintDrawables();
    }

    protected void paintDrawables() {
        int visFeatSize;
        if (this.isInvalid()) {
            this.visibleDrawables = this.getVisibleDrawables();
        }
        int n = visFeatSize = this.visibleDrawables == null ? 0 : this.visibleDrawables.size();
        if (visFeatSize == 0) {
            return;
        }
        int i = 0;
        int maxTierNum = this.manager.getMaxVisibleTierNumber();
        PixelMask mask = new PixelMask(maxTierNum, this.transformer.getPixelBounds().width);
        for (i = 0; i < visFeatSize; ++i) {
            Vector curVis = (Vector)this.visibleDrawables.elementAt(i);
            int curVisSize = curVis != null ? curVis.size() : 0;
            for (int j = 0; j < curVisSize; ++j) {
                Drawable dsf = (Drawable)curVis.elementAt(j);
                dsf.draw(this.graphics, this.transformer, this.manager, mask);
            }
        }
    }
}

