/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.FeatureProperty;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.Tier;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import java.awt.Color;
import java.util.Vector;

public class FeatureTier
extends Tier {
    private Vector drawables = new Vector();
    int min_pos;
    int max_pos;
    int max_pix;
    int textEnd = -1;
    int charHeight;
    int totalHeight;
    String tier_label;

    public void addFeature(Drawable dsf, Transformer transformer) {
        int insLoc = this.getLocation(dsf);
        this.drawables.insertElementAt(dsf, insLoc);
        if (dsf.getLow() < this.min_pos) {
            this.min_pos = dsf.getLow();
        }
        if (dsf.getHigh() > this.max_pos) {
            this.max_pos = dsf.getHigh();
            SeqFeatureI sf = dsf.getFeature();
            FeatureProperty fp = dsf.getFeatureProperty();
            Transformer.PixelRange pixRng = transformer.basepairRangeToPixelRange(sf);
            pixRng.ensureMinimumWidth(fp.getMinWidth());
            this.max_pix = pixRng.hi;
        }
    }

    public int getLocation(Drawable dsf) {
        int bot = 0;
        int top = this.drawables.size() - 1;
        int low = dsf.getLow();
        int high = dsf.getHigh();
        while (bot <= top) {
            int mid = (bot + top) / 2;
            Drawable midFeature = (Drawable)this.drawables.elementAt(mid);
            int midLow = midFeature.getLow();
            int cmp = 0;
            if (midLow > low) {
                cmp = 1;
            } else if (midLow < low) {
                cmp = -1;
            }
            if (cmp == 0) {
                int midHigh = midFeature.getHigh();
                if (midHigh > high) {
                    cmp = 1;
                } else if (midHigh < high) {
                    cmp = -1;
                }
            }
            if (cmp < 0) {
                bot = mid + 1;
                continue;
            }
            if (cmp > 0) {
                top = mid - 1;
                continue;
            }
            return mid;
        }
        return bot;
    }

    public int size() {
        return this.drawables.size();
    }

    public void removeDrawable(Drawable dsf) {
        this.drawables.removeElement(dsf);
    }

    void clearDrawables() {
        this.drawables = null;
    }

    public Vector getDrawables() {
        return this.drawables;
    }

    public int getHigh() {
        return this.max_pos;
    }

    public int getPixelHigh() {
        return this.max_pix;
    }

    public Drawable getDrawableAt(int i) {
        return (Drawable)this.drawables.elementAt(i);
    }

    public FeatureProperty getFeatureProperty() {
        FeatureProperty fp = null;
        if (this.size() > 0) {
            Drawable dsf = (Drawable)this.drawables.elementAt(0);
            fp = dsf.getFeatureProperty();
        }
        return fp;
    }

    public void setTierLabel(Drawable dsf) {
        if (dsf != null && dsf.getFeatureProperty() != null) {
            this.tier_label = dsf.getFeatureProperty().getDisplayType();
        } else if (dsf != null) {
            System.err.println("Feature Property for tier " + dsf.getType() + " is null");
        }
    }

    public String getTierLabel() {
        if (this.tier_label == null && this.size() > 0) {
            this.setTierLabel((Drawable)this.drawables.elementAt(0));
        }
        return this.tier_label;
    }

    public Color getColour() {
        Color color = null;
        if (this.size() > 0) {
            Drawable dsf = (Drawable)this.drawables.elementAt(0);
            if (dsf.getFeatureProperty() != null) {
                color = dsf.getFeatureProperty().getColour();
            } else {
                System.err.println("Feature Property for tier " + dsf.getType() + " is null");
            }
        }
        return color;
    }

    public boolean isLabeled() {
        boolean labeled = false;
        if (this.size() > 0) {
            Drawable dsf = (Drawable)this.drawables.elementAt(0);
            if (dsf.getFeatureProperty() != null && dsf.getFeatureProperty().getTier() != null) {
                labeled = dsf.getFeatureProperty().getTier().isLabeled();
            } else {
                System.err.println("Feature Property for tier " + dsf.getType() + " is null");
            }
        }
        return labeled;
    }

    public String toString() {
        StringBuffer tmpstr = new StringBuffer();
        for (int i = 0; i < this.drawables.size(); ++i) {
            Drawable sf = (Drawable)this.drawables.elementAt(i);
            tmpstr.append("Feature " + i + ". Limits " + sf.getLow() + " " + sf.getHigh() + "\n");
        }
        return tmpstr.toString();
    }

    public int getTextEnd() {
        return this.textEnd;
    }

    public void setTextEnd(int newEnd) {
        this.textEnd = newEnd;
    }
}

