/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.FeatureProperty;
import apollo.gui.Selection;
import apollo.gui.TierManagerI;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableUtil;
import apollo.gui.genomemap.DragViewI;
import apollo.gui.genomemap.ManagedView;
import apollo.gui.genomemap.TierViewI;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;

public class DragView
extends ManagedView
implements DragViewI {
    TierViewI originView;
    Point originPoint;
    Point relativePosition;
    Color hotspotColor = Color.yellow;
    boolean inHotspot = false;
    int hotspotType = 0;
    Selection selection;
    protected Vector drawables = new Vector();
    public static int EVIDENCE_HOTSPOT = 1;
    public static int OTHER_HOTSPOT = 2;

    public DragView(JComponent ap, String name, Selection selection) {
        super(ap, name, false);
        this.selection = selection;
    }

    public void setTierManager(TierManagerI manager) {
        manager.setIgnoreScoreThresholds(true);
        manager.setTierData(this.drawables);
        super.setTierManager(manager);
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void setHotspotColor(Color in) {
        this.hotspotColor = in;
    }

    public void setHotspotType(int Type2) {
        this.hotspotType = Type2;
    }

    public void setInHotspot(boolean hotspot) {
        this.inHotspot = hotspot;
    }

    public void paintView() {
        int visFeatSize;
        if (this.isInvalid() || this.visibleDrawables == null) {
            this.visibleDrawables = this.getVisibleDrawables();
        }
        int n = visFeatSize = this.visibleDrawables == null ? 0 : this.visibleDrawables.size();
        if (visFeatSize == 0) {
            return;
        }
        int i = 0;
        for (i = 0; i < visFeatSize; ++i) {
            Vector curVis = (Vector)this.visibleDrawables.elementAt(i);
            for (int j = 0; j < curVis.size(); ++j) {
                Drawable dsf = (Drawable)curVis.elementAt(j);
                if (this.inHotspot) {
                    int blue;
                    int green;
                    int red;
                    FeatureProperty fp = dsf.getFeatureProperty();
                    Color old = fp.getColour();
                    if (this.hotspotType == EVIDENCE_HOTSPOT) {
                        red = 255 - old.getRed();
                        green = 255 - old.getGreen();
                        blue = 255 - old.getBlue();
                    } else {
                        red = old.getRed() & 0x8F;
                        green = old.getGreen() & 0x8F;
                        blue = old.getBlue() & 0x8F;
                    }
                    fp.setColour(new Color(red, green, blue), true);
                    dsf.draw(this.graphics, this.transformer, this.manager);
                    fp.setColour(old, true);
                    continue;
                }
                dsf.draw(this.graphics, this.transformer, this.manager);
            }
        }
    }

    public Vector collectShadows() {
        Vector<Rectangle> shadowBoxes = new Vector<Rectangle>();
        if (this.visibleDrawables == null) {
            this.visibleDrawables = this.getVisibleDrawables();
        }
        for (int i = 0; i < this.visibleDrawables.size(); ++i) {
            Vector curVis = (Vector)this.visibleDrawables.elementAt(i);
            for (int j = 0; j < curVis.size(); ++j) {
                Drawable dsf = (Drawable)curVis.elementAt(j);
                DrawableUtil.setBoxBounds(dsf, this.transformer, this.manager);
                shadowBoxes.addElement(dsf.getBoxBounds());
            }
        }
        return shadowBoxes;
    }

    public void setOrigin(TierViewI v, Point p) {
        this.originView = v;
        this.originPoint = p;
    }

    public TierViewI getOriginView() {
        return this.originView;
    }

    public Point getOriginPosition() {
        return this.originPoint;
    }

    public void setLocation(Point p) {
        this.getBounds().x = p.x - this.relativePosition.x;
        this.getBounds().y = this.getTransform().getYOrientation() == 1 ? p.y : p.y - this.getBounds().height;
        this.setBounds(this.getBounds());
    }

    public void setRelativePosition(Point p) {
        this.relativePosition = p;
    }

    protected void setDrawables(Vector drawables) {
        if (drawables != null) {
            this.drawables = drawables;
        } else {
            drawables.clear();
        }
        if (this.manager != null) {
            this.manager.setTierData(drawables);
        }
    }
}

