/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.gui.genomemap.ApolloLayoutManager;
import apollo.gui.genomemap.ApolloPanel;
import apollo.gui.genomemap.ViewI;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Vector;

public class ColumnApolloLayout
extends ApolloLayoutManager {
    public ColumnApolloLayout() {
        this.free = null;
    }

    public void layoutViews(Container target) {
        if (target instanceof ApolloPanel) {
            ApolloPanel ap = (ApolloPanel)target;
            this.layoutViews(ap.getViews(), ap.getBounds(), 0);
        }
    }

    public void layoutViews(Vector views, Rectangle targetBounds, int startVertPos) {
        ViewI v;
        int i;
        int unmanagedHeight = 0;
        int standardHeight = 0;
        int vertPosition = startVertPos;
        Rectangle bounds = new Rectangle();
        int numHeightUnmanaged = 0;
        int numUnmanaged = 0;
        int numManaged = 0;
        int fillHeight = 0;
        int countManaged = 0;
        int countVisible = 0;
        for (i = 0; i < views.size(); ++i) {
            v = (ViewI)views.elementAt(i);
            if (!v.isVisible()) continue;
            if (this.viewmap.containsKey(v)) {
                if (((String)this.viewmap.get(v)).equals("Horizontal")) {
                    unmanagedHeight += v.getPreferredSize().height;
                    ++numHeightUnmanaged;
                } else if (((String)this.viewmap.get(v)).equals("None")) {
                    ++numUnmanaged;
                }
            } else {
                System.err.println("Warning: ColumnLayoutManager found an unmanaged view");
                ++numUnmanaged;
            }
            ++countVisible;
        }
        numManaged = countVisible - numHeightUnmanaged - numUnmanaged;
        if (numManaged != 0) {
            standardHeight = (targetBounds.height - unmanagedHeight) / numManaged;
            if (standardHeight == 0) {
                standardHeight = 1;
            }
            fillHeight = (targetBounds.height - unmanagedHeight) % standardHeight;
        }
        for (i = 0; i < views.size(); ++i) {
            v = (ViewI)views.elementAt(i);
            if (v.isVisible()) {
                if (this.viewmap.containsKey(v)) {
                    String layoutConstraint = (String)this.viewmap.get(v);
                    if (layoutConstraint.equals("None")) {
                        v.setBounds(v.getBounds());
                    } else if (layoutConstraint.equals("Horizontal")) {
                        bounds.x = 0;
                        bounds.y = vertPosition;
                        bounds.width = targetBounds.width;
                        bounds.height = v.getPreferredSize().height;
                        v.setBounds(bounds);
                        if (bounds.y != v.getBounds().y || bounds.height != v.getBounds().height) {
                            return;
                        }
                        vertPosition += v.getPreferredSize().height;
                    } else {
                        bounds.x = 0;
                        bounds.y = vertPosition;
                        bounds.width = targetBounds.width;
                        int vertPositionIncrease = bounds.height = standardHeight;
                        if (++countManaged == numManaged) {
                            bounds.height += fillHeight;
                            vertPosition += fillHeight;
                        }
                        v.setBounds(bounds);
                        vertPosition += vertPositionIncrease;
                    }
                } else if (v instanceof ViewI && !((String)this.viewmap.get(v)).equals("None")) {
                    bounds.width = targetBounds.width;
                } else {
                    v.setBounds(v.getBounds());
                }
                v.setInvalidity(true);
                continue;
            }
            bounds.x = 0;
            bounds.y = 0;
            bounds.width = targetBounds.width;
            bounds.height = 10;
            v.setBounds(bounds);
        }
    }
}

