/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.genomemap;

import apollo.config.Config;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.Selection;
import apollo.gui.SelectionManager;
import apollo.gui.StatusBar;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.event.BaseFocusListener;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.event.MouseButtonEvent;
import apollo.gui.event.OrientationEvent;
import apollo.gui.event.ReverseComplementEvent;
import apollo.gui.event.RubberbandEvent;
import apollo.gui.event.RubberbandListener;
import apollo.gui.event.ViewEvent;
import apollo.gui.event.ViewListener;
import apollo.gui.genomemap.AnnotationView;
import apollo.gui.genomemap.ApolloLayoutManager;
import apollo.gui.genomemap.ApolloPanelI;
import apollo.gui.genomemap.ContainerViewI;
import apollo.gui.genomemap.DragView;
import apollo.gui.genomemap.DragViewI;
import apollo.gui.genomemap.DropTargetViewI;
import apollo.gui.genomemap.FastClippingGraphics;
import apollo.gui.genomemap.FeatureView;
import apollo.gui.genomemap.KeyViewI;
import apollo.gui.genomemap.MouseManager;
import apollo.gui.genomemap.PickViewI;
import apollo.gui.genomemap.PopupViewI;
import apollo.gui.genomemap.ResultView;
import apollo.gui.genomemap.Rubberband;
import apollo.gui.genomemap.RubberbandRectangle;
import apollo.gui.genomemap.ScaleView;
import apollo.gui.genomemap.SelectViewI;
import apollo.gui.genomemap.SiteView;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.genomemap.TierView;
import apollo.gui.genomemap.TierViewI;
import apollo.gui.genomemap.ViewI;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.FeatureList;
import apollo.util.SwingMissingUtil;
import gov.sandia.postscript.PSGr2;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class ApolloPanel
extends JPanel
implements ApolloPanelI,
BaseFocusListener,
ControlledObjectI,
FeatureSelectionListener,
KeyListener,
MouseInputListener,
MouseWheelListener,
DataLoadListener,
RubberbandListener,
ViewListener {
    protected Image backBuffer;
    protected int backBufferWidth = 0;
    protected int backBufferHeight = 0;
    private Vector views;
    protected Vector linearViews;
    protected Vector pickViews;
    private ScaleView scaleView;
    protected ApolloLayoutManager layout_manager;
    protected Controller controller;
    protected ViewI focus;
    protected String name;
    protected boolean syncLimits = false;
    protected RubberbandRectangle rubberband;
    protected boolean inDrag = false;
    protected MouseEvent pressEvent = null;
    protected boolean inTierDrag = false;
    protected TierViewI dragTierView = null;
    protected StatusBar statusBar;
    protected Rectangle layoutBounds;
    protected boolean invalid = true;
    protected boolean allowsMovement = true;
    protected boolean showEdgeMatches = true;
    private MouseManager mouseManager;
    private SelectionManager selectionManager;
    private GuiCurationState curationState;
    static final Object ALOCK = new ApolloTreeLock();
    int count = 0;
    static /* synthetic */ Class class$apollo$gui$genomemap$FeatureView;
    static /* synthetic */ Class class$apollo$gui$genomemap$SelectViewI;
    static /* synthetic */ Class class$apollo$gui$genomemap$ViewI;
    static /* synthetic */ Class class$apollo$gui$genomemap$TierViewI;
    static /* synthetic */ Class class$apollo$gui$genomemap$StrandedZoomableApolloPanel;

    ApolloPanel(String name, GuiCurationState curationState) {
        this.setName(name);
        this.curationState = curationState;
        this.setSelectionManager(curationState.getSelectionManager());
        this.views = new Vector();
        this.linearViews = new Vector();
        this.pickViews = new Vector();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.rubberband = new RubberbandRectangle(this);
        this.rubberband.setActive(true);
        this.rubberband.addListener(this);
        this.setOpaque(false);
    }

    private void clearViews(boolean justFeatures) {
        int i;
        if (this.views == null) {
            return;
        }
        ArrayList featViews = this.getFeatureViews();
        for (i = 0; i < featViews.size(); ++i) {
            FeatureView fv = (FeatureView)featViews.get(i);
            if (justFeatures) {
                fv.clearFeatures();
                continue;
            }
            fv.clear();
        }
        if (!justFeatures) {
            for (i = 0; i < this.views.size(); ++i) {
                this.remove((ViewI)this.views.elementAt(i));
            }
        }
    }

    private ArrayList getFeatureViews() {
        if (this.views == null) {
            return null;
        }
        ArrayList featViews = new ArrayList(4);
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI view = (ViewI)this.views.elementAt(i);
            if (view instanceof FeatureView) {
                featViews.add(this.views.elementAt(i));
            }
            if (!(view instanceof ContainerViewI)) continue;
            Vector fViews = ((ContainerViewI)((Object)view)).getViewsOfClass(class$apollo$gui$genomemap$FeatureView == null ? ApolloPanel.class$("apollo.gui.genomemap.FeatureView") : class$apollo$gui$genomemap$FeatureView);
            featViews.addAll(fViews);
        }
        return featViews;
    }

    void clearFeatures() {
        this.clearViews(true);
    }

    public final synchronized Object getApolloLock() {
        return ALOCK;
    }

    public void add(ViewI view, Object constraints) {
        this.views.addElement(view);
        if (view instanceof ViewI && !(view instanceof DragViewI)) {
            this.linearViews.addElement(view);
        }
        if (view instanceof PickViewI && !(view instanceof DragViewI)) {
            this.pickViews.addElement(view);
        }
        if (this.layout_manager != null) {
            this.layout_manager.addLayoutView(view, constraints);
        }
        view.addViewListener(this);
    }

    public void add(ViewI view) {
        this.add(view, null);
    }

    public void setScaleView(ScaleView scale) {
        this.scaleView = scale;
    }

    public void setLayout(ApolloLayoutManager manager) {
        super.setLayout(manager);
        this.layout_manager = manager;
        this.invalidate();
        this.validate();
    }

    public void remove(ViewI view) {
        boolean found = false;
        if (this.views.contains(view)) {
            this.views.removeElement(view);
            found = true;
        }
        if (this.linearViews.contains(view)) {
            this.linearViews.removeElement(view);
        }
        if (this.pickViews.contains(view)) {
            this.pickViews.removeElement(view);
        }
        if (this.layout_manager != null) {
            this.layout_manager.removeLayoutView(view);
        }
        if (found) {
            this.invalidate();
            this.validate();
        }
    }

    public void putVerticalScrollbarsAtStart() {
        for (int i = 0; i < this.linearViews.size(); ++i) {
            ViewI lv = (ViewI)this.linearViews.elementAt(i);
            if (lv instanceof ResultView) {
                ((ResultView)lv).putScrollAtStart();
                continue;
            }
            if (!(lv instanceof AnnotationView)) continue;
            ((AnnotationView)lv).putScrollAtStart();
        }
    }

    public void setSyncLimits(boolean state) {
        this.syncLimits = state;
        if (this.syncLimits) {
            this.syncViewLimits(-1, -1);
        }
    }

    public void setSyncLimits(boolean state, int reglow, int reghigh) {
        this.syncLimits = state;
        if (this.syncLimits) {
            this.syncViewLimits(reglow, reghigh);
        }
    }

    public boolean isSynced() {
        return this.syncLimits;
    }

    protected void syncViewLimits(int reglow, int reghigh) {
        ViewI lv;
        int i;
        int[] globalLimits = new int[2];
        if (reglow < 0) {
            for (i = 0; i < this.linearViews.size(); ++i) {
                lv = (ViewI)this.linearViews.elementAt(i);
                if (!lv.areLimitsSet()) continue;
                if (i == 0 || lv.getLimits()[0] < globalLimits[0]) {
                    globalLimits[0] = lv.getLimits()[0];
                }
                if (i != 0 && lv.getLimits()[1] <= globalLimits[1]) continue;
                globalLimits[1] = lv.getLimits()[1];
            }
        } else {
            int hspace = (reghigh - reglow) / 100;
            globalLimits[0] = reglow - hspace;
            globalLimits[1] = reghigh + hspace;
        }
        for (i = 0; i < this.linearViews.size(); ++i) {
            lv = (ViewI)this.linearViews.elementAt(i);
            lv.setLimits(globalLimits);
            lv.setZoomFactor(1.0);
        }
        this.setLinearCentre((globalLimits[1] + globalLimits[0]) / 2);
    }

    public void setLinearCentre(int Position2) {
        if (this.allowsMovement) {
            if (this.isSynced()) {
                for (int i = 0; i < this.linearViews.size(); ++i) {
                    ViewI lv = (ViewI)this.linearViews.elementAt(i);
                    lv.setCentre(Position2);
                }
            } else {
                this.focus.setCentre(Position2);
            }
        }
        this.repaint();
    }

    public void setMovementAllowed(boolean state) {
        this.allowsMovement = state;
    }

    public int getLinearCentre() {
        if (this.isSynced()) {
            return ((ViewI)this.linearViews.elementAt(0)).getCentre();
        }
        return this.focus.getCentre();
    }

    public int getLinearMinimum() {
        if (this.isSynced()) {
            return ((ViewI)this.linearViews.elementAt(0)).getMinimum();
        }
        return this.focus.getMinimum();
    }

    public int getLinearMaximum() {
        if (this.isSynced()) {
            return ((ViewI)this.linearViews.elementAt(0)).getMaximum();
        }
        return this.focus.getMaximum();
    }

    public void setVisible(boolean state) {
        super.setVisible(state);
        this.backBuffer = this.createImage(1, 1);
    }

    public int getVisibleBasepairWidth() {
        int lv_width = -1;
        if (this.isSynced()) {
            ViewI lv = null;
            for (int i = 0; i < this.linearViews.size() && lv == null; ++i) {
                lv = ((ViewI)this.linearViews.elementAt(i)).isVisible() ? (ViewI)this.linearViews.elementAt(i) : null;
            }
            if (lv != null) {
                int[] lims = lv.getVisibleRange();
                lv_width = lims[1] - lims[0];
            }
        } else {
            int[] lims = this.focus.getVisibleRange();
            lv_width = lims[1] - lims[0];
        }
        return lv_width;
    }

    public void setZoomFactor(double xFactor, double yFactor) {
        if (this.isSynced()) {
            for (int i = 0; i < this.linearViews.size(); ++i) {
                ViewI lv = (ViewI)this.linearViews.elementAt(i);
                if (!(xFactor > 0.0)) continue;
                lv.setZoomFactor(xFactor);
            }
        }
        this.repaint();
    }

    public void setZoomFactorX(double xFactor) {
        this.setZoomFactor(xFactor, -1.0);
    }

    public void setZoomFactorY(double yFactor) {
        this.setZoomFactor(-1.0, yFactor);
    }

    public void setController(Controller controller) {
        this.controller = controller;
        controller.addListener(this);
        for (int i = 0; i < this.views.size(); ++i) {
            if (!(this.views.elementAt(i) instanceof ControlledObjectI)) continue;
            ControlledObjectI cti = (ControlledObjectI)this.views.elementAt(i);
            cti.setController(controller);
        }
    }

    private void setSelectionManager(SelectionManager sm) {
        this.selectionManager = sm;
        this.mouseManager = new MouseManager(this, this.getCurationState());
    }

    private GuiCurationState getCurationState() {
        return this.curationState;
    }

    public Selection getSelection() {
        return this.selectionManager.getSelection();
    }

    public Controller getController() {
        return this.controller;
    }

    public Object getControllerWindow() {
        return SwingMissingUtil.getWindowAncestor(this);
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    public void print(File file, String orientation, String scale) {
        try {
            PrintWriter fw = new PrintWriter(new FileWriter(file));
            PSGr2 psg = new PSGr2((Writer)fw);
            double scaleVal = 1.0;
            try {
                scaleVal = new Double(scale);
            }
            catch (Exception e) {
                System.out.println("Invalid scale factor");
                return;
            }
            if (orientation.equals("landscape")) {
                fw.println("-30 30 translate");
                fw.println("90 rotate");
                fw.println("" + (int)(30.0 * scaleVal) + " " + (int)(-822.0 * scaleVal) + " translate");
                fw.println("" + scale + " " + scale + " scale");
            } else {
                fw.println("-30 30 translate");
                int yOffset = (int)(762.0 - 792.0 * scaleVal);
                fw.println("30 " + yOffset + " translate");
                fw.println("" + scale + " " + scale + " scale");
            }
            for (int i = 0; i < this.views.size(); ++i) {
                ((ViewI)this.views.elementAt(i)).setInvalidity(true);
            }
            psg.setClip(new Rectangle(0, 0, this.getSize().width, this.getSize().height));
            this.paintComponent((Graphics)psg);
            psg.dispose();
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Failed printing to file " + file);
        }
    }

    public void paintComponent(Graphics g) {
        ViewI v;
        int i;
        Rectangle clipRect = null;
        Vector damagedViews = null;
        Rectangle damage = g.getClipBounds();
        damagedViews = this.getViews(damage);
        Graphics fg = Config.useFastClipGraphics() && !(g instanceof PSGr2) ? new FastClippingGraphics(g) : g;
        fg.setFont(Config.getDefaultFont());
        for (i = 0; i < damagedViews.size(); ++i) {
            v = (ViewI)damagedViews.elementAt(i);
            if (v.isInvalid()) continue;
            v.setGraphics(fg);
            clipRect = v.getBounds().intersection(damage);
            fg.setClip(clipRect);
            v.paintView();
        }
        fg.setClip(damage);
        for (i = 0; i < this.views.size(); ++i) {
            v = (ViewI)this.views.elementAt(i);
            if (!v.isInvalid() || v instanceof DragViewI || !v.isVisible()) continue;
            v.setGraphics(fg);
            fg.setClip(v.getBounds());
            v.paintView();
            damage = damage.union(v.getBounds());
            v.setInvalidity(false);
        }
        for (i = 0; i < this.views.size(); ++i) {
            v = (ViewI)this.views.elementAt(i);
            if (!(v instanceof DragViewI)) continue;
            Rectangle draggyBounds = new Rectangle(v.getBounds());
            Rectangle panelBounds = this.getBounds();
            if (draggyBounds.x < 0) {
                draggyBounds.x = 0;
            }
            if (draggyBounds.y < 0) {
                draggyBounds.y = 0;
            }
            if (draggyBounds.x > panelBounds.width) {
                draggyBounds.x = panelBounds.width;
            }
            if (draggyBounds.y > panelBounds.height) {
                draggyBounds.y = panelBounds.height;
            }
            if (draggyBounds.x + draggyBounds.width > panelBounds.width) {
                draggyBounds.width = panelBounds.width - draggyBounds.x;
            }
            if (draggyBounds.y + draggyBounds.height > panelBounds.height) {
                draggyBounds.height = panelBounds.height - draggyBounds.y;
            }
            fg.setClip(draggyBounds);
            v.setGraphics(fg);
            v.paintView();
            damage = damage.union(v.getBounds());
            v.setInvalidity(false);
        }
        fg.setClip(damage);
    }

    public void doLayout() {
        ++this.count;
        if (this.count < 3) {
            boolean isInvalid = false;
            for (int i = 0; i < this.views.size() && !isInvalid; ++i) {
                ViewI v = (ViewI)this.views.elementAt(i);
                if (!v.isInvalid() || !v.isVisible()) continue;
                isInvalid = true;
            }
            boolean bl = isInvalid = isInvalid || this.invalid;
            if (this.layout_manager != null && (!this.getBounds().equals(this.layoutBounds) || isInvalid)) {
                this.layout_manager.layoutViews(this);
                this.layout_manager.layoutContainer(this);
                this.layoutBounds = new Rectangle(this.getBounds());
            }
            --this.count;
        } else {
            System.out.println("Warning: recursive doLayout() call.");
            this.count = 0;
        }
    }

    public void setViewGraphics(Graphics g) {
    }

    public void setInvalidity(boolean state) {
        this.invalid = state;
    }

    public Graphics getViewGraphics() {
        return null;
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = new String(name);
    }

    protected ViewI getViewAt(Point p) {
        ViewI retview = null;
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (v instanceof DragViewI || !v.getBounds().contains(p) || !v.isVisible()) continue;
            if (v instanceof ContainerViewI) {
                v = ((ContainerViewI)((Object)v)).getContainedViewAt(p);
            }
            if (retview != null) {
                System.err.println("Warning: Overlapping non drag views (" + v.getName() + " and " + retview.getName() + ") in getViewAt()");
            }
            retview = v;
        }
        return retview;
    }

    protected void setFocusView(ViewI focus) {
        this.focus = focus;
    }

    public ViewI getFocus() {
        return this.focus;
    }

    public boolean handleDataLoadEvent(DataLoadEvent evt) {
        this.clearSelection();
        this.updateSelection();
        return true;
    }

    private void updateSelection() {
        this.fireFeatureSelectionEvent(this.getSelection());
        this.repaint();
    }

    private void fireFeatureSelectionEvent(Selection sel) {
        FeatureSelectionEvent evt = new FeatureSelectionEvent((Object)this, sel);
        this.controller.handleFeatureSelectionEvent(evt);
    }

    public boolean handleViewEvent(ViewEvent evt) {
        if (evt.getType() == 1 && this.isSynced()) {
            this.syncViewLimits(-1, -1);
        }
        return true;
    }

    public boolean handleBaseFocusEvent(BaseFocusEvent evt) {
        return true;
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
        boolean alreadyProcessed = false;
        if (evt.getSource() == this) {
            alreadyProcessed = true;
        }
        if (!alreadyProcessed) {
            for (int i = 0; i < this.views.size(); ++i) {
                ViewI v = (ViewI)this.views.elementAt(i);
                if (v instanceof SelectViewI && v.isVisible()) {
                    SelectViewI sv = (SelectViewI)v;
                    sv.select(evt.getSelection());
                    continue;
                }
                if (!(v instanceof ContainerViewI)) continue;
                Vector svs = ((ContainerViewI)((Object)v)).getViewsOfClass(class$apollo$gui$genomemap$SelectViewI == null ? ApolloPanel.class$("apollo.gui.genomemap.SelectViewI") : class$apollo$gui$genomemap$SelectViewI);
                for (int j = 0; j < svs.size(); ++j) {
                    SelectViewI sv = (SelectViewI)svs.elementAt(j);
                    sv.select(evt.getSelection());
                }
            }
        }
        this.processSelection(evt.getSelection());
        this.getStrandedZoomableApolloPanel().scrollToSelection();
        return true;
    }

    void verticalScrollToSelection() {
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (v instanceof SelectViewI && v.isVisible()) {
                SelectViewI sv = (SelectViewI)v;
                sv.verticalScrollToSelection();
                continue;
            }
            if (!(v instanceof ContainerViewI)) continue;
            Vector svs = ((ContainerViewI)((Object)v)).getViewsOfClass(class$apollo$gui$genomemap$SelectViewI == null ? ApolloPanel.class$("apollo.gui.genomemap.SelectViewI") : class$apollo$gui$genomemap$SelectViewI);
            for (int j = 0; j < svs.size(); ++j) {
                SelectViewI sv = (SelectViewI)svs.elementAt(j);
                sv.verticalScrollToSelection();
            }
        }
    }

    private void fireBaseFocusEvent(int focus) {
        BaseFocusEvent evt = new BaseFocusEvent(this, focus, null);
        this.controller.handleBaseFocusEvent(evt);
    }

    public void highlightEdges(Selection sel, boolean state) {
        if (this.showEdgeMatches) {
            this.clearEdges();
            for (int i = 0; i < this.views.size(); ++i) {
                ViewI v = (ViewI)this.views.elementAt(i);
                if (v instanceof FeatureView) {
                    ((FeatureView)v).setMatchingEdges(sel, state);
                    continue;
                }
                if (!(v instanceof ContainerViewI)) continue;
                Vector fvs = ((ContainerViewI)((Object)v)).getViewsOfClass(class$apollo$gui$genomemap$FeatureView == null ? ApolloPanel.class$("apollo.gui.genomemap.FeatureView") : class$apollo$gui$genomemap$FeatureView);
                for (int j = 0; j < fvs.size(); ++j) {
                    ((FeatureView)fvs.elementAt(j)).setMatchingEdges(sel, state);
                }
            }
        }
    }

    public void setEdgeMatching(boolean state) {
        this.showEdgeMatches = state;
        if (state) {
            this.highlightEdges(this.getSelection(), true);
        } else {
            this.clearEdges();
        }
        this.repaint();
    }

    public void clearEdges() {
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (v instanceof FeatureView) {
                ((FeatureView)v).clearEdges();
                continue;
            }
            if (!(v instanceof ContainerViewI)) continue;
            Vector fvs = ((ContainerViewI)((Object)v)).getViewsOfClass(class$apollo$gui$genomemap$FeatureView == null ? ApolloPanel.class$("apollo.gui.genomemap.FeatureView") : class$apollo$gui$genomemap$FeatureView);
            for (int j = 0; j < fvs.size(); ++j) {
                ((FeatureView)fvs.elementAt(j)).clearEdges();
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (this.focus != null && this.focus instanceof TierView) {
            TierView tv = (TierView)this.focus;
            tv.moveScrollbarByWheelAmount(evt.getWheelRotation());
        }
    }

    public void mouseEntered(MouseEvent evt) {
        this.requestFocusInWindow();
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        if (MouseButtonEvent.isMiddleMouseClickNoShift(evt)) {
            this.doMiddleClick(evt);
        } else if (MouseButtonEvent.isLeftMouseClick(evt)) {
            this.doLeftClick(evt);
            this.processSelection(this.getSelection());
        }
    }

    private void processSelection(Selection selection) {
        this.highlightEdges(selection, true);
        this.repaint();
    }

    private void doLeftClick(MouseEvent evt) {
        this.mouseManager.doLeftClick(evt);
    }

    boolean focusIsSelectable() {
        return this.focus instanceof PickViewI;
    }

    public PickViewI getPickViewFocus() {
        if (!this.focusIsSelectable()) {
            return null;
        }
        return (PickViewI)this.focus;
    }

    protected void doMiddleClick(MouseEvent evt) {
        Point base;
        ViewI v = this.findVisibleLinearView();
        if (v != null) {
            base = v.getTransform().toUser(evt.getX(), evt.getY());
        } else {
            System.err.println("Warning: No visible linearViews");
            base = ((ViewI)this.linearViews.elementAt(0)).getTransform().toUser(evt.getX(), evt.getY());
        }
        this.setLinearCentre(base.x);
        this.fireBaseFocusEvent(base.x);
    }

    private ViewI findVisibleLinearView() {
        ViewI v = null;
        for (int i = 0; i < this.linearViews.size() && v == null; ++i) {
            Vector lvs;
            ViewI tmp = (ViewI)this.linearViews.elementAt(i);
            if (!tmp.isVisible() || !((v = tmp) instanceof ContainerViewI) || (lvs = ((ContainerViewI)((Object)v)).getViewsOfClass(class$apollo$gui$genomemap$ViewI == null ? ApolloPanel.class$("apollo.gui.genomemap.ViewI") : class$apollo$gui$genomemap$ViewI)).size() == 0) continue;
            v = (ViewI)lvs.elementAt(0);
        }
        return v;
    }

    public void mousePressed(MouseEvent evt) {
        this.scaleView.clear();
        if (MouseButtonEvent.isRightMouseClickNoShift(evt)) {
            ViewI view = this.getViewAt(new Point(evt.getX(), evt.getY()));
            if (view instanceof PopupViewI) {
                if (this.getSelection().size() == 0) {
                    this.doLeftClick(evt);
                }
                ((PopupViewI)((Object)view)).showPopupMenu(evt);
            }
        } else if (MouseButtonEvent.isLeftMouseClick(evt)) {
            if (this.getSelection().size() == 0) {
                // empty if block
            }
            this.pressEvent = evt;
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (MouseButtonEvent.isLeftMouseClick(evt)) {
            if (this.inDrag) {
                this.endViewDrag(evt);
            }
        } else if (MouseButtonEvent.isRightMouseClickWithShift(evt) && this.inTierDrag) {
            this.endTierDrag(evt);
        }
    }

    private MouseEvent correctForShift(MouseEvent evt, DragViewI dv) {
        if ((evt.getModifiers() & 1) != 0) {
            return evt;
        }
        Point dropPosition = new Point(evt.getPoint());
        dropPosition.x = dv.getOriginPosition().x;
        return new MouseEvent((Component)evt.getSource(), 0, evt.getWhen(), evt.getModifiers(), dropPosition.x, dropPosition.y, evt.getClickCount(), evt.isPopupTrigger());
    }

    public void endViewDrag(MouseEvent evt) {
        if (this.inDrag) {
            DragViewI dv = this.getDragView();
            MouseEvent evt2 = this.correctForShift(evt, dv);
            Point dropPosition = new Point(evt2.getPoint());
            this.setFocusView(this.getViewAt(dropPosition));
            boolean dropSuccessful = false;
            if (this.focus instanceof DropTargetViewI) {
                dropSuccessful = ((DropTargetViewI)((Object)this.focus)).interpretDrop(dv, evt2);
            } else {
                System.err.println("Can't drop in " + this.focus);
            }
            if (dv instanceof DragView) {
                ((DragView)dv).clear();
            }
            this.remove(dv);
            if (dropSuccessful) {
                this.clearSelection();
            }
            this.inDrag = false;
            if (this.statusBar != null) {
                this.statusBar.setActionPane("");
            }
            this.repaint();
        }
    }

    public void endTierDrag(MouseEvent evt) {
        if (this.inTierDrag) {
            this.dragTierView.endTierDrag(evt);
            this.inTierDrag = false;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (MouseButtonEvent.isRightMouseClickWithShift(evt)) {
            this.doTierDrag(evt);
        } else if (MouseButtonEvent.isLeftMouseClick(evt)) {
            this.doViewDrag(evt);
        }
    }

    protected void doTierDrag(MouseEvent evt) {
        if (!this.inTierDrag) {
            TierViewI tv;
            this.mouseMoved(evt);
            if (this.focus instanceof TierViewI && (tv = (TierViewI)this.focus).allowsTierDrags() && tv.beginTierDrag(evt)) {
                this.dragTierView = tv;
                this.inTierDrag = true;
            }
        }
        if (this.inTierDrag) {
            this.dragTierView.updateTierDrag(evt);
            this.repaint();
        }
    }

    protected void doViewDrag(MouseEvent evt) {
        if (!this.inDrag && this.focus instanceof TierViewI) {
            TierViewI drag_view = (TierViewI)this.focus;
            Selection selections = drag_view.getViewSelection(this.getSelection());
            if (selections.size() != 0) {
                DragViewI dvi = drag_view.createDragView(evt, selections);
                if (dvi != null) {
                    this.add(dvi, (Object)"None");
                    this.inDrag = true;
                } else {
                    this.clearSelection();
                }
            } else if (this.pressEvent != null) {
                this.mouseClicked(this.pressEvent);
                this.pressEvent = null;
                this.mouseDragged(evt);
            }
        }
        if (this.inDrag) {
            DragViewI dv = this.getDragView();
            MouseEvent evt2 = this.correctForShift(evt, dv);
            Point newLocation = new Point(evt2.getPoint());
            dv.setLocation(newLocation);
            this.mouseMoved(evt2);
            if (this.focus instanceof DropTargetViewI && this.statusBar != null) {
                StringBuffer action = new StringBuffer();
                ((DropTargetViewI)((Object)this.focus)).interpretDrop(dv, evt2, false, action);
                if (dv instanceof DragView) {
                    DragView dfv = (DragView)dv;
                    dfv.setInHotspot(!action.toString().equals("No action"));
                    dfv.setHotspotType(action.toString().equals("Add evidence") ? DragView.EVIDENCE_HOTSPOT : DragView.OTHER_HOTSPOT);
                }
                this.statusBar.setActionPane(action.toString());
            }
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.setFocusView(this.getViewAt(new Point(evt.getX(), evt.getY())));
        ArrayList newPick = null;
        if (this.focus instanceof FeatureView) {
            if (this.focus instanceof SiteView) {
                SiteView siteFocus = (SiteView)this.focus;
                newPick = siteFocus.findFeatures(evt.getPoint());
            } else {
                FeatureView featFocus = (FeatureView)this.focus;
                newPick = featFocus.findFeatures(evt.getPoint());
            }
        }
        if (this.statusBar != null) {
            if (newPick != null && newPick.size() != 0) {
                SeqFeatureI sf = ((FeatureList)newPick).getFeature(0);
                StringBuffer barText = new StringBuffer(Config.getDisplayPrefs().getPublicName(sf));
                if (newPick.size() > 1) {
                    barText.append(" + others");
                }
                this.statusBar.setFeaturePane(barText.toString());
            } else {
                this.statusBar.setFeaturePane("");
            }
        }
        if (this.statusBar != null && this.focus != null) {
            int pos = this.focus.getTransform().toUser((Point)evt.getPoint()).x;
            this.statusBar.setPositionPane(new String(new Integer(pos + 1).toString()));
        }
    }

    public void changeTierHeights(int change) {
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (v instanceof TierViewI) {
                TierViewI tv = (TierViewI)v;
                if (change > 0) {
                    tv.incrementTierHeight();
                } else {
                    tv.decrementTierHeight();
                }
                tv.setInvalidity(true);
                continue;
            }
            if (!(v instanceof ContainerViewI)) continue;
            Vector tvs = ((ContainerViewI)((Object)v)).getViewsOfClass(class$apollo$gui$genomemap$TierViewI == null ? ApolloPanel.class$("apollo.gui.genomemap.TierViewI") : class$apollo$gui$genomemap$TierViewI);
            for (int j = 0; j < tvs.size(); ++j) {
                TierViewI tv = (TierViewI)tvs.elementAt(j);
                if (change > 0) {
                    tv.incrementTierHeight();
                } else {
                    tv.decrementTierHeight();
                }
                tv.setInvalidity(true);
            }
        }
        this.layout_manager.layoutViews(this);
        this.repaint();
    }

    public void keyPressed(KeyEvent evt) {
        char keyChar = evt.getKeyChar();
        if (keyChar == '-') {
            this.changeTierHeights(-1);
        } else if (keyChar == '+') {
            this.changeTierHeights(1);
        } else if (keyChar == 'r') {
            System.out.println("Reverse complementing");
            this.controller.handleReverseComplementEvent(new ReverseComplementEvent(this));
        } else if (keyChar == 'o') {
            System.out.println("Changing y orientation");
            this.controller.handleOrientationEvent(new OrientationEvent(this));
        }
        if (this.focus instanceof KeyViewI) {
            ((KeyViewI)((Object)this.focus)).keyPressed(evt);
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public RubberbandRectangle getRubberband() {
        return this.rubberband;
    }

    public boolean handleRubberbandEvent(RubberbandEvent evt) {
        Rubberband rb = (Rubberband)evt.getSource();
        Selection newSelection = new Selection();
        if (rb.getComponent() == this) {
            Vector viewVector = this.getPickViews(evt.getBounds());
            for (int i = 0; i < viewVector.size(); ++i) {
                PickViewI pv = (PickViewI)viewVector.elementAt(i);
                Selection viewSelection = pv.findFeaturesForSelection(evt.getBounds());
                newSelection.add(viewSelection);
            }
        }
        boolean exclusiveSelection = false;
        if ((rb.getModifiers() & 1) == 0) {
            exclusiveSelection = true;
        }
        this.selectionManager.select(newSelection, exclusiveSelection, this);
        this.processSelection(this.getSelection());
        return true;
    }

    public Vector getViews() {
        return this.views;
    }

    public Vector getPickViews(Rectangle bounds) {
        return this.getViews(bounds, this.pickViews);
    }

    public Vector getViews(Rectangle bounds) {
        return this.getViews(bounds, this.views);
    }

    public Vector getViews(Rectangle bounds, Vector viewVector) {
        Vector<ViewI> retviews = new Vector<ViewI>();
        for (int i = 0; i < viewVector.size(); ++i) {
            ViewI v = (ViewI)viewVector.elementAt(i);
            if (v instanceof DragViewI || !v.getBounds().intersects(bounds) || !v.isVisible()) continue;
            retviews.addElement(v);
        }
        return retviews;
    }

    public Vector getDragViews() {
        Vector<ViewI> retviews = new Vector<ViewI>();
        for (int i = 0; i < this.views.size(); ++i) {
            ViewI v = (ViewI)this.views.elementAt(i);
            if (!(v instanceof DragViewI)) continue;
            retviews.addElement(v);
        }
        return retviews;
    }

    public DragViewI getDragView() {
        Vector dvs = this.getDragViews();
        if (dvs.size() > 1) {
            System.err.println("Multiple drag views!!!");
        }
        DragViewI dv = (DragViewI)dvs.elementAt(0);
        return dv;
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void clearSelection() {
        this.getSelection().clear();
        this.clearEdges();
    }

    int[] getSelectionLimits() {
        int[] limits = new int[]{1000000000, -1000000000};
        FeatureList features = this.getSelection().getSelectedData();
        for (int i = 0; i < features.size(); ++i) {
            SeqFeatureI sf = features.getFeature(i);
            if (sf.getLow() < limits[0]) {
                limits[0] = sf.getLow();
            }
            if (sf.getHigh() <= limits[1]) continue;
            limits[1] = sf.getHigh();
        }
        return limits;
    }

    public void setStatusBar(StatusBar sb) {
        this.statusBar = sb;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void finalize() {
    }

    public StrandedZoomableApolloPanel getStrandedZoomableApolloPanel() {
        StrandedZoomableApolloPanel panel = (StrandedZoomableApolloPanel)SwingUtilities.getAncestorOfClass(class$apollo$gui$genomemap$StrandedZoomableApolloPanel == null ? (class$apollo$gui$genomemap$StrandedZoomableApolloPanel = ApolloPanel.class$("apollo.gui.genomemap.StrandedZoomableApolloPanel")) : class$apollo$gui$genomemap$StrandedZoomableApolloPanel, this);
        return panel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ApolloTreeLock {
        ApolloTreeLock() {
        }
    }
}

