/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.evidencepanel;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.ControlledPanel;
import apollo.gui.Controller;
import apollo.gui.DetailInfo;
import apollo.gui.Selection;
import apollo.gui.SelectionItem;
import apollo.gui.SelectionManager;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.MouseButtonEvent;
import apollo.util.ClipboardUtil;
import apollo.util.FeatureList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.bdgp.util.Comparator;
import org.bdgp.util.Range;
import org.bdgp.util.VectorUtil;

public class TablePanel
extends ControlledPanel {
    Controller controller = null;
    JTable table;
    JScrollPane pane;
    FilteredFeatureModel model = new FilteredFeatureModel();
    private SelectionManager selectionManager;
    private boolean listSelectionComesFromSelf = false;
    private RowSelectionListener rowSelectionListener;
    static /* synthetic */ Class class$java$lang$Object;

    public TablePanel(Controller c, SelectionManager sm) {
        this.table = new JTable(this.model);
        this.table.setAutoResizeMode(3);
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = TablePanel.class$("java.lang.Object")) : class$java$lang$Object, new CellRenderer());
        this.table.addMouseListener(new CopyMouseListener());
        this.table.getColumnModel().getSelectionModel().setSelectionMode(1);
        this.table.getSelectionModel().setSelectionMode(0);
        ListSelectionModel rsm = this.table.getSelectionModel();
        this.rowSelectionListener = new RowSelectionListener(rsm);
        rsm.addListSelectionListener(this.rowSelectionListener);
        this.pane = new JScrollPane();
        this.pane.setViewportView(this.table);
        this.setController(c);
        this.selectionManager = sm;
        JTableHeader th = this.table.getTableHeader();
        SortMouseListener sml = new SortMouseListener();
        th.addMouseListener(sml);
        th.addMouseMotionListener(sml);
    }

    protected boolean isSelectionSource(FeatureSelectionEvent e) {
        return e.getSource() == this.rowSelectionListener;
    }

    protected void selectFeature(SeqFeatureI feature) {
        if (feature instanceof DrawableSeqFeature) {
            feature = ((DrawableSeqFeature)((Object)feature)).getFeature();
        }
        int row = this.model.getRowNumberForFeature(feature);
        this.listSelectionComesFromSelf = true;
        if (row != -1) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
        }
        this.listSelectionComesFromSelf = false;
        this.scrollToRow(row);
    }

    private void scrollToRow(int row) {
        if (!this.isRowVisible(row)) {
            this.pane.getVerticalScrollBar().setValue(row * this.table.getRowHeight());
        }
    }

    private boolean isRowVisible(int row) {
        JScrollBar sb = this.pane.getVerticalScrollBar();
        int rowPixel = row * this.table.getRowHeight();
        return rowPixel > sb.getValue() && rowPixel < sb.getValue() + sb.getVisibleAmount();
    }

    protected void setToFeature(SeqFeatureI feature) {
        try {
            throw new Exception("Raw table called for " + feature.getName() + " class " + feature.getClass().getName());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public void setController(Controller c) {
        this.controller = c;
    }

    public Controller getController() {
        return this.controller;
    }

    protected SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TypeCellRenderer
    extends JButton
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
                this.setText("");
            } else {
                SeqFeatureI item = ((FilteredFeatureModel)table.getModel()).getRow(row);
                FeatureProperty property = Config.getPropertyScheme().getFeatureProperty(item.getTopLevelType());
                this.setBackground(property.getColour());
                this.setText(DetailInfo.getPropertyType(item));
                if (property.getColour() == Color.black) {
                    this.setForeground(Color.white);
                } else {
                    this.setForeground(Color.black);
                }
            }
            return this;
        }
    }

    protected class CellRenderer
    extends DefaultTableCellRenderer {
        protected CellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            Component out = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return out;
        }
    }

    protected class FilteredFeatureModel
    extends AbstractTableModel {
        private Vector propertyList = new Vector();
        private Vector data = new Vector();
        private String sortKey = null;
        private boolean reverseSort = true;
        private String type = "";
        private Vector keysWithDefaultSortingDescending;

        protected FilteredFeatureModel() {
        }

        public void setSortKey(String key) {
            this.sortKey = key;
            this.sort();
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getSortKey() {
            return this.sortKey;
        }

        public boolean getReverseSort() {
            return this.reverseSort;
        }

        public void setSortKey(int key, boolean reverse) {
            this.sortKey = (String)this.propertyList.elementAt(key);
            this.reverseSort = reverse;
            this.sort();
        }

        public void setReverseSort(boolean reverse) {
            this.reverseSort = reverse;
            this.sort();
        }

        public void sort() {
            VectorUtil.sort((Vector)this.data, (Comparator)new MegaComparator(this.sortKey), (boolean)this.reverseSort);
            this.fireTableDataChanged();
        }

        public void setPropertyList(Vector propertyList) {
            boolean fireChange = false;
            if (propertyList.size() != this.propertyList.size()) {
                fireChange = true;
            } else {
                for (int i = 0; i < propertyList.size(); ++i) {
                    String column_name = (String)propertyList.elementAt(i);
                    if (column_name.equals(this.propertyList.elementAt(i))) continue;
                    fireChange = true;
                    break;
                }
            }
            this.propertyList = propertyList;
            if (fireChange) {
                this.fireTableStructureChanged();
            }
        }

        public void setData(Vector data) {
            this.data = data;
            this.sort();
        }

        public void setData(FeatureList featList) {
            this.setData(featList.toVector());
        }

        public void setData(Vector data, String key, boolean reverse) {
            this.data = data;
            this.sortKey = key;
            this.reverseSort = reverse;
            this.sort();
        }

        public void setData(FeatureList data, String key, boolean reverse) {
            this.setData(data.toVector(), key, reverse);
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return this.propertyList.size();
        }

        public Object getValueAt(int row, int column) {
            SeqFeatureI sf = (SeqFeatureI)this.data.elementAt(row);
            String prop = (String)this.propertyList.elementAt(column);
            return DetailInfo.getPropertyForFeature(prop, sf);
        }

        public SeqFeatureI getRow(int row) {
            if (row < 0 || row >= this.data.size()) {
                return null;
            }
            return (SeqFeatureI)this.data.elementAt(row);
        }

        private int getRowNumberForFeature(SeqFeatureI sf) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getRow(i) != sf) continue;
                return i;
            }
            return -1;
        }

        public String getColumnName(int col) {
            String col_name = (String)this.propertyList.elementAt(col);
            return DetailInfo.getPrettyNameForString(col_name);
        }

        void setColumnDefaultSortingDescending(String key) {
            if (this.keysWithDefaultSortingDescending == null) {
                this.keysWithDefaultSortingDescending = new Vector(2);
            }
            this.keysWithDefaultSortingDescending.addElement(key);
        }

        private boolean defaultSortingIsDescending(int col) {
            if (this.keysWithDefaultSortingDescending == null) {
                return false;
            }
            String key = (String)this.propertyList.elementAt(col);
            return this.keysWithDefaultSortingDescending.contains(key);
        }
    }

    protected class RowSelectionListener
    implements ListSelectionListener {
        ListSelectionModel lsm;

        public RowSelectionListener(ListSelectionModel lsm) {
            this.lsm = lsm;
        }

        public void valueChanged(ListSelectionEvent e) {
            SeqFeatureI feature;
            if (TablePanel.this.listSelectionComesFromSelf) {
                return;
            }
            int row = TablePanel.this.table.getSelectedRow();
            if (row != -1 && (feature = TablePanel.this.model.getRow(row)) != null) {
                TablePanel.this.selectionManager.select(feature, (Object)this);
                TablePanel.this.setToFeature(feature);
            }
        }

        protected Selection getSelected(SeqFeatureI feature) {
            SeqFeatureI sf;
            Selection selection = new Selection();
            SeqFeatureI seqFeatureI = sf = feature instanceof DrawableSeqFeature ? ((DrawableSeqFeature)((Object)feature)).getFeature() : feature;
            if (sf.canHaveChildren()) {
                FeatureSetI fs = (FeatureSetI)sf;
                for (int i = 0; i < fs.size(); ++i) {
                    selection.add(new SelectionItem(this, fs.getFeatureAt(i)));
                }
            } else {
                selection.add(new SelectionItem(this, sf));
            }
            return selection;
        }
    }

    protected class CopyMouseListener
    extends MouseAdapter {
        protected CopyMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (MouseButtonEvent.isRightMouseClick(e)) {
                Point p = new Point(e.getX(), e.getY());
                int col = TablePanel.this.table.columnAtPoint(p);
                int row = TablePanel.this.table.rowAtPoint(p);
                ClipboardUtil.copyTextToClipboard(TablePanel.this.table.getValueAt(row, col).toString());
            }
        }
    }

    protected class SortMouseListener
    extends MouseInputAdapter {
        protected SortMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = TablePanel.this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = TablePanel.this.table.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                boolean shiftPressed;
                int shiftPressedInt = e.getModifiers() & 1;
                boolean descending = shiftPressed = shiftPressedInt != 0;
                if (TablePanel.this.model.defaultSortingIsDescending(column)) {
                    descending = !descending;
                }
                TablePanel.this.model.setSortKey(column, descending);
                TablePanel.this.table.requestFocus();
            }
        }
    }

    protected class MegaComparator
    implements Comparator {
        protected String sortKey;

        public MegaComparator(String sortKey) {
            this.sortKey = sortKey;
        }

        public int compare(Object fa, Object fb) {
            if (this.sortKey == null) {
                return 0;
            }
            SeqFeatureI feature_a = (SeqFeatureI)fa;
            SeqFeatureI feature_b = (SeqFeatureI)fb;
            Object a = DetailInfo.getPropertyForFeature(this.sortKey, feature_a);
            Object b = DetailInfo.getPropertyForFeature(this.sortKey, feature_b);
            if (a instanceof String && b instanceof String) {
                return this.compareStrings((String)a, (String)b);
            }
            if (a instanceof Range && b instanceof Range) {
                return this.compareRanges((Range)a, (Range)b);
            }
            if (a instanceof Double && b instanceof Double) {
                return this.compareDoubles((Double)a, (Double)b);
            }
            if (a instanceof Integer && b instanceof Integer) {
                return this.compareIntegers((Integer)a, (Integer)b);
            }
            return this.compareStrings(a.toString(), b.toString());
        }

        public int compareDoubles(Double a, Double b) {
            long anotherBits;
            double anotherVal;
            double thisVal = a;
            if (thisVal < (anotherVal = b.doubleValue())) {
                return -1;
            }
            if (thisVal > anotherVal) {
                return 1;
            }
            long thisBits = Double.doubleToLongBits(thisVal);
            return thisBits == (anotherBits = Double.doubleToLongBits(anotherVal)) ? 0 : (thisBits < anotherBits ? -1 : 1);
        }

        public int compareIntegers(Integer a, Integer b) {
            int anotherVal;
            int thisVal = a;
            return thisVal < (anotherVal = b.intValue()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public int compareRanges(Range a, Range b) {
            if (a.getLow() < b.getLow()) {
                return -1;
            }
            if (a.getLow() > b.getLow()) {
                return 1;
            }
            return 0;
        }

        public int compareStrings(String a, String b) {
            int comparison = a.compareTo(b);
            comparison = comparison < 0 ? -1 : (comparison > 0 ? 1 : 0);
            return comparison;
        }
    }
}

