/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.evidencepanel;

import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.gui.DetailInfo;
import apollo.gui.UnBorderedSplitPane;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.evidencepanel.SetDetailPanel;
import apollo.gui.evidencepanel.TablePanel;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.FeatureList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;

public class EvidencePanel
extends TablePanel {
    private SetDetailPanel setDetailPanel;
    UnBorderedSplitPane split;
    ApolloFeatureSelectionListener featureSelectionListener = new ApolloFeatureSelectionListener();
    public static Vector annot_columns = new Vector(3);
    public static Vector result_columns;
    private double initialDividerPercentage = 0.5;
    private boolean firstPaint = true;

    public EvidencePanel(GuiCurationState curationState) {
        super(curationState.getController(), curationState.getSelectionManager());
        curationState.getController().addListener(this.featureSelectionListener);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setDetailPanel = new SetDetailPanel(this.getController(), this.getSelectionManager());
        this.split = new UnBorderedSplitPane(0, false, this.pane, this.setDetailPanel);
        this.add((Component)this.split, "Center");
        this.setMinimumSize(new Dimension(150, 0));
        this.setPreferredSize(new Dimension(150, 150));
        this.getController().addListener(new EvPanAnnotCngListener());
    }

    public void reset() {
        this.model.setData(new Vector(0));
        this.model.setPropertyList(new Vector(0));
        this.setDetailPanel.reset();
    }

    private void populateBothTablesFromSelection(FeatureList selection) {
        boolean sortDescending;
        FeatureList featSets = this.getFeatureSetsFromSelection(selection);
        if (featSets.size() == 0) {
            this.reset();
            return;
        }
        Vector columns = this.haveScore(featSets) ? result_columns : annot_columns;
        String oldType = this.model.getType();
        String oldSortKey = this.model.getSortKey();
        SeqFeatureI firstFeature = featSets.first();
        if (firstFeature.getRefFeature() == null) {
            return;
        }
        this.model.setType(firstFeature.getFeatureType());
        this.model.setPropertyList(columns);
        String sortKey = "Range";
        boolean bl = sortDescending = firstFeature.getStrand() < 0;
        if (this.haveScore(featSets)) {
            sortKey = "SCORE";
            sortDescending = true;
            this.model.setColumnDefaultSortingDescending("SCORE");
        }
        this.model.setData(featSets, sortKey, sortDescending);
        if (oldType == null || oldType.equals(firstFeature.getFeatureType())) {
            this.model.setSortKey(oldSortKey);
        }
        this.setDetailPanel.setFeatureSet(featSets.last());
        this.table.getColumn("Type").setCellRenderer(new TablePanel.TypeCellRenderer(this));
        this.table.sizeColumnsToFit(-1);
        this.table.repaint();
    }

    private FeatureList getFeatureSetsFromSelection(FeatureList selection) {
        FeatureList sets = new FeatureList(true);
        for (int i = 0; i < selection.size(); ++i) {
            SeqFeatureI sf = selection.getFeature(i);
            if (!this.displayInEvidencePanel(sf)) continue;
            SeqFeatureI set = null;
            set = sf.canHaveChildren() ? sf : sf.getRefFeature();
            if (set == null) continue;
            sets.addFeature(set);
        }
        return sets;
    }

    private boolean displayInEvidencePanel(SeqFeatureI sf) {
        return !sf.isCodon();
    }

    public void setToFeature(SeqFeatureI feature) {
        this.setDetailPanel.setFeatureSet(feature);
    }

    public void setOrientation(int newOrientation) {
        this.split.setOrientation(newOrientation);
    }

    public void paint(Graphics g) {
        if (this.firstPaint) {
            this.split.setDividerLocation(this.initialDividerPercentage);
            this.firstPaint = false;
        }
        super.paint(g);
    }

    private boolean haveScore(FeatureList feature_list) {
        boolean scored = false;
        for (int i = 0; i < feature_list.size() && !scored; ++i) {
            SeqFeatureI sf = feature_list.getFeature(i);
            String tier_label = DetailInfo.getTier(sf).toString();
            if (tier_label.equalsIgnoreCase("Annotation")) continue;
            scored = true;
        }
        return scored;
    }

    static {
        annot_columns.addElement("BIOTYPE");
        annot_columns.addElement("NAME");
        annot_columns.addElement("Range");
        result_columns = new Vector(4);
        result_columns.addElement("Type");
        result_columns.addElement("NAME");
        result_columns.addElement("Range");
        result_columns.addElement("SCORE");
    }

    private class EvPanAnnotCngListener
    implements AnnotationChangeListener {
        private EvPanAnnotCngListener() {
        }

        public boolean handleAnnotationChangeEvent(AnnotationChangeEvent a) {
            FeatureList l = EvidencePanel.this.getSelectionManager().getSelection().getSelectedData();
            EvidencePanel.this.populateBothTablesFromSelection(l);
            return true;
        }
    }

    private class ApolloFeatureSelectionListener
    implements FeatureSelectionListener {
        private ApolloFeatureSelectionListener() {
        }

        public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
            if (evt.getSource() instanceof TablePanel.RowSelectionListener) {
                return false;
            }
            EvidencePanel.this.populateBothTablesFromSelection(evt.getFeatures());
            return true;
        }
    }
}

