/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.event;

import apollo.datamodel.SeqFeatureI;
import apollo.gui.Selection;
import apollo.gui.SelectionItem;
import apollo.util.FeatureList;
import java.util.EventObject;
import java.util.Vector;

public class FeatureSelectionEvent
extends EventObject {
    private Selection selected;
    private boolean force_selection = false;
    public static final int FEATURES = 1;
    public static final int SEQUENCE = 2;
    public static final int SYNLINK = 3;
    int type = 1;

    public FeatureSelectionEvent(Object source, Vector features, int type) {
        this(source, features);
        this.type = type;
    }

    public FeatureSelectionEvent(Object source, FeatureList feats) {
        super(source);
        this.init(feats);
    }

    public FeatureSelectionEvent(Object source, SeqFeatureI feature) {
        super(source);
        FeatureList f = new FeatureList(feature, false);
        this.init(f);
    }

    public FeatureSelectionEvent(Object source, Vector features) {
        super(source);
        this.init(features);
    }

    public FeatureSelectionEvent(Object source, Selection selected) {
        super(source);
        this.selected = selected;
    }

    public FeatureSelectionEvent(Object source, Selection selected, boolean force_selection) {
        this(source, selected);
        this.force_selection = force_selection;
    }

    private void init(FeatureList feats) {
        this.selected = new Selection(feats, this.source);
    }

    private void init(Vector features) {
        Selection s = new Selection();
        int fSize = features.size();
        for (int i = 0; i < fSize; ++i) {
            s.add(new SelectionItem(this.source, (SeqFeatureI)features.elementAt(i)));
        }
        this.selected = s;
    }

    public int getType() {
        return this.type;
    }

    public FeatureList getFeatures() {
        return this.selected;
    }

    public SeqFeatureI getFeature() {
        FeatureList features = this.getFeatures();
        if (features.size() > 0) {
            return features.getFeature(0);
        }
        return null;
    }

    public Selection getSelection() {
        return this.selected;
    }

    public Object getSource() {
        return this.source;
    }

    public boolean forceSelection() {
        return this.force_selection;
    }
}

