/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.config.Config;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.DrawableSeqFeature;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Triangle
extends DrawableSeqFeature {
    int[] x = new int[3];
    int[] y = new int[3];
    private int site;

    public Triangle() {
        super(true);
    }

    public Triangle(SeqFeatureI feature) {
        super(feature, true);
    }

    public void setFeature(SeqFeatureI feature) {
        super.setFeature(feature);
        String site_str = feature.getProperty("insertion_site");
        if ((site_str == null || site_str.equals("")) && feature.getRefFeature() != null) {
            site_str = feature.getRefFeature().getProperty("insertion_site");
        }
        try {
            this.site = Integer.parseInt(site_str) - feature.getStrand();
        }
        catch (Exception e) {
            this.site = feature.length() / 2;
        }
    }

    public void drawSelected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        this.drawSite(g, boxBounds, transformer, manager);
        g.setColor(Color.red);
        Rectangle pixBox = transformer.getPixelBounds();
        int y2 = this.getStrand() >= 0 && transformer.getXOrientation() == 1 || this.getStrand() < 0 && transformer.getXOrientation() == -1 ? pixBox.y + pixBox.height : pixBox.y;
        g.drawLine(this.x[0], this.y[0], this.x[0], y2);
    }

    public void drawUnselected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        this.drawSite(g, boxBounds, transformer, manager);
    }

    public void addHighlights(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        if (this.isHighlighted()) {
            g.setColor(Config.getHighlightColor());
            g.drawPolygon(this.x, this.y, 3);
        }
    }

    protected void drawSite(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        int xpoint;
        int xtricenter;
        int offset = (int)((double)this.site * transformer.getXPixelsPerCoord());
        if (this.getStrand() >= 0 && transformer.getXOrientation() == 1 || this.getStrand() < 0 && transformer.getXOrientation() == -1) {
            xtricenter = boxBounds.x + offset;
            xpoint = xtricenter + 8;
        } else {
            xtricenter = boxBounds.x + boxBounds.width - offset;
            xpoint = xtricenter - 8;
        }
        int ytricenter = boxBounds.y + (int)((double)(boxBounds.height + 1) * 0.5);
        this.x[0] = xtricenter;
        this.y[0] = boxBounds.y;
        this.x[2] = xtricenter;
        this.y[2] = boxBounds.y + boxBounds.height + 1;
        this.x[1] = xpoint;
        this.y[1] = ytricenter;
        g.setColor(this.getDrawableColor());
        g.fillPolygon(this.x, this.y, 3);
    }
}

