/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Exon;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableFeatureSet;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.gui.drawable.DrawableSetI;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Vector;

public class DrawableUtil {
    public static Color unconventionalPurple = new Color(160, 32, 240);
    private static final String drawablePath = "apollo.gui.drawable.";

    public static void setBoxBounds(Drawable dsf, Transformer transformer, TierManagerI manager) {
        int setSize;
        if (dsf instanceof DrawableSetI && (setSize = ((DrawableSetI)dsf).size()) == 0) {
            dsf.setBoxBounds(new Rectangle(0, 0, 0, 0));
            return;
        }
        dsf.setBoxBounds(DrawableUtil.getPixelBounds(dsf, transformer, manager));
    }

    public static Rectangle getBoxBounds(Vector drawables, Transformer transformer, TierManagerI manager) {
        Rectangle boxBounds = null;
        int drawable_count = drawables.size();
        for (int i = 0; i < drawable_count; ++i) {
            Drawable dsf = (Drawable)drawables.elementAt(i);
            Rectangle dsfPixels = DrawableUtil.getPixelBounds(dsf, transformer, manager);
            boxBounds = boxBounds == null ? dsfPixels : boxBounds.union(dsfPixels);
        }
        if (boxBounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return boxBounds;
    }

    private static Rectangle getPixelBounds(Drawable dsf, Transformer transformer, TierManagerI manager) {
        SeqFeatureI sf = dsf.getFeature();
        FeatureProperty fp = dsf.getFeatureProperty();
        Transformer.PixelRange pixRng = transformer.basepairRangeToPixelRange(sf);
        pixRng.ensureMinimumWidth(fp.getMinWidth());
        int pixelHeight = dsf.getSize(transformer, manager);
        int pixelY = DrawableUtil.getPixelY(dsf, transformer, manager, pixelHeight);
        return new Rectangle(pixRng.low, pixelY, pixRng.getWidth(), pixelHeight);
    }

    public static int getTierYCentrePixel(int tierNum, Transformer transformer, TierManagerI manager) {
        int tierCentre = manager.getTier(tierNum).getDrawCentre();
        return transformer.toPixelY(tierCentre);
    }

    private static int getPixelY(Drawable dsf, Transformer transformer, TierManagerI manager, int pixelHeight) {
        int pixelY = DrawableUtil.getTierYCentrePixel(dsf.getTierIndex(manager), transformer, manager);
        return pixelY -= (int)((double)pixelHeight * 0.5);
    }

    public static Drawable createDrawable(SeqFeatureI sf) {
        String glyph_name;
        FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(sf.getTopLevelType());
        Drawable glyph = null;
        if (fp != null && (glyph_name = fp.getStyle()) != null) {
            Drawable check_glyph = DrawableUtil.createGlyph(glyph_name);
            if (DrawableUtil.isOneLevel(fp) && fp.isAnnotationType()) {
                check_glyph = DrawableUtil.setToOneLevelGlyph(check_glyph);
            }
            int feature_level = sf.numberOfGenerations();
            if (check_glyph != null) {
                if (feature_level == check_glyph.getDrawLevel()) {
                    glyph = check_glyph;
                }
            } else {
                System.out.println("Unable to create glyph for " + glyph_name);
            }
        }
        if (glyph == null) {
            glyph = sf.canHaveChildren() ? new DrawableFeatureSet(false) : new DrawableSeqFeature(false);
        }
        glyph.setFeature(sf);
        return glyph;
    }

    private static boolean isOneLevel(FeatureProperty fp) {
        return fp.getNumberOfLevels() == 1;
    }

    private static Drawable setToOneLevelGlyph(Drawable glyph) {
        if (glyph.getDrawLevel() == 1) {
            return glyph;
        }
        boolean drawn = true;
        return new DrawableSeqFeature(drawn);
    }

    public static Drawable createGlyph(String glyph_name) {
        Drawable glyph = null;
        int tries = 0;
        boolean no_class = true;
        String prefix = drawablePath;
        String class_name = glyph_name;
        while (glyph == null && tries < 2) {
            try {
                Class<?> glyph_class;
                if (prefix != "" && !glyph_name.startsWith(prefix)) {
                    class_name = prefix + glyph_name;
                }
                no_class = (glyph_class = Class.forName(class_name)) == null;
                glyph = (Drawable)glyph_class.newInstance();
            }
            catch (Exception e) {
                System.out.println("createGlyph: couldn't create glyph " + class_name + "; no class = " + no_class);
                if (++tries >= 2) continue;
                prefix = "";
            }
        }
        return glyph;
    }

    public static Color getStartCodonColor(FeatureSetI fs) {
        return fs.unConventionalStart() || fs.getStartCodon() == null ? unconventionalPurple : Color.green;
    }

    public static Color getFeatureColor(SeqFeatureI feature, FeatureProperty fp) {
        Color color;
        if (feature != null) {
            boolean colorAllAnnotsByOwner = Config.getStyle().colorAllAnnotsByOwner();
            if (colorAllAnnotsByOwner && feature instanceof AnnotatedFeatureI || (feature instanceof Transcript || feature instanceof Exon) && feature.getTopLevelType().equalsIgnoreCase("gene")) {
                AnnotatedFeatureI annot = feature instanceof Exon ? (AnnotatedFeatureI)feature.getRefFeature() : (AnnotatedFeatureI)feature;
                String owner = Config.getProjectName(annot.getOwner());
                color = Config.getAnnotationColor(owner, fp);
            } else {
                color = fp.getColour();
            }
        } else {
            color = FeatureProperty.DEFAULT_COLOR;
        }
        return color;
    }
}

