/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.dataadapter.NotImplementedException;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.gui.DetailInfo;
import apollo.gui.SelectableI;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableUtil;
import apollo.gui.genomemap.FeatureTierManagerI;
import apollo.gui.genomemap.PixelMaskI;
import apollo.util.Visitor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;

public class DrawableSeqFeature
implements Drawable,
SelectableI {
    protected static byte VISIBLE = 1;
    protected static byte SELECTED = (byte)2;
    protected static byte HIGHLIGHTED = (byte)4;
    protected static byte LEFTEDGE = (byte)8;
    protected static byte RIGHTEDGE = (byte)16;
    protected static byte LABELED = (byte)32;
    protected static byte DECORATED = (byte)(LEFTEDGE | RIGHTEDGE | HIGHLIGHTED | SELECTED | LABELED);
    protected SeqFeatureI feature;
    protected Drawable drawable_parent;
    protected byte flags;
    private int tier_index = -1;
    protected Rectangle boxBounds = new Rectangle();
    PropertyScheme pscheme;
    protected int draw_level = 1;
    protected boolean is_drawn = false;
    private FeatureProperty featureProperty;
    private static Rectangle labStaticBounds = new Rectangle();

    public DrawableSeqFeature(boolean drawn) {
        this.setDrawn(drawn);
    }

    public DrawableSeqFeature(SeqFeatureI feature, boolean drawn) {
        this.setFeature(feature);
        this.setDrawn(drawn);
    }

    public void setDrawn(boolean drawn) {
        this.is_drawn = drawn;
    }

    public int getDrawLevel() {
        return this.draw_level;
    }

    public void setDrawLevel(int level) {
        this.draw_level = level;
    }

    public SeqFeatureI getFeature() {
        return this.feature;
    }

    public void setFeature(SeqFeatureI feature) {
        this.feature = feature;
        if (!feature.getTopLevelType().equals("no_type")) {
            this.synchFeatureProperty();
        }
    }

    public void synchFeatureProperty() {
        this.featureProperty = this.getFeatureType(this.feature.getTopLevelType());
    }

    public int getLeft(Transformer transformer) {
        if (transformer.getXOrientation() == 1) {
            return this.getLow();
        }
        return this.getHigh();
    }

    public int getRight(Transformer transformer) {
        if (transformer.getXOrientation() == 1) {
            return this.getHigh();
        }
        return this.getLow();
    }

    public int getTierIndex(TierManagerI manager) {
        if (this.tier_index == -1) {
            if (manager instanceof FeatureTierManagerI) {
                ((FeatureTierManagerI)manager).synchDrawablesWithTiers();
            }
            if (this.tier_index == -1) {
                this.tier_index = 0;
            }
        }
        return this.tier_index;
    }

    public Rectangle getBoxBounds() {
        return this.boxBounds;
    }

    public void setBoxBounds(Rectangle r) {
        this.boxBounds = r;
    }

    public boolean draw(Graphics g, Transformer transformer, TierManagerI manager, PixelMaskI mask) {
        boolean obscured;
        this.setLabeled();
        DrawableUtil.setBoxBounds(this, transformer, manager);
        boolean bl = obscured = mask == null ? false : mask.isCompletelyObscured(this.boxBounds.x, this.boxBounds.x + this.boxBounds.width, this.getTierIndex(manager));
        if ((!obscured || this.isSelected()) && this.wantToDraw(g, manager, transformer, this.boxBounds)) {
            mask.setPixelRangeState(this.boxBounds.x, this.boxBounds.x + this.boxBounds.width, true, this.getTierIndex(manager));
            this.feature_draw(g, transformer, manager, this.boxBounds);
            return true;
        }
        return false;
    }

    public boolean draw(Graphics g, Transformer transformer, TierManagerI manager) {
        this.setLabeled();
        DrawableUtil.setBoxBounds(this, transformer, manager);
        if (this.wantToDraw(g, manager, transformer, this.boxBounds)) {
            this.feature_draw(g, transformer, manager, this.boxBounds);
            return true;
        }
        return false;
    }

    protected boolean wantToDraw(Graphics g, TierManagerI manager, Transformer transformer, Rectangle boxBounds) {
        if (!this.isVisible()) {
            return false;
        }
        Rectangle clipBounds = g.getClipBounds();
        if (boxBounds.width != 0 && !clipBounds.intersects(boxBounds)) {
            if (this.isLabeled()) {
                return this.getLabeledBounds(transformer, manager, g, boxBounds).intersects(clipBounds);
            }
            return false;
        }
        return true;
    }

    private Rectangle getLabeledBounds(Transformer transformer, TierManagerI manager, Graphics g, Rectangle boxBounds) {
        int low = manager.getTier(this.getTierIndex(manager)).getDrawLow();
        int high = manager.getTier(this.getTierIndex(manager)).getCharHigh();
        Point lowpos = transformer.toPixel(this.getLeft(transformer), low);
        Point highpos = transformer.toPixel(this.getRight(transformer), high);
        if (transformer.getYOrientation() == 1) {
            DrawableSeqFeature.labStaticBounds.x = lowpos.x;
            DrawableSeqFeature.labStaticBounds.y = lowpos.y;
            DrawableSeqFeature.labStaticBounds.width = 100;
            DrawableSeqFeature.labStaticBounds.height = highpos.y - lowpos.y + 2;
        } else {
            DrawableSeqFeature.labStaticBounds.x = lowpos.x;
            DrawableSeqFeature.labStaticBounds.y = highpos.y;
            DrawableSeqFeature.labStaticBounds.width = 120;
            DrawableSeqFeature.labStaticBounds.height = lowpos.y - highpos.y + 2;
        }
        return labStaticBounds;
    }

    protected void feature_draw(Graphics g, Transformer transformer, TierManagerI manager, Rectangle boxBounds) {
        if (this.isSelected()) {
            this.drawSelected(g, boxBounds, transformer, manager);
        } else {
            this.drawUnselected(g, boxBounds, transformer, manager);
        }
        this.addHighlights(g, boxBounds, transformer, manager);
        this.addDecorations(g, boxBounds, transformer, manager);
    }

    public void addHighlights(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        if (this.isHighlighted()) {
            g.drawRect(boxBounds.x - 1, boxBounds.y - 1, boxBounds.width + 2, boxBounds.height + 2);
        }
        int width = Config.getEdgematchWidth();
        if (this.isLeftEdge()) {
            g.setColor(Config.getEdgematchColor());
            if (width == 1) {
                g.drawLine(boxBounds.x, boxBounds.y, boxBounds.x, boxBounds.y + boxBounds.height);
            } else {
                g.fillRect(boxBounds.x - 1, boxBounds.y, width, boxBounds.height + 1);
            }
        }
        if (this.isRightEdge()) {
            g.setColor(Config.getEdgematchColor());
            if (width == 1) {
                g.drawLine(boxBounds.x + boxBounds.width, boxBounds.y, boxBounds.x + boxBounds.width, boxBounds.y + boxBounds.height);
            } else {
                g.fillRect(boxBounds.x + boxBounds.width - 1, boxBounds.y, width, boxBounds.height + 1);
            }
        }
    }

    protected void addDecorations(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        String name;
        if (this.isLabeled() && (name = this.getDisplayLabel()) != null) {
            int y = manager.getTier(this.getTierIndex(manager)).getCharLow();
            int x = this.getLeftmostVisible(transformer);
            int text_x = transformer.toPixelX(x);
            int text_y = transformer.toPixelY(y);
            text_y = transformer.getYOrientation() == 1 ? (text_y += g.getFontMetrics().getAscent()) : (text_y -= g.getFontMetrics().getDescent());
            if (this.feature != null && this.feature.hasAnnotatedFeature()) {
                g.setColor(Config.getStyle().getAnnotationLabelColor());
            } else {
                g.setColor(Config.getFeatureLabelColor());
            }
            g.setFont(this.getFont());
            g.drawString(name, text_x, text_y);
        }
        if (this.feature.getRefSequence() != null && this.feature.getRefFeature() != null) {
            this.drawStartAndStopCodons(g, boxBounds, transformer);
        }
    }

    private Font getFont() {
        SeqFeatureI sf;
        SeqFeatureI seqFeatureI = sf = this.feature != null ? this.feature.getRefFeature() : null;
        if (sf != null && sf.getFeatureType().equalsIgnoreCase("gene")) {
            String pep_status = sf.getProperty("sp_status");
            return Config.getPeptideStatus(pep_status).getFont();
        }
        return Config.getDefaultFeatureLabelFont();
    }

    public void drawStartAndStopCodons(Graphics g, Rectangle boxBounds, Transformer transformer) {
        int position;
        boolean pointRight;
        FeatureSetI fs = (FeatureSetI)this.feature.getRefFeature();
        if (fs.isMissing3prime()) {
            if (fs.getFeatureIndex(this.feature) == fs.size() - 1) {
                pointRight = transformer.getXOrientation() == 1 && this.getStrand() == 1 || transformer.getXOrientation() == -1 && this.getStrand() == -1;
                this.drawMissing(g, boxBounds, pointRight, transformer.toPixelX(this.feature.getEnd()), Color.red);
            }
        } else {
            position = fs.getTranslationEnd();
            if (this.feature.contains(position) && this.feature.isSequenceAvailable(position)) {
                this.drawBases(g, boxBounds, transformer, position, 3, Color.red);
            }
        }
        if (fs.isMissing5prime()) {
            if (fs.getFeatureIndex(this.feature) == 0) {
                pointRight = !(transformer.getXOrientation() == 1 && this.getStrand() == 1 || transformer.getXOrientation() == -1 && this.getStrand() == -1);
                this.drawMissing(g, boxBounds, pointRight, transformer.toPixelX(this.feature.getStart()), Color.green);
            }
        } else {
            position = fs.getTranslationStart();
            if (this.feature.contains(position) && this.feature.isSequenceAvailable(position)) {
                this.drawBases(g, boxBounds, transformer, position, 3, DrawableUtil.getStartCodonColor(fs));
            }
        }
        if (this.feature.contains(position = fs.plus1FrameShiftPosition()) && this.feature.isSequenceAvailable(position)) {
            this.drawBases(g, boxBounds, transformer, position, 1, Color.yellow);
        }
        if (this.feature.contains(position = fs.minus1FrameShiftPosition()) && this.feature.isSequenceAvailable(position)) {
            this.drawBases(g, boxBounds, transformer, position, 1, Color.yellow);
        }
        if (this.feature.contains(position = fs.readThroughStopPosition()) && this.feature.isSequenceAvailable(position)) {
            this.drawBases(g, boxBounds, transformer, position, 3, Color.pink);
        }
    }

    protected int getCodonX(Transformer transformer, int x_position) {
        int codon_x = transformer.getXOrientation() == 1 && this.getStrand() == 1 ? transformer.toPixelX(x_position - 1) : (transformer.getXOrientation() == 1 && this.getStrand() == -1 ? transformer.toPixelX(x_position - 3) : (transformer.getXOrientation() == -1 && this.getStrand() == 1 ? transformer.toPixelX(x_position + 2) : transformer.toPixelX(x_position)));
        return codon_x;
    }

    private void drawBases(Graphics g, Rectangle boxBounds, Transformer transformer, int position, int base_count, Color colour) {
        int codon_x = this.getCodonX(transformer, position);
        g.setColor(colour);
        int width = (int)((double)base_count * transformer.getXPixelsPerCoord());
        if (width < 1) {
            width = 1;
        }
        g.fillRect(codon_x, boxBounds.y, width, boxBounds.height + 1);
    }

    protected void drawMissing(Graphics g, Rectangle boxBounds, boolean pointRight, int edge, Color color) {
        int point_height = Math.min(boxBounds.height, boxBounds.width);
        int[] x = new int[3];
        int[] y = new int[3];
        x[0] = edge;
        y[0] = boxBounds.y;
        x[1] = edge + (pointRight ? -point_height : point_height);
        y[1] = boxBounds.y;
        x[2] = edge;
        y[2] = this.getYCentre(boxBounds);
        g.setColor(Config.getAnnotationBackground());
        g.fillPolygon(x, y, 3);
        g.setColor(color);
        g.drawLine(x[1], y[1], x[2], y[2]);
        y[0] = boxBounds.y + boxBounds.height + 1;
        y[1] = boxBounds.y + boxBounds.height + 1;
        g.setColor(Config.getAnnotationBackground());
        g.fillPolygon(x, y, 3);
        g.setColor(color);
        g.drawLine(x[1], y[1], x[2], y[2]);
    }

    public void drawSelected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        g.setColor(Config.getSelectionColor());
        if (Config.getDraw3D()) {
            g.fill3DRect(boxBounds.x - 2, boxBounds.y - 2, boxBounds.width + 5, boxBounds.height + 5, true);
        } else {
            g.fillRect(boxBounds.x - 2, boxBounds.y - 2, boxBounds.width + 5, boxBounds.height + 5);
        }
        this.drawUnselected(g, boxBounds, transformer, manager);
    }

    protected Color getDrawableColor() {
        return DrawableUtil.getFeatureColor(this.feature, this.getFeatureProperty());
    }

    public void drawUnselected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        Transcript t;
        g.setColor(this.getDrawableColor());
        if (this.feature != null && this.feature.getRefFeature() instanceof Transcript && (t = (Transcript)this.feature.getRefFeature()).getGene() == null) {
            String m = "ERROR: You are trying to draw a Transcript that has been deleted from its Gene. The view and the model are out of synch. When deleting a transcript from the model an AnnotationChangeEvent must be sent out to notify the view. If you use AnnotationEditor this is done for you.";
            System.err.println(m);
            throw new RuntimeException(m);
        }
        if (Config.getDraw3D()) {
            g.fill3DRect(boxBounds.x, boxBounds.y, boxBounds.width, boxBounds.height, true);
        } else {
            g.fillRect(boxBounds.x, boxBounds.y, boxBounds.width, boxBounds.height);
        }
        if (Config.getDrawOutline()) {
            g.setColor(Config.getOutlineColor());
            g.drawRect(boxBounds.x, boxBounds.y, boxBounds.width, boxBounds.height);
        }
    }

    public int getYSpace(Transformer transformer, TierManagerI manager) {
        int tierNum = this.getTierIndex(manager);
        return manager.getTier(tierNum).getDrawSpace();
    }

    public int getYCentre(Rectangle boxBounds) {
        return boxBounds.y + (int)((double)boxBounds.height * 0.5);
    }

    public int getSize(Transformer transformer, TierManagerI manager) {
        int ysize;
        int yspace = this.getYSpace(transformer, manager) - 1;
        if (this.getFeatureProperty().getSizeByScore()) {
            float min;
            double score = this.feature.getScore();
            float max = this.featureProperty.getMaxScore();
            ysize = max > (min = this.featureProperty.getMinScore()) ? (int)((score - (double)min) / (double)(max - min) * (double)yspace) : (int)(((double)min - score) / (double)(min - max) * (double)yspace);
            if (ysize < 3) {
                ysize = 3;
            } else if (ysize > yspace) {
                ysize = yspace;
            }
        } else {
            ysize = yspace;
            if (ysize < 3) {
                ysize = 3;
            }
        }
        return ysize;
    }

    public void setTierIndex(int index) {
        this.tier_index = (short)index;
    }

    public void setSelected(boolean state) {
        this.setFlag(state, SELECTED);
    }

    public boolean isSelected() {
        return this.flagValue(SELECTED);
    }

    public void setVisible(boolean state) {
        this.setFlag(state, VISIBLE);
    }

    public boolean isVisible() {
        return this.flagValue(VISIBLE);
    }

    private void setFlag(boolean state, byte mask) {
        if (state) {
            this.flags = (byte)(this.flags | mask);
        } else if ((this.flags & mask) == mask) {
            this.flags = (byte)(this.flags ^ mask);
        }
    }

    private boolean flagValue(int mask) {
        return (this.flags & mask) != 0;
    }

    public FeatureProperty getFeatureProperty() {
        if (this.featureProperty == null) {
            this.synchFeatureProperty();
        }
        return this.featureProperty;
    }

    protected FeatureProperty getFeatureType(String type) {
        FeatureProperty fp;
        if (this.pscheme == null) {
            this.pscheme = Config.getPropertyScheme();
        }
        if ((fp = this.pscheme.getFeatureProperty(type)) == null) {
            System.out.println("No type " + type);
        }
        return fp;
    }

    public void setHighlighted(boolean state) {
        this.setFlag(state, HIGHLIGHTED);
    }

    protected void setLabeled() {
        this.setLabeled(this.featureProperty != null && this.featureProperty.getTier().isLabeled() && (this.getRefDrawable() == null || this.getRefDrawable() != null && !this.getRefDrawable().isDrawn()));
    }

    public void setLabeled(boolean state) {
        this.setFlag(state, LABELED);
    }

    public boolean isHighlighted() {
        return this.flagValue(HIGHLIGHTED);
    }

    public boolean isDecorated() {
        return this.flagValue(DECORATED);
    }

    public boolean isLabeled() {
        return this.flagValue(LABELED);
    }

    public boolean isLeftEdge() {
        return this.flagValue(LEFTEDGE);
    }

    public boolean isRightEdge() {
        return this.flagValue(RIGHTEDGE);
    }

    public void setEdgeHighlights(int[] edges, boolean state, Transformer transformer) {
        this.setFlag(false, LEFTEDGE);
        this.setFlag(false, RIGHTEDGE);
        int left = this.getLeft(transformer);
        int right = this.getRight(transformer);
        if (Arrays.binarySearch(edges, left) > -1) {
            this.setFlag(state, LEFTEDGE);
        }
        if (Arrays.binarySearch(edges, right) > -1) {
            this.setFlag(state, RIGHTEDGE);
        }
    }

    public boolean contains(Point point, Transformer transformer, TierManagerI manager) {
        DrawableUtil.setBoxBounds(this, transformer, manager);
        return this.boxBounds.contains(point);
    }

    public boolean intersects(Rectangle pixrect, Transformer transformer, TierManagerI manager) {
        DrawableUtil.setBoxBounds(this, transformer, manager);
        return this.boxBounds.intersects(pixrect);
    }

    public String getDisplayLabel() {
        if (this.feature == null) {
            return "";
        }
        String label = DetailInfo.getName(this.feature);
        if ((label.equals("") || label.equals("no_name")) && this.getFeature().getParent() != null) {
            label = this.getFeature().getParent().getName();
        }
        return label;
    }

    public Drawable findDrawable(SeqFeatureI sf) {
        if (sf == null) {
            return null;
        }
        DrawableSeqFeature found = null;
        if (this.sameFeature(sf, this.getFeature())) {
            found = this;
        }
        return found;
    }

    protected boolean sameFeature(SeqFeatureI one, SeqFeatureI two) {
        boolean same;
        boolean bl = same = one == two;
        if (one == null || two == null || same) {
            return same;
        }
        if (!same && one.getName().equals(two.getName()) && one.getStart() == two.getStart() && one.getEnd() == two.getEnd() && one.getClass().getName().equals(two.getClass().getName())) {
            same = false;
        }
        return same;
    }

    protected int getCharY(FontMetrics fm, Rectangle box) {
        int char_height = fm.getAscent() + fm.getDescent();
        if (char_height >= box.height) {
            return box.y + box.height - fm.getLeading();
        }
        return box.y + char_height + (box.height - char_height) / 2;
    }

    protected int getLeftmostVisible(Transformer transformer) {
        int[] visRange = transformer.getXVisibleRange();
        if (transformer.getXOrientation() == 1) {
            return Math.max(visRange[0], this.getLeft(transformer));
        }
        return Math.min(visRange[1], this.getLeft(transformer));
    }

    public boolean isDrawn() {
        return this.is_drawn;
    }

    public Color fontColorForBackground(Color bgColor) {
        float[] HSB = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
        float lightness = HSB[2] + HSB[1] / 2.0f;
        Color labelColor = Color.black;
        if ((double)lightness < 1.11) {
            labelColor = Color.white;
        }
        return labelColor;
    }

    public void accept(Visitor visitor) {
        throw new NotImplementedException("Not implemented for DrawableSeqFeature");
    }

    public void setRefDrawable(Drawable dfs) {
        this.drawable_parent = dfs;
    }

    public Drawable getRefDrawable() {
        return this.drawable_parent;
    }

    public int getStart() {
        return this.feature.getStart();
    }

    public int getEnd() {
        return this.feature.getEnd();
    }

    public int getLow() {
        return this.feature.getLow();
    }

    public int getHigh() {
        return this.feature.getHigh();
    }

    public int getStrand() {
        return this.feature.getStrand();
    }

    public boolean isForwardStrand() {
        return this.feature.isForwardStrand();
    }

    public String getType() {
        return this.feature.getFeatureType();
    }

    public String getName() {
        return this.feature.getName();
    }

    public void deleteDrawable(Drawable child) {
    }
}

