/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.config.Config;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableFeatureSet;
import apollo.gui.drawable.DrawableResultSeqFeature;
import apollo.gui.drawable.DrawableUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DrawableResultFeatureSet
extends DrawableFeatureSet {
    public DrawableResultFeatureSet() {
        super(true);
    }

    public DrawableResultFeatureSet(FeatureSetI feature) {
        super(feature, true);
    }

    public Drawable createDrawable(SeqFeatureI sf) {
        return new DrawableResultSeqFeature(sf);
    }

    protected boolean drawDashedLines(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager, Color color, int y_center) {
        boolean drawn = false;
        if (Config.getDashSets()) {
            for (int i = 0; i < this.size(); ++i) {
                int right_end;
                int left_end;
                if (i + 1 >= this.size()) continue;
                Drawable dsf_1 = this.getDrawableAt(i);
                Drawable dsf_2 = this.getDrawableAt(i + 1);
                if (dsf_1.getFeature() == null || dsf_2.getFeature() == null || !(dsf_1.getFeature() instanceof FeaturePairI) || !(dsf_2.getFeature() instanceof FeaturePairI)) continue;
                FeaturePairI fp_1 = (FeaturePairI)dsf_1.getFeature();
                FeaturePairI fp_2 = (FeaturePairI)dsf_2.getFeature();
                DrawableUtil.setBoxBounds(dsf_1, transformer, manager);
                DrawableUtil.setBoxBounds(dsf_2, transformer, manager);
                Rectangle fp1_bounds = dsf_1.getBoxBounds();
                Rectangle fp2_bounds = dsf_2.getBoxBounds();
                if (fp1_bounds.x < fp2_bounds.x) {
                    left_end = fp1_bounds.x;
                    right_end = fp2_bounds.x;
                } else {
                    right_end = fp1_bounds.x;
                    left_end = fp2_bounds.x;
                }
                if (fp_1.getHitFeature() == null || fp_2.getHitFeature() == null) continue;
                SequenceI seq_1 = fp_1.getHitFeature().getRefSequence();
                SequenceI seq_2 = fp_2.getHitFeature().getRefSequence();
                if (seq_1 == null || seq_1.getName() == null || seq_2 == null || seq_2.getName() == null || seq_1.getName().equals(seq_2.getName())) {
                    g.setColor(color);
                    g.drawLine(left_end, y_center, right_end, y_center);
                } else {
                    g.setColor(Config.getSeqGapColor());
                    for (int j = left_end; j < right_end; j += 6) {
                        int dash = Math.min(4, right_end - j);
                        g.drawLine(j, y_center, j + dash, y_center);
                    }
                }
                drawn = true;
            }
        }
        return drawn;
    }
}

