/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Evidence;
import apollo.datamodel.EvidenceFinder;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.gui.SelectableI;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableSeqFeature;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class DrawableGeneSeqFeature
extends DrawableSeqFeature
implements Drawable,
SelectableI {
    Color weirdDonorSpliceColor;
    Color weirdAcceptorSpliceColor;

    public DrawableGeneSeqFeature() {
        super(true);
        this.weirdAcceptorSpliceColor = this.weirdDonorSpliceColor = Color.orange;
    }

    public DrawableGeneSeqFeature(SeqFeatureI feature) {
        super(feature, true);
        this.weirdAcceptorSpliceColor = this.weirdDonorSpliceColor = Color.orange;
    }

    public void drawSelected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        g.setColor(Config.getSelectionColor());
        if (Config.getDraw3D()) {
            g.fill3DRect(boxBounds.x - 2, boxBounds.y - 2, boxBounds.width + 5, boxBounds.height + 5, true);
        } else {
            g.fillRect(boxBounds.x - 2, boxBounds.y - 2, boxBounds.width + 5, boxBounds.height + 5);
        }
        this.drawUnselected(g, boxBounds, transformer, manager);
    }

    public void drawUnselected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        int edge;
        int center_y;
        int[] splice_y;
        int point_len;
        Color color = this.getDrawableColor();
        g.setColor(color);
        int leftEdge = boxBounds.x;
        int rightEdge = boxBounds.x + boxBounds.width + 1;
        ExonI exon = this.feature instanceof ExonI ? (ExonI)this.feature : null;
        int exonType = this.feature.getCodingProperties();
        if (exonType != 4 && exonType != 7) {
            g.setColor(this.getFeatureProperty().getUtrColor());
            g.fillRect(boxBounds.x + 1, boxBounds.y + 1, boxBounds.width - 1, boxBounds.height - 1);
            g.setColor(color);
            g.drawRect(boxBounds.x, boxBounds.y, boxBounds.width, boxBounds.height);
            if (exonType == 3 || exonType == 1 || exonType == 2) {
                int left_edge = leftEdge + 1;
                int right_edge = rightEdge - 1;
                FeatureSetI trans = (FeatureSetI)this.feature.getRefFeature();
                if (this.feature.getStrand() == 1 && transformer.getXOrientation() == 1 || this.feature.getStrand() == -1 && transformer.getXOrientation() == -1) {
                    if (exonType == 3) {
                        left_edge = transformer.toPixelX(trans.getTranslationStart());
                        right_edge = transformer.toPixelX(trans.getTranslationEnd());
                    } else if (exonType == 1) {
                        left_edge = transformer.toPixelX(trans.getTranslationStart());
                    } else if (exonType == 2) {
                        right_edge = transformer.toPixelX(trans.getTranslationEnd());
                    }
                } else if (exonType == 3) {
                    left_edge = transformer.toPixelX(trans.getTranslationEnd());
                    right_edge = transformer.toPixelX(trans.getTranslationStart());
                } else if (exonType == 1) {
                    right_edge = transformer.toPixelX(trans.getTranslationStart());
                } else if (exonType == 2) {
                    left_edge = transformer.toPixelX(trans.getTranslationEnd());
                }
                g.fillRect(left_edge, boxBounds.y, right_edge - left_edge + 1, boxBounds.height + 1);
            }
        } else {
            g.fillRect(leftEdge, boxBounds.y, rightEdge - leftEdge, boxBounds.height + 1);
        }
        if (exon != null && exon.isNonConsensusAcceptor()) {
            int n = point_len = this.getStrand() >= 0 && transformer.getXOrientation() == 1 || this.getStrand() < 0 && transformer.getXOrientation() == -1 ? boxBounds.height : -boxBounds.height;
            if (Math.abs(point_len) < boxBounds.width + 1) {
                int[] splice_x = new int[3];
                splice_y = new int[3];
                center_y = this.getYCentre(boxBounds);
                splice_x[0] = edge = this.getStrand() >= 0 && transformer.getXOrientation() == 1 || this.getStrand() < 0 && transformer.getXOrientation() == -1 ? leftEdge : rightEdge;
                splice_y[0] = boxBounds.y;
                splice_x[1] = edge + point_len;
                splice_y[1] = center_y;
                splice_x[2] = edge;
                splice_y[2] = boxBounds.y + boxBounds.height + 1;
                g.setColor(this.weirdAcceptorSpliceColor);
                g.fillPolygon(splice_x, splice_y, 3);
            }
        }
        if (exon != null && exon.isNonConsensusDonor()) {
            int n = point_len = this.getStrand() >= 0 && transformer.getXOrientation() == 1 || this.getStrand() < 0 && transformer.getXOrientation() == -1 ? boxBounds.height : -boxBounds.height;
            if (Math.abs(point_len) < boxBounds.width + 1) {
                int[] splice_x = new int[3];
                splice_y = new int[3];
                center_y = this.getYCentre(boxBounds);
                splice_x[0] = edge = this.getStrand() >= 0 && transformer.getXOrientation() == 1 || this.getStrand() < 0 && transformer.getXOrientation() == -1 ? rightEdge : leftEdge;
                splice_y[0] = boxBounds.y;
                splice_x[1] = edge - point_len;
                splice_y[1] = center_y;
                splice_x[2] = edge;
                splice_y[2] = boxBounds.y + boxBounds.height + 1;
                g.setColor(this.weirdDonorSpliceColor);
                g.fillPolygon(splice_x, splice_y, 3);
            }
        }
        if (Config.getDrawOutline()) {
            g.setColor(Config.getOutlineColor());
            g.drawRect(boxBounds.x, boxBounds.y, boxBounds.width, boxBounds.height);
        }
    }

    protected void addDecorations(Graphics g, Rectangle box, Transformer transformer, TierManagerI manager) {
        super.addDecorations(g, box, transformer, manager);
        int exonType = this.feature.getCodingProperties();
        if ((exonType == 3 || exonType == 1 || exonType == 2 || exonType == 4) && transformer.getXPixelsPerCoord() >= 5.0 && this.feature.isSequenceAvailable(this.feature.getStart())) {
            int aa_offset;
            int base_phase;
            int end;
            FeatureSetI trans = (FeatureSetI)this.feature.getRefFeature();
            int transStart = trans.getTranslationStart();
            int transEnd = trans.getTranslationEnd();
            int[] visRange = transformer.getXVisibleRange();
            int leftCoord = visRange[0];
            int rightCoord = visRange[1];
            boolean forward = transformer.getXOrientation() == 1;
            String aa = trans.translate();
            int start = this.feature.contains(transStart) ? transStart : this.getStart() + this.feature.getPhase() * this.getStrand();
            int n = end = this.feature.contains(transEnd) ? transEnd - 3 * this.getStrand() : this.getEnd() - (this.feature.getEndPhase() + 2) % 3 * this.getStrand();
            if (this.getStrand() == 1) {
                if (leftCoord < start) {
                    leftCoord = start;
                } else if (this.feature.contains(leftCoord)) {
                    base_phase = (leftCoord - start) % 3;
                    leftCoord += (3 - base_phase) % 3;
                } else {
                    leftCoord = start;
                }
                if (rightCoord > end) {
                    rightCoord = end;
                }
            } else {
                if (leftCoord < end) {
                    leftCoord = end;
                } else if (this.feature.contains(leftCoord)) {
                    base_phase = (start - leftCoord) % 3;
                    leftCoord -= (3 - base_phase) % 3;
                } else {
                    leftCoord = end;
                }
                if (rightCoord > start) {
                    rightCoord = start;
                }
            }
            if ((aa_offset = (trans.getFeaturePosition(leftCoord) - trans.getFeaturePosition(transStart)) / 3) < 0) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            int res_y = this.getCharY(fm, box);
            Color labelColor = this.residueColorForTranscript(trans);
            g.setColor(labelColor);
            for (int i = leftCoord; i <= rightCoord; i += 3) {
                String res;
                try {
                    if (aa_offset >= aa.length()) {
                        return;
                    }
                    res = aa_offset + 1 < aa.length() ? aa.substring(aa_offset, aa_offset + 1) : aa.substring(aa_offset);
                    aa_offset += this.getStrand();
                }
                catch (Exception e) {
                    System.out.println("DrawableGeneSeqFeature:  caught exception: name = " + this.getName() + ", leftCoord = " + leftCoord + " on feature at " + trans.getFeaturePosition(leftCoord) + ", TSS = " + transStart + " on feature at " + trans.getFeaturePosition(transStart) + ", leftVisible = " + visRange[0] + ", feature Tstart = " + start + ", aa_offset = " + aa_offset + ", for peptide " + "of length " + aa.length());
                    return;
                }
                int res_x = forward ? transformer.toPixelX(i - 1) : transformer.toPixelX(i);
                g.drawString(res, res_x += (int)(transformer.getXPixelsPerCoord() / 2.0 - (double)(fm.stringWidth(res) / 2)), res_y);
            }
        }
    }

    protected Color residueColorForTranscript(FeatureSetI fs) {
        Color fs_color;
        if (fs instanceof Transcript) {
            Transcript transcript = (Transcript)fs;
            String owner = Config.getProjectName(transcript.getOwner());
            fs_color = Config.getAnnotationColor(owner, this.getFeatureProperty());
        } else {
            fs_color = this.getDrawableColor();
        }
        return this.fontColorForBackground(fs_color);
    }

    public void setHighlights(boolean state) {
        AnnotatedFeatureI gi;
        Vector evidence;
        if (this.feature instanceof AnnotatedFeatureI && (evidence = (gi = (AnnotatedFeatureI)this.feature).getEvidence()).size() != 0 && gi.getEvidenceFinder() != null) {
            EvidenceFinder ef = gi.getEvidenceFinder();
            for (int i = 0; i < evidence.size(); ++i) {
                String evidenceId = ((Evidence)evidence.elementAt(i)).getFeatureId();
                SeqFeatureI sf = ef.findEvidence(evidenceId);
                if (!(sf instanceof Drawable)) continue;
                Drawable dsf = (Drawable)((Object)sf);
                dsf.setHighlighted(state);
            }
        }
    }

    public void setSelected(boolean state) {
        super.setSelected(state);
        this.setHighlights(state);
    }
}

