/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.config.Config;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableFeatureSet;
import apollo.gui.drawable.DrawableGeneSeqFeature;
import apollo.gui.drawable.DrawableSetI;
import apollo.gui.drawable.DrawableUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class DrawableGeneFeatureSet
extends DrawableFeatureSet
implements DrawableSetI {
    private static byte NEEDS_SORT = (byte)4;
    static int maxEdge = 100;
    static int[] edges = new int[maxEdge];
    private byte sortFlags = NEEDS_SORT;
    private byte currOrientation;

    public DrawableGeneFeatureSet() {
        super(true);
    }

    public DrawableGeneFeatureSet(FeatureSetI fset) {
        super(fset, true);
    }

    public Drawable createDrawable(SeqFeatureI sf) {
        return new DrawableGeneSeqFeature(sf);
    }

    public void drawUnselected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        int setSize = this.size();
        if ((this.sortFlags & NEEDS_SORT) == NEEDS_SORT || this.currOrientation != transformer.getXOrientation()) {
            this.sort(transformer.getXOrientation());
            this.sortFlags = (byte)(this.sortFlags ^ NEEDS_SORT);
            this.currOrientation = (byte)transformer.getXOrientation();
        }
        if (setSize > 1) {
            int twoSetSize = 2 * setSize;
            if (twoSetSize > maxEdge) {
                maxEdge = twoSetSize;
                edges = new int[maxEdge];
            }
            int j = 0;
            Vector features = this.getDrawables();
            int i = 0;
            while (i < setSize) {
                Drawable dsf = (Drawable)features.elementAt(i);
                DrawableUtil.setBoxBounds(dsf, transformer, manager);
                Rectangle fp_bounds = dsf.getBoxBounds();
                DrawableGeneFeatureSet.edges[j] = fp_bounds.x;
                DrawableGeneFeatureSet.edges[j + 1] = fp_bounds.x + fp_bounds.width;
                ++i;
                j += 2;
            }
            int twoSetSizeMin1 = twoSetSize - 1;
            if (Config.getDrawOutline()) {
                g.setColor(Config.getOutlineColor());
            } else {
                g.setColor(this.getDrawableColor());
            }
            for (int i2 = 1; i2 < twoSetSizeMin1; i2 += 2) {
                int ip1 = i2 + 1;
                int centre = (edges[ip1] - edges[i2] + 1) / 2 + edges[i2];
                int y_mid = this.getYCentre(boxBounds);
                int y_top = boxBounds.y + (transformer.getXOrientation() == 1 && this.getStrand() == 1 || transformer.getXOrientation() == -1 && this.getStrand() == -1 ? 0 : boxBounds.height);
                g.drawLine(edges[i2], y_mid, centre, y_top);
                g.drawLine(centre, y_top, edges[ip1], y_mid);
            }
        }
    }

    public Drawable addFeatureDrawable(SeqFeatureI sf) {
        Drawable dsf = super.addFeatureDrawable(sf);
        this.sortFlags = (byte)(this.sortFlags | NEEDS_SORT);
        return dsf;
    }
}

