/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.config.Config;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationCompoundEvent;
import apollo.editor.FeatureChangeEvent;
import apollo.editor.TransactionSubpart;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.Drawable;
import apollo.gui.drawable.DrawableSeqFeature;
import apollo.gui.drawable.DrawableSetI;
import apollo.gui.drawable.DrawableUtil;
import apollo.gui.genomemap.PixelMaskI;
import apollo.util.FeatureList;
import apollo.util.QuickSort;
import apollo.util.SeqFeatureUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class DrawableFeatureSet
extends DrawableSeqFeature
implements DrawableSetI {
    Vector drawable_set;
    boolean debug = false;

    public DrawableFeatureSet() {
        this(true);
    }

    public DrawableFeatureSet(boolean drawn) {
        super(drawn);
        this.draw_level = 2;
        this.drawable_set = new Vector();
    }

    public DrawableFeatureSet(FeatureSetI feature, boolean drawn) {
        super(feature, drawn);
        this.draw_level = 2;
        if (feature == null) {
            return;
        }
        this.initSet();
    }

    public void initSet() {
        this.drawable_set = new Vector();
        int feature_size = ((FeatureSetI)this.feature).size();
        for (int i = 0; i < feature_size; ++i) {
            SeqFeatureI sf = ((FeatureSetI)this.feature).getFeatureAt(i);
            this.addFeatureDrawable(sf);
        }
    }

    public Drawable addFeatureDrawable(SeqFeatureI sf) {
        Drawable dsf = this.createDrawable(sf);
        this.addDrawable(dsf);
        return dsf;
    }

    public Drawable createDrawable(SeqFeatureI sf) {
        return DrawableUtil.createDrawable(sf);
    }

    public void addDrawable(Drawable dsf) {
        this.drawable_set.addElement(dsf);
        dsf.setRefDrawable(this);
    }

    public void sort(int sortStrand) {
        int i;
        int setSize = this.size();
        if (setSize == 0) {
            return;
        }
        int[] coord = new int[setSize];
        Object[] obj = new Drawable[setSize];
        for (i = 0; i < setSize; ++i) {
            Drawable sf = this.getDrawableAt(i);
            coord[i] = sf.getStart();
            obj[i] = sf;
        }
        QuickSort.sort(coord, obj);
        if (sortStrand == 1) {
            for (i = 0; i < setSize; ++i) {
                this.drawable_set.setElementAt(obj[i], i);
            }
        } else {
            for (i = 0; i < setSize; ++i) {
                this.drawable_set.setElementAt(obj[i], setSize - i - 1);
            }
        }
    }

    public void setFeature(SeqFeatureI feature) {
        super.setFeature(feature);
        this.initSet();
    }

    public boolean draw(Graphics g, Transformer transformer, TierManagerI manager, PixelMaskI mask) {
        Drawable sf;
        int i;
        this.setLabeled(this.getFeatureProperty().getTier().isLabeled());
        DrawableUtil.setBoxBounds(this, transformer, manager);
        if (!this.wantToDraw(g, manager, transformer, this.boxBounds)) {
            return false;
        }
        int setSize = this.size();
        boolean fullDraw = (float)this.boxBounds.width / (float)setSize > Config.getFastDrawLimit();
        boolean decorated = false;
        if (!fullDraw) {
            fullDraw = super.isDecorated();
        }
        decorated = super.isDecorated();
        for (i = 0; i < setSize && !fullDraw; ++i) {
            sf = this.getDrawableAt(i);
            if (!sf.isDecorated()) continue;
            fullDraw = true;
            decorated = true;
            break;
        }
        if (!mask.isCompletelyObscured(this.boxBounds.x, this.boxBounds.x + this.boxBounds.width, this.getTierIndex(manager)) || decorated) {
            if (fullDraw) {
                this.feature_draw(g, transformer, manager, this.boxBounds);
                for (i = 0; i < setSize; ++i) {
                    sf = this.getDrawableAt(i);
                    sf.draw(g, transformer, manager, mask);
                }
            } else {
                DrawableSeqFeature sf2 = (DrawableSeqFeature)this.getDrawableAt(0);
                DrawableUtil.setBoxBounds(this, transformer, manager);
                mask.setPixelRangeState(this.boxBounds.x, this.boxBounds.x + this.boxBounds.width, true, this.getTierIndex(manager));
                sf2.feature_draw(g, transformer, manager, this.boxBounds);
            }
        }
        return true;
    }

    public boolean draw(Graphics g, Transformer transformer, TierManagerI manager) {
        boolean drawn = false;
        if (!super.draw(g, transformer, manager)) {
            drawn = false;
        } else {
            int setSize = this.size();
            for (int i = 0; i < setSize; ++i) {
                this.getDrawableAt(i).draw(g, transformer, manager);
            }
        }
        return drawn;
    }

    public void addHighlights(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
    }

    public void drawSelected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        this.drawUnselected(g, boxBounds, transformer, manager);
    }

    protected boolean drawDashedLines(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager, Color color, int y_center) {
        return false;
    }

    public void drawUnselected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        if (this.size() > 1) {
            Color color = this.getDrawableColor();
            g.setColor(color);
            int y_center = this.getYCentre(boxBounds);
            if (!this.drawDashedLines(g, boxBounds, transformer, manager, color, y_center)) {
                g.drawLine(boxBounds.x < 0 ? 0 : boxBounds.x, y_center, boxBounds.x + boxBounds.width > 3000 ? 3000 : boxBounds.x + boxBounds.width, y_center);
            }
        }
    }

    public void setSelected(boolean state) {
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            this.getDrawableAt(i).setSelected(state);
        }
        super.setSelected(state);
    }

    public void setVisible(boolean state) {
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            this.getDrawableAt(i).setVisible(state);
        }
        super.setVisible(state);
    }

    public void setLabeled(boolean state) {
        super.setLabeled(state);
    }

    public void setTierIndex(int index) {
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            this.getDrawableAt(i).setTierIndex(index);
        }
        super.setTierIndex(index);
    }

    public int size() {
        return this.drawable_set.size();
    }

    public void deleteDrawable(Drawable sf) {
        if (!this.drawable_set.removeElement(sf)) {
            System.out.println("Did not have drawable for " + sf.getName());
        }
    }

    public Drawable getDrawableAt(int i) {
        return (Drawable)this.drawable_set.elementAt(i);
    }

    public Vector getDrawables() {
        return this.drawable_set;
    }

    public FeatureList findFeaturesByAllNames(String name) {
        return ((FeatureSetI)this.feature).findFeaturesByAllNames(name);
    }

    public FeatureList findFeaturesByAllNames(String name, boolean useRegExp) {
        return ((FeatureSetI)this.feature).findFeaturesByAllNames(name, false);
    }

    public Drawable findDrawable(SeqFeatureI sf) {
        Drawable found = super.findDrawable(sf);
        if (found == null) {
            int setSize = this.size();
            for (int i = 0; i < setSize && found == null; ++i) {
                Drawable check = this.getDrawableAt(i);
                found = check.findDrawable(sf);
            }
        }
        return found;
    }

    public void repairFeatureSet(AnnotationCompoundEvent ace) {
        for (int i = 0; i < ace.getNumberOfChildren(); ++i) {
            this.repairFeatureSet(ace.getChildChangeEvent(i));
        }
    }

    public void repairFeatureSet(FeatureChangeEvent ce) {
        SeqFeatureI parentModel = ce.getParentFeature();
        DrawableSetI parentDrawable = (DrawableSetI)this.findDrawable(parentModel);
        Drawable changedDrawable = this.findDrawable(ce.getChangedFeature());
        if (ce.isUpdate() && ce.getSubpart() == TransactionSubpart.TYPE) {
            parentDrawable.deleteDrawable(changedDrawable);
            Drawable newDrawable = parentDrawable.addFeatureDrawable(ce.getChangedFeature());
            int go_up = newDrawable.getDrawLevel() - changedDrawable.getDrawLevel();
            if (go_up < 0) {
                newDrawable.setDrawLevel(changedDrawable.getDrawLevel());
            }
        } else if (ce.isAdd() && !ce.hasSubpart() || ce.isMerge() || ce.isSplit()) {
            if (this.drawableNotNull(parentDrawable, ce)) {
                if (changedDrawable != null) {
                    parentDrawable.deleteDrawable(changedDrawable);
                }
                parentDrawable.addFeatureDrawable(ce.getChangedFeature());
            }
        } else if (ce.isMove()) {
            SeqFeatureI oldParentModel = ce.getUpdateDetails().getOldParent();
            Drawable oldParentDrawable = this.findDrawable(oldParentModel);
            if (!this.drawableNotNull(oldParentDrawable, ce)) {
                return;
            }
            if (changedDrawable != null) {
                oldParentDrawable.deleteDrawable(changedDrawable);
            }
            parentDrawable.addFeatureDrawable(ce.getChangedFeature());
        } else if (ce.isDelete() && !ce.hasSubpart()) {
            if (this.drawableNotNull(parentDrawable, ce)) {
                if (changedDrawable != null) {
                    parentDrawable.deleteDrawable(changedDrawable);
                } else {
                    System.err.println("Could not delete " + ce.getChangedFeature().getName() + " from " + ce.getParentFeature().getName() + " because drawable was not found");
                }
            }
        } else if (ce.isSync()) {
            this.syncDrawableToModel(parentModel, this);
            this.eraseDrawables(parentModel, this);
        }
        Drawable d = this.findDrawable(ce.getChangeTop());
        if (d != null) {
            d.setVisible(true);
        }
    }

    private void debugDrawable(Drawable d, String indent) {
        System.out.println(indent + "Using a " + d.getClass().getName() + " to draw " + d.getFeature().getName() + " a " + d.getFeature().getFeatureType() + " draw level=" + d.getDrawLevel() + " isDrawn=" + d.isDrawn());
        if (d instanceof DrawableSetI) {
            DrawableSetI ds = (DrawableSetI)d;
            for (int i = 0; i < ds.size(); ++i) {
                this.debugDrawable(ds.getDrawableAt(i), indent + "\t");
            }
        }
    }

    private void syncDrawableToModel(SeqFeatureI fs, DrawableFeatureSet dfs) {
        int feature_count = fs.getNumberOfChildren();
        for (int i = 0; i < feature_count; ++i) {
            SeqFeatureI sf = fs.getFeatureAt(i);
            DrawableSeqFeature dsf = (DrawableSeqFeature)this.findDrawable(sf);
            if (dsf == null) {
                dfs.addFeatureDrawable(sf);
                continue;
            }
            if (!sf.canHaveChildren()) continue;
            this.syncDrawableToModel((FeatureSetI)sf, (DrawableFeatureSet)dsf);
        }
    }

    private void eraseDrawables(SeqFeatureI fs, DrawableFeatureSet dfs) {
        int feature_count = dfs.size();
        for (int i = feature_count - 1; i >= 0; --i) {
            Drawable dsf = dfs.getDrawableAt(i);
            SeqFeatureI sf = dsf.getFeature();
            if (!SeqFeatureUtil.containsFeature(fs, sf)) {
                dfs.deleteDrawable(dsf);
                continue;
            }
            if (!(dsf instanceof DrawableFeatureSet)) continue;
            this.eraseDrawables((FeatureSetI)sf, (DrawableFeatureSet)dsf);
        }
    }

    private boolean drawableNotNull(Drawable drawable, FeatureChangeEvent ce) {
        if (drawable == null) {
            try {
                SeqFeatureI feat = ce.getParentFeature();
                throw new Exception("Failed to find annotation to repair on " + feat.getName() + " of class " + feat.getClass().getName() + " for event " + ce + ".\nPrinting error message and stack trace to help with debugging:");
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public String toString_mv() {
        return this.drawable_set.toString();
    }

    public void setEdgeHighlights(int[] edges, boolean state, Transformer transformer) {
        super.setEdgeHighlights(edges, state, transformer);
        for (int i = 0; i < this.size(); ++i) {
            this.getDrawableAt(i).setEdgeHighlights(edges, state, transformer);
        }
    }

    public void setHighlighted(boolean state) {
        super.setHighlighted(false);
        int setSize = this.size();
        for (int i = 0; i < setSize; ++i) {
            if (!(this.getDrawableAt(i) instanceof DrawableSeqFeature)) continue;
            this.getDrawableAt(i).setHighlighted(state);
        }
    }

    public FeatureSetI getFeatureSet() {
        return (FeatureSetI)this.feature;
    }
}

