/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.Transcript;
import apollo.gui.drawable.DrawableFeatureSet;
import apollo.gui.drawable.DrawableSeqFeature;

public class DrawableDisplayTool {
    public static void showGene(AnnotatedFeatureI g) {
        System.err.println("Gene : ");
        for (int i = 0; i < g.getFeatures().size(); ++i) {
            System.err.println("  transcript " + (i + 1) + ": ");
            Transcript t = (Transcript)g.getFeatures().elementAt(i);
            for (int j = 0; j < t.getExons().size(); ++j) {
                ExonI e = (ExonI)t.getExons().elementAt(j);
                System.err.println("    exon " + (j + 1) + ": " + e.getName() + (e.getStrand() == 1 ? "+" : "-") + " (" + e.getStart() + ", " + e.getEnd() + ")");
            }
        }
    }

    public static void showExon(ExonI e) {
        System.err.println("    exon : " + e.getName() + (e.getStrand() == 1 ? "+" : "-") + " (" + e.getStart() + ", " + e.getEnd() + ") " + e.getFeatureType());
    }

    public static void showDrawableFeatureSet(DrawableFeatureSet fs) {
        DrawableDisplayTool.showDrawableFeatureSet(fs, 0);
    }

    public static void showDrawableFeatureSet(DrawableFeatureSet fs, int indent) {
        DrawableDisplayTool.outputSpaces(indent);
        System.err.println("  " + DrawableDisplayTool.getStringForSeqFeature(fs));
        for (int i = 0; i < fs.size(); ++i) {
            DrawableSeqFeature sf = (DrawableSeqFeature)((Object)fs.getFeature().getFeatureAt(i));
            DrawableDisplayTool.outputSpaces(indent);
            System.err.println("    " + (i + 1) + ") " + DrawableDisplayTool.getStringForSeqFeature(sf));
            if (!sf.getFeature().canHaveChildren()) continue;
            DrawableDisplayTool.showDrawableFeatureSet((DrawableFeatureSet)sf, indent + 3);
        }
    }

    public static void outputSpaces(int nSpace) {
        for (int i = 0; i < nSpace; ++i) {
            System.err.print(" ");
        }
    }

    public static String getStringForSeqFeature(DrawableSeqFeature sf) {
        return "\"" + sf.getName() + "\"-" + sf.getType() + " (" + sf.getStart() + ", " + sf.getEnd() + ")" + (sf.getStrand() == 1 ? "+" : "-") + " {" + sf.getClass().getName() + "}" + " {" + sf.getFeature().getClass().getName() + "}" + (sf.isVisible() ? " VIS" : " INVIS");
    }
}

