/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.drawable;

import apollo.datamodel.SeqFeatureI;
import apollo.gui.TierManagerI;
import apollo.gui.Transformer;
import apollo.gui.drawable.DrawableSeqFeature;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

public class DoubleHeadedArrow
extends DrawableSeqFeature {
    public DoubleHeadedArrow() {
        super(true);
    }

    public DoubleHeadedArrow(SeqFeatureI feature) {
        super(feature, true);
    }

    public void drawUnselected(Graphics g, Rectangle boxBounds, Transformer transformer, TierManagerI manager) {
        int y_height = (int)((double)boxBounds.height * 0.5);
        int x_width = y_height + 1;
        if (boxBounds.width < x_width + x_width) {
            super.drawUnselected(g, boxBounds, transformer, manager);
        } else {
            int x_begin = boxBounds.x;
            int x_end = x_begin + boxBounds.width;
            int y_center = this.getYCentre(boxBounds);
            if (x_end > 3000) {
                x_end = 3000;
            }
            g.setColor(this.getDrawableColor());
            g.drawLine(x_begin, y_center, x_end, y_center);
            this.drawArrowHead(g, x_begin + x_width - 1, x_begin, y_center, y_height);
            this.drawArrowHead(g, x_end - x_width + 1, x_end + 1, y_center, y_height);
        }
    }

    public void drawArrowHead(Graphics g, int x_tip, int x_flat, int y_center, int y_height) {
        int[] x = new int[3];
        int[] y = new int[3];
        Polygon poly = new Polygon(x, y, 3);
        x = poly.xpoints;
        y = poly.ypoints;
        x[0] = x_flat;
        y[0] = y_center - y_height;
        x[1] = x_tip;
        y[1] = y_center;
        x[2] = x_flat;
        y[2] = y_center + y_height;
        g.fillPolygon(x, y, 3);
    }
}

