/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.config.Config;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.gui.BaseScrollable;
import apollo.gui.detailviewers.exonviewer.BaseRenderer;
import apollo.gui.detailviewers.exonviewer.DefaultBaseRenderer;
import apollo.gui.detailviewers.exonviewer.Directions;
import apollo.gui.detailviewers.exonviewer.FeatureWrapper;
import apollo.gui.detailviewers.exonviewer.SeqWrapper;
import apollo.util.SwingMissingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import javax.swing.event.MouseInputAdapter;
import org.bdgp.swing.FastTranslatedGraphics;

public class SeqAlignPanel
extends JPanel
implements Scrollable,
BaseScrollable {
    public static final int NO_BOUNDARY = 0;
    public static final int LEFT_BOUNDARY = 1;
    public static final int RIGHT_BOUNDARY = 2;
    public static final int NO_TYPE = -1;
    public static final int STOP_CODON = 1;
    public static final int START_CODON = 2;
    public static final int INTRON = 4;
    public static final int EXON = 5;
    protected Vector sequences;
    protected JComponent defaultRowHeader;
    public int cols;
    protected int stripeWidth = 5;
    protected int rowMargin = 10;
    protected boolean horizontalMode = false;
    public boolean reverseStrand = false;
    private AutoscrollThread horizontalScrollThread;
    private AutoscrollThread verticalScrollThread;
    private boolean autoscroll = false;
    protected int lowestBase;
    protected int highestBase;
    protected int longest_seq = 0;
    protected BaseRenderer renderer = new DefaultBaseRenderer(this.getCharWidth(), this.getCharHeight());
    static int i = 0;

    public void setAutoscroll(boolean autoscroll) {
        this.autoscroll = autoscroll;
        if (autoscroll) {
            ScrollMouseListener listener = new ScrollMouseListener();
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }
    }

    public void setReverseStrand(boolean in) {
        this.reverseStrand = in;
    }

    public boolean getReverseStrand() {
        return this.reverseStrand;
    }

    public void setStripeWidth(int width) {
        this.stripeWidth = width;
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public int getTierCount() {
        return this.sequences.size();
    }

    public void addSequence(SequenceI seq, int phase, String seq_type, int index) {
        if (this.longest_seq == 0 || seq.getRange() != null && seq.getRange().getHigh() > this.longest_seq || seq.getRange() == null && seq.getLength() > this.longest_seq) {
            this.longest_seq = seq.getRange() != null ? seq.getRange().getHigh() : seq.getLength();
        }
        if (index >= this.sequences.size()) {
            this.sequences.addElement(new SeqWrapper(seq, phase, seq_type, this));
        } else {
            this.sequences.insertElementAt(new SeqWrapper(seq, phase, seq_type, this), index);
        }
    }

    public void attachRendererToSequence(int seqIndex, BaseRenderer br) {
        SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(seqIndex);
        sw.setRenderer(br);
    }

    protected boolean isOneLevelAnnot(SeqFeatureI ann) {
        return ann.isAnnotTop() && !ann.hasKids();
    }

    public int getBoundaryType(int pos, int tier) {
        SeqWrapper sw = this.getSeqWrapperForTier(tier);
        if (sw == null) {
            return 0;
        }
        return sw.getBoundaryType(pos);
    }

    public SeqFeatureI getFeatureAtPosition(int position, int tier) {
        if (tier >= this.sequences.size()) {
            return null;
        }
        SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(tier);
        return sw.getFeatureAtPosition(position);
    }

    public Vector getFeaturesInRange(int startpos, int endpos, int tier) {
        if (tier >= this.sequences.size()) {
            return null;
        }
        SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(tier);
        return sw.getFeaturesInRange(startpos, endpos);
    }

    public SeqFeatureI getFeatureForPixelPosition(int x, int y) {
        return this.getFeatureForPixelPosition(x, y, false);
    }

    public SeqFeatureI getFeatureForPixelPosition(int x, int y, boolean noSet) {
        int tier = this.getTierForPixelPosition(y);
        int row = this.getRowForPixelPosition(y);
        int col = this.getColForPixelPosition(x);
        int pos = this.cols * row + col + 1;
        if (noSet) {
            return this.getFeatureAtPosition(pos, tier);
        }
        return this.getFeatureSetAtPosition(pos, tier);
    }

    public FeatureSetI getFeatureSetAtPosition(int position, int tier) {
        if (tier >= this.sequences.size()) {
            return null;
        }
        SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(tier);
        return sw.getFeatureSetAtPosition(position);
    }

    protected SeqWrapper getSeqWrapperForTier(int tier) {
        if (tier >= 0 && tier < this.sequences.size()) {
            return (SeqWrapper)this.sequences.elementAt(tier);
        }
        return null;
    }

    public int getTypeAtPosition(int tier, int base) {
        SeqWrapper sw = this.getSeqWrapperForTier(tier);
        return sw.getTypeAtPosition(base);
    }

    public double[] getRangeAtPosition(int tier, int pos) {
        SeqWrapper sw = this.getSeqWrapperForTier(tier);
        if (sw == null) {
            return null;
        }
        return sw.getRangeAtPosition(pos);
    }

    public int getRangeIndex(int tier, int low, int high) {
        SeqWrapper sw = this.getSeqWrapperForTier(tier);
        return sw.getRangeIndex(low, high);
    }

    public int getExonRangeIndex(int tier, int low, int high) {
        return this.getExonRangeIndex(tier, low, high, false);
    }

    public int getExonRangeIndex(int tier, int low, int high, boolean exact) {
        SeqWrapper sw = this.getSeqWrapperForTier(tier);
        return sw.getExonRangeIndex(low, high, exact);
    }

    public SeqFeatureI getFeatureAtIndex(int tier, int index) {
        SeqWrapper sw = this.getSeqWrapperForTier(tier);
        return sw.getFeatureAtIndex(index);
    }

    public int getFeatureCount(int tier) {
        SeqWrapper sw = this.getSeqWrapperForTier(tier);
        return sw.getFeatureCount();
    }

    public SeqAlignPanel(int cols, int lowestBase, int highestBase) {
        this.cols = cols;
        this.horizontalMode = false;
        this.sequences = new Vector();
        this.longest_seq = 0;
        this.defaultRowHeader = new DefaultRowHeader();
        this.attachListeners();
        this.lowestBase = lowestBase;
        this.highestBase = highestBase;
    }

    public void setHorizontalMode(boolean mode) {
        this.horizontalMode = mode;
    }

    private void attachListeners() {
        if (this.autoscroll) {
            ScrollMouseListener listener = new ScrollMouseListener();
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }
    }

    public JComponent getDefaultHeader() {
        return this.defaultRowHeader;
    }

    protected boolean canBeAddedToSequence(SeqWrapper sw, SeqFeatureI feature) {
        Vector features = sw.getFeatures();
        for (int i = 0; i < features.size(); ++i) {
            FeatureWrapper fw = (FeatureWrapper)features.elementAt(i);
            SeqFeatureI currentFeature = fw.getFeature();
            if (!feature.contains(currentFeature.getLow()) && !feature.contains(currentFeature.getHigh()) && !currentFeature.contains(feature.getHigh()) && !currentFeature.contains(feature.getLow())) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.sequences.removeAllElements();
        this.longest_seq = 0;
    }

    public int addAlignFeature(SequenceI seq, SeqFeatureI feature) {
        SeqWrapper wrapper = null;
        int seqNum = -1;
        for (int seqIndex = 0; seqIndex < this.sequences.size(); ++seqIndex) {
            SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(seqIndex);
            if (sw.getSequence() != seq || !this.canBeAddedToSequence(sw, feature)) continue;
            wrapper = sw;
            seqNum = seqIndex;
            break;
        }
        if (wrapper == null) {
            seqNum = this.sequences.size();
            this.addSequence(seq, -1, "DNA", seqNum);
            this.attachRendererToSequence(seqNum, new DefaultBaseRenderer(this.getCharWidth(), this.getCharHeight()));
            wrapper = (SeqWrapper)this.sequences.elementAt(seqNum);
        }
        wrapper.addFeature(feature);
        return seqNum;
    }

    protected void removeFeature(FeatureSetI feature, int tier) {
        if (tier >= this.sequences.size()) {
            System.out.println("SeqAlignPanel.removeFeature: requested tier " + tier + " is bigger than max tier " + this.sequences.size());
            return;
        }
        if (tier == -1) {
            System.out.println("EDE trying to remove feature that it cant find!");
            if (Config.DEBUG) {
                System.out.println("Heres the stack trace for debugging (might be a cloning issue)");
                new Throwable().printStackTrace();
            }
            return;
        }
        SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(tier);
        sw.removeFeature(feature);
        if (sw.getFeatureCount() == 0) {
            this.sequences.removeElement(sw);
        }
    }

    public void moveSequence(int oldpos, int newpos) {
        SeqWrapper sequence = (SeqWrapper)this.sequences.elementAt(oldpos);
        this.sequences.removeElementAt(oldpos);
        this.sequences.insertElementAt(sequence, newpos);
        this.reformat();
    }

    public int getSequenceCount() {
        return this.sequences.size();
    }

    public char getCharAt(int tier, int pos) {
        return ((SeqWrapper)this.sequences.elementAt(tier)).getCharAt(pos);
    }

    public SequenceI getSequenceForTier(int tier) {
        return ((SeqWrapper)this.sequences.elementAt(tier)).getSequence();
    }

    public void setVisibilityForSequence(int seqIndex, boolean visible) {
        SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(seqIndex);
        sw.setVisible(visible);
    }

    public BaseRenderer getRendererAt(int seqIndex) {
        if (seqIndex < 0 || seqIndex >= this.sequences.size()) {
            seqIndex = 0;
        }
        SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(seqIndex);
        return sw.getRenderer();
    }

    public void attachFeatureToSequence(int seqIndex, SeqFeatureI sf) {
        SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(seqIndex);
        sw.addFeature(sf);
    }

    protected int getTierForFeature(SeqFeatureI sf) {
        if (sf == null) {
            new Throwable().printStackTrace();
            return -1;
        }
        for (int i = 0; i < this.sequences.size(); ++i) {
            SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(i);
            Vector tier_features = sw.getFeatures();
            for (int j = 0; j < tier_features.size(); ++j) {
                SeqFeatureI tier_feature = ((FeatureWrapper)tier_features.elementAt(j)).getFeature();
                if (tier_feature == sf || tier_feature == sf.getRefFeature()) {
                    return i;
                }
                if (!tier_feature.isIdentical(sf)) continue;
                if (Config.DEBUG) {
                    System.out.println("DEBUG: EDE found clone of feature, not actual feature. Double check this is right. " + sf.getName() + " trace:");
                    new Throwable().printStackTrace();
                }
                return i;
            }
        }
        if (Config.DEBUG) {
            System.out.println("DEBUG EDE failed to find tier for feature " + sf.getName());
            System.out.println("returning -1(yikes)\nHeres stack trace:");
            new Throwable().printStackTrace();
        }
        return -1;
    }

    protected static String padPerChar(String target, String padString) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < target.length(); ++i) {
            out.append(target.charAt(i) + padString);
        }
        return out.toString();
    }

    public int getCharHeight() {
        return this.getFont().getSize();
    }

    public int getLongestSeq() {
        return this.longest_seq;
    }

    public void validateTree() {
        int visible = this.getVisibleBase();
        this.reformat();
        super.validateTree();
        this.scrollToBase(visible);
    }

    public void validate() {
        int visible = this.getVisibleBase();
        this.reformat();
        super.validate();
        this.scrollToBase(visible);
    }

    protected void reformat() {
        Container c = this.getParent();
        int width = -1;
        int height = -1;
        if (this.horizontalMode) {
            this.cols = this.getLongestSeq();
        }
        if (c != null && c instanceof JViewport) {
            Container sc = c.getParent();
            height = sc.getSize().height;
            if (sc instanceof JScrollPane && ((JScrollPane)sc).getHorizontalScrollBarPolicy() == 31) {
                this.horizontalMode = false;
                width = ((JViewport)c).getViewRect().width;
                this.cols = width / this.getCharWidth();
                if (this.cols < 1) {
                    this.cols = 100;
                }
            }
        }
        int desiredHeight = this.getRowCount() * (this.getRowHeight() + this.getRowMargin());
        int desiredWidth = this.cols * this.getCharWidth();
        height = desiredHeight;
        if (desiredWidth != this.getPreferredSize().width && desiredHeight != this.getPreferredSize().height) {
            this.setPreferredSize(new Dimension(desiredWidth, desiredHeight));
            if (width == -1) {
                this.setSize(this.getPreferredSize());
            } else {
                this.setSize(desiredWidth, this.getPreferredSize().height);
            }
        }
    }

    public void addNotify() {
        Container sc;
        Container c = this.getParent();
        if (c != null && c instanceof JViewport && (sc = c.getParent()) instanceof JScrollPane && ((JScrollPane)sc).getVerticalScrollBarPolicy() == 21) {
            this.horizontalMode = true;
        }
        this.reformat();
        super.addNotify();
    }

    public int getRowHeight() {
        return this.getCharHeight() * this.sequences.size();
    }

    public int getCharWidth() {
        return this.getFont().getSize();
    }

    public Rectangle getRectangleForCharPosition(int pos, int tier) {
        Point p = this.getPixelLocForPosition(pos, tier);
        return new Rectangle(p.x, p.y, this.getCharWidth(), this.getCharHeight());
    }

    public Point getPixelLocForPosition(int pos, int tier) {
        if (tier == -1) {
            tier = this.sequences.size() - 1;
        }
        int colNum = this.getColForPosition(pos);
        int rowNum = this.getRowForPosition(pos);
        int tierHeight = this.getRowHeight();
        int x = colNum * this.getCharWidth();
        int y = rowNum * (tierHeight + this.getRowMargin()) + tier * this.getCharHeight();
        return new Point(x, y);
    }

    public Rectangle getRectangleForTierPosition(int pos) {
        Point p = this.getPixelLocForPosition(pos, 0);
        return new Rectangle(p.x, p.y, this.getCharWidth(), this.getRowHeight());
    }

    public int getRowForPosition(int pos) {
        return pos / this.cols;
    }

    public int getColumnCount() {
        return this.cols;
    }

    public int getRowCount() {
        int length = this.residueToPos(this.getLongestSeq()) + 1;
        return (int)Math.ceil((double)length / (double)this.cols);
    }

    public int getColForPosition(int pos) {
        return pos % this.cols;
    }

    public int getRowForPixelPosition(int y) {
        int rowNum = y / (this.getRowHeight() + this.getRowMargin());
        return rowNum;
    }

    public int getTierForPixelPosition(int y) {
        int loc = y % (this.getRowHeight() + this.getRowMargin()) / this.getCharHeight();
        return loc;
    }

    protected Point getPixelLocForColAndRow(int col, int row) {
        return new Point(col * this.getCharWidth(), row * (this.getRowHeight() + this.getRowMargin()));
    }

    public void scrollToRow(int row) {
        JViewport view = SwingMissingUtil.getViewportAncestor(this);
        if (view != null) {
            Point point = this.getPixelLocForColAndRow(0, row);
            if (point.x + view.getViewRect().width > this.getSize().width) {
                point.x = this.getSize().width - view.getViewRect().width;
            }
            if (point.x + view.getViewRect().height > this.getSize().height) {
                point.y = this.getSize().height - view.getViewRect().height;
            }
            view.setViewPosition(point);
        }
    }

    public int getVisibleBase() {
        JViewport view = SwingMissingUtil.getViewportAncestor(this);
        if (view == null) {
            return -1;
        }
        Rectangle r = view.getViewRect();
        int row = this.getRowForPixelPosition(r.y);
        int col = this.getColForPixelPosition(r.x);
        int pos = col + row * this.getColumnCount();
        return this.posToBasePair(pos);
    }

    public int posToBasePair(int pos) {
        if (this.reverseStrand) {
            return this.highestBase - pos;
        }
        return pos + this.lowestBase;
    }

    public int basePairToPos(int basePair) {
        if (this.reverseStrand) {
            return this.highestBase - basePair;
        }
        return basePair - this.lowestBase;
    }

    public int posToResidue(int pos) {
        if (this.reverseStrand) {
            return pos;
        }
        return pos + this.lowestBase;
    }

    public int residueToPos(int residue) {
        if (this.reverseStrand) {
            return residue;
        }
        return residue - this.lowestBase;
    }

    public int residueToBasePair(int residue) {
        if (this.reverseStrand) {
            return residue;
        }
        return residue - this.lowestBase;
    }

    public int getLowestBase() {
        return this.lowestBase;
    }

    public int getHighestBase() {
        return this.highestBase;
    }

    public int getVisibleBaseCount() {
        JViewport view = SwingMissingUtil.getViewportAncestor(this);
        if (view == null) {
            return -1;
        }
        Rectangle r = view.getViewRect();
        int height = this.horizontalMode ? 0 : this.getRowForPixelPosition(r.height);
        int width = this.getColForPixelPosition(r.width);
        return this.getColumnCount() * height + width;
    }

    public void scrollToBase(int basepair) {
        this.scrollToPosition(this.basePairToPos(basepair));
    }

    public void scrollToPosition(int pos) {
        JViewport view = SwingMissingUtil.getViewportAncestor(this);
        if (view != null) {
            Point point = this.getPixelLocForPosition(pos, 0);
            if (point.x + view.getViewRect().width > this.getSize().width) {
                point.x = this.getSize().width - view.getViewRect().width;
            }
            if (!this.horizontalMode && point.y + view.getViewRect().height > this.getSize().height) {
                point.y = this.getSize().height - view.getViewRect().height;
            }
            view.setViewPosition(point);
        }
    }

    public void scrollToFeature(SeqFeatureI feature) {
        JViewport view = SwingMissingUtil.getViewportAncestor(this);
        if (feature != null && view != null) {
            Rectangle r = view.getViewRect();
            int first_row = this.getRowForPixelPosition(r.y);
            int first_col = this.getColForPixelPosition(r.x);
            int first_pos = first_col + first_row * this.getColumnCount();
            int first_base = this.posToBasePair(first_pos);
            int last_row = this.getRowForPixelPosition(r.y + r.height);
            int last_col = this.getColForPixelPosition(r.x + r.width);
            int last_pos = last_col + last_row * this.getColumnCount();
            int last_base = this.posToBasePair(last_pos);
            if (!this.reverseStrand && (feature.getStart() > last_base || feature.getEnd() < first_base) || this.reverseStrand && (feature.getStart() < first_base || feature.getEnd() > last_base)) {
                this.scrollToBase(feature.getStart());
            }
        }
    }

    public int getColForPixelPosition(int x) {
        int colNum = x / this.getCharWidth();
        return colNum;
    }

    public Rectangle getPosRectangleForPixels(Rectangle r) {
        int rowStart = this.getRowForPixelPosition(r.y);
        int rowEnd = this.getRowForPixelPosition(r.y + r.height) - rowStart + 1;
        int colStart = this.getColForPixelPosition(r.x);
        int colEnd = this.getColForPixelPosition(r.x + r.width) - colStart + 1;
        return new Rectangle(colStart, rowStart, colEnd, rowEnd);
    }

    public void repaint(int startPos, int endPos) {
        int t;
        if (endPos < startPos) {
            int temp = endPos;
            endPos = startPos;
            startPos = temp;
        }
        int startCol = this.getColForPosition(startPos);
        int startRow = this.getRowForPosition(startPos);
        int endCol = this.getColForPosition(++endPos);
        int endRow = this.getRowForPosition(endPos);
        if (endRow < startRow) {
            t = endRow;
            endRow = startRow;
            startRow = t;
        }
        if (endCol < startCol) {
            t = endCol;
            endCol = startCol;
            startCol = t;
        }
        if (startRow == endRow) {
            this.repaint(startCol, startRow, endCol - startCol, 1);
        } else {
            this.repaint(0, startRow, this.cols, endRow - startRow + 1);
        }
    }

    public void repaint(int x, int y, int width, int height) {
        Point start = this.getPixelLocForColAndRow(x, y);
        int drawWidth = width * this.getCharWidth();
        int drawHeight = height * (this.getRowHeight() + this.getRowMargin());
        RepaintManager.currentManager(this).addDirtyRegion(this, start.x, start.y, drawWidth, drawHeight);
    }

    private void paint(Graphics g, int x, int y, int width, int height) {
        int charWidth = this.getCharWidth();
        FastTranslatedGraphics transG = new FastTranslatedGraphics(g);
        for (int j = y; j < y + height; ++j) {
            for (int i = x; i < x + width; ++i) {
                g.setFont(this.getFont());
                int pos = i + j * this.cols;
                g.setColor(this.getBackgroundColor(i));
                Point p = this.getPixelLocForPosition(pos, 0);
                g.fillRect(p.x, p.y, charWidth, this.getRowHeight() + this.getRowMargin());
                for (int n = 0; n < this.sequences.size(); ++n) {
                    char ch;
                    SeqWrapper sw = (SeqWrapper)this.sequences.elementAt(n);
                    if (!sw.isVisible() || (ch = sw.getCharAt(pos)) == '\u0000') continue;
                    Component c = sw.getRenderer().getBaseRendererComponent(ch, pos, n, sw.getSequence());
                    Point pl = this.getPixelLocForPosition(pos, n);
                    transG.translateAbsolute(pl.x, pl.y);
                    c.paint((Graphics)transG);
                }
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle clipBounds = g.getClipBounds();
        Rectangle clipPos = this.getPosRectangleForPixels(clipBounds);
        int x = clipPos.x;
        int y = clipPos.y;
        int width = clipPos.width;
        int height = clipPos.height;
        this.paint(g, x, y, width, height);
    }

    private Color getBackgroundColor(int column) {
        if (column % (this.stripeWidth * 2) >= this.stripeWidth) {
            return this.getBackgroundColor2();
        }
        return this.getBackgroundColor1();
    }

    protected Color getBackgroundColor1() {
        return Config.getExonDetailEditorBackgroundColor1();
    }

    protected Color getBackgroundColor2() {
        return Config.getExonDetailEditorBackgroundColor2();
    }

    protected Graphics createGraphics(Graphics g, int x, int y, int w, int h) {
        Graphics out = g.create();
        out.translate(x, y);
        return out;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width * 3 / 4;
        }
        return visibleRect.height;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return this.getCharWidth();
        }
        if (this.horizontalMode) {
            return this.getCharHeight();
        }
        return this.getRowHeight() + this.getRowMargin();
    }

    protected void haltThread(AutoscrollThread thread) {
        if (thread == null) {
            return;
        }
        if (thread.getHalt()) {
            return;
        }
        thread.halt();
        thread.interrupt();
    }

    protected void handleAutoscroll(int x, int y) {
        int threshold = 20;
        int interval = 100;
        int distance = this.getCharHeight();
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            boolean rightHotspot;
            JViewport view = (JViewport)parent;
            Rectangle rect = view.getViewRect();
            boolean upperHotspot = (double)y < rect.getY() + (double)threshold;
            boolean leftHotspot = (double)x < rect.getX() + (double)threshold;
            boolean lowerHotspot = (double)y > rect.getY() + rect.getHeight() - (double)threshold;
            boolean bl = rightHotspot = (double)x > rect.getX() + rect.getWidth() - (double)threshold;
            if (!leftHotspot && !rightHotspot) {
                this.haltThread(this.horizontalScrollThread);
            }
            if (!upperHotspot && !lowerHotspot) {
                this.haltThread(this.verticalScrollThread);
            }
            if (leftHotspot) {
                this.haltThread(this.horizontalScrollThread);
                this.horizontalScrollThread = new AutoscrollThread(interval, distance, view, 3);
                this.horizontalScrollThread.start();
            }
            if (rightHotspot) {
                this.haltThread(this.horizontalScrollThread);
                this.horizontalScrollThread = new AutoscrollThread(interval, distance, view, 4);
                this.horizontalScrollThread.start();
            }
            if (upperHotspot) {
                this.haltThread(this.verticalScrollThread);
                this.verticalScrollThread = new AutoscrollThread(interval, distance, view, 1);
                this.verticalScrollThread.start();
            }
            if (lowerHotspot) {
                this.haltThread(this.verticalScrollThread);
                this.verticalScrollThread = new AutoscrollThread(interval, distance, view, 2);
                this.verticalScrollThread.start();
            }
        }
    }

    protected class AutoscrollThread
    extends Thread
    implements Directions {
        private int timeInterval;
        private int distance;
        private JViewport viewport;
        private Component comp;
        private int direction;
        protected boolean halt;

        public AutoscrollThread(int timeInterval, int distance, JViewport viewport, int direction) {
            this.timeInterval = timeInterval;
            this.distance = distance;
            this.viewport = viewport;
            this.direction = direction;
            this.comp = viewport.getView();
            this.halt = false;
        }

        public void run() {
            do {
                Point p = this.viewport.getViewPosition();
                int x = (int)p.getX();
                int y = (int)p.getY();
                int verticaloffset = 0;
                int horizontaloffset = 0;
                if (this.direction == 1) {
                    verticaloffset = -this.distance;
                } else if (this.direction == 2) {
                    verticaloffset = this.distance;
                } else if (this.direction == 3) {
                    horizontaloffset = -this.distance;
                } else if (this.direction == 4) {
                    horizontaloffset = this.distance;
                }
                Dimension scrollerSize = this.viewport.getSize();
                Dimension viewSize = this.viewport.getView().getSize();
                if ((x += horizontaloffset) < 0 || (y += verticaloffset) < 0 || !((double)x + scrollerSize.getWidth() <= viewSize.getWidth()) || !((double)y + scrollerSize.getHeight() <= viewSize.getHeight())) {
                    this.halt = true;
                    return;
                }
                Point newPos = new Point(x, y);
                this.viewport.setViewPosition(newPos);
                this.comp.repaint();
                try {
                    AutoscrollThread.sleep(this.timeInterval);
                }
                catch (InterruptedException e) {
                    this.halt = true;
                    return;
                }
            } while (!this.halt);
        }

        public boolean getHalt() {
            return this.halt;
        }

        public void halt() {
            this.halt = true;
        }
    }

    protected class ScrollMouseListener
    extends MouseInputAdapter {
        protected ScrollMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            SeqAlignPanel.this.haltThread(SeqAlignPanel.this.verticalScrollThread);
            SeqAlignPanel.this.haltThread(SeqAlignPanel.this.horizontalScrollThread);
        }

        public void mouseDragged(MouseEvent e) {
            SeqAlignPanel.this.handleAutoscroll(e.getX(), e.getY());
        }
    }

    public class DefaultRowHeader
    extends JPanel {
        protected int low = 1;

        public void addNotify() {
            this.removeAll();
            GridLayout layout = new GridLayout(SeqAlignPanel.this.getRowCount(), 1, 0, 0);
            this.setLayout(layout);
            Font font = new Font("Dialog", 0, 12);
            this.setPreferredSize(new Dimension(66, SeqAlignPanel.this.getRowCount() * (SeqAlignPanel.this.getRowHeight() + SeqAlignPanel.this.getRowMargin())));
            this.setSize(this.getPreferredSize());
            for (int i = 0; i < SeqAlignPanel.this.getRowCount(); ++i) {
                JLabel b = new JLabel("" + (i * SeqAlignPanel.this.getColumnCount() + this.low + SeqAlignPanel.this.lowestBase));
                b.setFont(font);
                this.add(b);
            }
            super.addNotify();
        }

        public void setLowest(int low) {
            this.low = low;
        }
    }
}

