/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.TranslationI;
import apollo.editor.AnnotationEditor;
import apollo.gui.detailviewers.exonviewer.BaseEditorPanel;
import apollo.gui.detailviewers.exonviewer.BaseRenderer;
import apollo.gui.detailviewers.exonviewer.SelectableDNARenderer;
import apollo.gui.event.MouseButtonEvent;
import apollo.util.ClipboardUtil;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

class BaseMouseListener
extends MouseInputAdapter {
    private BaseEditorPanel baseEditorPanel;
    int dragStartPos = -1;
    int startPos = -1;
    int preDragStartBasePair = -1;
    int preDragEndBasePair = -1;
    int dragType = -1;
    int limit_3prime = -1;
    int limit_5prime = -1;
    SeqFeatureI dragFeature;
    boolean dragging = false;
    int tier = -1;
    int startDragTier = -1;
    int pos = -1;

    BaseMouseListener(BaseEditorPanel baseEditorPanel) {
        this.baseEditorPanel = baseEditorPanel;
    }

    public int getTier() {
        return this.tier;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int x, int y) {
        this.tier = this.baseEditorPanel.getTierForPixelPosition(y);
        this.pos = this.calculatePosition(x, y);
    }

    private int calculatePosition(int x, int y) {
        int row = this.baseEditorPanel.getRowForPixelPosition(y);
        int col = this.baseEditorPanel.getColForPixelPosition(x);
        return this.baseEditorPanel.getColumnCount() * row + col;
    }

    public void mouseMoved(MouseEvent e) {
        int mouseMoveTier = this.baseEditorPanel.getTierForPixelPosition(e.getY());
        int mouseMovePos = this.calculatePosition(e.getX(), e.getY());
        int type = this.baseEditorPanel.getBoundaryType(mouseMovePos, mouseMoveTier);
        if (type == 0) {
            this.baseEditorPanel.setCursor(Cursor.getDefaultCursor());
        } else {
            this.baseEditorPanel.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mousePressed(MouseEvent e) {
        BaseRenderer rend;
        this.setPos(e.getX(), e.getY());
        if (MouseButtonEvent.isRightMouseClickNoShift(e) && (rend = this.baseEditorPanel.getRendererAt(this.tier)) instanceof SelectableDNARenderer) {
            ((SelectableDNARenderer)rend).setTargetPos(this.pos, this.tier);
            this.baseEditorPanel.repaint();
            return;
        }
        if (!MouseButtonEvent.isLeftMouseClick(e)) {
            return;
        }
        if (this.dragStartPos == -1) {
            this.dragType = e.isControlDown() ? 2100 : this.baseEditorPanel.getBoundaryType(this.pos, this.tier);
            this.dragFeature = this.baseEditorPanel.getFeatureAtPosition(this.pos, this.tier);
            this.dragStartPos = this.pos;
            this.startPos = this.pos;
            this.startDragTier = this.tier;
            if (this.dragFeature == null) {
                if (this.dragType != 2100 || this.startDragTier > this.baseEditorPanel.getTierCount() || this.startDragTier < 3) {
                    this.resetDragState();
                    return;
                }
            }
            if (this.dragType == 1) {
                this.limit_3prime = this.dragFeature.getEnd();
                int lowBound = this.baseEditorPanel.basePairToPos(this.dragFeature.getStart());
                double[] lowRange = this.baseEditorPanel.getRangeAtPosition(this.tier, lowBound - 1);
                this.limit_5prime = lowRange[0] < 0.0 ? this.baseEditorPanel.posToBasePair(0) : this.baseEditorPanel.posToBasePair((int)lowRange[0]);
                this.baseEditorPanel.setCursor(Cursor.getPredefinedCursor(10));
            } else if (this.dragType == 2) {
                SequenceI seq;
                this.limit_5prime = this.dragFeature.getStart();
                int highBound = this.baseEditorPanel.basePairToPos(this.dragFeature.getEnd());
                double[] highRange = this.baseEditorPanel.getRangeAtPosition(this.tier, highBound + 1);
                this.limit_3prime = highRange[1] > (double)(seq = this.baseEditorPanel.getSequenceForTier(this.tier)).getLength() ? this.baseEditorPanel.posToBasePair(seq.getLength()) : this.baseEditorPanel.posToBasePair((int)highRange[1]);
                this.baseEditorPanel.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.dragType == 2100) {
                this.baseEditorPanel.setCursor(Cursor.getPredefinedCursor(2));
                this.baseEditorPanel.setSelectBeginPos(this.pos);
                this.baseEditorPanel.setSelectCurrentPos(this.pos);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!MouseButtonEvent.isLeftMouseClick(e)) {
            return;
        }
        if (!this.dragging && this.dragFeature != null) {
            this.preDragStartBasePair = this.dragFeature.getStart();
            this.preDragEndBasePair = this.dragFeature.getEnd();
        }
        this.dragging = true;
        if (this.dragType == 1) {
            this.baseEditorPanel.setCursor(Cursor.getPredefinedCursor(10));
        } else if (this.dragType == 2) {
            this.baseEditorPanel.setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.dragType == 2100) {
            this.baseEditorPanel.setCursor(Cursor.getPredefinedCursor(2));
        }
        this.setPos(e.getX(), e.getY());
        this.startPos = this.pos;
        if (this.dragType == 1) {
            if (this.baseEditorPanel.notTooSmall(this.pos, this.baseEditorPanel.basePairToPos(this.dragFeature.getEnd()))) {
                this.baseEditorPanel.changeStart(this.dragFeature, this.pos - this.dragStartPos, this.limit_5prime, this.limit_3prime);
            }
        } else if (this.dragType == 2) {
            if (this.baseEditorPanel.notTooSmall(this.baseEditorPanel.basePairToPos(this.dragFeature.getStart()), this.pos)) {
                this.baseEditorPanel.changeEnd(this.dragFeature, this.pos - this.dragStartPos, this.limit_5prime, this.limit_3prime);
            }
        } else if (this.dragType == 2100) {
            int redrawLowPos = this.baseEditorPanel.selectLowPos();
            int redrawHighPos = this.baseEditorPanel.selectHighPos();
            if (this.pos < redrawLowPos) {
                redrawLowPos = this.pos;
            }
            if (this.pos > redrawHighPos) {
                redrawHighPos = this.pos;
            }
            this.baseEditorPanel.setSelectCurrentPos(this.pos);
            this.baseEditorPanel.repaint(redrawLowPos, redrawHighPos);
            return;
        }
        this.baseEditorPanel.repaint(this.pos, this.dragStartPos);
        this.dragStartPos = this.pos;
    }

    protected void resetDragState() {
        this.baseEditorPanel.setCursor(Cursor.getDefaultCursor());
        this.dragStartPos = -1;
        this.dragType = -1;
        this.limit_5prime = -1;
        this.limit_3prime = -1;
        this.baseEditorPanel.setSelectBeginPos(-1);
        this.baseEditorPanel.setSelectCurrentPos(-1);
        this.dragFeature = null;
        this.dragging = false;
        this.preDragStartBasePair = -1;
        this.preDragEndBasePair = -1;
    }

    public void mouseReleased(MouseEvent e) {
        BaseRenderer rend;
        if (MouseButtonEvent.isRightMouseClick(e) && (rend = this.baseEditorPanel.getRendererAt(this.tier)) instanceof SelectableDNARenderer) {
            ((SelectableDNARenderer)rend).setTargetPos(-1, -1);
            this.baseEditorPanel.repaint();
        }
        if (this.dragType == 2100) {
            SequenceI seq = this.baseEditorPanel.getSequenceForTier(this.startDragTier);
            int lowBP = this.baseEditorPanel.posToResidue(this.baseEditorPanel.selectLowPos());
            int highBP = this.baseEditorPanel.posToResidue(this.baseEditorPanel.selectHighPos());
            String sequence = seq.getResidues(lowBP, highBP);
            String header = " Arbitrary selection (" + seq.getName() + ": " + lowBP + "," + highBP + ")";
            ClipboardUtil.copySeqToClipboard(new Sequence(header, sequence));
            this.resetDragState();
            this.baseEditorPanel.repaint();
            return;
        }
        if (!MouseButtonEvent.isLeftMouseClick(e) || !this.dragging || this.dragFeature == null) {
            this.resetDragState();
            return;
        }
        if (this.dragging && this.dragFeature != null && this.dragFeature.isAnnot()) {
            if (this.dragFeature.isExon() && this.dragFeature.getRefFeature() != null && this.dragFeature.getRefFeature().isTranscript()) {
                SeqFeatureI transcript = this.dragFeature.getRefFeature();
                TranslationI cds = transcript.getTranslation();
                int transStart = transcript.getStart();
                int cdsStart = cds.getTranslationStart();
                boolean isForward = transcript.isForwardStrand();
                if (cds.isMissing5prime() && (isForward && transStart < cdsStart || !isForward && transStart > cdsStart)) {
                    cds.calcTranslationStartForLongestPeptide();
                } else {
                    cds.setTranslationEndFromStart();
                }
            }
            int oldStart = this.preDragStartBasePair == -1 ? this.dragFeature.getStart() : this.preDragStartBasePair;
            int oldEnd = this.preDragEndBasePair == -1 ? this.dragFeature.getEnd() : this.preDragEndBasePair;
            AnnotationEditor ae = this.baseEditorPanel.getAnnotationEditor();
            ae.setAnnotTerminus(this.dragFeature.getAnnotatedFeature(), oldStart, oldEnd, this.dragFeature.getStart(), this.dragFeature.getEnd());
            this.baseEditorPanel.repaint();
        }
        this.resetDragState();
        this.baseEditorPanel.getCurationState().getSZAP().repaint();
    }

    public void mouseClicked(MouseEvent e) {
        this.setPos(e.getX(), e.getY());
        if (MouseButtonEvent.isRightMouseClickNoShift(e) && this.tier > 2) {
            this.baseEditorPanel.displayRightClickMenu(e.getX(), e.getY());
        }
        if (MouseButtonEvent.isMiddleMouseClickNoShift(e)) {
            this.baseEditorPanel.scrollToPosition(this.pos);
        } else if (MouseButtonEvent.isRightMouseClickWithShift(e)) {
            this.baseEditorPanel.scrollToPosition(this.pos);
        }
        if (MouseButtonEvent.isLeftMouseClick(e)) {
            this.baseEditorPanel.selectAnnot(this.pos, this.tier);
            this.baseEditorPanel.repaint();
        }
    }
}

