/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.gui.detailviewers.exonviewer.BaseEditorPanel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class BaseFineEditorRowHeader
extends JComponent {
    BaseEditorPanel baseEditorPanel;
    int textMargin = 10;

    public BaseFineEditorRowHeader(BaseEditorPanel baseEditorPanel) {
        this.baseEditorPanel = baseEditorPanel;
        int panelHeight = baseEditorPanel.getRowHeight() + baseEditorPanel.getRowMargin();
        this.setPreferredSize(new Dimension(100, baseEditorPanel.getRowCount() * panelHeight));
        this.setSize(this.getPreferredSize());
    }

    public void paint(Graphics g) {
        int panelHeight = this.baseEditorPanel.getRowHeight() + this.baseEditorPanel.getRowMargin();
        Rectangle clipBounds = g.getClipBounds();
        Rectangle clipPos = this.baseEditorPanel.getPosRectangleForPixels(clipBounds);
        for (int row = clipPos.y; row < clipPos.y + clipPos.height; ++row) {
            g.drawLine(0, row * panelHeight, this.getSize().width, row * panelHeight);
            for (int tier = 0; tier < this.baseEditorPanel.getTierCount(); ++tier) {
                int y = row * panelHeight + this.baseEditorPanel.getCharHeight() * (tier + 1);
                g.drawString(this.getString(row, tier), this.textMargin, y);
            }
        }
    }

    public String getString(int row, int tier) {
        int pos = row * this.baseEditorPanel.getColumnCount();
        int basepair = this.baseEditorPanel.posToBasePair(pos);
        return tier == 0 ? "" + basepair : "";
    }
}

