/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.SelectionManager;
import apollo.gui.Transformer;
import apollo.gui.detailviewers.exonviewer.BaseEditorPanel;
import apollo.gui.detailviewers.exonviewer.BaseFineEditorRowHeader;
import apollo.gui.detailviewers.exonviewer.TranslationViewer;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.synteny.GuiCurationState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BaseFineEditor
extends JFrame
implements FeatureSelectionListener,
ControlledObjectI,
AnnotationChangeListener {
    private static final Color[] colorList = new Color[]{new Color(0, 0, 0), new Color(255, 255, 0), new Color(0, 255, 255), new Color(255, 0, 255), new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255)};
    private static int colorIndex = 0;
    private static ArrayList baseEditorInstanceList = new ArrayList(5);
    protected BaseEditorPanel editorPanel = null;
    private TranslationViewer translationViewer;
    private JViewport viewport;
    protected JLabel lengthLabel;
    private JComboBox transcriptComboBox;
    StrandedZoomableApolloPanel szap;
    Transformer transformer;
    private FineEditorScrollListener scrollListener;
    Color indicatorColor;
    JPanel colorSwatch;
    SelectionManager selection_manager;
    protected JButton findButton;
    protected JButton clearFindsButton;
    protected JCheckBox showIntronBox;
    private JCheckBox followSelectionCheckBox;
    protected JButton upstream_button;
    protected JButton downstream_button;
    private AnnotatedFeatureI currentAnnot;
    protected Transcript neighbor_up;
    protected Transcript neighbor_down;
    private GuiCurationState curationState;
    private TranscriptComboBoxItemListener transItemListener = new TranscriptComboBoxItemListener();

    public static void showBaseEditor(AnnotatedFeatureI editMe, GuiCurationState curationState, SeqFeatureI geneHolder) {
        BaseFineEditor bfe = new BaseFineEditor(editMe, curationState, geneHolder);
        baseEditorInstanceList.add(bfe);
    }

    private BaseFineEditor(AnnotatedFeatureI editMe, GuiCurationState curationState, SeqFeatureI geneHolder) {
        super((editMe.isForwardStrand() ? "Forward" : "Reverse") + " Strand Exon Editor");
        this.curationState = curationState;
        curationState.getController().addListener(this);
        curationState.getController().addListener(new BaseEditorDataListener());
        this.szap = curationState.getSZAP();
        this.transformer = this.szap.getScaleView().getTransform();
        int seqStart = curationState.getCurationSet().getLow();
        int seqEnd = curationState.getCurationSet().getHigh();
        this.editorPanel = new BaseEditorPanel(curationState, this, !editMe.isForwardStrand(), seqStart, seqEnd, geneHolder);
        this.initGui(editMe);
        this.editorPanel.displayAnnot(editMe);
        this.attachListeners();
        this.showEditRegion();
        this.displayAnnot(this.getTransOrOneLevelAnn(editMe));
        this.translationViewer.repaint();
        this.setVisible(true);
        if (this.getState() == 1) {
            this.setState(0);
        }
    }

    public void setController(Controller controller) {
    }

    public Controller getController() {
        return this.curationState.getController();
    }

    public Object getControllerWindow() {
        return this;
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    public void setSelectionManager(SelectionManager sm) {
        this.selection_manager = sm;
    }

    public SelectionManager getSelectionManager() {
        return this.curationState.getSelectionManager();
    }

    private void removeComponents(Container cont) {
        Component[] components = cont.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (comp == null) continue;
            cont.remove(comp);
            if (!(comp instanceof Container)) continue;
            this.removeComponents((Container)comp);
        }
    }

    public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
        if (this.isVisible() && evt.getSource() != this) {
            boolean is_reverse;
            if (evt.isEndOfEditSession()) {
                this.displayAnnot(this.currentAnnot);
                this.repaint();
                return true;
            }
            AnnotatedFeatureI sf = evt.getAnnotTop();
            boolean bl = is_reverse = sf.getStrand() == -1;
            if (this.editorPanel.getReverseStrand() != is_reverse) {
                return false;
            }
            if (evt.isDelete() && evt.isRootAnnotChange()) {
                AnnotatedFeatureI gene = evt.getChangedAnnot();
                int trans_count = gene.size();
                for (int i = 0; i < trans_count; ++i) {
                    Transcript t = (Transcript)gene.getFeatureAt(i);
                    this.editorPanel.detachTranscript(t);
                    if (t != this.currentAnnot) continue;
                    this.currentAnnot = null;
                }
            } else if (evt.isDelete() && evt.isTranscriptChange()) {
                Transcript t = (Transcript)evt.getChangedAnnot();
                this.editorPanel.detachTranscript(t);
                if (t == this.currentAnnot) {
                    this.currentAnnot = null;
                }
            } else if ((evt.isAdd() || evt.isSplit() || evt.isMerge()) && evt.isRootAnnotChange()) {
                AnnotatedFeatureI gene = evt.getChangedAnnot();
                int trans_count = gene.size();
                for (int i = 0; i < trans_count; ++i) {
                    Transcript t = (Transcript)gene.getFeatureAt(i);
                    int tier = this.editorPanel.attachAnnot(t);
                }
            } else if (evt.isAdd() && evt.isTranscriptChange()) {
                Transcript t = (Transcript)evt.getChangedAnnot();
                int tier = this.editorPanel.attachAnnot(t);
            } else if (evt.isAdd() && evt.isExonChange()) {
                Transcript t = (Transcript)evt.getParentFeature();
                this.editorPanel.detachTranscript(t);
                this.editorPanel.attachAnnot(t);
            } else if (evt.isDelete() && evt.isExonChange()) {
                Transcript t = (Transcript)evt.getParentFeature();
                this.editorPanel.detachTranscript(t);
                this.editorPanel.attachAnnot(t);
            }
        }
        return true;
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
        if (!this.canHandleSelection(evt, this)) {
            return false;
        }
        AnnotatedFeatureI gai = (AnnotatedFeatureI)evt.getFeatures().getFeature(0);
        this.displayAnnot(this.getTransOrOneLevelAnn(gai));
        this.translationViewer.repaint();
        return true;
    }

    boolean canHandleSelection(FeatureSelectionEvent evt, Object self) {
        boolean is_reverse;
        if (this.noExternalSelection() && this.isExternalSelection(evt) && !evt.forceSelection()) {
            return false;
        }
        if (evt.getSource() == self) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        if (evt.getFeatures().size() == 0) {
            return false;
        }
        SeqFeatureI sf = evt.getFeatures().getFeature(0);
        boolean bl = is_reverse = sf.getStrand() == -1;
        if (is_reverse != this.editorPanel.getReverseStrand()) {
            return false;
        }
        return sf instanceof AnnotatedFeatureI;
    }

    private boolean isExternalSelection(FeatureSelectionEvent e) {
        return e.getSource() != this && e.getSource() != this.editorPanel;
    }

    private boolean noExternalSelection() {
        return !this.followSelectionCheckBox.isSelected();
    }

    public Color getIndicatorColor() {
        return this.indicatorColor;
    }

    private void showEditRegion() {
        colorIndex = (colorIndex + 1) % colorList.length;
        this.indicatorColor = colorList[colorIndex];
        this.colorSwatch.setBackground(this.indicatorColor);
        this.szap.addHighlightRegion(this.editorPanel, this.indicatorColor, this.editorPanel.getReverseStrand());
    }

    public void attachListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BaseFineEditor.this.szap.removeHighlightRegion(BaseFineEditor.this.editorPanel);
                BaseFineEditor.this.szap.repaint();
                BaseFineEditor.this.setVisible(false);
            }
        });
        this.clearFindsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseFineEditor.this.editorPanel.setShowHitZones(false);
                BaseFineEditor.this.clearFindsButton.setEnabled(false);
            }
        });
        this.findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseFineEditor.this.editorPanel.showFindDialog();
            }
        });
        this.showIntronBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseFineEditor.this.translationViewer.setDrawIntrons(BaseFineEditor.this.showIntronBox.isSelected());
            }
        });
        this.upstream_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseFineEditor.this.selectAnnot(BaseFineEditor.this.neighbor_up);
            }
        });
        this.downstream_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseFineEditor.this.selectAnnot(BaseFineEditor.this.neighbor_down);
            }
        });
    }

    public static void disposeAllEditors() {
        Iterator it = baseEditorInstanceList.iterator();
        while (it.hasNext()) {
            ((BaseFineEditor)it.next()).dispose();
        }
        baseEditorInstanceList.clear();
    }

    public void dispose() {
        this.removeComponents(this);
        this.editorPanel.cleanup();
        this.szap.removeHighlightRegion(this.editorPanel);
        this.editorPanel = null;
        this.translationViewer = null;
        this.viewport.removeChangeListener(this.scrollListener);
        this.viewport = null;
        this.lengthLabel = null;
        this.transcriptComboBox = null;
        this.szap = null;
        this.transformer = null;
        this.scrollListener = null;
        this.indicatorColor = null;
        this.colorSwatch = null;
        this.getController().removeListener(this);
        this.findButton = null;
        this.clearFindsButton = null;
        this.upstream_button = null;
        this.downstream_button = null;
        super.dispose();
    }

    private void initGui(AnnotatedFeatureI annot) {
        this.translationViewer = new TranslationViewer(this.editorPanel);
        this.translationViewer.setBackground(Color.black);
        this.transcriptComboBox = new JComboBox();
        this.lengthLabel = new JLabel("Translation length: <no feature selected>");
        this.lengthLabel.setForeground(Color.black);
        this.findButton = new JButton("Find sequence...");
        this.clearFindsButton = new JButton("Clear search hits");
        this.clearFindsButton.setEnabled(false);
        this.showIntronBox = new JCheckBox("Show introns in translation viewer", true);
        this.showIntronBox.setBackground(Color.white);
        this.followSelectionCheckBox = new JCheckBox("Follow external selection", false);
        this.followSelectionCheckBox.setBackground(Color.white);
        this.upstream_button = new JButton();
        this.downstream_button = new JButton();
        this.colorSwatch = new JPanel();
        this.setSize(824, 500);
        JScrollPane pane = new JScrollPane(this.editorPanel);
        pane.setHorizontalScrollBarPolicy(31);
        pane.setRowHeaderView(new BaseFineEditorRowHeader(this.editorPanel));
        this.viewport = pane.getViewport();
        this.colorSwatch.setPreferredSize(new Dimension(10, 10));
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.colorSwatch, "North");
        this.getContentPane().add((Component)pane, "Center");
        Box transcriptListBox = new Box(0);
        JLabel tranLabel = annot.isAnnotTop() ? new JLabel("Annotation: ") : new JLabel("Transcript: ");
        tranLabel.setForeground(Color.black);
        transcriptListBox.add(Box.createHorizontalStrut(5));
        transcriptListBox.add(tranLabel);
        transcriptListBox.setBackground(Color.white);
        this.transcriptComboBox.setMaximumSize(new Dimension(300, 30));
        transcriptListBox.add(this.transcriptComboBox);
        transcriptListBox.add(Box.createHorizontalGlue());
        transcriptListBox.add(Box.createHorizontalStrut(5));
        transcriptListBox.add(this.lengthLabel);
        transcriptListBox.add(Box.createHorizontalGlue());
        Box checkboxesTop = new Box(0);
        checkboxesTop.setBackground(Color.white);
        checkboxesTop.add(Box.createHorizontalStrut(5));
        checkboxesTop.add(this.findButton);
        checkboxesTop.add(Box.createHorizontalStrut(10));
        checkboxesTop.add(this.clearFindsButton);
        checkboxesTop.add(Box.createHorizontalGlue());
        Box checkboxesBottom = new Box(0);
        checkboxesBottom.add(this.showIntronBox);
        checkboxesBottom.add(Box.createHorizontalGlue());
        checkboxesBottom.add(Box.createHorizontalStrut(10));
        checkboxesBottom.add(this.followSelectionCheckBox);
        Box checkboxes = new Box(1);
        checkboxes.add(checkboxesTop);
        checkboxes.add(checkboxesBottom);
        Box labelPanel = new Box(1);
        labelPanel.setBackground(Color.white);
        labelPanel.add(transcriptListBox);
        labelPanel.add(Box.createVerticalStrut(5));
        labelPanel.add(checkboxes);
        Box navPanel = new Box(1);
        navPanel.setBackground(Color.white);
        navPanel.add(this.upstream_button);
        navPanel.add(Box.createVerticalStrut(10));
        navPanel.add(this.downstream_button);
        navPanel.add(Box.createVerticalGlue());
        Box textBoxes = new Box(0);
        textBoxes.setBackground(Color.white);
        textBoxes.add(labelPanel);
        textBoxes.add(navPanel);
        Box detailPanel = new Box(1);
        detailPanel.setBackground(Color.white);
        detailPanel.add(this.translationViewer);
        detailPanel.add(textBoxes);
        this.getContentPane().add((Component)detailPanel, "South");
        this.validateTree();
        this.scrollListener = new FineEditorScrollListener();
        this.viewport.addChangeListener(this.scrollListener);
    }

    private void selectAnnot(AnnotatedFeatureI annot) {
        this.displayAnnot(this.getTransOrOneLevelAnn(annot));
        this.translationViewer.repaint();
        BaseFocusEvent evt = new BaseFocusEvent(this, annot.getStart(), annot);
        this.getController().handleBaseFocusEvent(evt);
        this.getSelectionManager().select(annot, (Object)this);
    }

    private void displayAnnot(AnnotatedFeatureI annot) {
        this.currentAnnot = annot;
        if (this.currentAnnot == null) {
            this.transcriptComboBox.removeAllItems();
            this.transcriptComboBox.addItem("<no feature selected>");
            this.lengthLabel.setText("Translation length: <no feature selected>");
            this.upstream_button.setLabel("");
            this.downstream_button.setLabel("");
            this.translationViewer.setTranscript(null, this.editorPanel.getSelectedTier());
            return;
        }
        this.setupTranscriptComboBox(this.currentAnnot);
        SeqFeatureI topAnnot = this.currentAnnot;
        if (topAnnot.isTranscript()) {
            topAnnot = this.currentAnnot.getRefFeature();
        }
        if (topAnnot.isProteinCodingGene()) {
            String translation = this.currentAnnot.translate();
            if (translation == null) {
                this.lengthLabel.setText("Translation length: <no start selected>");
            } else {
                this.lengthLabel.setText("Translation length: " + this.currentAnnot.translate().length());
            }
        } else {
            this.lengthLabel.setText(topAnnot.getFeatureType() + " annotation");
        }
        FeatureSetI holder = (FeatureSetI)topAnnot.getRefFeature();
        this.neighbor_up = null;
        this.neighbor_down = null;
        if (holder != null) {
            Transcript trans;
            FeatureSetI gene_sib;
            int i;
            int index = holder.getFeatureIndex(topAnnot);
            for (i = index - 1; i >= 0 && this.neighbor_up == null; --i) {
                gene_sib = (FeatureSetI)holder.getFeatureAt(i);
                if (!(gene_sib.getFeatureAt(0) instanceof Transcript) || !(trans = (Transcript)gene_sib.getFeatureAt(0)).haveWholeSequence()) continue;
                this.neighbor_up = trans;
            }
            for (i = index + 1; i < holder.size() && this.neighbor_down == null; ++i) {
                gene_sib = (FeatureSetI)holder.getFeatureAt(i);
                if (!(gene_sib.getFeatureAt(0) instanceof Transcript) || !(trans = (Transcript)gene_sib.getFeatureAt(0)).haveWholeSequence()) continue;
                this.neighbor_down = trans;
            }
        }
        this.upstream_button.setLabel(this.neighbor_up == null ? "" : "Go to next 5' annotation (" + this.neighbor_up.getParent().getName() + ")");
        this.upstream_button.setVisible(this.neighbor_up != null);
        this.downstream_button.setLabel(this.neighbor_down == null ? "" : "Go to next 3' annotation (" + this.neighbor_down.getParent().getName() + ")");
        this.downstream_button.setVisible(this.neighbor_down != null);
        if (this.currentAnnot.isTranscript()) {
            this.translationViewer.setTranscript((Transcript)this.currentAnnot, this.editorPanel.getSelectedTier());
        }
    }

    private void setupTranscriptComboBox(AnnotatedFeatureI annot) {
        if (this.transcriptComboBox.getSelectedItem() == annot) {
            return;
        }
        this.transcriptComboBox.removeItemListener(this.transItemListener);
        this.transcriptComboBox.removeAllItems();
        if (annot == null) {
            this.transcriptComboBox.addItem("<no feature selected>");
            return;
        }
        if (annot.isAnnotTop()) {
            this.transcriptComboBox.addItem(annot);
            return;
        }
        SeqFeatureI gene = annot.getRefFeature();
        Vector transcripts = gene.getFeatures();
        for (int i = 0; i < transcripts.size(); ++i) {
            this.transcriptComboBox.addItem(transcripts.elementAt(i));
        }
        this.transcriptComboBox.setSelectedItem(annot);
        this.transcriptComboBox.addItemListener(this.transItemListener);
    }

    private AnnotatedFeatureI getTransOrOneLevelAnn(AnnotatedFeatureI af) {
        if (af != null) {
            if (af.isTranscript()) {
                return af;
            }
            if (af.isExon()) {
                return af.getRefFeature().getAnnotatedFeature();
            }
            if (af.isAnnotTop()) {
                if (af.hasKids()) {
                    return af.getFeatureAt(0).getAnnotatedFeature();
                }
                return af;
            }
        }
        return null;
    }

    private class TranscriptComboBoxItemListener
    implements ItemListener {
        private TranscriptComboBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && e.getItem() instanceof Transcript) {
                BaseFineEditor.this.selectAnnot((Transcript)e.getItem());
            }
        }
    }

    private class BaseEditorDataListener
    implements DataLoadListener {
        private BaseEditorDataListener() {
        }

        public boolean handleDataLoadEvent(DataLoadEvent e) {
            if (!e.dataRetrievalBeginning()) {
                return false;
            }
            BaseFineEditor.disposeAllEditors();
            BaseFineEditor.this.curationState.getController().removeListener(this);
            return true;
        }
    }

    private class FineEditorScrollListener
    implements ChangeListener {
        int oldstart = -1;
        int oldwidth = -1;

        private FineEditorScrollListener() {
        }

        public void stateChanged(ChangeEvent e) {
            BaseFineEditor.this.szap.repaint();
            BaseFineEditor.this.translationViewer.repaint();
        }
    }
}

