/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.detailviewers.exonviewer;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.CurationSet;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceEdit;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import apollo.editor.AnnotationEditor;
import apollo.gui.SequenceSelector;
import apollo.gui.detailviewers.exonviewer.AminoAcidRenderer;
import apollo.gui.detailviewers.exonviewer.BaseFineEditor;
import apollo.gui.detailviewers.exonviewer.BaseFineEditorRowHeader;
import apollo.gui.detailviewers.exonviewer.BaseMouseListener;
import apollo.gui.detailviewers.exonviewer.SelectableDNARenderer;
import apollo.gui.detailviewers.exonviewer.SeqAlignPanel;
import apollo.gui.detailviewers.seqexport.SeqExport;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.FeatureList;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.bdgp.util.DNAUtils;

public class BaseEditorPanel
extends SeqAlignPanel {
    public static final int SEQ_SELECT_DRAG = 2100;
    protected int padAmt = 15;
    protected SeqFeatureI selectedFeature;
    protected int selectedTier;
    protected AnnotationEditor annotationEditor;
    protected BaseFineEditor baseFineEditor;
    protected JLabel locationLabel;
    protected JLabel relativeLocationLabel;
    protected JPopupMenu rightClickMenu;
    protected JMenuItem makeIntronMenuItem;
    protected JMenuItem createExonMenuItem;
    protected JMenuItem merge5PrimeMenuItem;
    protected JMenuItem merge3PrimeMenuItem;
    protected JMenuItem set5PrimeMenuItem;
    protected JMenuItem set3PrimeMenuItem;
    protected JMenuItem deleteExonMenuItem;
    protected JMenuItem startTranslationMenuItem;
    protected JMenuItem translationSlipMenuItem;
    protected JMenuItem translationStutterMenuItem;
    protected JMenuItem insertionMenuItem;
    protected JMenuItem deletionMenuItem;
    protected JMenuItem substitutionMenuItem;
    protected JMenuItem noAdjustmentMenuItem;
    protected JMenu sequencingErrorSubMenu;
    protected JMenuItem findSequenceMenuItem;
    protected JMenuItem sequenceMenuItem;
    protected Color seqSelectColor = new Color(255, 153, 0);
    protected Color selectionBoxColor = Color.black;
    private SequenceI refSeq;
    protected SequenceI[] frame = new SequenceI[]{null, null, null};
    private static final int MIN_FEATURE_SIZE = 1;
    BaseMouseListener mouseListener;
    RightClickActionListener rightClickListener;
    protected int selectBeginPos = -1;
    protected int selectCurrentPos = -1;
    protected int[] splices = new int[2];
    protected Vector hitZones = new Vector();
    protected Vector translatedHitZones;
    protected boolean showHitZones = false;
    private GuiCurationState curationState;
    private BaseEditorSelectionListener baseEditorSelectionListener;
    private static Object[] bases = new Object[]{"A", "T", "G", "C", "N", "Cancel"};
    private static Object[] bases_noA = new Object[]{"T", "G", "C", "N", "Cancel"};
    private static Object[] bases_noT = new Object[]{"A", "G", "C", "N", "Cancel"};
    private static Object[] bases_noG = new Object[]{"A", "T", "C", "N", "Cancel"};
    private static Object[] bases_noC = new Object[]{"A", "T", "G", "N", "Cancel"};
    private static Object[] opts = new Object[]{"OK", "Cancel"};

    public BaseEditorPanel(GuiCurationState curationState, BaseFineEditor baseFineEditor, boolean reverseStrand, int lowestBase, int highestBase, SeqFeatureI annotFeatureSet) {
        super(1, lowestBase, highestBase);
        this.curationState = curationState;
        this.setFont(Config.getExonDetailEditorSequenceFont());
        this.translatedHitZones = new Vector(3);
        this.translatedHitZones.addElement(null);
        this.translatedHitZones.addElement(null);
        this.translatedHitZones.addElement(null);
        this.setReverseStrand(reverseStrand);
        this.annotationEditor = curationState.getAnnotationEditor(!reverseStrand);
        this.baseFineEditor = baseFineEditor;
        this.setStripeWidth(10);
        this.defaultRowHeader = new BaseFineEditorRowHeader(this);
        this.createRightClickMenu();
        this.attachListeners();
        this.baseEditorSelectionListener = new BaseEditorSelectionListener();
        baseFineEditor.getController().addListener(this.baseEditorSelectionListener);
        this.addTranscriptsFromFeatSet(annotFeatureSet);
    }

    AnnotationEditor getAnnotationEditor() {
        return this.curationState.getAnnotationEditor(!this.getReverseStrand());
    }

    public void setShowHitZones(boolean showHitZones) {
        this.showHitZones = showHitZones;
        this.repaint();
    }

    public boolean getShowHitZones() {
        return this.showHitZones;
    }

    private void addTranscriptsFromFeatSet(SeqFeatureI annotFeatureSet) {
        Vector annots = this.getTranscriptsAnd1LevAnnots(annotFeatureSet);
        this.attachTranscripts(annots);
    }

    private Vector getTranscriptsAnd1LevAnnots(SeqFeatureI annotFeatureSet) {
        Vector<SeqFeatureI> output = new Vector<SeqFeatureI>();
        if (annotFeatureSet.isTranscript()) {
            if (annotFeatureSet.isContainedByRefSeq()) {
                output.add(annotFeatureSet);
            }
        } else if (this.isOneLevelAnnot(annotFeatureSet)) {
            output.add(annotFeatureSet);
        } else {
            for (int i = 0; i < annotFeatureSet.getFeatures().size(); ++i) {
                SeqFeatureI feature = annotFeatureSet.getFeatureAt(i);
                if (!feature.canHaveChildren()) continue;
                output.addAll(this.getTranscriptsAnd1LevAnnots(feature));
            }
        }
        return output;
    }

    public void setHitZones(Vector hitZones) {
        this.hitZones = hitZones;
    }

    public void setTranslatedHitZones(Vector hitZones, int frame) {
        this.translatedHitZones.setElementAt(hitZones, frame);
    }

    public Vector getTranslatedHitZones(int frame) {
        if (frame >= this.translatedHitZones.size()) {
            return null;
        }
        return (Vector)this.translatedHitZones.elementAt(frame);
    }

    void cleanup() {
        this.baseFineEditor.getController().removeListener(this.baseEditorSelectionListener);
        this.memLeakBugWorkAround();
    }

    private void memLeakBugWorkAround() {
        this.annotationEditor = null;
        this.sequences = null;
        this.selectedFeature = null;
        this.refSeq = null;
    }

    public int selectLowPos() {
        return this.selectBeginPos < this.selectCurrentPos ? this.selectBeginPos : this.selectCurrentPos;
    }

    public int selectHighPos() {
        return this.selectBeginPos > this.selectCurrentPos ? this.selectBeginPos : this.selectCurrentPos;
    }

    void setSelectCurrentPos(int scp) {
        this.selectCurrentPos = scp;
    }

    void setSelectBeginPos(int sbp) {
        this.selectBeginPos = sbp;
    }

    public int getRowMargin() {
        return 20;
    }

    public Color[][] getColorArray() {
        Color firstExonColor = Config.getExonDetailEditorFeatureColor1();
        Color secondExonColor = Config.getExonDetailEditorFeatureColor2();
        Color[][] colors = new Color[][]{{firstExonColor, secondExonColor}};
        return colors;
    }

    public SeqFeatureI getSelectedFeature() {
        return this.selectedFeature;
    }

    public int getSelectedTier() {
        return this.selectedTier;
    }

    public int addFeature(SeqFeatureI feature) {
        return this.addAlignFeature(this.refSeq, feature);
    }

    void selectAnnot(int pos, int tier) {
        FeatureSetI sf = this.getFeatureSetAtPosition(pos, tier);
        this.showAnnotSelected(sf, tier);
        if (sf != null) {
            this.baseFineEditor.getSelectionManager().select(sf, (Object)this);
        }
    }

    private void showAnnotSelected(SeqFeatureI sf, int tier) {
        if (sf == null) {
            return;
        }
        this.selectedTier = tier;
        this.selectedFeature = sf;
    }

    void displayAnnot(AnnotatedFeatureI sf) {
        int tier;
        if (!sf.isTranscript() && !sf.isExon() && sf.hasKids()) {
            sf = sf.getFeatureAt(0).getAnnotatedFeature();
        }
        if ((tier = this.getTierForFeature(sf)) < 0) {
            System.out.println("Can't scroll to " + sf.getName() + " because it can't be found");
            new Throwable().printStackTrace();
        } else {
            this.showAnnotSelected(sf, tier);
            this.scrollToFeature(sf);
            this.repaint();
        }
    }

    private Vector findPositions(String seq, String search_str) {
        Vector<int[]> out = new Vector<int[]>();
        search_str = search_str.toUpperCase();
        int index = seq.indexOf(search_str, 0);
        while (index >= 0) {
            int[] indices = new int[]{index, index + search_str.length()};
            out.addElement(indices);
            index = seq.indexOf(search_str, index + 1);
        }
        return out;
    }

    private void findSplices(int pos, int strand, boolean add_exon, int low_limit, int high_limit) {
        boolean well_ordered;
        int donor;
        int acceptor;
        int start_pos = Math.max(pos - 12, low_limit + 1);
        int end_pos = Math.min(pos + 12, high_limit - 1);
        int dna_start = this.posToResidue(start_pos);
        int dna_end = this.posToResidue(end_pos);
        String dna = this.refSeq.getResidues(dna_start, dna_end);
        if (add_exon) {
            acceptor = dna.indexOf("AG");
            donor = dna.indexOf("GT", (int)((double)dna.length() * 0.5));
            well_ordered = donor != -1 && acceptor != -1 && acceptor < donor;
        } else {
            donor = dna.indexOf("GT");
            acceptor = dna.indexOf("AG", (int)((double)dna.length() * 0.5));
            boolean bl = well_ordered = donor != -1 && acceptor != -1 && donor < acceptor;
        }
        if (!well_ordered) {
            if (add_exon) {
                acceptor = this.posToBasePair(pos);
                donor = this.posToBasePair(pos);
            } else {
                donor = this.posToBasePair(pos - 1);
                acceptor = this.posToBasePair(pos + 1);
            }
        } else {
            donor = this.residueToBasePair(donor - 1 + dna_start);
            acceptor = this.residueToBasePair(acceptor + 2 + dna_start);
        }
        this.splices[0] = donor;
        this.splices[1] = acceptor;
    }

    protected void showFindDialog() {
        FindDialog fd = new FindDialog();
        fd.show();
    }

    protected boolean notTooSmall(int start_pos, int end_pos) {
        return end_pos - start_pos + 1 >= 1;
    }

    protected void changeStart(SeqFeatureI feature, int base_offset, int limit_5prime, int limit_3prime) {
        boolean okay;
        if (base_offset == 0) {
            return;
        }
        int new_start = feature.getStart() + base_offset * feature.getStrand();
        boolean bl = this.reverseStrand ? new_start > limit_3prime && new_start < limit_5prime : (okay = new_start < limit_3prime && new_start > limit_5prime);
        if (okay) {
            feature.setStart(new_start);
            FeatureSetI parent = (FeatureSetI)feature.getRefFeature();
            if (parent != null) {
                parent.adjustEdges();
            }
        }
    }

    protected void changeEnd(SeqFeatureI feature, int base_offset, int limit_5prime, int limit_3prime) {
        boolean okay;
        if (base_offset == 0) {
            return;
        }
        int new_end = feature.getEnd() + base_offset * feature.getStrand();
        boolean bl = this.reverseStrand ? new_end > limit_3prime && new_end < limit_5prime : (okay = new_end < limit_3prime && new_end > limit_5prime);
        if (okay) {
            feature.setEnd(new_end);
            FeatureSetI parent = (FeatureSetI)feature.getRefFeature();
            if (parent != null) {
                parent.adjustEdges();
            }
        }
    }

    protected void createRightClickMenu() {
        this.rightClickMenu = new JPopupMenu();
        this.rightClickListener = new RightClickActionListener();
        this.locationLabel = new JLabel("Location");
        this.relativeLocationLabel = new JLabel("Relative location");
        this.makeIntronMenuItem = new JMenuItem("Make intron");
        this.createExonMenuItem = new JMenuItem("Create exon");
        this.deleteExonMenuItem = new JMenuItem("Delete exon");
        this.merge5PrimeMenuItem = new JMenuItem("Merge with 5' exon");
        this.merge3PrimeMenuItem = new JMenuItem("Merge with 3' exon");
        this.set5PrimeMenuItem = new JMenuItem("Set as 5' end");
        this.set3PrimeMenuItem = new JMenuItem("Set as 3' end");
        this.startTranslationMenuItem = new JMenuItem("Set start of translation");
        this.findSequenceMenuItem = new JMenuItem("Find sequence...");
        this.sequenceMenuItem = new JMenuItem("Sequence...");
        this.translationSlipMenuItem = new JMenuItem("Set +1 translational frame shift here");
        this.translationStutterMenuItem = new JMenuItem("Set -1 translational frame shift here");
        this.sequencingErrorSubMenu = new JMenu("Adjust for sequencing error here");
        this.insertionMenuItem = new JMenuItem("Insertion...");
        this.deletionMenuItem = new JMenuItem("Deletion");
        this.substitutionMenuItem = new JMenuItem("Substitution...");
        this.noAdjustmentMenuItem = new JMenuItem("Remove sequencing adjustment here");
        this.sequencingErrorSubMenu.add(this.insertionMenuItem);
        this.sequencingErrorSubMenu.add(this.deletionMenuItem);
        this.sequencingErrorSubMenu.add(this.substitutionMenuItem);
        this.makeIntronMenuItem.addActionListener(this.rightClickListener);
        this.createExonMenuItem.addActionListener(this.rightClickListener);
        this.merge5PrimeMenuItem.addActionListener(this.rightClickListener);
        this.merge3PrimeMenuItem.addActionListener(this.rightClickListener);
        this.set5PrimeMenuItem.addActionListener(this.rightClickListener);
        this.set3PrimeMenuItem.addActionListener(this.rightClickListener);
        this.deleteExonMenuItem.addActionListener(this.rightClickListener);
        this.startTranslationMenuItem.addActionListener(this.rightClickListener);
        this.translationSlipMenuItem.addActionListener(this.rightClickListener);
        this.translationStutterMenuItem.addActionListener(this.rightClickListener);
        this.insertionMenuItem.addActionListener(this.rightClickListener);
        this.deletionMenuItem.addActionListener(this.rightClickListener);
        this.substitutionMenuItem.addActionListener(this.rightClickListener);
        this.noAdjustmentMenuItem.addActionListener(this.rightClickListener);
        this.findSequenceMenuItem.addActionListener(this.rightClickListener);
        this.sequenceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SeqExport(BaseEditorPanel.this.getSelectedFeature(), BaseEditorPanel.this.baseFineEditor.getController());
            }
        });
        this.rightClickMenu.add(this.locationLabel);
        this.rightClickMenu.add(this.relativeLocationLabel);
        this.rightClickMenu.addSeparator();
        this.rightClickMenu.add(this.sequenceMenuItem);
        this.rightClickMenu.add(this.findSequenceMenuItem);
        this.rightClickMenu.addSeparator();
        this.rightClickMenu.add(this.makeIntronMenuItem);
        this.rightClickMenu.add(this.createExonMenuItem);
        this.rightClickMenu.add(this.deleteExonMenuItem);
        this.rightClickMenu.add(this.merge5PrimeMenuItem);
        this.rightClickMenu.add(this.merge3PrimeMenuItem);
        this.rightClickMenu.add(this.set5PrimeMenuItem);
        this.rightClickMenu.add(this.set3PrimeMenuItem);
        this.rightClickMenu.add(this.startTranslationMenuItem);
        this.rightClickMenu.addSeparator();
        if (Config.getStyle().translationalFrameShiftEditingIsEnabled()) {
            this.rightClickMenu.add(this.translationSlipMenuItem);
            this.rightClickMenu.add(this.translationStutterMenuItem);
        }
        if (Config.getStyle().seqErrorEditingIsEnabled()) {
            this.rightClickMenu.add(this.sequencingErrorSubMenu);
        }
    }

    public void formatRightClickMenu() {
        int pos = this.mouseListener.getPos();
        int tier = this.mouseListener.getTier();
        SeqFeatureI feature = this.getFeatureAtPosition(pos, tier);
        int dnapos = this.posToBasePair(pos);
        if (feature != null) {
            if (feature instanceof ExonI) {
                FeatureSetI fs = (FeatureSetI)feature.getRefFeature();
                int feat_index = fs.getFeatureIndex(feature);
                int mRNA_loc = fs.getFeaturePosition(dnapos);
                int exon_loc = feature.getFeaturePosition(dnapos);
                this.relativeLocationLabel.setText("   Base " + exon_loc + " of exon " + (feat_index + 1) + " mRNA base " + mRNA_loc);
            } else {
                int trans_loc = feature.getStart() + dnapos * feature.getStrand();
                this.relativeLocationLabel.setText("   Base " + trans_loc + " of transcript");
            }
        } else {
            this.relativeLocationLabel.setText("   No feature at position");
            this.relativeLocationLabel.setEnabled(false);
        }
        this.locationLabel.setText("   Location = " + dnapos);
        this.sequenceMenuItem.setEnabled(this.selectedFeature != null);
        if (feature != null) {
            int start = this.basePairToPos(feature.getStart());
            int end = this.basePairToPos(feature.getEnd());
            if (feature.hasKids()) {
                this.startTranslationMenuItem.setEnabled(false);
                this.translationSlipMenuItem.setEnabled(false);
                this.translationStutterMenuItem.setEnabled(false);
                this.deleteExonMenuItem.setEnabled(false);
                this.set5PrimeMenuItem.setEnabled(false);
                this.set3PrimeMenuItem.setEnabled(false);
                this.makeIntronMenuItem.setEnabled(false);
                this.merge3PrimeMenuItem.setEnabled(false);
                this.merge5PrimeMenuItem.setEnabled(false);
                double[] intronRange = this.getRangeAtPosition(tier, pos);
                if ((double)pos != intronRange[0] && (double)pos != intronRange[1]) {
                    this.findSplices(pos, feature.getStrand(), true, (int)intronRange[0], (int)intronRange[1]);
                    int donor_pos = this.basePairToPos(this.splices[0]);
                    int acceptor_pos = this.basePairToPos(this.splices[1]);
                    this.createExonMenuItem.setEnabled((double)donor_pos > intronRange[0] && (double)acceptor_pos < intronRange[1]);
                } else {
                    this.createExonMenuItem.setEnabled(false);
                }
            } else {
                this.createExonMenuItem.setEnabled(false);
                boolean isExon = feature.isExon();
                this.startTranslationMenuItem.setEnabled(isExon);
                FeatureSetI fs = (FeatureSetI)feature.getRefFeature();
                this.engageTranslationSlipMenuItem(isExon, fs, dnapos);
                this.engageTranslationStutterMenuItem(isExon, fs, dnapos);
                if (Config.getStyle().seqErrorEditingIsEnabled()) {
                    this.sequencingErrorMenuItem(fs, dnapos);
                }
                this.deleteExonMenuItem.setEnabled(isExon);
                this.set5PrimeMenuItem.setEnabled(pos != start && this.notTooSmall(pos, end));
                this.set3PrimeMenuItem.setEnabled(pos != end && this.notTooSmall(start, pos));
                this.makeIntronMenuItem.setEnabled(isExon && this.notTooSmall(pos + 1, end) && this.notTooSmall(start, pos - 1));
                int index = this.getExonRangeIndex(tier, start, end, true);
                SeqFeatureI nextExon = this.getFeatureAtIndex(tier, index - 1);
                this.merge5PrimeMenuItem.setEnabled(nextExon != null && nextExon.getRefFeature() == feature.getRefFeature());
                nextExon = this.getFeatureAtIndex(tier, index + 1);
                this.merge3PrimeMenuItem.setEnabled(nextExon != null && nextExon.getRefFeature() == feature.getRefFeature());
            }
        } else {
            this.makeIntronMenuItem.setEnabled(false);
            this.startTranslationMenuItem.setEnabled(false);
            this.translationSlipMenuItem.setEnabled(false);
            this.translationStutterMenuItem.setEnabled(false);
            this.deleteExonMenuItem.setEnabled(false);
            this.set5PrimeMenuItem.setEnabled(false);
            this.set3PrimeMenuItem.setEnabled(false);
            this.merge5PrimeMenuItem.setEnabled(false);
            this.merge3PrimeMenuItem.setEnabled(false);
            this.createExonMenuItem.setEnabled(false);
        }
    }

    public void displayRightClickMenu(int xLoc, int yLoc) {
        this.formatRightClickMenu();
        xLoc = xLoc >= this.getSize().width / 2 ? (xLoc -= this.rightClickMenu.getPreferredSize().width) : (xLoc += 10);
        if (yLoc + this.rightClickMenu.getPreferredSize().height > this.getSize().height) {
            yLoc -= yLoc + this.rightClickMenu.getPreferredSize().height - this.getSize().height;
        }
        this.rightClickMenu.show(this, xLoc, yLoc);
    }

    private void attachListeners() {
        this.mouseListener = new BaseMouseListener(this);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
    }

    public void detachTranscript(Transcript trans) {
        int trans_tier = this.getTierForFeature(trans);
        if (trans_tier == -1) {
            System.out.println("EDE failed to find transcript to delete. This will mess up your display. close & reopen EDE and report bug to apollo list.");
            if (Config.DEBUG) {
                System.out.println("DEBUG: Heres a stack trace:");
                new Throwable().printStackTrace();
            }
            return;
        }
        this.removeFeature(trans, trans_tier);
    }

    public int attachAnnot(AnnotatedFeatureI annot) {
        int current_tier_count = this.getTierCount();
        int trans_tier = this.addFeature(annot);
        if (trans_tier >= current_tier_count) {
            SelectableDNARenderer renderer = new SelectableDNARenderer(this, this.getCharWidth(), this.getCharHeight());
            renderer.setFont(this.getFont());
            this.attachRendererToSequence(trans_tier, renderer);
        }
        return trans_tier;
    }

    public void attachTranscripts(Vector transcripts) {
        if (transcripts.size() < 1) {
            return;
        }
        SeqFeatureI transcript = (SeqFeatureI)transcripts.elementAt(0);
        this.refSeq = transcript.getRefSequence();
        if (this.refSeq.getResidueType() == null) {
            this.refSeq.setResidueType("DNA");
        }
        if (this.reverseStrand) {
            this.refSeq = new Sequence(this.refSeq.getName(), this.refSeq.getReverseComplement());
            this.refSeq.setResidueType("DNA");
        }
        for (int i = 0; i < transcripts.size(); ++i) {
            SeqFeatureI t = (SeqFeatureI)transcripts.elementAt(i);
            this.attachAnnot(t.getAnnotatedFeature());
        }
        int char_width = this.getCharWidth();
        int char_height = this.getCharHeight();
        String dna = this.refSeq.getResidues();
        AminoAcidRenderer aar = new AminoAcidRenderer(char_width, char_height, 0, this);
        aar.setFontSizes(this.getFont().getSize());
        String aa = DNAUtils.translate((String)dna, (int)2, (int)100);
        this.frame[0] = new Sequence(this.refSeq.getName(), aa);
        this.frame[0].setResidueType("AA");
        this.addSequence(this.frame[0], 0, "AA", 0);
        this.attachRendererToSequence(0, aar);
        aar = new AminoAcidRenderer(char_width, char_height, 1, this);
        aar.setFontSizes(this.getFont().getSize());
        aa = DNAUtils.translate((String)dna, (int)3, (int)100);
        this.frame[1] = new Sequence(this.refSeq.getName(), aa);
        this.frame[1].setResidueType("AA");
        this.addSequence(this.frame[1], 1, "AA", 1);
        this.attachRendererToSequence(1, aar);
        aar = new AminoAcidRenderer(char_width, char_height, 2, this);
        aar.setFontSizes(this.getFont().getSize());
        aa = DNAUtils.translate((String)dna, (int)4, (int)100);
        this.frame[2] = new Sequence(this.refSeq.getName(), aa);
        this.frame[2].setResidueType("AA");
        this.addSequence(this.frame[2], 2, "AA", 2);
        this.attachRendererToSequence(2, aar);
        this.reformat();
    }

    public Color getSeqSelectColor() {
        return this.seqSelectColor;
    }

    public Color getSelectionBoxColor() {
        return this.selectionBoxColor;
    }

    protected boolean isSequencingErrorPosition(int dnapos) {
        return this.curationState.getCurationSet().getRefSequence().isSequencingErrorPosition(dnapos);
    }

    private void engageTranslationSlipMenuItem(boolean isExon, FeatureSetI fs, int dnapos) {
        boolean enable = false;
        if (isExon && fs.withinCDS(dnapos) && !this.isSequencingErrorPosition(dnapos) && fs.minus1FrameShiftPosition() != dnapos) {
            enable = true;
            String text = dnapos == fs.plus1FrameShiftPosition() ? "Remove +1 translational frame shift here" : "Set +1 translational frame shift here";
            this.translationSlipMenuItem.setText(text);
        }
        this.translationSlipMenuItem.setEnabled(enable);
    }

    private void engageTranslationStutterMenuItem(boolean isExon, FeatureSetI fs, int dnapos) {
        boolean enable = false;
        if (isExon && fs.withinCDS(dnapos) && !this.isSequencingErrorPosition(dnapos) && fs.plus1FrameShiftPosition() != dnapos) {
            enable = true;
            String text = dnapos == fs.minus1FrameShiftPosition() ? "Remove -1 translational frame shift here" : "Set -1 translational frame shift here";
            this.translationStutterMenuItem.setText(text);
        }
        this.translationStutterMenuItem.setEnabled(enable);
    }

    private void sequencingErrorMenuItem(FeatureSetI fs, int dnapos) {
        if (fs.plus1FrameShiftPosition() != dnapos && fs.minus1FrameShiftPosition() != dnapos) {
            SequenceEdit seq_edit = fs.getSequencingErrorAtPosition(dnapos);
            if (seq_edit != null) {
                this.rightClickMenu.remove(this.sequencingErrorSubMenu);
                this.noAdjustmentMenuItem.setText("Remove " + seq_edit.getEditType() + " here");
                this.rightClickMenu.add(this.noAdjustmentMenuItem);
            } else {
                this.rightClickMenu.remove(this.noAdjustmentMenuItem);
                this.rightClickMenu.add(this.sequencingErrorSubMenu);
            }
        } else {
            this.rightClickMenu.remove(this.sequencingErrorSubMenu);
            this.rightClickMenu.remove(this.noAdjustmentMenuItem);
        }
    }

    private String getBaseFromUser(String msg, Object[] bases) {
        JOptionPane pane = new JOptionPane(msg, 3, 2, null, bases, bases[0]);
        JDialog dialog = pane.createDialog(this.baseFineEditor, "Please select a base");
        dialog.setBackground(Config.getAnnotationBackground());
        dialog.show();
        Object result = pane.getValue();
        String base = null;
        if (result != null) {
            for (int i = 0; i < bases.length && base == null; ++i) {
                base = bases[i].equals(result) ? (String)result : null;
            }
            if (base.equals("Cancel")) {
                base = null;
            }
        }
        return base;
    }

    private void dealWithSequenceEdit(SeqFeatureI feature, int basepair, String operation, String base) {
        CurationSet curation = this.getCurationSet();
        SequenceI seq = curation.getRefSequence();
        FeatureList annots = curation.getAnnots().getLeafFeatsOver(basepair);
        int exon_count = annots.size() - 1;
        boolean approved = true;
        for (int i = exon_count; i >= 0 && approved; --i) {
            SeqFeatureI exon = annots.getFeature(i);
            if (exon == feature) continue;
            approved = this.getOkayFromUser(operation, exon);
        }
        if (approved) {
            this.annotationEditor.setSequencingErrorPositions(seq, operation, basepair, base, annots);
        }
    }

    private boolean getOkayFromUser(String operation, SeqFeatureI sf) {
        String msg = (operation.equals("NOP") ? "This " : "This " + operation + " ") + "will affect the transcript of " + sf.getRefFeature().getName() + ". Are you sure you want to do this?";
        JOptionPane pane = new JOptionPane(msg, 3, 2, null, opts, opts[1]);
        JDialog dialog = pane.createDialog(this.baseFineEditor, "Please confirm");
        dialog.show();
        Object result = pane.getValue();
        boolean okay = result != null && opts[0].equals(result);
        return okay;
    }

    private CurationSet getCurationSet() {
        return this.curationState.getCurationSet();
    }

    GuiCurationState getCurationState() {
        return this.curationState;
    }

    private class BaseEditorSelectionListener
    implements FeatureSelectionListener {
        private BaseEditorSelectionListener() {
        }

        public boolean handleFeatureSelectionEvent(FeatureSelectionEvent e) {
            if (!BaseEditorPanel.this.baseFineEditor.canHandleSelection(e, BaseEditorPanel.this)) {
                return false;
            }
            AnnotatedFeatureI g = (AnnotatedFeatureI)e.getFeatures().getFeature(0);
            BaseEditorPanel.this.displayAnnot(g);
            return true;
        }
    }

    private class RightClickActionListener
    implements ActionListener {
        int pos;
        int tier;

        private RightClickActionListener() {
        }

        public int getPos() {
            return this.pos;
        }

        public void actionPerformed(ActionEvent e) {
            this.pos = BaseEditorPanel.this.mouseListener.getPos();
            this.tier = BaseEditorPanel.this.mouseListener.getTier();
            BaseEditorPanel.this.selectAnnot(this.pos, this.tier);
            SeqFeatureI feature = BaseEditorPanel.this.getFeatureAtPosition(this.pos, this.tier);
            int basepair = BaseEditorPanel.this.posToBasePair(this.pos);
            if (e.getSource() == BaseEditorPanel.this.makeIntronMenuItem) {
                Vector<SeqFeatureI> exons = new Vector<SeqFeatureI>();
                exons.addElement(feature);
                int strand = feature.getStrand();
                int start = BaseEditorPanel.this.basePairToPos(feature.getStart());
                int end = BaseEditorPanel.this.basePairToPos(feature.getEnd());
                boolean make_a_break = true;
                if (this.pos != start && this.pos != end) {
                    BaseEditorPanel.this.findSplices(this.pos, strand, false, start, end);
                    int donor_pos = BaseEditorPanel.this.basePairToPos(BaseEditorPanel.this.splices[0]);
                    int acceptor_pos = BaseEditorPanel.this.basePairToPos(BaseEditorPanel.this.splices[1]);
                    if (BaseEditorPanel.this.notTooSmall(start, donor_pos) && BaseEditorPanel.this.notTooSmall(acceptor_pos, end)) {
                        make_a_break = false;
                        if (BaseEditorPanel.this.splices[0] < BaseEditorPanel.this.splices[1]) {
                            BaseEditorPanel.this.annotationEditor.setSelections(BaseEditorPanel.this.splices[0], BaseEditorPanel.this.splices[1], exons, exons, null, null);
                        } else {
                            BaseEditorPanel.this.annotationEditor.setSelections(BaseEditorPanel.this.splices[1], BaseEditorPanel.this.splices[0], exons, exons, null, null);
                        }
                    }
                }
                if (make_a_break) {
                    BaseEditorPanel.this.annotationEditor.setSelections(basepair, -1, exons, exons, null, null);
                }
                BaseEditorPanel.this.annotationEditor.splitExon();
            } else if (e.getSource() == BaseEditorPanel.this.deleteExonMenuItem) {
                Vector<SeqFeatureI> exons = new Vector<SeqFeatureI>();
                exons.addElement(feature);
                BaseEditorPanel.this.annotationEditor.setSelections(exons, exons, null, null);
                BaseEditorPanel.this.annotationEditor.deleteSelectedFeatures();
            } else if (e.getSource() == BaseEditorPanel.this.createExonMenuItem) {
                SeqFeature temp = new SeqFeature();
                if (BaseEditorPanel.this.reverseStrand) {
                    temp.setStrand(-1);
                } else {
                    temp.setStrand(1);
                }
                temp.setStart(BaseEditorPanel.this.splices[1]);
                temp.setEnd(BaseEditorPanel.this.splices[0]);
                Vector<SeqFeatureI> transcripts = new Vector<SeqFeatureI>();
                transcripts.addElement(feature);
                Vector<SeqFeature> exons = new Vector<SeqFeature>();
                exons.addElement(temp);
                BaseEditorPanel.this.annotationEditor.setSelections(transcripts, transcripts, exons, null);
                BaseEditorPanel.this.annotationEditor.addExons();
            } else if (e.getSource() == BaseEditorPanel.this.merge5PrimeMenuItem) {
                int index = BaseEditorPanel.this.getExonRangeIndex(this.tier, BaseEditorPanel.this.basePairToPos(feature.getStart()), BaseEditorPanel.this.basePairToPos(feature.getEnd()), true);
                SeqFeatureI nextExon = BaseEditorPanel.this.getFeatureAtIndex(this.tier, index - 1);
                Vector<SeqFeatureI> exons = new Vector<SeqFeatureI>();
                exons.addElement(feature);
                exons.addElement(nextExon);
                BaseEditorPanel.this.annotationEditor.setSelections(exons, exons, null, null);
                BaseEditorPanel.this.annotationEditor.mergeExons();
            } else if (e.getSource() == BaseEditorPanel.this.merge3PrimeMenuItem) {
                int index = BaseEditorPanel.this.getExonRangeIndex(this.tier, BaseEditorPanel.this.basePairToPos(feature.getStart()), BaseEditorPanel.this.basePairToPos(feature.getEnd()), true);
                SeqFeatureI nextExon = BaseEditorPanel.this.getFeatureAtIndex(this.tier, index + 1);
                Vector<SeqFeatureI> exons = new Vector<SeqFeatureI>();
                exons.addElement(feature);
                exons.addElement(nextExon);
                BaseEditorPanel.this.annotationEditor.setSelections(exons, exons, null, null);
                BaseEditorPanel.this.annotationEditor.mergeExons();
            } else if (e.getSource() == BaseEditorPanel.this.set5PrimeMenuItem) {
                SeqFeature temp = new SeqFeature();
                if (BaseEditorPanel.this.reverseStrand) {
                    temp.setStrand(-1);
                } else {
                    temp.setStrand(1);
                }
                temp.setStart(basepair);
                temp.setEnd(basepair);
                Vector<SeqFeature> temps = new Vector<SeqFeature>();
                temps.addElement(temp);
                Vector<SeqFeatureI> exons = new Vector<SeqFeatureI>();
                exons.addElement(feature);
                BaseEditorPanel.this.annotationEditor.setSelections(exons, exons, temps, null);
                AnnotationEditor cfr_ignored_0 = BaseEditorPanel.this.annotationEditor;
                BaseEditorPanel.this.annotationEditor.setExonTerminus(1);
            } else if (e.getSource() == BaseEditorPanel.this.set3PrimeMenuItem) {
                SeqFeature temp = new SeqFeature();
                if (BaseEditorPanel.this.reverseStrand) {
                    temp.setStrand(-1);
                } else {
                    temp.setStrand(1);
                }
                temp.setStart(basepair);
                temp.setEnd(basepair);
                Vector<SeqFeature> temps = new Vector<SeqFeature>();
                temps.addElement(temp);
                Vector<SeqFeatureI> exons = new Vector<SeqFeatureI>();
                exons.addElement(feature);
                BaseEditorPanel.this.annotationEditor.setSelections(exons, exons, temps, null);
                AnnotationEditor cfr_ignored_1 = BaseEditorPanel.this.annotationEditor;
                BaseEditorPanel.this.annotationEditor.setExonTerminus(2);
            } else if (e.getSource() == BaseEditorPanel.this.startTranslationMenuItem) {
                BaseEditorPanel.this.annotationEditor.setSelections(null, null, null, null);
                BaseEditorPanel.this.annotationEditor.setTranslationStart((ExonI)feature, basepair);
            } else if (e.getSource() == BaseEditorPanel.this.translationSlipMenuItem) {
                BaseEditorPanel.this.annotationEditor.setSelections(null, null, null, null);
                if (BaseEditorPanel.this.translationSlipMenuItem.getText().startsWith("Remove")) {
                    BaseEditorPanel.this.annotationEditor.setFrameShiftPosition((ExonI)feature, 0, true);
                } else {
                    BaseEditorPanel.this.annotationEditor.setFrameShiftPosition((ExonI)feature, basepair, true);
                }
            } else if (e.getSource() == BaseEditorPanel.this.translationStutterMenuItem) {
                BaseEditorPanel.this.annotationEditor.setSelections(null, null, null, null);
                if (BaseEditorPanel.this.translationStutterMenuItem.getText().startsWith("Remove")) {
                    BaseEditorPanel.this.annotationEditor.setFrameShiftPosition((ExonI)feature, 0, false);
                } else {
                    BaseEditorPanel.this.annotationEditor.setFrameShiftPosition((ExonI)feature, basepair, false);
                }
            } else if (e.getSource() == BaseEditorPanel.this.insertionMenuItem) {
                String base = BaseEditorPanel.this.getBaseFromUser("Enter base to be inserted at " + basepair, bases);
                if (base != null) {
                    BaseEditorPanel.this.dealWithSequenceEdit(feature, basepair, "nucleotide_insertion", base);
                }
            } else if (e.getSource() == BaseEditorPanel.this.deletionMenuItem) {
                BaseEditorPanel.this.dealWithSequenceEdit(feature, basepair, "nucleotide_deletion", null);
            } else if (e.getSource() == BaseEditorPanel.this.substitutionMenuItem) {
                String base;
                char old_base = feature.getRefSequence().getBaseAt(basepair);
                if (feature.getStrand() < 0) {
                    if (old_base == 'A') {
                        old_base = 'T';
                    } else if (old_base == 'T') {
                        old_base = 'A';
                    } else if (old_base == 'G') {
                        old_base = 'C';
                    } else if (old_base == 'C') {
                        old_base = 'G';
                    }
                }
                if ((base = old_base == 'A' ? BaseEditorPanel.this.getBaseFromUser("Enter base to substitute for " + old_base + " at " + basepair, bases_noA) : (old_base == 'T' ? BaseEditorPanel.this.getBaseFromUser("Enter base to substitute for " + old_base + " at " + basepair, bases_noT) : (old_base == 'G' ? BaseEditorPanel.this.getBaseFromUser("Enter base to substitute for " + old_base + " at " + basepair, bases_noG) : (old_base == 'C' ? BaseEditorPanel.this.getBaseFromUser("Enter base to substitute for " + old_base + " at " + basepair, bases_noC) : BaseEditorPanel.this.getBaseFromUser("Enter base to substitute for " + old_base + " at " + basepair, bases))))) != null) {
                    BaseEditorPanel.this.dealWithSequenceEdit(feature, basepair, "substitution", base);
                }
            } else if (e.getSource() == BaseEditorPanel.this.noAdjustmentMenuItem) {
                BaseEditorPanel.this.dealWithSequenceEdit(feature, basepair, "NOP", null);
            } else if (e.getSource() == BaseEditorPanel.this.findSequenceMenuItem) {
                BaseEditorPanel.this.showFindDialog();
            }
            BaseEditorPanel.this.repaint();
            BaseEditorPanel.this.curationState.getSZAP().repaint();
        }
    }

    private class FindDialog
    extends JDialog {
        JLabel seqLabel = new JLabel("Sequence");
        JTextField seqField = new JTextField();
        JRadioButton isAminoAcidButton = new JRadioButton("is amino acid sequence");
        JRadioButton isGenomicButton = new JRadioButton("is genomic sequence");
        JTable posTable;
        JButton searchButton;
        Vector colNames = new Vector();

        public FindDialog() {
            this.colNames.addElement("Position");
            this.colNames.addElement("Query_frame");
            this.posTable = new JTable(new Vector(), this.colNames);
            this.searchButton = new JButton("Search");
            this.init();
            this.installListeners();
        }

        public void init() {
            this.posTable.setSelectionMode(0);
            ButtonGroup radioButtons = new ButtonGroup();
            radioButtons.add(this.isAminoAcidButton);
            radioButtons.add(this.isGenomicButton);
            this.searchButton.setAlignmentX(0.5f);
            Box seqBox = new Box(0);
            seqBox.add(Box.createHorizontalStrut(10));
            seqBox.add(this.seqLabel);
            seqBox.add(Box.createHorizontalStrut(5));
            seqBox.add(this.seqField);
            seqBox.add(Box.createHorizontalStrut(10));
            Box buttonBoxes = new Box(0);
            buttonBoxes.add(this.isAminoAcidButton);
            buttonBoxes.add(Box.createHorizontalStrut(5));
            buttonBoxes.add(this.isGenomicButton);
            JScrollPane pane = new JScrollPane(this.posTable, 20, 31);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(Box.createVerticalStrut(10));
            this.getContentPane().add(seqBox);
            this.getContentPane().add(buttonBoxes);
            this.getContentPane().add(pane);
            this.getContentPane().add(this.searchButton);
            this.setTitle("Exon Detail Editor sequence search");
            this.setSize(400, 300);
        }

        public void doSearch() {
            String seqText = this.seqField.getText();
            if (seqText.length() < 1) {
                return;
            }
            FindTableModel model = new FindTableModel();
            if (this.isAminoAcidButton.isSelected()) {
                for (int j = 0; j < 3; ++j) {
                    SequenceI aa_seq = BaseEditorPanel.this.frame[j];
                    SeqFeature seqFeature = new SeqFeature(1, aa_seq.getLength(), "sequence");
                    seqFeature.setRefSequence(aa_seq);
                    SequenceSelector seqSelector = new SequenceSelector(seqFeature, seqText, false, true);
                    Vector matches = seqSelector.getZones();
                    BaseEditorPanel.this.setTranslatedHitZones(matches, j);
                    for (int i = 0; i < matches.size(); ++i) {
                        int[] zone = (int[])matches.elementAt(i);
                        zone[0] = zone[0] - 1;
                        int start = zone[0] * 3 + j;
                        int end = zone[1] * 3 + j;
                        int[] found_pos = new int[2];
                        if (BaseEditorPanel.this.reverseStrand) {
                            found_pos[1] = BaseEditorPanel.this.posToBasePair(start);
                            found_pos[0] = BaseEditorPanel.this.posToBasePair(end);
                        } else {
                            found_pos[0] = BaseEditorPanel.this.posToBasePair(start);
                            found_pos[1] = BaseEditorPanel.this.posToBasePair(end);
                        }
                        int queryFrame = j + 1;
                        model.add(found_pos, queryFrame);
                    }
                }
            } else {
                SeqFeature seqFeature = new SeqFeature(1, BaseEditorPanel.this.refSeq.getLength(), "sequence");
                Sequence backbone = new Sequence(String.valueOf(System.currentTimeMillis()), BaseEditorPanel.this.refSeq.getResidues());
                seqFeature.setRefSequence(backbone);
                SequenceSelector seqSelector = new SequenceSelector(seqFeature, seqText, false, true);
                Vector matches = seqSelector.getZones();
                BaseEditorPanel.this.setHitZones(matches);
                for (int i = 0; i < matches.size(); ++i) {
                    int[] zone = (int[])matches.elementAt(i);
                    zone[0] = zone[0] - 1;
                    int[] found_pos = new int[2];
                    if (BaseEditorPanel.this.reverseStrand) {
                        found_pos[1] = BaseEditorPanel.this.posToBasePair(zone[0]);
                        found_pos[0] = BaseEditorPanel.this.posToBasePair(zone[1]);
                    } else {
                        found_pos[0] = BaseEditorPanel.this.posToBasePair(zone[0]);
                        found_pos[1] = BaseEditorPanel.this.posToBasePair(zone[1]);
                    }
                    model.add(found_pos, -1);
                }
            }
            this.posTable.setModel(model);
            BaseEditorPanel.this.baseFineEditor.clearFindsButton.setEnabled(true);
            BaseEditorPanel.this.setShowHitZones(true);
        }

        public void installListeners() {
            this.searchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    this.doSearch();
                }
            });
            ListSelectionModel select_model = this.posTable.getSelectionModel();
            select_model.setSelectionMode(0);
            select_model.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ FindDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(ListSelectionEvent e) {
                    int row;
                    if (!e.getValueIsAdjusting() && (row = this.this$1.posTable.getSelectedRow()) >= 0) {
                        FindTableModel ftm = (FindTableModel)this.this$1.posTable.getModel();
                        FindDialog.access$200(this.this$1).scrollToBase(ftm.getBaseForRow(row));
                    }
                }
            });
        }

        static /* synthetic */ BaseEditorPanel access$200(FindDialog x0) {
            return x0.BaseEditorPanel.this;
        }

        class FindTableModel
        extends AbstractTableModel {
            Vector coords = new Vector();
            Vector phases = new Vector();

            public void add(int[] coord, int phase) {
                this.coords.addElement(coord);
                this.phases.addElement(new Integer(phase));
            }

            public int getColumnCount() {
                return 2;
            }

            public String getColumnName(int col) {
                return (String)FindDialog.this.colNames.elementAt(col);
            }

            public int getRowCount() {
                return this.coords.size();
            }

            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    int[] coord = (int[])this.coords.elementAt(row);
                    return coord[0] + " - " + coord[1];
                }
                Integer myInt = (Integer)this.phases.elementAt(row);
                if (myInt == -1) {
                    return "N/A";
                }
                return myInt.toString();
            }

            public int getBaseForRow(int row) {
                if (row >= 0 && row < this.coords.size()) {
                    int[] coord = (int[])this.coords.elementAt(row);
                    return coord[0];
                }
                return 1;
            }
        }
    }
}

