/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.annotinfo;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.datamodel.Transcript;
import apollo.editor.CompoundTransaction;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.gui.annotinfo.FeatureEditPanel;
import apollo.gui.annotinfo.FeatureEditorDialog;
import apollo.gui.annotinfo.ReadWriteField;
import apollo.gui.drawable.DrawableUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

class TranscriptEditPanel
extends FeatureEditPanel {
    private JLabel ownerLabel = new JLabel();
    private JCheckBox finishedCheckbox = new JCheckBox();
    private JLabel nonConsensusSplice;
    private JCheckBox nonConsensusSpliceOkay = new JCheckBox();
    private JLabel missing5prime = new JLabel();
    private JLabel missing3prime = new JLabel();
    private JLabel startCodon = new JLabel();
    private JCheckBox replaceStop = new JCheckBox();
    private JLabel slippagePosition = new JLabel();
    private JLabel stutterPosition = new JLabel();
    private boolean editingName = false;
    private ReadWriteField proteinNameField = new ReadWriteField();

    TranscriptEditPanel(FeatureEditorDialog featureEditorDialog, boolean isReadOnly) {
        super(featureEditorDialog, isReadOnly);
        this.bgColor = new Color(210, 240, 255);
        this.jbInit();
    }

    protected void jbInit() {
        super.jbInit();
        this.getNameField().setEditable(this.getStyle().getTranscriptSymbolEditable());
        if (Config.DEBUG) {
            this.addField("ID(debug)", (Component)this.featureIDField.getComponent());
            this.addField("Protein Name(debug)", (Component)this.proteinNameField.getComponent());
            this.proteinNameField.setEditable(false);
        }
        this.addSynonymGui();
        this.addIsProblematicCheckbox();
        if (this.getStyle().showFinishedCheckbox()) {
            this.addField("Finished?", (Component)this.finishedCheckbox);
            this.finishedCheckbox.setBackground(this.bgColor);
            this.finishedCheckbox.setEnabled(!this.isReadOnly);
        }
        this.addField("Author", (Component)this.ownerLabel);
        this.ownerLabel.setFont(new Font("Dialog", 1, 12));
        this.ownerLabel.setForeground(Color.black);
        this.ownerLabel.setMinimumSize(new Dimension(80, 25));
        if (this.getStyle().showReplaceStopCheckbox()) {
            String replaceStopPhrase = "Readthrough stop codon";
            this.addField(replaceStopPhrase, (Component)this.replaceStop);
            this.replaceStop.setBackground(this.bgColor);
            this.replaceStop.setEnabled(!this.isReadOnly);
        }
        this.nonConsensusSplice = this.initLabel("Non-consensus splice ");
        this.addField(this.nonConsensusSplice, (Component)this.nonConsensusSpliceOkay);
        this.nonConsensusSpliceOkay.setBackground(this.bgColor);
        this.nonConsensusSpliceOkay.setEnabled(!this.isReadOnly);
        if (Config.getStyle().translationalFrameShiftEditingIsEnabled()) {
            this.addField("+1 translational frame shift ", (Component)this.slippagePosition);
            this.slippagePosition.setFont(new Font("Dialog", 1, 12));
            this.slippagePosition.setForeground(Color.black);
            this.slippagePosition.setMinimumSize(new Dimension(80, 25));
            this.addField("-1 translational frame shift ", (Component)this.stutterPosition);
            this.stutterPosition.setFont(new Font("Dialog", 1, 12));
            this.stutterPosition.setForeground(Color.black);
            this.stutterPosition.setMinimumSize(new Dimension(80, 25));
        }
        this.addField("Missing start codon", (Component)this.missing5prime);
        this.missing5prime.setFont(new Font("Dialog", 1, 12));
        this.missing5prime.setForeground(Color.black);
        this.missing5prime.setMinimumSize(new Dimension(80, 25));
        this.addField("Missing stop codon", (Component)this.missing3prime);
        this.missing3prime.setFont(new Font("Dialog", 1, 12));
        this.missing3prime.setForeground(Color.black);
        this.missing3prime.setMinimumSize(new Dimension(80, 25));
        this.addField("Unconventional start codon", (Component)this.startCodon);
        this.startCodon.setVisible(true);
        this.startCodon.setFont(new Font("Dialog", 1, 12));
        this.startCodon.setForeground(Color.black);
        this.startCodon.setMinimumSize(new Dimension(80, 25));
        this.featureIDField.setEditable(false);
        super.addFieldsPanelBottomGlue();
        super.getFeatureBox().add(super.getFieldsPanel());
        this.border = new TitledBorder("Transcript");
        this.border.setTitleColor(Color.black);
        this.setBorder(this.border);
        this.addListeners();
    }

    private Transcript getTranscript() {
        return (Transcript)this.getEditedFeature();
    }

    protected void loadSelectedFeature() {
        if (this.getEditedFeature() == null) {
            this.clearFields();
        } else {
            Transcript t = this.getTranscript();
            this.featureNameField.setValue(t.getName());
            if (Config.DEBUG) {
                this.featureIDField.setValue(t.getId());
                String n = "";
                if (t.getPeptideSequence() != null) {
                    n = "Pep acc:  " + t.getPeptideSequence().getAccessionNo() + "  Pep name: " + t.getPeptideSequence().getName();
                }
                if (t.get_cDNASequence() != null) {
                    n = n + " cDNA acc: " + t.get_cDNASequence().getAccessionNo();
                }
                this.proteinNameField.setValue(n);
            }
            this.loadSynonymGui();
            this.isProblematicCheckbox.setSelected(t.isProblematic());
            this.border.setTitle(t.getFeatureType() + " " + t.getName());
            String owner = t.getOwner();
            FeatureProperty fp = Config.getPropertyScheme().getFeatureProperty(t.getTopLevelType());
            Color owner_color = Config.getAnnotationColor(owner, fp);
            this.ownerLabel.setForeground(owner_color);
            String ownersFullName = Config.getFullNameForUser(owner);
            if (ownersFullName == null) {
                ownersFullName = "";
            }
            this.ownerLabel.setText(ownersFullName);
            this.border.setTitleColor(owner_color);
            boolean status = t.getProperty("status") != null && t.getProperty("status").equals("all done");
            this.finishedCheckbox.setSelected(status);
            int odd_acceptor_exon_index = t.getNonConsensusAcceptorNum();
            int odd_donor_exon_index = t.getNonConsensusDonorNum();
            if (t.size() == 1) {
                this.nonConsensusSplice.setText("No introns");
                this.nonConsensusSpliceOkay.setEnabled(false);
                this.nonConsensusSpliceOkay.setVisible(false);
            } else if (odd_acceptor_exon_index == -1 && odd_donor_exon_index == -1) {
                this.nonConsensusSplice.setText("All splice sites match consensus");
                this.nonConsensusSpliceOkay.setEnabled(false);
                this.nonConsensusSpliceOkay.setVisible(false);
            } else {
                String text = "Approve non-consensus";
                if (odd_acceptor_exon_index >= 0) {
                    text = text + " acceptor in exon " + (odd_acceptor_exon_index + 1);
                }
                if (odd_donor_exon_index >= 0) {
                    if (odd_acceptor_exon_index >= 0) {
                        text = text + " and";
                    }
                    text = text + " donor in exon " + (odd_donor_exon_index + 1);
                }
                this.nonConsensusSplice.setText(text);
                this.nonConsensusSpliceOkay.setSelected(t.nonConsensusSplicingOkay());
                this.nonConsensusSpliceOkay.setEnabled(!this.isReadOnly);
                this.nonConsensusSpliceOkay.setVisible(true);
            }
            if (t.isProteinCodingGene()) {
                this.replaceStop.setSelected(t.hasReadThroughStop());
                int frameshiftPosition = t.plus1FrameShiftPosition();
                if (frameshiftPosition > 0) {
                    this.slippagePosition.setText("Yes: " + frameshiftPosition);
                } else {
                    this.slippagePosition.setText("No");
                }
                frameshiftPosition = t.minus1FrameShiftPosition();
                if (frameshiftPosition > 0) {
                    this.stutterPosition.setText("Yes: " + frameshiftPosition);
                } else {
                    this.stutterPosition.setText("No");
                }
                this.missing5prime.setText(t.isMissing5prime() ? "Yes" : "No");
                this.setMissing3PrimeGuiFromModel();
                if (t.unConventionalStart()) {
                    this.startCodon.setForeground(DrawableUtil.getStartCodonColor(t));
                    this.startCodon.setText("Encoding " + t.getStartCodon() + " as Met");
                } else {
                    this.startCodon.setForeground(Color.black);
                    this.startCodon.setText("No");
                }
            }
        }
        this.updateUI();
    }

    private void setMissing3PrimeGuiFromModel() {
        boolean miss3 = this.getEditedFeature().isMissing3prime();
        this.missing3prime.setText(miss3 ? "Yes" : "No");
    }

    private void addListeners() {
        this.finishedCheckbox.addActionListener(new FinishedCheckboxListener());
        this.replaceStop.addActionListener(new ReplaceStopCheckboxListener());
        this.nonConsensusSpliceOkay.addActionListener(new NonConSpliceCheckboxListener());
        this.getNameField().addFocusListener(new TranscriptNameFocusListener());
    }

    protected void checkFocusDrivenEdits() {
        super.checkFocusDrivenEdits();
        if (this.editingName) {
            this.updateModelNameFromGui();
        }
    }

    private void updateModelNameFromGui() {
        if (this.getGuiName().equals(this.getModelName())) {
            return;
        }
        if (this.transcriptNameIsFaulty()) {
            this.setGuiNameFromModel();
            return;
        }
        CompoundTransaction t = this.getNameAdapter().setTranscriptName(this.getEditedFeature(), this.getGuiName());
        ((Transaction)t).setSource(this.getFeatureEditorDialog());
        this.fireAnnotEvent(t.generateAnnotationChangeEvent(this.getFeatureEditorDialog()));
        if (Config.DEBUG) {
            this.loadSelectedFeature();
        }
    }

    private boolean transcriptNameIsFaulty() {
        if (this.namePrefixNotEqualGeneName()) {
            return true;
        }
        if (this.suffixInUse()) {
            return true;
        }
        return this.suffixIsFaulty();
    }

    private boolean namePrefixNotEqualGeneName() {
        String prefix = this.getGuiNamePrefix();
        if (!prefix.equals(this.getGeneName())) {
            this.errorPopup("Error: transcript symbol " + this.getGuiName() + " does not match parent annotation's symbol, " + this.getGeneName());
            return true;
        }
        return false;
    }

    private boolean suffixInUse() {
        Vector trans = this.getAnnotTranscripts();
        String suffix = this.getGuiNameSuffix();
        if (this.getNameAdapter().suffixInUse(trans, suffix, this.getTranscriptIndex())) {
            this.errorPopup("Error: suffix used twice in transcript symbols: -" + suffix);
            return true;
        }
        return false;
    }

    private boolean suffixIsFaulty() {
        if (!this.getNameAdapter().checkFormat(this.getTranscript(), this.getGuiName())) {
            String err = "Error: illegal transcript suffix format: -" + this.getGuiNameSuffix();
            String expectedTranscriptNameFormat = this.getNameAdapter().getTranscriptNamePattern();
            if (expectedTranscriptNameFormat != null) {
                err = err + "\nSuffix name format should be: " + expectedTranscriptNameFormat;
            }
            this.errorPopup(err);
            return true;
        }
        return false;
    }

    private String getGeneName() {
        return this.getTranscript().getRefFeature().getName();
    }

    private String getGuiNamePrefix() {
        int index = this.getGuiName().lastIndexOf(this.getNameAdapter().getSuffixDelimiter());
        if (index > 0) {
            return this.getGuiName().substring(0, index);
        }
        System.out.println(this.getGuiName() + " is missing a suffix!!!");
        return this.getGuiName();
    }

    private String getGuiNameSuffix() {
        return this.getGuiName().substring(this.getGuiName().lastIndexOf("-") + 1);
    }

    private Vector getAnnotTranscripts() {
        return this.getTranscript().getRefFeature().getFeatures();
    }

    private int getTranscriptIndex() {
        Vector v = this.getAnnotTranscripts();
        for (int i = 0; i < v.size(); ++i) {
            if (this.getTranscript() != v.get(i)) continue;
            return i;
        }
        return -1;
    }

    private class TranscriptNameFocusListener
    implements FocusListener {
        private TranscriptNameFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            TranscriptEditPanel.this.editingName = true;
        }

        public void focusLost(FocusEvent e) {
            TranscriptEditPanel.this.updateModelNameFromGui();
            TranscriptEditPanel.this.editingName = false;
        }
    }

    private class NonConSpliceCheckboxListener
    implements ActionListener {
        private NonConSpliceCheckboxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean guiState = TranscriptEditPanel.this.nonConsensusSpliceOkay.isSelected();
            TransactionSubpart ts = TransactionSubpart.NON_CONSENSUS_SPLICE_OKAY;
            TranscriptEditPanel.this.setBooleanSubpart(guiState, ts);
        }
    }

    private class ReplaceStopCheckboxListener
    implements ActionListener {
        private ReplaceStopCheckboxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean b = TranscriptEditPanel.this.replaceStop.isSelected();
            TransactionSubpart t = TransactionSubpart.REPLACE_STOP;
            TranscriptEditPanel.this.setBooleanSubpart(b, t);
            TranscriptEditPanel.this.setMissing3PrimeGuiFromModel();
        }
    }

    private class FinishedCheckboxListener
    implements ActionListener {
        private FinishedCheckboxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean b = TranscriptEditPanel.this.finishedCheckbox.isSelected();
            TransactionSubpart t = TransactionSubpart.FINISHED;
            TranscriptEditPanel.this.setBooleanSubpart(b, t);
        }
    }
}

