/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.annotinfo;

import apollo.config.Config;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.Document;

class ReadWriteField {
    private static final Dimension fieldSize = new Dimension(200, 21);
    private static final Font fieldFont = new Font("Dialog", 0, 12);
    private boolean isList;
    private JComboBox list;
    private JTextField jTextField;
    private JComponent jComponent;
    private boolean isReadOnly = !Config.isEditingEnabled();

    ReadWriteField() {
        this(false);
    }

    ReadWriteField(boolean isList) {
        this.isList = isList;
        if (isList) {
            this.list = new JComboBox();
            this.list.setEditable(false);
            this.list.setBackground(Config.getAnnotationBackground());
            this.jComponent = this.list;
        } else {
            this.jTextField = new JTextField();
            this.jComponent = this.jTextField;
            this.jTextField.setEditable(!this.isReadOnly);
        }
        this.jComponent.setMinimumSize(fieldSize);
        this.jComponent.setPreferredSize(fieldSize);
        this.jComponent.setFont(fieldFont);
    }

    void setEditable(boolean editable) {
        boolean bl = this.isReadOnly = !editable;
        if (this.jTextField != null) {
            this.jTextField.setEditable(editable);
        }
    }

    void setValue(String value) {
        if (this.isList) {
            this.list.setSelectedItem(value);
        } else {
            this.jTextField.setText(value);
        }
    }

    String getValue() {
        if (this.isList) {
            return (String)this.list.getSelectedItem();
        }
        return this.jTextField.getText();
    }

    JComponent getComponent() {
        return this.jComponent;
    }

    void addFocusListener(FocusListener fl) {
        this.jComponent.addFocusListener(fl);
    }

    void setListBackground(Color bgColor) {
        if (this.isList) {
            this.list.setBackground(bgColor);
        }
    }

    void addItem(String listItem) {
        if (this.isReadOnly || !this.isList) {
            return;
        }
        this.list.addItem(listItem);
    }

    void setMaximumRowCount(int max) {
        if (this.isReadOnly || !this.isList) {
            return;
        }
        this.list.setMaximumRowCount(max);
    }

    void removeAllItems() {
        if (this.isReadOnly || !this.isList) {
            return;
        }
        this.list.removeAllItems();
    }

    void addKeyListener(KeyListener kl) {
        this.getComponent().addKeyListener(kl);
    }

    Document getDocument() {
        if (!this.isList) {
            return this.jTextField.getDocument();
        }
        return null;
    }
}

