/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui.annotinfo;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PeptideStatus;
import apollo.dataadapter.chadoxml.ChadoXmlAdapter;
import apollo.dataadapter.chadoxml.ChadoXmlWrite;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.Protein;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceEdit;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import apollo.editor.AnnotationCompoundEvent;
import apollo.editor.AnnotationUpdateEvent;
import apollo.editor.CompoundTransaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateTransaction;
import apollo.editor.UserName;
import apollo.gui.DetailInfo;
import apollo.gui.annotinfo.Commentator;
import apollo.gui.annotinfo.DbxRefTableModel;
import apollo.gui.annotinfo.FeatureEditPanel;
import apollo.gui.annotinfo.FeatureEditorDialog;
import apollo.gui.annotinfo.ReadWriteField;
import apollo.gui.annotinfo.TranscriptEditPanel;
import apollo.util.HTMLUtil;
import apollo.util.SeqFeatureUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.framework.TestCase;

public class GeneEditPanel
extends FeatureEditPanel {
    private TranscriptEditPanel transcriptPanel;
    private static final Dimension tableSize = new Dimension(250, 80);
    private ReadWriteField featureTypeList;
    JTextArea bigCommentField = new JTextArea(12, 3);
    private ReadWriteField peptideStatus;
    JTextArea sequencingComments = new JTextArea();
    private JCheckBox isDicistronicCheckbox = new JCheckBox();
    private int table_row_selected = -1;
    private Vector annotFeatureProps;
    private DbxRefTableModel dbXRefModel;
    Box dataBox = new Box(1);
    JButton addAnnotComment;
    JButton addTransComment;
    private Commentator commentator;
    private String GO_URL = "http://godatabase.org/cgi-bin/go.cgi?view=details&search_constraint=terms&depth=0&query=";
    private boolean warnedAboutEditingIDs = false;
    private IDFocusListener idFocusListener;
    private GeneNameListener geneNameListener;

    GeneEditPanel(FeatureEditorDialog featureEditorDialog, boolean isReadOnly) {
        super(featureEditorDialog, isReadOnly);
        if (isReadOnly) {
            this.featureTypeList = new ReadWriteField(false);
            this.peptideStatus = new ReadWriteField(false);
        } else {
            this.featureTypeList = new ReadWriteField(true);
            this.peptideStatus = new ReadWriteField(true);
        }
        this.annotFeatureProps = GeneEditPanel.getAnnotationFeatureProps();
        this.jbInit();
        this.attachListeners();
    }

    protected void jbInit() {
        super.jbInit();
        if (Config.getStyle().showIdField() || Config.DEBUG) {
            String dbg = Config.DEBUG && !Config.getStyle().showIdField() ? "(DEBUG)" : "";
            this.addField("ID" + dbg, (Component)this.featureIDField.getComponent());
        }
        this.addSynonymGui();
        this.addIsProblematicCheckbox();
        this.addField("Type", (Component)this.featureTypeList.getComponent());
        this.featureTypeList.setListBackground(this.bgColor);
        this.loadTypes();
        if (Config.getStyle().showIsDicistronicCheckbox()) {
            this.addField("Is dicistronic?", (Component)this.isDicistronicCheckbox);
            this.isDicistronicCheckbox.setEnabled(!this.isReadOnly);
            this.isDicistronicCheckbox.setBackground(this.bgColor);
            this.isDicistronicCheckbox.addActionListener(new DicistronicButtonListener());
        }
        if (Config.getStyle().showEvalOfPeptide()) {
            this.addField("Evaluation of peptide", (Component)this.peptideStatus.getComponent());
            this.peptideStatus.setListBackground(this.bgColor);
        }
        super.addFieldsPanelBottomGlue();
        Box dataBox = new Box(1);
        dataBox.add(this.fieldsPanel);
        dataBox.add(Box.createVerticalStrut(5));
        if (this.showDbXRefs()) {
            dataBox.add(this.getDbTablePane());
        }
        Box topBox = new Box(0);
        topBox.add(dataBox);
        topBox.add(Box.createHorizontalStrut(12));
        this.transcriptPanel = new TranscriptEditPanel(this.featureEditorDialog, this.isReadOnly);
        topBox.add(this.transcriptPanel);
        Box bottomBox = this.getCommentBox();
        this.featureBox.add(topBox);
        this.featureBox.add(Box.createVerticalStrut(12));
        this.featureBox.add(bottomBox);
        this.border = new TitledBorder("Annotation");
        this.border.setTitleColor(Color.black);
        this.featureBox.setBorder(this.border);
    }

    private boolean showDbXRefs() {
        return Config.getStyle().showDbXRefTable();
    }

    private JScrollPane getDbTablePane() {
        this.dbXRefModel = new DbxRefTableModel();
        final JTable table = new JTable(this.dbXRefModel);
        table.getTableHeader().setReorderingAllowed(false);
        table.getColumnModel().getColumn(0).setHeaderValue("ID Value");
        table.getColumnModel().getColumn(1).setHeaderValue("DB Name");
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int row_index = table.getSelectedRow();
                if (row_index == GeneEditPanel.this.table_row_selected) {
                    return;
                }
                GeneEditPanel.this.table_row_selected = row_index;
                String id = (String)GeneEditPanel.this.dbXRefModel.getValueAt(row_index, 0);
                String dbname = (String)GeneEditPanel.this.dbXRefModel.getValueAt(row_index, 1);
                if (id.startsWith("FBgn") || id.startsWith("GO:") || id.startsWith("FBti")) {
                    String url = "";
                    if (id.startsWith("FB")) {
                        if (Config.getExternalRefURL() == null) {
                            return;
                        }
                        url = Config.getExternalRefURL() + id;
                    } else if (id.startsWith("GO:")) {
                        url = GeneEditPanel.this.GO_URL + id;
                    }
                    HTMLUtil.loadIntoBrowser(url);
                } else {
                    System.err.println("Don't know how to pull up info for id " + id + ", db = " + dbname);
                }
            }
        });
        JScrollPane tableHolder = new JScrollPane(table);
        tableHolder.setPreferredSize(tableSize);
        tableHolder.setMaximumSize(tableSize);
        tableHolder.setBackground(this.bgColor);
        return tableHolder;
    }

    private Box getCommentBox() {
        this.bigCommentField.setWrapStyleWord(true);
        this.bigCommentField.setLineWrap(true);
        this.bigCommentField.setEditable(false);
        JScrollPane bigCommentPane = new JScrollPane(this.bigCommentField, 20, 31);
        bigCommentPane.setPreferredSize(new Dimension(450, 300));
        Box commentBox = new Box(0);
        commentBox.add(Box.createHorizontalStrut(12));
        commentBox.add(bigCommentPane);
        commentBox.add(Box.createHorizontalStrut(8));
        Box buttonBox = new Box(1);
        buttonBox.add(Box.createVerticalStrut(20));
        if (!this.isReadOnly) {
            this.commentator = new Commentator(this.featureEditorDialog);
            this.commentator.setVisible(false);
            this.addAnnotComment = this.initCommentButton();
            this.addTransComment = this.initCommentButton();
            buttonBox.add(this.addAnnotComment);
            buttonBox.add(Box.createVerticalStrut(20));
            buttonBox.add(this.addTransComment);
            buttonBox.add(Box.createVerticalStrut(20));
        }
        if (Config.getStyle().seqErrorEditingIsEnabled()) {
            this.sequencingComments.setWrapStyleWord(true);
            this.sequencingComments.setLineWrap(true);
            this.sequencingComments.setEditable(false);
            this.sequencingComments.setPreferredSize(new Dimension(250, 160));
            this.sequencingComments.setBackground(new Color(255, 250, 205));
            JScrollPane seqPane = new JScrollPane(this.sequencingComments, 21, 31);
            TitledBorder border = new TitledBorder("Genomic sequencing errors");
            seqPane.setBorder(border);
            seqPane.setBackground(this.bgColor);
            seqPane.setPreferredSize(new Dimension(250, 160));
            buttonBox.add(seqPane);
        }
        commentBox.add(buttonBox);
        commentBox.add(Box.createHorizontalGlue());
        commentBox.setBorder(new TitledBorder("Comments and properties"));
        return commentBox;
    }

    private JButton initCommentButton() {
        JButton addComment = new JButton();
        addComment.setBackground(Color.white);
        Dimension buttonSize = new Dimension(250, 40);
        addComment.setMaximumSize(buttonSize);
        addComment.setMinimumSize(buttonSize);
        addComment.setPreferredSize(buttonSize);
        addComment.setText("Edit comments");
        addComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneEditPanel.this.editComments(e);
            }
        });
        return addComment;
    }

    void clearFields() {
        super.clearFields();
        this.isDicistronicCheckbox.setSelected(false);
    }

    protected void disposeCommentator() {
        if (!this.isReadOnly) {
            this.commentator.dispose();
        }
    }

    protected void loadSelectedFeature() {
        if (this.getEditedFeature() == null) {
            this.clearFields();
            return;
        }
        this.setGuiNameFromModel();
        this.setGuiIDFromModel();
        this.featureIDField.setEditable(this.idIsEditable());
        this.loadSynonymGui();
        this.isProblematicCheckbox.setSelected(this.getEditedFeature().isProblematic());
        FeatureProperty fp = this.getFeatureProperty();
        this.featureTypeList.setValue(fp.getDisplayType());
        this.refreshCommentField(this.getEditedFeature());
        if (this.getEditedFeature().isProteinCodingGene()) {
            StringBuffer buf = new StringBuffer();
            HashMap adjustments = this.getEditedFeature().getGenomicErrors();
            if (adjustments != null) {
                Iterator positions = adjustments.keySet().iterator();
                while (positions.hasNext()) {
                    SequenceI refSeq;
                    String more_info;
                    String position = (String)positions.next();
                    SequenceEdit seq_edit = (SequenceEdit)adjustments.get(position);
                    String string = more_info = seq_edit.getResidue() != null ? " of " + seq_edit.getResidue() : "";
                    if (seq_edit.getEditType().equals("substitution") && (refSeq = this.getEditedFeature().getRefSequence()) != null && refSeq.isSequenceAvailable(seq_edit.getPosition())) {
                        char base = refSeq.getBaseAt(seq_edit.getPosition());
                        more_info = more_info + " for " + base;
                    }
                    buf.append(seq_edit.getEditType() + more_info + " at base " + position + "\n");
                }
            }
            this.sequencingComments.setText(buf.toString());
            this.sequencingComments.setVisible(true);
        } else {
            this.sequencingComments.setVisible(false);
        }
        if (this.showDbXRefs()) {
            this.dbXRefModel.setListData(this.collectDbXrefs());
        }
        this.setPeptideStatus(this.getEditedFeature());
        if (this.getEditedFeature().isProteinCodingGene()) {
            if (this.getEditedFeature().getProperty("dicistronic").equals("true")) {
                this.isDicistronicCheckbox.setSelected(true);
            } else {
                this.isDicistronicCheckbox.setSelected(false);
            }
        }
        this.isDicistronicCheckbox.setVisible(this.getEditedFeature().isProteinCodingGene());
        this.border.setTitle(this.getEditedFeature().getFeatureType() + " " + this.getEditedFeature().getName());
        this.loadTranscript();
        this.setWindowTitleWithFeatureName();
        this.updateUI();
    }

    private FeatureProperty getFeatureProperty() {
        return Config.getPropertyScheme().getFeatureProperty(this.getEditedFeature().getFeatureType());
    }

    private CompoundTransaction commitGeneAndTranscriptNameChange() {
        if (!this.nameHasChanged()) {
            return null;
        }
        String newName = this.getGuiName();
        CompoundTransaction ct = this.getNameAdapter().setAnnotName(this.getEditedFeature(), newName);
        ct.setSource(this.getFeatureEditorDialog());
        this.setWindowTitleWithFeatureName();
        return ct;
    }

    private void setWindowTitleWithFeatureName() {
        String title = this.getEditedFeature().getName() + " Annotation Information";
        this.getFeatureEditorDialog().setTitle(title);
    }

    private boolean idIsEditable() {
        return Config.getStyle().showIdField() && Config.getStyle().isSuperUser(UserName.getUserName());
    }

    private CompoundTransaction commitIdChange() {
        CompoundTransaction ct = this.getNameAdapter().setAnnotId(this.getEditedFeature(), this.getGuiId());
        ct.setSource(this.getFeatureEditorDialog());
        if (Config.DEBUG) {
            this.transcriptPanel.loadSelectedFeature();
        }
        return ct;
    }

    private String getGuiId() {
        return this.featureIDField.getValue().trim();
    }

    private void setGuiIDFromModel() {
        this.setGuiId(this.getEditedFeature().getId());
    }

    private void setGuiId(String id) {
        this.featureIDField.setValue(id);
    }

    private Vector collectDbXrefs() {
        Vector db_xrefs = new Vector();
        db_xrefs.addAll(this.getEditedFeature().getDbXrefs());
        for (int i = 0; i < this.getEditedFeature().size(); ++i) {
            Transcript t = (Transcript)this.getEditedFeature().getFeatureAt(i);
            db_xrefs.addAll(t.getDbXrefs());
            Protein pep = t.getProteinFeat();
            if (pep == null) continue;
            db_xrefs.addAll(pep.getDbXrefs());
        }
        return db_xrefs;
    }

    private boolean idChanged(String new_id, String current_id) {
        return new_id != null && !new_id.equals("") && !new_id.equals(current_id);
    }

    protected static Vector getAnnotationFeatureProps() {
        return Config.getPropertyScheme().getAnnotationFeatureProps();
    }

    protected FeatureProperty findFeatureProp(String typeName) {
        Iterator props = this.annotFeatureProps.iterator();
        FeatureProperty prop = null;
        while (props.hasNext()) {
            prop = (FeatureProperty)props.next();
            String t = prop.getDisplayType();
            if (!t.equals(typeName)) continue;
            return prop;
        }
        return null;
    }

    void loadTypes() {
        Iterator props = this.annotFeatureProps.iterator();
        int numTypes = 0;
        while (props.hasNext()) {
            this.featureTypeList.addItem(((FeatureProperty)props.next()).getDisplayType());
            ++numTypes;
        }
        this.featureTypeList.setMaximumRowCount(numTypes);
        if (!this.isReadOnly) {
            FeatureTypeItemListener ftil = new FeatureTypeItemListener();
            ((JComboBox)this.featureTypeList.getComponent()).addItemListener(ftil);
        }
    }

    void refreshCommentField() {
        this.refreshCommentField(this.getEditedFeature());
    }

    private void refreshCommentField(AnnotatedFeatureI editedFeature) {
        if (!this.isReadOnly) {
            String shortName = DetailInfo.getName(editedFeature);
            this.addAnnotComment.setText("Edit " + shortName + " comments");
        }
        this.bigCommentField.setText(this.getCommentString(editedFeature));
        this.bigCommentField.setCaretPosition(0);
    }

    private String getCommentString(AnnotatedFeatureI sf) {
        StringBuffer commentList = new StringBuffer();
        String desc = sf.getDescription();
        if (desc != null && !desc.equals("")) {
            commentList.append(sf.getName() + " description:\n");
            commentList.append(desc + "\n");
        }
        Vector comments = sf.getComments();
        int cnum = 0;
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = (Comment)comments.elementAt(i);
            if (comment.isInternal() && !Config.internalMode() || comment.getText().equals("")) continue;
            if (++cnum == 1) {
                commentList.append(sf.getName() + " comments:\n");
            }
            commentList.append("        " + cnum + ". " + comment.getText() + "\n");
        }
        commentList.append(this.showProperties(sf));
        if (!(sf instanceof Transcript) && sf.canHaveChildren() && sf.size() > 0) {
            AnnotatedFeatureI fs = sf;
            Vector sorted_set = SeqFeatureUtil.sortFeaturesAlphabetically(fs.getFeatures());
            for (int i = 0; i < sorted_set.size(); ++i) {
                AnnotatedFeatureI t = (AnnotatedFeatureI)sorted_set.elementAt(i);
                commentList.append(this.getCommentString(t));
            }
        }
        return commentList.toString();
    }

    private StringBuffer showProperties(SeqFeatureI sf) {
        Hashtable properties = sf.getPropertiesMulti();
        StringBuffer propList = new StringBuffer();
        boolean first = true;
        Enumeration e = properties.keys();
        boolean hasProperties = false;
        if (this.getFeatureEditorDialog().getTranscript() == null && Config.internalMode()) {
            propList.append(sf.getName() + " properties:\n");
            first = false;
            propList.append("        Author: " + ((AnnotatedFeature)sf).getOwner());
            propList.append("\n");
        }
        while (e.hasMoreElements()) {
            Vector values;
            String key = (String)e.nextElement();
            String label = key.toUpperCase();
            if (label.equalsIgnoreCase("DATE")) {
                label = "LAST MODIFIED ON";
            }
            if (key.equalsIgnoreCase("sp_status") || key.equalsIgnoreCase("internal_synonym") && !Config.internalMode() || key.equalsIgnoreCase("encoded_symbol") || key.equalsIgnoreCase("problem") || key.equalsIgnoreCase("status") || key.equalsIgnoreCase("dicistronic") || key.equalsIgnoreCase("symbol") || ChadoXmlWrite.isSpecialProperty(key)) continue;
            if (first) {
                propList.append(sf.getName() + " properties:\n");
                first = false;
            }
            if ((values = (Vector)properties.get(key)) == null || values.size() <= 0) continue;
            hasProperties = true;
            propList.append("        " + label + ": ");
            for (int i = 0; i < values.size(); ++i) {
                String value;
                if (i > 0) {
                    propList.append(", ");
                }
                if ((value = (String)values.elementAt(i)).startsWith(ChadoXmlAdapter.FIELD_LABEL)) {
                    value = value.substring(ChadoXmlAdapter.FIELD_LABEL.length());
                }
                propList.append(value);
            }
            propList.append("\n");
        }
        if (hasProperties) {
            propList.append("\n");
        }
        return propList;
    }

    private void setPeptideStatus(AnnotatedFeatureI g) {
        this.peptideStatus.removeAllItems();
        if (!g.isProteinCodingGene()) {
            this.peptideStatus.addItem("NOT A PEPTIDE");
            this.peptideStatus.setValue("NOT A PEPTIDE");
        } else {
            Hashtable curator_values = Config.getPeptideStates();
            String pep_status = g.getProperty("sp_status");
            PeptideStatus this_status = Config.getPeptideStatus(pep_status);
            this.peptideStatus.addItem(this_status.getText());
            Enumeration e = curator_values.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                PeptideStatus a_status = (PeptideStatus)curator_values.get(key);
                if (a_status.getPrecedence() < this_status.getPrecedence() || a_status.getText().equals(this_status.getText()) || !a_status.getCurated()) continue;
                this.peptideStatus.addItem(a_status.getText());
            }
            this.peptideStatus.setValue(this_status.getText());
        }
    }

    private void loadTranscript() {
        Transcript trans = this.getFeatureEditorDialog().getTranscript();
        if (trans == null) {
            this.enableTranscripts(false);
            return;
        }
        this.transcriptPanel.loadAnnotation(trans);
        if (!trans.getRefFeature().getTopLevelType().equalsIgnoreCase("miscellaneous curator's observation")) {
            this.enableTranscripts(true);
            if (!this.isReadOnly) {
                String shortName = DetailInfo.getName(trans);
                this.addTransComment.setText("Edit " + shortName + " comments");
            }
        } else {
            this.enableTranscripts(false);
        }
    }

    private void enableTranscripts(boolean enable) {
        this.addTransComment.setEnabled(enable && !this.isReadOnly);
        this.addTransComment.setVisible(enable && !this.isReadOnly);
        this.transcriptPanel.setVisible(enable);
    }

    private void editComments(ActionEvent e) {
        this.commentator.commitCurrentComment();
        JButton button = (JButton)e.getSource();
        if (button == this.addAnnotComment) {
            this.commentator.setFeature(this.getEditedFeature(), this.getBackground());
            this.commentator.setType(Commentator.ANNOTATION);
        } else {
            this.commentator.setFeature(this.transcriptPanel.getEditedFeature(), this.transcriptPanel.getBackground());
            this.commentator.setType(Commentator.TRANSCRIPT);
        }
        if (this.commentator.getState() == 1) {
            this.commentator.setState(0);
        }
        this.commentator.setVisible(true);
    }

    private boolean idAndNameInconsistent() {
        AnnotatedFeatureI af = this.getEditedFeature();
        if (!this.getNameAdapter().idAndNameHaveSameFormat(af, this.getGuiId(), this.getGuiName())) {
            return false;
        }
        return !this.getGuiId().equals(this.getGuiName());
    }

    private boolean nameAndIdAreEqual() {
        return this.getGuiId().equals(this.getGuiName());
    }

    private CompoundTransaction setGuiAndModelName(String newName) {
        this.setGuiName(newName);
        CompoundTransaction compTrans = this.commitGeneAndTranscriptNameChange();
        return compTrans;
    }

    protected void checkFocusDrivenEdits() {
        super.checkFocusDrivenEdits();
        if (this.idIsEditable()) {
            this.idFocusListener.updateIdFromGui();
        }
        this.geneNameListener.updateName();
    }

    private void attachListeners() {
        this.featureIDField.getComponent().addKeyListener(new IDKeyListener());
        this.idFocusListener = new IDFocusListener();
        this.featureIDField.addFocusListener(this.idFocusListener);
        this.geneNameListener = new GeneNameListener(this.getNameField());
    }

    void testNameUndo(TestCase testCase) {
        String originalName = this.getModelName();
        this.geneNameListener.focusGained(null);
        this.geneNameListener.insertUpdate(null);
        this.setGuiName("new-name-test");
        this.geneNameListener.focusLost(null);
        TestCase.assertEquals((Object)this.getGuiName(), (Object)this.getModelName());
        this.getFeatureEditorDialog().undo();
        TestCase.assertEquals((Object)originalName, (Object)this.getModelName());
    }

    private class GeneNameListener
    implements FocusListener,
    DocumentListener {
        private boolean inFocus = false;
        private boolean documentEdited = false;
        private boolean nameCommitted = true;

        private GeneNameListener(ReadWriteField nameField) {
            nameField.addFocusListener(this);
            nameField.getDocument().addDocumentListener(this);
        }

        private boolean nameBeingEdited() {
            return this.inFocus && this.documentEdited && !this.nameCommitted;
        }

        public void focusGained(FocusEvent e) {
            this.inFocus = true;
        }

        public void focusLost(FocusEvent e) {
            this.updateName();
            this.resetEditFlags();
        }

        private void resetEditFlags() {
            this.nameCommitted = true;
            this.inFocus = false;
            this.documentEdited = false;
        }

        private void setDocumentEdited() {
            this.documentEdited = true;
            this.nameCommitted = false;
        }

        public void removeUpdate(DocumentEvent d) {
            this.setDocumentEdited();
        }

        public void insertUpdate(DocumentEvent d) {
            this.setDocumentEdited();
        }

        public void changedUpdate(DocumentEvent d) {
            this.setDocumentEdited();
        }

        private void updateName() {
            if (!this.nameBeingEdited()) {
                return;
            }
            if (!GeneEditPanel.this.nameHasChanged()) {
                this.resetEditFlags();
                return;
            }
            if (GeneEditPanel.this.getNameAdapter().checkName(GeneEditPanel.this.getGuiName(), GeneEditPanel.this.getEditedFeature().getClass())) {
                System.out.println("checking for duplicate name: ");
                String e = "Error: gene name already exists in data store " + GeneEditPanel.this.getGuiName();
                GeneEditPanel.this.errorPopup(e);
                GeneEditPanel.this.setGuiNameFromModel();
                this.resetEditFlags();
                return;
            }
            if (GeneEditPanel.this.idAndNameInconsistent()) {
                String e = "Error: annotation symbol " + GeneEditPanel.this.getGuiName() + " is inconsistent with ID " + GeneEditPanel.this.getGuiId();
                if (GeneEditPanel.this.idIsEditable()) {
                    e = e + "\nTo do this edit use the ID field.";
                }
                GeneEditPanel.this.errorPopup(e);
                GeneEditPanel.this.setGuiNameFromModel();
                this.resetEditFlags();
                return;
            }
            CompoundTransaction compTrans = GeneEditPanel.this.commitGeneAndTranscriptNameChange();
            AnnotationCompoundEvent ace = new AnnotationCompoundEvent(compTrans);
            GeneEditPanel.this.fireAnnotEvent(ace);
            GeneEditPanel.this.loadSelectedFeature();
            this.resetEditFlags();
        }
    }

    private class IDFocusListener
    implements FocusListener {
        boolean idBeingEdited = false;

        private IDFocusListener() {
        }

        public void focusGained(FocusEvent f) {
            this.idBeingEdited = true;
        }

        public void focusLost(FocusEvent f) {
            this.updateIdFromGui();
            this.idBeingEdited = false;
        }

        private void updateIdFromGui() {
            if (!this.idBeingEdited) {
                return;
            }
            if (GeneEditPanel.this.getGuiId().equals(GeneEditPanel.this.getEditedFeature().getId())) {
                return;
            }
            if (!this.idFormatOk()) {
                this.badIdFormatErrorPopup();
                GeneEditPanel.this.setGuiIDFromModel();
                return;
            }
            CompoundTransaction compTrans = new CompoundTransaction(this);
            if (GeneEditPanel.this.idAndNameInconsistent()) {
                boolean userWantsNameAndIdChange = this.queryUserOnNameChange();
                if (!userWantsNameAndIdChange) {
                    GeneEditPanel.this.setGuiIDFromModel();
                    return;
                }
                CompoundTransaction nameTrans = GeneEditPanel.this.setGuiAndModelName(GeneEditPanel.this.getGuiId());
                compTrans.addTransaction(nameTrans);
            }
            CompoundTransaction idTrans = GeneEditPanel.this.commitIdChange();
            compTrans.addTransaction(idTrans);
            compTrans.setSource(GeneEditPanel.this.featureEditorDialog);
            AnnotationCompoundEvent ace = new AnnotationCompoundEvent(compTrans);
            GeneEditPanel.this.fireAnnotEvent(ace);
            GeneEditPanel.this.loadSelectedFeature();
        }

        private boolean queryUserOnNameChange() {
            String nm = GeneEditPanel.this.getEditedFeature().getName();
            String m = "Name " + nm + " and ID " + GeneEditPanel.this.getGuiId() + " have the same pattern but are" + " not the same.\nWould you like to change the name as well or cancel your ID" + " edit?";
            String title = "Change both name and ID?";
            int question = 3;
            String updateName = "Update name";
            String cancel = "Cancel ID Update";
            int opt = -1;
            Object[] vals = new Object[]{updateName, cancel};
            int i = JOptionPane.showOptionDialog(null, m, title, opt, question, null, vals, null);
            return i == 0;
        }

        private boolean idFormatOk() {
            String guiID = GeneEditPanel.this.getGuiId();
            return GeneEditPanel.this.getNameAdapter().checkFormat(GeneEditPanel.this.getEditedFeature(), guiID);
        }

        private void badIdFormatErrorPopup() {
            String err = "Error: annotation ID is not in a valid format: " + GeneEditPanel.this.getGuiId();
            if (this.haveIdFormat()) {
                err = err + "\nID format should be: " + this.getIdFormat();
            }
            GeneEditPanel.this.errorPopup(err);
        }

        private boolean haveIdFormat() {
            FeatureProperty fp = GeneEditPanel.this.getFeatureProperty();
            return fp != null && fp.getIdFormat() != null;
        }

        private String getIdFormat() {
            return GeneEditPanel.this.getFeatureProperty().getIdFormat();
        }
    }

    private class IDKeyListener
    implements KeyListener {
        private IDKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (!GeneEditPanel.this.warnedAboutEditingIDs) {
                System.out.println("Warning: editing IDs is considered dangerous!  Proceed at your own risk.");
                GeneEditPanel.this.warnedAboutEditingIDs = true;
            }
        }
    }

    private class FeatureTypeItemListener
    implements ItemListener {
        private FeatureTypeItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            this.changeType();
        }

        private void changeType() {
            String oldType = GeneEditPanel.this.getEditedFeature().getFeatureType();
            FeatureProperty fp = GeneEditPanel.this.findFeatureProp(GeneEditPanel.this.featureTypeList.getValue());
            String newType = fp.getAnalysisType(0);
            for (int i = 0; i < fp.getAnalysisTypesSize(); ++i) {
                if (!oldType.equals(fp.getAnalysisType(i))) continue;
                return;
            }
            TransactionSubpart ts = TransactionSubpart.TYPE;
            UpdateTransaction ut = new UpdateTransaction(GeneEditPanel.this.getEditedFeature(), ts);
            ut.setSource(GeneEditPanel.this.getFeatureEditorDialog());
            ut.setOldSubpartValue(oldType);
            ut.setNewSubpartValue(newType);
            String oldId = GeneEditPanel.this.getEditedFeature().getId();
            ut.setOldId(oldId);
            if (GeneEditPanel.this.getNameAdapter().typeChangeCausesIdChange(oldType, newType)) {
                String newId = GeneEditPanel.this.getNameAdapter().getNewIdFromTypeChange(oldId, oldType, newType);
                ut.setNewId(newId);
                ut.setNameAdapter(GeneEditPanel.this.getNameAdapter());
            }
            ut.editModel();
            if (GeneEditPanel.this.getEditedFeature().isProteinCodingGene()) {
                int trans_count = GeneEditPanel.this.getEditedFeature().size();
                for (int i = 0; i < trans_count; ++i) {
                    AnnotatedFeatureI transClone = (AnnotatedFeatureI)GeneEditPanel.this.getEditedFeature().getFeatureAt(i);
                    if (transClone.getTranslationStart() != 0) continue;
                    transClone.calcTranslationStartForLongestPeptide();
                }
            }
            AnnotationUpdateEvent a = new AnnotationUpdateEvent(ut);
            GeneEditPanel.this.fireAnnotEvent(a);
            GeneEditPanel.this.setPeptideStatus(GeneEditPanel.this.getEditedFeature());
            GeneEditPanel.this.loadSelectedFeature();
        }
    }

    private class DicistronicButtonListener
    implements ActionListener {
        private DicistronicButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean b = GeneEditPanel.this.isDicistronicCheckbox.isSelected();
            GeneEditPanel.this.setBooleanSubpart(b, TransactionSubpart.IS_DICISTRONIC);
        }
    }
}

