/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.gui.ScoreCalculator;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

public abstract class WindowScoreCalculator
extends ScoreCalculator {
    private int winSize = 15;
    private static final int minWinSize = 1;
    private static final int maxWinSize = 500;
    int halfWinSize = 7;
    BoundedRangeModel windowModel;
    int[] winExtents = new int[2];

    public WindowScoreCalculator(int winSize) {
        this.windowModel = new DefaultBoundedRangeModel(winSize, 0, 1, 500);
        this.setWinSize(winSize);
    }

    public void setWinSize(int size) {
        this.winSize = size;
        this.halfWinSize = size / 2;
        if (this.halfWinSize * 2 + 1 != this.winSize) {
            ++this.winSize;
        }
        this.windowModel.setValue(this.winSize);
    }

    public int getWinSize() {
        return this.winSize;
    }

    protected void getWindowExtents(int pos, int[] extents, int min, int max) {
        int low = pos - this.halfWinSize;
        int high = pos + this.halfWinSize;
        extents[0] = low < min ? min : low;
        extents[1] = high > max ? max : high;
    }

    public boolean hasModel() {
        return true;
    }

    public BoundedRangeModel getModel() {
        return this.windowModel;
    }
}

