/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.config.FeatureProperty;
import apollo.config.TierProperty;
import apollo.gui.SliderWindow;
import apollo.gui.event.MouseButtonEvent;
import apollo.gui.genomemap.ApolloPanel;
import apollo.gui.menus.PropertyMenu;
import apollo.gui.menus.ThresholdMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class PropertyPanel
extends JPanel
implements ActionListener,
MouseInputListener {
    JCheckBox visible;
    JCheckBox expanded;
    JCheckBox sorted;
    JCheckBox labeled;
    JPanel jp;
    ApolloPanel ap;
    TierProperty tierProperty;
    boolean beginFlash;
    Timer flashTimer = null;

    public PropertyPanel(ApolloPanel ap, TierProperty tierProperty) {
        this.ap = ap;
        this.tierProperty = tierProperty;
        this.jbInit();
    }

    public void jbInit() {
        JLabel label = new JLabel(this.tierProperty.getLabel(), 0);
        label.setForeground(Color.black);
        this.visible = new JCheckBox("Show");
        this.visible.setHorizontalTextPosition(2);
        this.visible.setHorizontalAlignment(4);
        this.expanded = new JCheckBox("Expand");
        this.expanded.setHorizontalTextPosition(2);
        this.expanded.setHorizontalAlignment(4);
        this.sorted = new JCheckBox("Sort");
        this.labeled = new JCheckBox("Label");
        this.jp = new JPanel();
        Color colour = this.tierProperty.getColour();
        this.setColours(this, colour, Color.black);
        this.setColours(this.visible, colour, Color.black);
        this.setColours(this.expanded, colour, Color.black);
        this.setColours(this.sorted, colour, Color.black);
        this.setColours(this.labeled, colour, Color.black);
        this.setColours(this.jp, colour, Color.black);
        this.visible.setSelected(this.tierProperty.isVisible());
        this.expanded.setSelected(this.tierProperty.isExpanded());
        this.sorted.setSelected(this.tierProperty.isSorted());
        this.labeled.setSelected(this.tierProperty.isLabeled());
        this.jp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 12;
        gbc.gridwidth = 0;
        this.jp.add((Component)this.visible, gbc);
        gbc.anchor = 14;
        this.jp.add((Component)this.expanded, gbc);
        JPanel jp2 = new JPanel();
        jp2.setLayout(new GridLayout(2, 1));
        jp2.add(this.sorted);
        jp2.add(this.labeled);
        this.setLayout(new BorderLayout());
        Font smallFont = new Font("Dialog", 0, 10);
        this.setFont(smallFont);
        this.visible.setFont(smallFont);
        this.expanded.setFont(smallFont);
        this.sorted.setFont(smallFont);
        this.labeled.setFont(smallFont);
        this.add("West", jp2);
        this.add("Center", label);
        this.add("East", this.jp);
        this.addMouseListener(this);
        label.addMouseListener(this);
        this.visible.addActionListener(this);
        this.expanded.addActionListener(this);
        this.sorted.addActionListener(this);
        this.labeled.addActionListener(this);
    }

    public TierProperty getProperty() {
        return this.tierProperty;
    }

    public void flash() {
        Color colour = this.tierProperty.getColour();
        this.setBackground(colour.darker());
        this.beginFlash = true;
    }

    public void paintComponent(Graphics g) {
        if (this.beginFlash) {
            this.flashTimer = new Timer(750, this);
            this.flashTimer.start();
            this.beginFlash = false;
        }
        super.paintComponent(g);
    }

    public void updateValues() {
        this.setColours(this, this.tierProperty.getColour(), Color.black);
        this.setColours(this.visible, this.tierProperty.getColour(), Color.black);
        this.setColours(this.expanded, this.tierProperty.getColour(), Color.black);
        this.setColours(this.sorted, this.tierProperty.getColour(), Color.black);
        this.setColours(this.labeled, this.tierProperty.getColour(), Color.black);
        this.setColours(this.jp, this.tierProperty.getColour(), Color.black);
        this.visible.setSelected(this.tierProperty.isVisible());
        this.expanded.setSelected(this.tierProperty.isExpanded());
        this.sorted.setSelected(this.tierProperty.isSorted());
        this.labeled.setSelected(this.tierProperty.isLabeled());
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.visible) {
            this.tierProperty.setVisible(this.visible.isSelected());
        } else if (evt.getSource() == this.expanded) {
            this.tierProperty.setExpanded(this.expanded.isSelected());
        } else if (evt.getSource() == this.sorted) {
            this.tierProperty.setSorted(this.sorted.isSelected());
        } else if (evt.getSource() == this.labeled) {
            if (this.labeled.isSelected()) {
                this.tierProperty.setExpanded(true);
                this.expanded.setSelected(true);
                this.tierProperty.setLabeled(true);
            }
            this.tierProperty.setLabeled(this.labeled.isSelected());
            if (this.tierProperty.isLabeled()) {
                if (this.ap == null) {
                    return;
                }
                this.ap.putVerticalScrollbarsAtStart();
            }
        } else if (evt.getSource() == this.flashTimer) {
            Color colour = this.tierProperty.getColour();
            this.setColours(this, colour, Color.black);
            this.flashTimer.stop();
            this.flashTimer = null;
        }
    }

    public void mouseEntered(MouseEvent evt) {
        this.requestFocusInWindow();
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (MouseButtonEvent.isMiddleMouseClick(evt)) {
            ThresholdMenu popup = new ThresholdMenu(this, this.tierProperty, new Point(evt.getX(), evt.getY()));
            popup.show((Component)evt.getSource(), evt.getX(), evt.getY());
        } else if (MouseButtonEvent.isRightMouseClick(evt)) {
            PropertyMenu popup = new PropertyMenu(this, this.tierProperty, new Point(evt.getX(), evt.getY()));
            popup.show((Component)evt.getSource(), evt.getX(), evt.getY());
        } else if (MouseButtonEvent.isLeftMouseClick(evt) && this.tierProperty.isSorted()) {
            DefaultBoundedRangeModel model = new DefaultBoundedRangeModel(this.tierProperty.getMaxRow(), 0, 0, 100);
            new SliderWindow("Set max rows (" + this.tierProperty.getLabel() + " tier)", "Max rows in tier", model, this.getLocationOnScreen());
            model.addChangeListener(new MaxRowListener());
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    private void setColours(JComponent comp, Color bg, Color fg) {
        comp.setBackground(bg);
        if (bg == Color.black) {
            this.setForeground(Color.white);
        } else {
            comp.setForeground(fg);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("TypePanel test");
        String analysis_type = "Genscan";
        Vector<String> types = new Vector<String>();
        types.addElement(analysis_type);
        TierProperty tierProperty = new TierProperty(analysis_type, true, false);
        FeatureProperty fp = new FeatureProperty(tierProperty, analysis_type, types);
        PropertyPanel tp1 = new PropertyPanel(null, tierProperty);
        analysis_type = "RepeatMasker";
        types = new Vector();
        types.addElement(analysis_type);
        tierProperty = new TierProperty(analysis_type, true, false);
        fp = new FeatureProperty(tierProperty, analysis_type, types);
        PropertyPanel tp2 = new PropertyPanel(null, tierProperty);
        f.getContentPane().setLayout(new GridLayout(1, 2));
        f.getContentPane().add(tp1);
        f.getContentPane().add(tp2);
        f.setSize(300, 100);
        f.show();
    }

    class MaxRowListener
    implements ChangeListener {
        MaxRowListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() instanceof DefaultBoundedRangeModel) {
                PropertyPanel.this.tierProperty.setMaxRow(((DefaultBoundedRangeModel)evt.getSource()).getValue());
            }
        }
    }
}

